<?php

class Host_simulate_model extends Host_generate_model
{

    public $insertLogs = false;


    public function updateHost($hostKey)
    {
        $sql = 'UPDATE "__hosts" SET "lastreporttimestamp" = \'now()\' WHERE hostkey = \'' . $hostKey . '\'';
        $sql = sprintf($sql, $hostKey);
        $this->cfdb->query($sql);
    }

    public function updateVariables($hostKey, $i)
    {
        $variablesData = include __DIR__ . '/../data/variables.php';
        $insertLogs = [];
        foreach ($variablesData as $key => $d) {
            $updateArr[] = ['variablevalue' => (string) $d['variablevalue'], 'changetimestamp' => 'now()', 'comp' => $d['comp']];
            unset($d['comp']);
            $d['changeoperation'] = 'CHANGE';
            $insertLogs[] = $d;
        }
        $this->cfdb->where('hostkey', $hostKey);
        $this->cfdb->update_batch('__variables', $updateArr, 'comp');
        if ($this->insertLogs) {
            $this->cfdb->insert_batch('__variableslog', $insertLogs);
        }
    }

    public function updateSoftware($hostKey)
    {
        $this->cfdb->query("UPDATE __software SET changetimestamp = now() WHERE hostkey = '$hostKey'");

        if ($this->insertLogs) {
            $sql = file_get_contents(__DIR__ . '/../data/softwarelog.sql');
            $sql = str_replace('%hostkey%', $hostKey, $sql);
            $sql = str_replace('%timestamp%', date('Y-m-d H:i:s+00'), $sql);
            $this->cfdb->query($sql);
        }
    }

    public function updatePromiseExecutions($hostKey)
    {
        $this->cfdb->query("UPDATE __promiseexecutions SET changetimestamp = now(), linenumber = " . mt_rand(1,
                200) . " WHERE hostkey = '$hostKey'");
    }

    public function updateContexts($hostKey, $i)
    {
        $data = include __DIR__ . '/../data/contexts.php';
        $this->cfdb->query("UPDATE __contexts SET changetimestamp = 'now()' WHERE hostkey = '$hostKey'");
        $insertLogs = [];
        foreach ($data as $key => $d) {
            $d['changeoperation'] = 'ADD';
            $insertLogs[] = $d;
        }

        if ($this->insertLogs) {
            $this->cfdb->insert_batch('__contextslog', $insertLogs);
        }
    }


    public function isHostExist($hostKey)
    {
        return $this->cfdb->query("SELECT * FROM __hosts WHERE hostkey = '$hostKey'")->row();
    }

    public function updateMeasurementsData($hostKey)
    {
        $id = $this->cfdb->query("SELECT id FROM __monitoringmgmeta WHERE observable = 'cpu' AND hostkey = '$hostKey'")->row()->id;

        if ($id) {
           $next_sample = $this->cfdb->query("SELECT max(sample) + 1 as next_sample FROM __monitoringmg WHERE meta_id = $id")->row()->next_sample;
           $this->cfdb->query("INSERT INTO __monitoringmg (meta_id, sample, value1, value2, value3, value4, updatedtimestamp) VALUES
                               ($id, $next_sample, " . mt_rand(0, 10) . "." . mt_rand(0, 10) . ", " . mt_rand(0, 10) . "." . mt_rand(0, 10) . ", " . mt_rand(0, 10) . "." . mt_rand(0, 10) . ",	0,	now() )");
        } else {
           echo "no existing monitoring data so skipping the update" . PHP_EOL;
        }
    }

    public function updateAgentStatus($hostKey)
    {
        $this->cfdb->query("UPDATE __agentstatus SET lastagentlocalexecutiontimestamp = now() WHERE hostkey = '$hostKey'");
    }

}
