<a ng-if="ruleId" ng-click="openAddCheckModal(ruleId)" class="margin-left-small createCondition">Edit</a>
<button ng-if="!ruleId"  class="btn margin-top-large add-check" ng-click="openAddCheckModal(ruleId)">+ Add a check</button>
<script type="text/ng-template" id="addCheck.html">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"  ng-click="close()">
            <i class="bi bi-x"></i>
        </button>
        <h2>{{ruleId == null ? 'Add a' : 'Edit'}} check</h2>
    </div>
    <div class="modal-body">
        <div ng-if="!ruleId" class="form-horizontal">
            <div ng-show="rulesList.length" class="control-group">
                    <label class="control-label" name="">
                        <span>Select existing check</span>
                    </label>
                <div class="controls">
                    <select
                            id="rules_dropdown"
                            required
                            data-placeholder=""
                            chozen
                            conditions="false"
                            ng-model="existingRuleData"
                            ng-change="selectExistingCheck(existingRuleData)"
                            watch="rulesList"
                            ng-options="rule as rule.name
                                    group by rule.type | DCA_ValueToString:'RuleTypes_dropDown_with_deselect'
                                    disable when rule.disabled
                                    for rule in rulesList track by rule.id"
                            ng-init="conditionsPlaceholder='Select a condition'"
                    >
                    </select>
                </div>
            </div>
        </div>
        <b ng-hide="existingRuleData" style="margin: 10px 0 20px 250px;display: block;" class="muted">
            OR create new
        </b>
        <form ng-hide="existingRuleData" name="form.ruleForm" class="form-horizontal compliance-form confirm-before-leave" style="overflow:visible" id="form.ruleForm" novalidate>
            <div class="control-group required"
                 ng-class="{error:alertEdit.$dirty && (form.ruleForm.name.$invalid || form.ruleForm.name.$error.required)}">
                <label class="control-label">
                    <span>Name</span>
                </label>

                <div class="controls">
                    <input  type="text" name="name" ng-model="ruleData.name" maxlength="100" required>
                    <span class="help-block"
                          ng-hide="alertEdit.$dirty && (form.ruleForm.name.$invalid || form.ruleForm.name.$error.required)">Unique name for the condition.</span>
                    <span class="help-block error"
                          ng-show="alertEdit.$dirty && (form.ruleForm.name.$invalid || form.ruleForm.name.$error.required)">You must name the condition.</span>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label">
                    <span>Description</span>
                </label>

                <div class="controls">
                    <textarea name="description"  ng-model="ruleData.description" maxlength="300"></textarea>
                    <span class="help-block"></span>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label">Condition for</label>
                <div class="controls">
                    <select
                            required
                            chozen
                            ng-model="ruleData.conditionMustBeMet"
                            name="conditionMustBeMet"
                            ng-options="item.value as item.label for item in conditionFor"
                    >
                    </select>
                </div>
            </div>
            <!-- OPTIONS LEVEL 1 -->
            <div class="control-group required">
                <label class="control-label" name="">
                    <span>Type</span>
                </label>

                <div class="controls">
                    <select
                            required
                            data-placeholder="Select condition type"
                            chozen
                            ng-model="ruleData.type"
                            watch="DCA.RuleTypes_dropDown"
                            ng-options="item.value as item.label for item in DCA.RuleTypes_dropDown"
                    >
                    </select>
                    <span class="help-block"></span>
                </div>
            </div>
            <div class="add_condition-rules">
                <?php
                // object-dependent views
                $this->load->view('dashboard/partials/rules/policy.php');
                $this->load->view('dashboard/partials/rules/softwareupdate.php');
                $this->load->view('dashboard/partials/rules/filechanged.php');
                $this->load->view('dashboard/partials/rules/inventory.php');
                $this->load->view('dashboard/partials/rules/custom.php');
                ?>
            </div>
            <div class="controls">
                <div rule-description rule="ruleData"></div>
            </div>
            <div class="margin-top add_condition">
                <div class="control-group required">
                    <label class="control-label">
                        <span>Condition category</span>
                    </label>

                    <div class="controls">
                        <input autocomplete-input
                               ng-model="ruleData.category"
                               url="/autocomplete/condition_categories"
                        >
                    </div>
                </div>
                <div class="control-group required">
                    <label class="control-label">
                        <span>Severity</span>
                    </label>

            <div class="controls">
                <select
                        required
                        data-placeholder="Select severity"
                        chozen
                        ng-model="ruleData.severity"
                        watch="DCA.RuleSeverity"
                        name="severity"
                        ng-options="item.value as item.label for item in DCA.RuleSeverity"
                >
                </select>
            </div>
        </div>
        <hr/>
        <div class="control-group host-filter-condition">
            <label class="control-label">
                <span>Hosts filter</span>
            </label>
            <div ng-init="showFilter=true" ng-class="{'open':showFilter}">
                <div class="no-border"
                     state="hostContextState"
                     onclick="$('.modal-body').animate({scrollTop: 500}, 'slow')"
                     id="ruleHostFilter"
                     hosts-include-exclude
                     hide-specific-hosts-filter="true">
                </div>
            </div>
        </div>

            </div>
        </form>

    </div>
    <div class="modal-footer">
        <button ng-hide="existingRuleData" class="btn btn-primary btn-large pull-right" ng-disabled="!form.ruleForm.$valid" ng-click="saveRule()">
            Save check
        </button>
        <button ng-show="existingRuleData" class="btn btn-primary btn-large pull-right"  ng-click="addExistingCheck()">
            Add check
        </button>
        <button class="btn btn-large btn-info pull-left" type="button" class="close" data-dismiss="modal"  ng-click="close()">
            Cancel
        </button>
    </div>
    <style>
        .chosen-with-drop {height: 285px}
        .chosen-drop {top: auto !important;}
    </style>
</script>
