'use strict';

    var inventoryDataServiceClass = Class.extend({
        INVENTORY_URL: MP_SITE_URL + '/advancedreports/inventory/',
        getVariables: function () {
            return this.$http({
                method: 'get',
                url: this.INVENTORY_URL + 'variables',
                cache: false
            }).then(function (data) {
                var items = {};
                angular.forEach(data.data, function (value, key) {
                    Object.assign(value, {
                        'label': value.attribute_name,
                        'id_key': value.id
                    });
                    value.attribute_name = 'attribute_name=' + value.attribute_name;
                    items['attribute_name=' + value.attribute_name] = value;
                });
                return items;
            });
        },

        updateVariable: function (filter) {
            return this.$http({
                method: 'patch',
                headers: {
                    'Content-Type': 'application/json'
                },
                url: this.INVENTORY_URL + 'update_variable/' + filter.id_key,
                cache: false,
                data: {'type': filter.type}
            }).then(function (data) {

                return data;
            });
        },

        getData: function (params, headers = {}) {
            return this.$http({
                method: 'POST',
                url: this.INVENTORY_URL + 'data',
                data: params,
                cache: false,
                headers: headers
            });
        },
        getClasses: function (query, page = 1) {
            return this.$http({
                method: 'GET',
                url: `/widget/allclasses/${page}/${query}/20`,
                cache: false
            });
        }
});

(function() {
    var inventoryDataServiceProvider = Class.extend({
        instance: new inventoryDataServiceClass(),
        $get: ['$http', function($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });


    angular.module('inventoryDataServiceModule', [])
        .provider('inventoryDataService', inventoryDataServiceProvider);

}());

