"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/ConfigurationObject.tsx
var ConfigurationObject_exports = {};
__export(ConfigurationObject_exports, {
  ConfigurationObject: () => ConfigurationObject,
  TwoColumnData: () => TwoColumnData,
  TwoColumnDataMultiple: () => TwoColumnDataMultiple,
  TwoColumns: () => TwoColumns,
  default: () => ConfigurationObject_default
});
module.exports = __toCommonJS(ConfigurationObject_exports);
var import_react = __toESM(require("react"), 1);
var import_icons_material = require("@mui/icons-material");
var import_material = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_copy_to_clipboard = __toESM(require("copy-to-clipboard"), 1);
var import_jsx_runtime = require("react/jsx-runtime");
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  root: {
    [".key > b"]: {
      backgroundColor: theme.palette.grey[400],
      color: theme.palette.getContrastText(theme.palette.grey[400])
    }
  }
}));
var cutoffLength = 100;
var ValueColumn = ({ value = "", setSnackbar }) => {
  const [tooltipVisible, setTooltipVisible] = (0, import_react.useState)(false);
  const isComponent = import_react.default.isValidElement(value);
  const onClick = () => {
    if (setSnackbar) {
      let copyable = value;
      if (isComponent) {
        copyable = value.props.value;
      }
      (0, import_copy_to_clipboard.default)(copyable);
      setSnackbar("Value copied to clipboard");
    }
  };
  let shownValue = value;
  if (!isComponent) {
    shownValue = /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { title: value, children: value.length > cutoffLength ? `${value.substring(0, cutoffLength - 3)}...` : value });
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
    "div",
    {
      className: `flexbox ${setSnackbar ? "clickable" : ""}`,
      onClick,
      onMouseEnter: () => setTooltipVisible(true),
      onMouseLeave: () => setTooltipVisible(false),
      children: [
        shownValue,
        setSnackbar && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Tooltip, { title: "Copy to clipboard", placement: "top", open: tooltipVisible, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.FileCopyOutlined, { color: "primary", className: `margin-left-small ${tooltipVisible ? "fadeIn" : "fadeOut"}`, fontSize: "small" }) })
      ]
    }
  );
};
var KeyColumn = ({ value, chipLikeKey }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: `align-right ${chipLikeKey ? "key" : ""} muted`, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)("b", { children: value }) });
var TwoColumns = ({
  className = "",
  children = void 0,
  chipLikeKey = true,
  compact = false,
  items = {},
  KeyComponent = KeyColumn,
  KeyProps = {},
  setSnackbar,
  style = {},
  ValueComponent = ValueColumn,
  ValueProps = {}
}) => {
  const { classes } = useStyles();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: `break-all two-columns ${classes.root} ${compact ? "compact" : ""} ${className}`, style, children: children ? children : Object.entries(items).map(([key, value]) => /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_react.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(KeyComponent, { chipLikeKey, value: key, ...KeyProps }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(ValueComponent, { setSnackbar, value, ...ValueProps })
  ] }, key)) });
};
var TwoColumnData = ({ className = "", config, ...props }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(TwoColumns, { className: `column-data ${className}`, items: config, ...props });
var TwoColumnDataMultiple = ({ className = "", config, style, ...props }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: `two-columns-multiple ${className}`, style: { ...style }, children: Object.entries(config).map(([key, value]) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(TwoColumnData, { className: "multiple", config: { [key]: value }, compact: true, ...props }, key)) });
var ConfigurationObject = ({ config, ...props }) => {
  const content = Object.entries(config).reduce((accu, [key, value]) => {
    accu[key] = `${value}`;
    return accu;
  }, {});
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(TwoColumnData, { ...props, config: content });
};
var ConfigurationObject_default = ConfigurationObject;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ConfigurationObject,
  TwoColumnData,
  TwoColumnDataMultiple,
  TwoColumns
});
//# sourceMappingURL=ConfigurationObject.cjs.map