"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/ConfirmModal.tsx
var ConfirmModal_exports = {};
__export(ConfirmModal_exports, {
  ConfirmModal: () => ConfirmModal
});
module.exports = __toCommonJS(ConfirmModal_exports);
var import_react = require("react");
var import_material2 = require("@mui/material");

// src/dialogs/BaseDialog.tsx
var import_material = require("@mui/material");
var import_jsx_runtime = require("react/jsx-runtime");
var BaseDialog = (props) => {
  const { children, onClose, title, ...dialogProps } = props;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_material.Dialog, { ...dialogProps, onClose, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.DialogTitle, { children: title }),
    children
  ] });
};

// src/ConfirmModal.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var ConfirmModal = (props) => {
  const { close, onConfirm, className = "", toType, header, description, open, maxWidth = "xs" } = props;
  const [inputValue, setInputValue] = (0, import_react.useState)("");
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(
    BaseDialog,
    {
      title: header,
      className,
      open,
      onClose: close,
      maxWidth,
      slotProps: {
        paper: {
          component: "form",
          onSubmit: (event) => {
            event.preventDefault();
            onConfirm();
            close();
          }
        }
      },
      children: [
        /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_material2.DialogContent, { children: [
          /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.DialogContentText, { className: "margin-bottom-small", children: description }),
          /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_material2.DialogContentText, { className: "margin-bottom-small", children: [
            "Type '",
            toType,
            "' below to continue"
          ] }),
          /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
            import_material2.TextField,
            {
              value: inputValue,
              onChange: (e) => setInputValue(e.target.value),
              autoFocus: true,
              required: true,
              name: "confirmation-text",
              id: "confirmation-text",
              label: toType,
              type: "text"
            }
          )
        ] }),
        /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_material2.DialogActions, { children: [
          /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.Button, { onClick: close, size: "small", children: "Cancel" }),
          /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.Button, { color: "secondary", type: "submit", variant: "contained", disabled: inputValue !== toType, size: "small", children: "Confirm" })
        ] })
      ]
    }
  );
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ConfirmModal
});
//# sourceMappingURL=ConfirmModal.cjs.map