"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/Time.tsx
var Time_exports = {};
__export(Time_exports, {
  ApproximateRelativeDate: () => ApproximateRelativeDate,
  MaybeTime: () => MaybeTime,
  RelativeTime: () => RelativeTime,
  Time: () => Time,
  default: () => Time_default
});
module.exports = __toCommonJS(Time_exports);
var import_react = require("react");
var import_material = require("@mui/material");
var import_dayjs = __toESM(require("dayjs"), 1);
var import_relativeTime = __toESM(require("dayjs/plugin/relativeTime.js"), 1);
var import_pluralize = __toESM(require("pluralize"), 1);
var import_jsx_runtime = require("react/jsx-runtime");
var defaultDateFormat = "YYYY-MM-DD";
var defaultTimeFormat = `${defaultDateFormat} HH:mm`;
import_dayjs.default.extend(import_relativeTime.default);
var Time = ({ value, relative, format = defaultTimeFormat, valueFormat, titleFormat = defaultTimeFormat, Component = "time", ...remainingProps }) => {
  if (!value) {
    value = (0, import_dayjs.default)();
  }
  value = (0, import_dayjs.default)(value, valueFormat, true);
  const machineReadable = value.format("YYYY-MM-DDTHH:mm:ssZ");
  const humanReadable = relative ? value.fromNow() : value.format(format);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Component, { title: relative ? value.format(titleFormat) : null, ...remainingProps, dateTime: machineReadable, children: humanReadable });
};
var MaybeTime = ({ className = "", value, ...remainingProps }) => value ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Time, { value, ...remainingProps }) : /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className, children: "-" });
var cutoff = -5 * 60;
var RelativeTime = ({ className, shouldCount = "both", updateTime }) => {
  const [updatedTime, setUpdatedTime] = (0, import_react.useState)();
  (0, import_react.useEffect)(() => {
    setUpdatedTime((updatedTime2) => updateTime !== updatedTime2 ? (0, import_dayjs.default)(updateTime) : updatedTime2);
  }, [updateTime]);
  let timeDisplay = /* @__PURE__ */ (0, import_jsx_runtime.jsx)(MaybeTime, { className, value: updatedTime });
  const diffSeconds = updatedTime ? updatedTime.diff((0, import_dayjs.default)(), "seconds") : 0;
  if (updatedTime && diffSeconds > cutoff && (shouldCount === "both" || shouldCount === "up" && diffSeconds > 0 || shouldCount === "down" && diffSeconds < 0)) {
    timeDisplay = /* @__PURE__ */ (0, import_jsx_runtime.jsx)("time", { className, dateTime: updatedTime, children: updatedTime.fromNow() });
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Tooltip, { title: updatedTime ? updatedTime.toDate().toString().slice(0, 33) : "", arrow: true, enterDelay: 500, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { children: timeDisplay }) });
};
var cutoffDays = 14;
var ApproximateRelativeDate = ({ className, updateTime }) => {
  const [updatedTime, setUpdatedTime] = (0, import_react.useState)();
  (0, import_react.useEffect)(() => {
    setUpdatedTime((updatedTime2) => updateTime !== updatedTime2 ? (0, import_dayjs.default)(updateTime) : updatedTime2);
  }, [updateTime]);
  const diff = updatedTime ? Math.abs(updatedTime.diff((0, import_dayjs.default)(), "days")) : 0;
  if (updatedTime && diff <= cutoffDays) {
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("time", { className, dateTime: updatedTime.format(defaultDateFormat), children: diff !== 0 ? `${diff} ${(0, import_pluralize.default)("day", diff)} ago` : "today" });
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(MaybeTime, { className, value: updatedTime, format: defaultDateFormat, titleFormat: defaultDateFormat });
};
var Time_default = Time;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ApproximateRelativeDate,
  MaybeTime,
  RelativeTime,
  Time
});
//# sourceMappingURL=Time.cjs.map