// src/forms/Filters.tsx
import { useEffect, useState } from "react";
import { FormProvider, useForm } from "react-hook-form";
import { makeStyles } from "tss-react/mui";
import { TIMEOUTS } from "@northern.tech/store/constants";
import { useDebounce } from "@northern.tech/utils/debouncehook";
import { jsx, jsxs } from "react/jsx-runtime";
var useStyles = makeStyles()((theme) => ({
  filters: {
    backgroundColor: theme.palette.background.lightgrey,
    columnGap: theme.spacing(2),
    display: "flex",
    flexWrap: "wrap",
    padding: `10px ${theme.spacing(3)} ${theme.spacing(3)}`,
    rowGap: theme.spacing(2),
    ".filter-item": {
      display: "grid"
    },
    ".filter-item > div": {
      alignSelf: "end"
    }
  },
  filterReset: { right: theme.spacing(3) }
}));
var Filters = ({ className = "", defaultValues, filters = [], initialValues, onChange, fieldResetTrigger = "", dirtyField, clearDirty }) => {
  const { classes } = useStyles();
  const [values, setValues] = useState(initialValues);
  const methods = useForm({ mode: "onChange", defaultValues });
  const { formState, reset, resetField, watch, setValue, getValues } = methods;
  const { isDirty } = formState;
  useEffect(() => {
    Object.entries(initialValues).forEach(([key, value]) => setValue(key, value));
  }, [JSON.stringify(initialValues), setValue]);
  useEffect(() => {
    if (dirtyField && !formState.isDirty) {
      setValue(dirtyField, getValues(dirtyField), { shouldDirty: true });
      clearDirty("");
    }
  }, [clearDirty, dirtyField, formState, getValues, setValue]);
  useEffect(() => {
    if (!fieldResetTrigger) {
      return;
    }
    resetField(fieldResetTrigger);
  }, [fieldResetTrigger, resetField]);
  watch(setValues);
  const debouncedValues = useDebounce(values, TIMEOUTS.oneSecond);
  useEffect(() => {
    onChange(debouncedValues);
  }, [JSON.stringify(debouncedValues), onChange]);
  return /* @__PURE__ */ jsx(FormProvider, { ...methods, children: /* @__PURE__ */ jsxs("form", { className: `margin-bottom relative margin-top ${classes.filters} ${className}`, noValidate: true, children: [
    filters.map(({ key, title, Component, componentProps }) => /* @__PURE__ */ jsxs("div", { className: "filter-item", children: [
      /* @__PURE__ */ jsx("h5", { className: "margin-top-small margin-bottom-small muted", children: title }),
      /* @__PURE__ */ jsx(Component, { name: key, ...componentProps })
    ] }, key)),
    isDirty && /* @__PURE__ */ jsx("span", { className: `link absolute ${classes.filterReset}`, onClick: () => reset(), children: "Clear filter" })
  ] }) });
};
var Filters_default = Filters;

export {
  Filters,
  Filters_default
};
//# sourceMappingURL=chunk-AIGCHI4H.js.map