// src/CopyText.tsx
import { useEffect, useRef, useState } from "react";
import CopyToClipboard from "react-copy-to-clipboard";
import { FileCopy as CopyPasteIcon } from "@mui/icons-material";
import { Button } from "@mui/material";
import { makeStyles } from "tss-react/mui";
import { TIMEOUTS, yes } from "@northern.tech/store/constants";
import { jsx, jsxs } from "react/jsx-runtime";
var useStyles = makeStyles()(() => ({
  copyNotification: { height: 15 }
}));
var CopyTextToClipboard = ({ notify = true, onCopy = yes, token }) => {
  const [copied, setCopied] = useState(false);
  const { classes } = useStyles();
  const timer = useRef(void 0);
  useEffect(() => () => clearTimeout(timer.current), []);
  const onCopied = () => {
    setCopied(true);
    onCopy();
    timer.current = setTimeout(() => setCopied(false), TIMEOUTS.fiveSeconds);
  };
  return /* @__PURE__ */ jsxs("div", { children: [
    /* @__PURE__ */ jsx(CopyToClipboard, { text: token, onCopy: onCopied, children: /* @__PURE__ */ jsx(Button, { startIcon: /* @__PURE__ */ jsx(CopyPasteIcon, {}), children: "Copy to clipboard" }) }),
    notify && /* @__PURE__ */ jsx("p", { className: classes.copyNotification, children: copied && /* @__PURE__ */ jsx("span", { className: "green fadeIn", children: "Copied to clipboard." }) })
  ] });
};

export {
  CopyTextToClipboard
};
//# sourceMappingURL=chunk-D3PUKIAW.js.map