import {
  Pagination_default
} from "./chunk-LOMBHKTZ.js";
import {
  MenderTooltip_default
} from "./chunk-6YMQVQXN.js";
import {
  Loader_default
} from "./chunk-3AOVUJ7W.js";

// src/List.tsx
import { useCallback, useEffect, useRef, useState } from "react";
import { Settings as SettingsIcon, Sort as SortIcon } from "@mui/icons-material";
import { Checkbox } from "@mui/material";
import { makeStyles } from "tss-react/mui";
import { DEVICE_LIST_DEFAULTS, SORTING_OPTIONS, TIMEOUTS } from "@northern.tech/store/constants";
import { isDarkMode } from "@northern.tech/store/utils";
import { toggle } from "@northern.tech/utils/helpers";
import { useWindowSize } from "@northern.tech/utils/resizehook";
import { jsx, jsxs } from "react/jsx-runtime";
var { page: defaultPage, perPage: defaultPerPage } = DEVICE_LIST_DEFAULTS;
var useStyles = makeStyles()((theme) => ({
  header: {
    // @ts-ignore
    color: theme.palette.text.hint
  },
  resizer: {
    cursor: "col-resize",
    paddingLeft: 5,
    paddingRight: 5
  },
  resizeHandle: {
    width: 4,
    background: "initial",
    ["&.hovering"]: {
      background: theme.palette.grey[600]
    },
    ["&.resizing"]: {
      background: isDarkMode(theme.palette.mode) ? theme.palette.grey[200] : theme.palette.grey[900]
    }
  }
}));
var minCellWidth = 150;
var calculateResizeChange = ({ columnElements, columnHeaders, e, index, prev, selectable }) => {
  const isShrinkage = prev > e.clientX ? -1 : 1;
  const columnDelta = Math.abs(e.clientX - prev) * isShrinkage;
  const relevantColumns = getRelevantColumns(columnElements, selectable);
  const canModifyNextColumn = index + 1 < columnHeaders.length - 1;
  return relevantColumns.reduce((accu, element, columnIndex) => {
    const currentWidth = element.offsetWidth;
    const column = { attribute: columnHeaders[columnIndex + 1].attribute, size: currentWidth };
    if (canModifyNextColumn && index === columnIndex) {
      column.size = currentWidth + columnDelta;
    } else if (canModifyNextColumn && index + 1 === columnIndex) {
      column.size = currentWidth - columnDelta;
    }
    accu.push(column);
    return accu;
  }, []);
};
var getRelevantColumns = (columnElements, selectable) => [...columnElements].slice(selectable ? 1 : 0, columnElements.length - 1);
var getTemplateColumns = (columns, selectable) => selectable ? `52px ${columns} minmax(${minCellWidth}px, 1fr)` : `${columns} minmax(${minCellWidth}px, 1fr)`;
var getColumnsStyle = (columns, defaultSize, selectable) => {
  const template = columns.map(({ size }) => `minmax(${minCellWidth}px, ${size ? `${size}px` : defaultSize})`);
  return getTemplateColumns(template.join(" "), selectable);
};
var CommonList = (props) => {
  const {
    columnHeaders,
    customColumnSizes = [],
    listItems,
    listState,
    idAttribute,
    onChangeRowsPerPage,
    PaginationProps = {},
    onExpandClick,
    onResizeColumns,
    onPageChange,
    onSelect,
    onSort = () => {
    },
    pageLoading,
    sortingNotes,
    ListItemComponent
  } = props;
  const { page: pageNo = defaultPage, perPage: pageLength = defaultPerPage, selection: selectedRows = [], sort = {}, total: pageTotal = 1 } = listState;
  const { direction: sortDown = SORTING_OPTIONS.desc, key: sortCol } = sort;
  const listRef = useRef(null);
  const selectedRowsRef = useRef(selectedRows);
  const initRef = useRef(null);
  const [resizeTrigger, setResizeTrigger] = useState(false);
  const size = useWindowSize();
  const selectable = !!onSelect;
  const { classes } = useStyles();
  useEffect(() => {
    selectedRowsRef.current = selectedRows;
  }, [selectedRows]);
  useEffect(() => {
    if (!listRef.current) {
      return;
    }
    const relevantColumns = getRelevantColumns(listRef.current?.querySelector(".deviceListRow")?.children, selectable);
    listRef.current.style.gridTemplateColumns = getColumnsStyle(
      customColumnSizes.length && customColumnSizes.length === relevantColumns.length ? customColumnSizes : relevantColumns,
      "1.5fr",
      selectable
    );
  }, [customColumnSizes, columnHeaders, selectable, resizeTrigger, size.width]);
  useEffect(() => {
    clearTimeout(initRef.current || void 0);
    initRef.current = setTimeout(() => setResizeTrigger(toggle), TIMEOUTS.debounceDefault);
    return () => {
      clearTimeout(initRef?.current || void 0);
    };
  }, [customColumnSizes.length]);
  const onRowSelection = (selectedRow) => {
    const updatedSelection = [...selectedRowsRef.current];
    const selectedIndex = updatedSelection.indexOf(selectedRow);
    if (selectedIndex === -1) {
      updatedSelection.push(selectedRow);
    } else {
      updatedSelection.splice(selectedIndex, 1);
    }
    if (onSelect) {
      onSelect(updatedSelection);
    }
  };
  const onSelectAllClick = () => {
    let newSelectedRows = Array.from({ length: listItems.length }, (_, i) => i);
    if (selectedRows.length && selectedRows.length <= listItems.length) {
      newSelectedRows = [];
    }
    if (onSelect) {
      onSelect(newSelectedRows);
    }
  };
  const handleResizeChange = useCallback(
    (e, { index, prev, ref }) => {
      const changedColumns = calculateResizeChange({
        columnElements: [...ref.current.parentElement.children],
        columnHeaders,
        e,
        index,
        prev,
        selectable
      });
      if (listRef.current) listRef.current.style.gridTemplateColumns = getColumnsStyle(changedColumns, void 0, selectable);
    },
    [columnHeaders, selectable]
  );
  const handleResizeFinish = useCallback(
    (e, { index, prev, ref }) => {
      const changedColumns = calculateResizeChange({
        columnElements: ref.current.parentElement.children,
        columnHeaders,
        e,
        index,
        prev,
        selectable
      });
      if (onResizeColumns) {
        onResizeColumns(changedColumns);
      }
    },
    [columnHeaders, onResizeColumns, selectable]
  );
  const numSelected = (selectedRows || []).length;
  return /* @__PURE__ */ jsxs("div", { className: `deviceList ${selectable ? "selectable" : ""}`, ref: listRef, children: [
    /* @__PURE__ */ jsx("div", { className: `header ${classes.header}`, children: /* @__PURE__ */ jsxs("div", { className: "deviceListRow", children: [
      selectable && /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(
        Checkbox,
        {
          indeterminate: numSelected > 0 && numSelected < listItems.length,
          checked: numSelected === listItems.length,
          onChange: onSelectAllClick
        }
      ) }),
      columnHeaders.map((item, index) => /* @__PURE__ */ jsx(
        HeaderItem,
        {
          column: item,
          columnCount: columnHeaders.length,
          index,
          onSort,
          resizable: !!onResizeColumns,
          sortCol,
          sortDown,
          onResizeChange: handleResizeChange,
          onResizeFinish: handleResizeFinish,
          sortingNotes
        },
        `columnHeader-${index}`
      ))
    ] }) }),
    /* @__PURE__ */ jsx("div", { className: "body", children: listItems.map((item, index) => /* @__PURE__ */ jsx(
      ListItemComponent,
      {
        columnHeaders,
        listItem: item,
        listState,
        idAttribute,
        index,
        onClick: onExpandClick,
        onRowSelect: onRowSelection,
        selectable,
        selected: selectedRows.indexOf(index) !== -1
      },
      item.id
    )) }),
    /* @__PURE__ */ jsxs("div", { className: "footer flexbox margin-top", children: [
      /* @__PURE__ */ jsx(
        Pagination_default,
        {
          className: "margin-top-none",
          count: pageTotal,
          rowsPerPage: pageLength,
          onChangeRowsPerPage,
          page: pageNo,
          onChangePage: onPageChange,
          ...PaginationProps
        }
      ),
      /* @__PURE__ */ jsx(Loader_default, { show: pageLoading, small: true })
    ] })
  ] });
};
var HeaderItem = (props) => {
  const { sortingNotes, column, columnCount, index, sortCol, sortDown = void 0, onSort, onResizeChange, onResizeFinish, resizable } = props;
  const [isHovering, setIsHovering] = useState(false);
  const [shouldRemoveListeners, setShouldRemoveListeners] = useState(false);
  const resizeRef = useRef(null);
  const ref = useRef(null);
  const { classes } = useStyles();
  const onMouseOut = () => setIsHovering(false);
  const onMouseOver = () => setIsHovering(true);
  const mouseMove = useCallback(
    (e) => {
      if (resizable && resizeRef.current) {
        onResizeChange(e, { index, prev: resizeRef.current, ref });
        resizeRef.current = e.clientX;
      }
    },
    [index, onResizeChange, resizable]
  );
  const mouseUp = useCallback(
    (e) => {
      if (resizeRef.current) {
        onResizeFinish(e, { index, prev: resizeRef.current, ref });
        resizeRef.current = null;
        setShouldRemoveListeners(true);
      }
    },
    [index, onResizeFinish]
  );
  const mouseDown = (e) => resizeRef.current = e.clientX;
  useEffect(() => {
    window.addEventListener("mousemove", mouseMove);
    window.addEventListener("mouseup", mouseUp);
    return () => {
      setShouldRemoveListeners(!!resizeRef.current);
    };
  }, [mouseMove, mouseUp]);
  useEffect(() => {
    if (shouldRemoveListeners) {
      window.removeEventListener("mousemove", mouseMove);
      window.removeEventListener("mouseup", mouseUp);
      setShouldRemoveListeners(false);
    }
  }, [shouldRemoveListeners, mouseMove, mouseUp]);
  let resizeHandleClassName = resizable && isHovering ? "hovering" : "";
  resizeHandleClassName = resizeRef.current ? "resizing" : resizeHandleClassName;
  const header = /* @__PURE__ */ jsxs("div", { className: "columnHeader flexbox space-between relative", style: column.style, onMouseEnter: onMouseOver, onMouseLeave: onMouseOut, ref, children: [
    /* @__PURE__ */ jsxs("div", { className: "flexbox center-aligned", onClick: () => onSort(column.attribute ? column.attribute : {}), children: [
      column.title,
      column.sortable && /* @__PURE__ */ jsx(
        SortIcon,
        {
          className: `sortIcon ${sortCol === column.attribute.name ? "selected" : ""} ${(sortDown === SORTING_OPTIONS.desc).toString()}`,
          style: { fontSize: 16 }
        }
      )
    ] }),
    /* @__PURE__ */ jsxs("div", { className: "flexbox center-aligned full-height", children: [
      column.customize && /* @__PURE__ */ jsx(SettingsIcon, { onClick: column.customize, style: { fontSize: 16 } }),
      index < columnCount - 2 && resizable && /* @__PURE__ */ jsx("div", { onMouseDown: mouseDown, className: `${classes.resizer} full-height`, children: /* @__PURE__ */ jsx("div", { className: `full-height ${classes.resizeHandle} ${resizeHandleClassName}` }) })
    ] })
  ] });
  return column.sortable && sortingNotes && sortingNotes[column.attribute.name] ? /* @__PURE__ */ jsx(MenderTooltip_default, { title: sortingNotes[column.attribute.name], placement: "top-start", children: header }) : header;
};

export {
  minCellWidth,
  calculateResizeChange,
  CommonList
};
//# sourceMappingURL=chunk-DDGRSFCS.js.map