import {
  MenderTooltipClickable,
  MenderTooltip_default
} from "./chunk-6YMQVQXN.js";

// src/EnterpriseNotification.tsx
import { useState } from "react";
import { useSelector } from "react-redux";
import { Link } from "react-router-dom";
import { Chip } from "@mui/material";
import { withStyles } from "tss-react/mui";
import { ADDONS, BENEFITS, PLANS } from "@northern.tech/store/constants";
import { getTenantCapabilities } from "@northern.tech/store/selectors";
import { yes } from "@northern.tech/utils/helpers";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var PlansTooltip = withStyles(MenderTooltip_default, ({ palette }) => ({
  arrow: {
    color: palette.tooltip?.tierTipBackground ?? palette.grey[100]
  },
  tooltip: {
    backgroundColor: palette.tooltip?.tierTipBackground ?? palette.grey[100],
    maxWidth: 300
  }
}));
var PlanChip = withStyles(Chip, ({ palette }) => ({
  root: {
    backgroundColor: palette.tooltip?.tierTipBackground ?? palette.grey[100],
    color: palette.text.disabled,
    textTransform: "uppercase",
    "&:hover": {
      fontWeight: "bold"
    }
  }
}));
var DefaultUpgradeNotification = (props) => /* @__PURE__ */ jsxs("div", { ...props, children: [
  "This feature is not available on your plan. ",
  /* @__PURE__ */ jsx(Link, { to: "/subscription", children: "Upgrade" }),
  " to enable it"
] });
var EnterpriseNotification = ({ className = "", id = BENEFITS.default.id }) => {
  const [isOpen, setIsOpen] = useState(false);
  const tenantCapabilities = useSelector(getTenantCapabilities);
  const { isEnterprise, plan: currentPlan } = tenantCapabilities;
  const { benefit, requiredAddon = "", requiredPlan = PLANS.os.id } = BENEFITS[id];
  const hasAddon = requiredAddon ? ADDONS[requiredAddon].needs.every((need) => tenantCapabilities[need]) : false;
  const currentPlanIndex = Object.keys(PLANS).indexOf(currentPlan);
  const requiredPlanIndex = Object.keys(PLANS).indexOf(requiredPlan);
  const shouldShow = requiredPlanIndex > currentPlanIndex;
  if (isEnterprise || BENEFITS[id].requiredPlan && !shouldShow || requiredAddon && hasAddon) {
    return null;
  }
  const content = requiredAddon ? /* @__PURE__ */ jsxs(Fragment, { children: [
    "Add the ",
    /* @__PURE__ */ jsx("b", { children: ADDONS[requiredAddon].title }),
    " add-on to ",
    benefit,
    "."
  ] }) : /* @__PURE__ */ jsxs(Fragment, { children: [
    "Upgrade to the ",
    /* @__PURE__ */ jsx("b", { children: PLANS[requiredPlan].name }),
    " plan ",
    requiredPlanIndex === Object.keys(PLANS).length - 1 ? "" : "or higher ",
    "to gain access to ",
    benefit,
    "."
  ] });
  return /* @__PURE__ */ jsx(
    MenderTooltipClickable,
    {
      onOpenChange: setIsOpen,
      title: /* @__PURE__ */ jsxs("div", { children: [
        content,
        /* @__PURE__ */ jsxs("div", { className: "flexbox space-between margin-top-small", children: [
          /* @__PURE__ */ jsx(Link, { to: "/subscription", children: "Upgrade now" }),
          /* @__PURE__ */ jsx("span", { className: "link", onClick: () => setIsOpen(false), children: "Close" })
        ] })
      ] }),
      tooltipComponent: PlansTooltip,
      visibility: isOpen,
      children: /* @__PURE__ */ jsx(PlanChip, { className, onClick: yes, label: PLANS[requiredPlan].name })
    }
  );
};
var EnterpriseNotification_default = EnterpriseNotification;

export {
  DefaultUpgradeNotification,
  EnterpriseNotification,
  EnterpriseNotification_default
};
//# sourceMappingURL=chunk-OK65RLZY.js.map