// src/DetailsTable.tsx
import { Sort as SortIcon } from "@mui/icons-material";
import { Checkbox, Table, TableBody, TableCell, TableHead, TableRow } from "@mui/material";
import { makeStyles } from "tss-react/mui";
import { SORTING_OPTIONS } from "@northern.tech/store/constants";
import { jsx, jsxs } from "react/jsx-runtime";
var useStyles = makeStyles()(() => ({
  header: {
    ".columnHeader": {
      display: "table-cell"
    },
    ".columnHeader .sortIcon": {
      marginBottom: -6
    },
    ".nonSortable": { cursor: "initial" }
  }
}));
var DetailsTable = ({
  className = "",
  columns,
  items,
  onChangeSorting,
  onItemClick,
  sort = {},
  style = {},
  tableRef,
  onRowSelected,
  selectedRows = []
}) => {
  const { classes } = useStyles();
  const onRowSelection = (selectedRow) => {
    const updatedSelection = [...selectedRows];
    const selectedIndex = updatedSelection.indexOf(selectedRow);
    if (selectedIndex === -1) {
      updatedSelection.push(selectedRow);
    } else {
      updatedSelection.splice(selectedIndex, 1);
    }
    onRowSelected(updatedSelection);
  };
  const onSelectAllClick = () => {
    let newSelectedRows = Array.from({ length: items.length }, (_, index) => index);
    if (selectedRows.length && selectedRows.length <= items.length) {
      newSelectedRows = [];
    }
    onRowSelected(newSelectedRows);
  };
  return /* @__PURE__ */ jsxs(Table, { className: `margin-bottom ${className}`, style, ref: tableRef, children: [
    /* @__PURE__ */ jsx(TableHead, { className: classes.header, children: /* @__PURE__ */ jsxs(TableRow, { children: [
      onRowSelected !== void 0 && /* @__PURE__ */ jsx(TableCell, { children: /* @__PURE__ */ jsx(Checkbox, { indeterminate: false, checked: selectedRows.length === items.length, onChange: onSelectAllClick }) }),
      columns.map(({ extras, key, renderTitle, sortable, title }) => /* @__PURE__ */ jsxs(TableCell, { className: `columnHeader ${sortable ? "" : "nonSortable"}`, onClick: () => sortable ? onChangeSorting(key) : null, children: [
        renderTitle ? renderTitle(extras) : title,
        sortable && /* @__PURE__ */ jsx(SortIcon, { className: `sortIcon ${sort.key === key ? "selected" : ""} ${(sort.direction === SORTING_OPTIONS.desc).toString()}` })
      ] }, key))
    ] }) }),
    /* @__PURE__ */ jsx(TableBody, { children: items.map((item, index) => /* @__PURE__ */ jsxs(TableRow, { className: onItemClick ? "clickable" : "", hover: true, children: [
      onRowSelected !== void 0 && /* @__PURE__ */ jsx(TableCell, { children: /* @__PURE__ */ jsx(Checkbox, { checked: selectedRows.includes(index), onChange: () => onRowSelection(index) }) }),
      columns.map((column) => /* @__PURE__ */ jsx(TableCell, { className: "relative", onClick: () => onItemClick ? onItemClick(item) : null, children: column.render(item, column.extras) }, column.key))
    ] }, item.id || index)) })
  ] });
};
var DetailsTable_default = DetailsTable;

export {
  DetailsTable,
  DetailsTable_default
};
//# sourceMappingURL=chunk-QSTPAB3T.js.map