"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/forms/PasswordInput.tsx
var PasswordInput_exports = {};
__export(PasswordInput_exports, {
  PasswordInput: () => PasswordInput,
  default: () => PasswordInput_default
});
module.exports = __toCommonJS(PasswordInput_exports);
var import_react2 = __toESM(require("react"), 1);
var import_react_hook_form2 = require("react-hook-form");
var import_icons_material = require("@mui/icons-material");
var import_material2 = require("@mui/material");
var import_constants = require("@northern.tech/store/constants");
var import_helpers = require("@northern.tech/utils/helpers");
var import_copy_to_clipboard = __toESM(require("copy-to-clipboard"), 1);
var import_generate_password_browser = __toESM(require("generate-password-browser"), 1);

// src/forms/Form.tsx
var import_react = require("react");
var import_react_hook_form = require("react-hook-form");
var import_material = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_validator = __toESM(require("validator"), 1);
var import_jsx_runtime = require("react/jsx-runtime");
var validationMethods = {
  isAlpha: "This field must contain only letters",
  isAlphanumeric: "This field must contain only letters or numbers",
  isEmail: "Please enter a valid email address",
  isHexadecimal: "The secret has to be entered as a hexadecimal string",
  isNumeric: "Please enter a valid code",
  isURL: "Please enter a valid URL",
  isUUID: "Please enter a valid ID"
};
var getErrorMsg = (validateMethod, args) => {
  if (validationMethods[validateMethod]) {
    return validationMethods[validateMethod];
  }
  switch (validateMethod) {
    case "isLength":
      if (Number(args[0]) === 1) {
        return "This field is required";
      } else if (args[0] > 1) {
        return `Must be at least ${args[0]} characters long`;
      }
      break;
    case "isAlphanumericLocator":
      if (args[0] && import_validator.default.matches(args[0], /^[a-zA-Z0-9_-]+$/)) {
        return "";
      } else {
        return "This please only enter valid characters. Valid characters are a-z, A-Z, 0-9, _ and -";
      }
    case "isNot":
      if (args[0] === args[1]) {
        return `This field should have a value other than ${args[0]}`;
      }
      break;
    default:
      return "There is an error with this field";
  }
};
var tryApplyValidationEntry = (value, validations = [], validationResults = []) => {
  const validation = validations.shift();
  if (!validation) {
    return validationResults.pop();
  }
  let args = validation.split(":");
  const validateMethod = args.shift();
  const tmpArgs = args;
  args = [value].concat(args);
  try {
    if (!import_validator.default[validateMethod](...args)) {
      return tryApplyValidationEntry(value, validations, [...validationResults, { errortext: getErrorMsg(validateMethod, tmpArgs), isValid: false }]);
    }
  } catch {
    const errortext = getErrorMsg(validateMethod, args) || "";
    return tryApplyValidationEntry(value, validations, [...validationResults, { errortext, isValid: !errortext }]);
  }
  return { errortext: "", isValid: true };
};
var tryApplyValidations = (value, validations, initialValidationResult) => validations.split(",").reduce((accu, validation) => {
  if (!accu.isValid || !validation) {
    return accu;
  }
  const alternatives = validation.split("||");
  return tryApplyValidationEntry(value, alternatives, [accu]);
}, initialValidationResult);
var runPasswordValidations = ({ required, value, validations, isValid, errortext }) => {
  if (required && !value) {
    return { isValid: false, errortext: "Password is required" };
  } else if (required || value) {
    const { isValid: validatedIsValid, errortext: validatedErrortext } = tryApplyValidations(value, validations, { isValid, errortext });
    return { isValid: validatedIsValid, errortext: !validatedIsValid ? validatedErrortext ? validatedErrortext : "Password too weak" : errortext };
  }
  return { isValid, errortext };
};
var runValidations = ({ required, value, id, validations, wasMaybeTouched }) => {
  const isValid = true;
  const errortext = "";
  if (id && id.includes("password")) {
    return runPasswordValidations({ required, value, validations, isValid, errortext });
  } else {
    if (value || required || wasMaybeTouched && validations.includes("isLength:1")) {
      return tryApplyValidations(validations.includes("trim") ? value.trim() : value, validations, { isValid, errortext });
    }
  }
  return { isValid, errortext };
};
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  buttonWrapper: { display: "flex", justifyContent: "flex-end", height: "min-content", marginTop: theme.spacing(4) },
  cancelButton: { marginRight: theme.spacing() }
}));

// src/forms/PasswordInput.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var PasswordGenerateButtons = ({ clearPass, edit, generatePass, disabled }) => /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { className: "pass-buttons", children: [
  /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.Button, { color: "primary", onClick: generatePass, disabled, children: "Generate" }),
  edit ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.Button, { onClick: clearPass, children: "Cancel" }) : null
] });
var SCORE_THRESHOLD = 3;
var PasswordGenerationControls = ({ score, feedback }) => /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_jsx_runtime2.Fragment, { children: [
  /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { className: "help-text", id: "pass-strength", children: [
    "Strength: ",
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("meter", { max: 4, min: 0, value: score, high: 3.9, optimum: 4, low: 2.5 }),
    score > SCORE_THRESHOLD ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_icons_material.CheckCircle, { className: "fadeIn green", style: { height: 18, marginTop: -3, marginBottom: -3 } }) : null
  ] }),
  !!feedback.length && /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("p", { className: "help-text", children: feedback.map((message, index) => /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_react2.default.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("span", { children: message }),
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("br", {})
  ] }, `feedback-${index}`)) })
] });
var PasswordInput = ({
  autocomplete,
  className,
  control,
  create,
  defaultValue,
  disabled,
  edit,
  generate,
  id,
  InputLabelProps = {},
  label,
  onClear,
  placeholder,
  required,
  validations = ""
}) => {
  const [score, setScore] = (0, import_react2.useState)(0);
  const [visible, setVisible] = (0, import_react2.useState)(false);
  const [copied, setCopied] = (0, import_react2.useState)(false);
  const [feedback, setFeedback] = (0, import_react2.useState)([]);
  const [confirmationId] = (0, import_react2.useState)(id.includes("current") ? "" : ["password", "password_confirmation"].find((thing) => thing !== id));
  const timer = (0, import_react2.useRef)();
  const {
    clearErrors,
    formState: { errors },
    setError,
    setValue,
    trigger,
    getValues
  } = (0, import_react_hook_form2.useFormContext)();
  const confirmation = (0, import_react_hook_form2.useWatch)({ name: confirmationId });
  const errorKey = `${id}`;
  const { message } = errors[errorKey] ?? {};
  (0, import_react2.useEffect)(() => {
    if (confirmationId === "password" && !message) {
      trigger(confirmationId);
    }
  }, [confirmationId, message, trigger]);
  (0, import_react2.useEffect)(() => () => {
    clearTimeout(timer.current);
  });
  const clearPassClick = () => {
    setValue(id, "");
    onClear();
    setCopied(false);
  };
  const generatePassClick = () => {
    const password = import_generate_password_browser.default.generate({ length: 16, numbers: true });
    setValue(id, password);
    const form = getValues();
    if (form.hasOwnProperty(`${id}_confirmation`)) {
      setValue(`${id}_confirmation`, password);
    }
    (0, import_copy_to_clipboard.default)(password);
    setCopied(true);
    setVisible(true);
    timer.current = setTimeout(() => setCopied(false), import_constants.TIMEOUTS.fiveSeconds);
    trigger();
  };
  const validate = async (value = "") => {
    if (disabled) {
      return true;
    }
    let { isValid, errortext } = runValidations({ id, required, validations, value });
    if (confirmation && value !== confirmation) {
      isValid = false;
      errortext = "The passwords you provided do not match, please check again.";
    }
    if (isValid) {
      clearErrors(errorKey);
    } else {
      setError(errorKey, { type: "validate", message: errortext });
    }
    const { default: zxcvbn } = await import(
      /* webpackChunkName: "zxcvbn" */
      "zxcvbn"
    );
    const strength = zxcvbn(value);
    const score2 = strength.score;
    setScore(score2);
    if (!create || !required && !value) {
      return isValid || errortext;
    }
    setFeedback(strength.feedback.suggestions || []);
    return score2 > SCORE_THRESHOLD && isValid || errortext;
  };
  const showAsNotched = label && typeof label !== "string" ? { notched: true } : {};
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { className, children: [
    /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { className: "password-wrapper", children: [
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
        import_react_hook_form2.Controller,
        {
          name: id,
          control,
          rules: { required, validate },
          render: ({ field: { value, onChange, onBlur, ref }, fieldState: { error } }) => /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_material2.FormControl, { className: required ? "required" : "", error: Boolean((error || errors[errorKey])?.message), style: { width: 400 }, children: [
            /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.InputLabel, { htmlFor: id, ...InputLabelProps, children: label }),
            /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
              import_material2.OutlinedInput,
              {
                autoComplete: autocomplete,
                id,
                label,
                name: id,
                type: visible ? "text" : "password",
                defaultValue,
                placeholder,
                value: value ?? "",
                disabled,
                inputRef: ref,
                required,
                onChange: ({ target: { value: value2 } }) => {
                  setValue(id, value2);
                  onChange(value2);
                },
                onBlur,
                endAdornment: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.InputAdornment, { position: "end", children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.IconButton, { onClick: () => setVisible(import_helpers.toggle), size: "large", children: visible ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_icons_material.Visibility, {}) : /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_icons_material.VisibilityOff, {}) }) }),
                ...showAsNotched
              }
            ),
            /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.FormHelperText, { children: (errors[errorKey] || error)?.message })
          ] })
        }
      ),
      generate && !required && /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(PasswordGenerateButtons, { disabled, clearPass: clearPassClick, edit, generatePass: generatePassClick })
    ] }),
    copied ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { className: "green fadeIn margin-bottom-small", children: "Copied to clipboard" }) : null,
    create && /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_jsx_runtime2.Fragment, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(PasswordGenerationControls, { feedback, score }),
      generate && required && /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(PasswordGenerateButtons, { disabled, clearPass: clearPassClick, edit, generatePass: generatePassClick })
    ] })
  ] });
};
var PasswordInput_default = PasswordInput;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  PasswordInput
});
//# sourceMappingURL=PasswordInput.cjs.map