"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/auditlogs/eventdetails/DeviceDetails.tsx
var DeviceDetails_exports = {};
__export(DeviceDetails_exports, {
  DetailInformation: () => DetailInformation,
  DeviceDetails: () => DeviceDetails,
  default: () => DeviceDetails_default
});
module.exports = __toCommonJS(DeviceDetails_exports);
var import_react_router_dom = require("react-router-dom");
var import_icons_material = require("@mui/icons-material");
var import_mui = require("tss-react/mui");
var import_ConfigurationObject = require("@northern.tech/common-ui/ConfigurationObject");
var import_DeviceIdentity = __toESM(require("@northern.tech/common-ui/DeviceIdentity"), 1);
var import_constants = require("@northern.tech/store/constants");
var import_locationutils = require("@northern.tech/store/locationutils");
var import_jsx_runtime = require("react/jsx-runtime");
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  eventDetails: { gridTemplateColumns: "minmax(max-content, 150px) max-content", rowGap: theme.spacing(2.5) },
  deviceLink: { color: theme.palette.text.secondary, fontWeight: "initial" }
}));
var DetailInformation = ({ title, details }) => {
  const { classes } = useStyles();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "flexbox column margin-top-small", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("b", { className: "margin-bottom-small capitalized-start", children: [
      title,
      " details"
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_ConfigurationObject.TwoColumns, { className: classes.eventDetails, items: details })
  ] }, `${title}-details`);
};
var deviceAuditlogType = import_constants.AUDIT_LOGS_TYPES.find((type) => type.value === "device");
var DeviceDetails = ({ device, idAttribute, onClose }) => {
  const { classes } = useStyles();
  const { attributes, id: deviceId } = device;
  const { name, device_type: deviceTypes, artifact_name } = attributes || {};
  const { attribute } = idAttribute;
  const usesId = attribute === "id" || attribute === "Device ID";
  const nameContainer = name ? { Name: name } : {};
  const deviceDetails = {
    ...nameContainer,
    [usesId ? "Device ID" : attribute]: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_react_router_dom.Link, { className: `flexbox center-aligned ${classes.deviceLink}`, to: `/devices?id=${deviceId}`, children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_DeviceIdentity.default, { device, isEditable: false }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Launch, { className: "margin-left-small link-color", fontSize: "small" })
    ] }),
    "Device type": deviceTypes,
    "Operating system version": device[import_constants.rootfsImageVersion] || artifact_name || "-",
    " ": /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_react_router_dom.Link,
      {
        to: `/auditlog?${(0, import_locationutils.formatAuditlogs)({ pageState: { type: deviceAuditlogType, detail: deviceId, startDate: import_constants.BEGINNING_OF_TIME } }, {})}`,
        onClick: onClose,
        children: "List all log entries for this device"
      }
    )
  };
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DetailInformation, { title: "device", details: deviceDetails });
};
var DeviceDetails_default = DeviceDetails;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DetailInformation,
  DeviceDetails
});
//# sourceMappingURL=DeviceDetails.cjs.map