// src/auditlogs/ColumnComponents.tsx
import { Link } from "react-router-dom";
import DetailsIndicator from "@northern.tech/common-ui/DetailsIndicator";
import DeviceIdentityDisplay from "@northern.tech/common-ui/DeviceIdentity";
import Time from "@northern.tech/common-ui/Time";
import { AUDIT_LOGS_TYPES, DEPLOYMENT_ROUTES, canAccess } from "@northern.tech/store/constants";
import { jsx } from "react/jsx-runtime";
var ArtifactLink = ({ item }) => /* @__PURE__ */ jsx(Link, { to: `/releases/${item.object.artifact.name}`, children: "View artifact" });
var DeploymentLink = ({ item }) => /* @__PURE__ */ jsx(Link, { to: `${DEPLOYMENT_ROUTES.finished.route}?open=true&id=${item.object.id}`, children: "View deployment" });
var DeviceLink = ({ item }) => /* @__PURE__ */ jsx(Link, { to: `/devices?id=${item.object.id}`, children: "View device" });
var DeviceRejectedLink = ({ item }) => /* @__PURE__ */ jsx(Link, { to: `/devices/rejected?id=${item.object.id}`, children: "View device" });
var TerminalSessionLink = () => /* @__PURE__ */ jsx("a", { children: "View session log" });
var ChangeFallback = (props) => {
  const {
    item: { change = "-" }
  } = props;
  return /* @__PURE__ */ jsx("div", { className: "text-overflow", children: change });
};
var FallbackFormatter = (props) => {
  let result = "";
  try {
    result = JSON.stringify(props);
  } catch (error) {
    console.log(error);
  }
  return /* @__PURE__ */ jsx("div", { children: result });
};
var ArtifactFormatter = ({ artifact }) => /* @__PURE__ */ jsx("div", { children: artifact.name });
var DeploymentFormatter = ({ deployment }) => /* @__PURE__ */ jsx("div", { children: deployment.name });
var DeviceFormatter = ({ id }) => /* @__PURE__ */ jsx(DeviceIdentityDisplay, { device: { id } });
var UserFormatter = ({ user }) => /* @__PURE__ */ jsx("div", { children: user.email });
var TenantFormatter = ({ tenant }) => /* @__PURE__ */ jsx("div", { children: tenant.name });
var defaultAccess = canAccess;
var changeMap = {
  default: { component: "div", actionFormatter: FallbackFormatter, title: "defaultTitle", accessCheck: defaultAccess },
  artifact: { actionFormatter: ArtifactFormatter, component: ArtifactLink, accessCheck: ({ canReadReleases }) => canReadReleases },
  deployment: {
    actionFormatter: DeploymentFormatter,
    component: DeploymentLink,
    accessCheck: ({ canReadDeployments }) => canReadDeployments
  },
  deviceDecommissioned: { actionFormatter: DeviceFormatter, component: "div", accessCheck: defaultAccess },
  deviceRejected: { actionFormatter: DeviceFormatter, component: DeviceRejectedLink, accessCheck: ({ canReadDevices }) => canReadDevices },
  deviceGeneral: { actionFormatter: DeviceFormatter, component: DeviceLink, accessCheck: ({ canReadDevices }) => canReadDevices },
  deviceTerminalSession: { actionFormatter: DeviceFormatter, component: TerminalSessionLink, accessCheck: defaultAccess },
  user: { actionFormatter: UserFormatter, component: ChangeFallback, accessCheck: defaultAccess },
  user_access_token: { actionFormatter: FallbackFormatter, component: ChangeFallback, accessCheck: defaultAccess },
  tenant: { actionFormatter: TenantFormatter, component: ChangeFallback, accessCheck: defaultAccess }
};
var mapChangeToContent = (item) => {
  let content = changeMap[item.object.type];
  if (content) {
    return content;
  } else if (item.object.type === "device" && item.action.includes("terminal")) {
    content = changeMap.deviceTerminalSession;
  } else if (item.object.type === "device" && item.action.includes("reject")) {
    content = changeMap.deviceRejected;
  } else if (item.object.type === "device" && item.action.includes("decommission")) {
    content = changeMap.deviceDecommissioned;
  } else if (item.object.type === "device") {
    content = changeMap.deviceGeneral;
  } else {
    content = changeMap.default;
  }
  return content;
};
var actorMap = {
  user: "email",
  device: "id"
};
var generateKey = (item, index) => `${item.time}-${index}`;
var UserDescriptor = (item, index) => /* @__PURE__ */ jsx("div", { children: item.actor[actorMap[item.actor.type]] }, generateKey(item, index));
var ActionDescriptor = (item, index) => /* @__PURE__ */ jsx("div", { className: "uppercased", children: item.action }, generateKey(item, index));
var TypeDescriptor = (item, index) => /* @__PURE__ */ jsx("div", { className: "capitalized", children: AUDIT_LOGS_TYPES[item.object.type]?.title ?? item.object.type }, generateKey(item, index));
var ChangeDescriptor = (item, index) => {
  const FormatterComponent = mapChangeToContent(item).actionFormatter;
  return /* @__PURE__ */ jsx(FormatterComponent, { ...item.object }, generateKey(item, index));
};
var ChangeDetailsDescriptor = (item, index, userCapabilities) => {
  const { component: Comp, accessCheck } = mapChangeToContent(item);
  const key = generateKey(item, index);
  return accessCheck(userCapabilities) ? /* @__PURE__ */ jsx(Comp, { item }, key) : /* @__PURE__ */ jsx("div", {}, key);
};
var TimeWrapper = (item, index) => /* @__PURE__ */ jsx(Time, { value: item.time }, generateKey(item, index));
var ViewDetails = ({ item, index, onIssueSelection = () => {
}, ViewComponent = DetailsIndicator }) => /* @__PURE__ */ jsx("div", { className: "clickable", onClick: () => onIssueSelection(item), children: /* @__PURE__ */ jsx(ViewComponent, {}) }, generateKey(item, index));

export {
  UserDescriptor,
  ActionDescriptor,
  TypeDescriptor,
  ChangeDescriptor,
  ChangeDetailsDescriptor,
  TimeWrapper,
  ViewDetails
};
//# sourceMappingURL=chunk-BNQO4KJ2.js.map