"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  AuditLogs: () => AuditLogs,
  Button: () => Button3
});
module.exports = __toCommonJS(index_exports);

// src/auditlogs/AuditLogs.tsx
var import_react7 = require("react");
var import_react_redux5 = require("react-redux");
var import_mui4 = require("tss-react/mui");
var import_EnterpriseNotification = __toESM(require("@northern.tech/common-ui/EnterpriseNotification"), 1);
var import_constants5 = require("@northern.tech/store/constants");
var import_liststatehook = require("@northern.tech/store/liststatehook");
var import_selectors5 = require("@northern.tech/store/selectors");
var import_thunks5 = require("@northern.tech/store/thunks");
var import_helpers3 = require("@northern.tech/utils/helpers");
var import_dayjs3 = __toESM(require("dayjs"), 1);

// ../../assets/img/history.png
var history_default = "./history-JI2OFHQF.png";

// src/auditlogs/AuditLogsFilter.tsx
var import_react = require("react");
var import_material = require("@mui/material");
var import_Autocomplete = require("@northern.tech/common-ui/forms/Autocomplete");
var import_ClickFilter = __toESM(require("@northern.tech/common-ui/forms/ClickFilter"), 1);
var import_Filters = __toESM(require("@northern.tech/common-ui/forms/Filters"), 1);
var import_TimeframePicker = __toESM(require("@northern.tech/common-ui/forms/TimeframePicker"), 1);
var import_helpers = require("@northern.tech/utils/helpers");
var import_jsx_runtime = require("react/jsx-runtime");
var detailsMap = {
  Deployment: "to device group",
  User: "email"
};
var getOptionLabel = (option) => option.title ?? option.email ?? option;
var renderOption = (props, option) => {
  const { key, ...rest } = props;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("li", { ...rest, children: getOptionLabel(option) }, key);
};
var isUserOptionEqualToValue = ({ email, id }, value) => id === value || email === value || email === value?.email;
var autoSelectProps = {
  autoSelect: true,
  filterSelectedOptions: true,
  getOptionLabel,
  handleHomeEndKeys: true,
  renderOption
};
var AuditLogsFilter = ({ groups, users, selectionState, disabled, onFiltersChange, detailsReset, auditLogsTypes, dirtyField, setDirtyField }) => {
  const { detail, endDate, user, startDate, type } = selectionState;
  const [date] = (0, import_react.useState)((0, import_helpers.getISOStringBoundaries)(/* @__PURE__ */ new Date()));
  const { start: today, end: tonight } = date;
  const typeOptionsMap = {
    Deployment: groups,
    User: Object.values(users)
  };
  const detailOptions = typeOptionsMap[type?.title] ?? [];
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_ClickFilter.default, { disabled, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_Filters.default,
    {
      initialValues: { startDate, endDate, user, type, detail },
      defaultValues: { startDate: today, endDate: tonight, user: "", type: null, detail: "" },
      fieldResetTrigger: detailsReset,
      dirtyField,
      clearDirty: setDirtyField,
      filters: [
        {
          key: "user",
          title: "Performed by",
          Component: import_Autocomplete.ControlledAutoComplete,
          componentProps: {
            ...autoSelectProps,
            freeSolo: true,
            isOptionEqualToValue: isUserOptionEqualToValue,
            options: Object.values(users),
            renderInput: (params) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.TextField, { ...params, placeholder: "Select a user", InputProps: { ...params.InputProps } })
          }
        },
        {
          key: "type",
          title: "Filter by changes",
          Component: import_Autocomplete.ControlledAutoComplete,
          componentProps: {
            ...autoSelectProps,
            options: auditLogsTypes,
            isOptionEqualToValue: (option, value) => option.value === value.value && option.object_type === value.object_type,
            renderInput: (params) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.TextField, { ...params, placeholder: "Type", InputProps: { ...params.InputProps } })
          }
        },
        {
          key: "detail",
          title: "",
          Component: import_Autocomplete.ControlledAutoComplete,
          componentProps: {
            ...autoSelectProps,
            freeSolo: true,
            options: detailOptions,
            disabled: !type,
            renderInput: (params) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.TextField, { ...params, placeholder: detailsMap[type] || "-", InputProps: { ...params.InputProps } })
          }
        },
        {
          key: "timeframe",
          title: "Start time",
          Component: import_TimeframePicker.default,
          componentProps: {
            tonight
          }
        }
      ],
      onChange: onFiltersChange
    }
  ) });
};
var AuditLogsFilter_default = AuditLogsFilter;

// src/auditlogs/AuditLogsList.tsx
var import_icons_material = require("@mui/icons-material");
var import_mui = require("tss-react/mui");
var import_DetailsIndicator = __toESM(require("@northern.tech/common-ui/DetailsIndicator"), 1);
var import_Loader = __toESM(require("@northern.tech/common-ui/Loader"), 1);
var import_Pagination = __toESM(require("@northern.tech/common-ui/Pagination"), 1);
var import_constants = require("@northern.tech/store/constants");
var import_jsx_runtime2 = require("react/jsx-runtime");
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  auditlogsList: {
    "& .auditlogs-list-item": {
      display: "grid",
      gridTemplateColumns: "2fr 1fr 1fr 2fr 2fr 1.75fr 120px",
      gridColumnGap: theme.spacing(4),
      padding: `5px ${theme.spacing(2)}`,
      borderBottom: `1px solid ${theme.palette.border.main}`,
      height: theme.spacing(6),
      minHeight: theme.spacing(6),
      maxHeight: theme.spacing(6),
      alignItems: "center",
      "&:last-of-type": {
        borderBottom: "transparent"
      },
      "& > *": {
        display: "flex",
        alignItems: "center",
        maxHeight: theme.spacing(6),
        overflow: "hidden"
      },
      "> .text-overflow": {
        display: "block"
      },
      "&.auditlogs-list-item-header": {
        borderBottom: "transparent",
        cursor: "initial",
        padding: `10px ${theme.spacing(2)}`,
        position: "relative"
      }
    }
  }
}));
var AuditLogsList = ({
  items,
  onChangePage,
  onChangeRowsPerPage,
  onChangeSorting,
  selectionState,
  userCapabilities,
  auditLogColumns,
  onIssueSelection
}) => {
  const { page, perPage, sort = {}, total: count, isLoading } = selectionState;
  const { classes } = useStyles();
  return !!items.length && /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { className: `fadeIn deploy-table-contain auditlogs-list ${classes.auditlogsList}`, children: [
    /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { className: "auditlogs-list-item auditlogs-list-item-header muted", children: [
      auditLogColumns.map((column, index) => /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(
        "div",
        {
          className: "columnHeader",
          onClick: () => column.sortable ? onChangeSorting() : null,
          style: column.sortable ? {} : { cursor: "initial" },
          children: [
            column.title,
            column.sortable ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_icons_material.Sort, { className: `sortIcon selected ${(sort.direction === import_constants.SORTING_OPTIONS.desc).toString()}` }) : null
          ]
        },
        `columnHeader-${index}`
      )),
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", {})
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { className: "auditlogs-list", children: items.map((item) => {
      const allowsExpansion = onIssueSelection && (!!item.change || item.action.includes("terminal") || item.action.includes("portforward"));
      return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(
        "div",
        {
          className: `auditlogs-list-item ${allowsExpansion ? "clickable" : ""}`,
          onClick: () => onIssueSelection ? onIssueSelection(allowsExpansion ? item : void 0) : null,
          children: [
            auditLogColumns.map((column, index) => column.render(item, index, userCapabilities)),
            allowsExpansion ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_DetailsIndicator.default, {}) : /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", {})
          ]
        },
        `event-${item.time}`
      );
    }) }),
    /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { className: "flexbox margin-top", children: [
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
        import_Pagination.default,
        {
          className: "margin-top-none",
          count,
          rowsPerPage: perPage,
          onChangeRowsPerPage,
          page,
          onChangePage
        }
      ),
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_Loader.default, { show: isLoading, small: true })
    ] })
  ] });
};
var AuditLogsList_default = AuditLogsList;

// src/auditlogs/AuditlogsView.tsx
var import_material2 = require("@mui/material");
var import_InfoHint = require("@northern.tech/common-ui/InfoHint");
var import_Loader2 = __toESM(require("@northern.tech/common-ui/Loader"), 1);
var import_jsx_runtime3 = require("react/jsx-runtime");
var AuditlogsView = ({ total, csvLoading, createCsvDownload, infoHintComponent = null, auditLogsFilter, children }) => /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("div", { className: "fadeIn margin-left flexbox column", style: { marginRight: "5%" }, children: [
  /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("div", { className: "flexbox center-aligned", children: [
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("h3", { className: "margin-right-small", children: "Audit log" }),
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_InfoHint.InfoHintContainer, { children: infoHintComponent })
  ] }),
  auditLogsFilter,
  /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("div", { className: "flexbox center-aligned", style: { justifyContent: "flex-end" }, children: [
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_Loader2.default, { show: csvLoading }),
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material2.Button, { variant: "contained", color: "secondary", disabled: csvLoading || !total, onClick: createCsvDownload, style: { marginLeft: 15 }, children: "Download results as csv" })
  ] }),
  children
] });
var AuditlogsView_default = AuditlogsView;

// src/auditlogs/ColumnComponents.tsx
var import_react_router_dom = require("react-router-dom");
var import_DetailsIndicator2 = __toESM(require("@northern.tech/common-ui/DetailsIndicator"), 1);
var import_DeviceIdentity = __toESM(require("@northern.tech/common-ui/DeviceIdentity"), 1);
var import_Time = __toESM(require("@northern.tech/common-ui/Time"), 1);
var import_constants2 = require("@northern.tech/store/constants");
var import_jsx_runtime4 = require("react/jsx-runtime");
var ArtifactLink = ({ item }) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_react_router_dom.Link, { to: `/releases/${item.object.artifact.name}`, children: "View artifact" });
var DeploymentLink = ({ item }) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_react_router_dom.Link, { to: `${import_constants2.DEPLOYMENT_ROUTES.finished.route}?open=true&id=${item.object.id}`, children: "View deployment" });
var DeviceLink = ({ item }) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_react_router_dom.Link, { to: `/devices?id=${item.object.id}`, children: "View device" });
var DeviceRejectedLink = ({ item }) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_react_router_dom.Link, { to: `/devices/rejected?id=${item.object.id}`, children: "View device" });
var TerminalSessionLink = () => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("a", { children: "View session log" });
var ChangeFallback = (props) => {
  const {
    item: { change = "-" }
  } = props;
  return /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { className: "text-overflow", children: change });
};
var FallbackFormatter = (props) => {
  let result = "";
  try {
    result = JSON.stringify(props);
  } catch (error) {
    console.log(error);
  }
  return /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { children: result });
};
var ArtifactFormatter = ({ artifact }) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { children: artifact.name });
var DeploymentFormatter = ({ deployment }) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { children: deployment.name });
var DeviceFormatter = ({ id }) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_DeviceIdentity.default, { device: { id } });
var UserFormatter = ({ user }) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { children: user.email });
var TenantFormatter = ({ tenant }) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { children: tenant.name });
var defaultAccess = import_constants2.canAccess;
var changeMap = {
  default: { component: "div", actionFormatter: FallbackFormatter, title: "defaultTitle", accessCheck: defaultAccess },
  artifact: { actionFormatter: ArtifactFormatter, component: ArtifactLink, accessCheck: ({ canReadReleases }) => canReadReleases },
  deployment: {
    actionFormatter: DeploymentFormatter,
    component: DeploymentLink,
    accessCheck: ({ canReadDeployments }) => canReadDeployments
  },
  deviceDecommissioned: { actionFormatter: DeviceFormatter, component: "div", accessCheck: defaultAccess },
  deviceRejected: { actionFormatter: DeviceFormatter, component: DeviceRejectedLink, accessCheck: ({ canReadDevices }) => canReadDevices },
  deviceGeneral: { actionFormatter: DeviceFormatter, component: DeviceLink, accessCheck: ({ canReadDevices }) => canReadDevices },
  deviceTerminalSession: { actionFormatter: DeviceFormatter, component: TerminalSessionLink, accessCheck: defaultAccess },
  user: { actionFormatter: UserFormatter, component: ChangeFallback, accessCheck: defaultAccess },
  user_access_token: { actionFormatter: FallbackFormatter, component: ChangeFallback, accessCheck: defaultAccess },
  tenant: { actionFormatter: TenantFormatter, component: ChangeFallback, accessCheck: defaultAccess }
};
var mapChangeToContent = (item) => {
  let content = changeMap[item.object.type];
  if (content) {
    return content;
  } else if (item.object.type === "device" && item.action.includes("terminal")) {
    content = changeMap.deviceTerminalSession;
  } else if (item.object.type === "device" && item.action.includes("reject")) {
    content = changeMap.deviceRejected;
  } else if (item.object.type === "device" && item.action.includes("decommission")) {
    content = changeMap.deviceDecommissioned;
  } else if (item.object.type === "device") {
    content = changeMap.deviceGeneral;
  } else {
    content = changeMap.default;
  }
  return content;
};
var actorMap = {
  user: "email",
  device: "id"
};
var generateKey = (item, index) => `${item.time}-${index}`;
var UserDescriptor = (item, index) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { children: item.actor[actorMap[item.actor.type]] }, generateKey(item, index));
var ActionDescriptor = (item, index) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { className: "uppercased", children: item.action }, generateKey(item, index));
var TypeDescriptor = (item, index) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { className: "capitalized", children: import_constants2.AUDIT_LOGS_TYPES[item.object.type]?.title ?? item.object.type }, generateKey(item, index));
var ChangeDescriptor = (item, index) => {
  const FormatterComponent = mapChangeToContent(item).actionFormatter;
  return /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(FormatterComponent, { ...item.object }, generateKey(item, index));
};
var ChangeDetailsDescriptor = (item, index, userCapabilities) => {
  const { component: Comp, accessCheck } = mapChangeToContent(item);
  const key = generateKey(item, index);
  return accessCheck(userCapabilities) ? /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(Comp, { item }, key) : /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", {}, key);
};
var TimeWrapper = (item, index) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_Time.default, { value: item.time }, generateKey(item, index));

// src/auditlogs/EventDetailsDrawer.tsx
var import_material3 = require("@mui/material");
var import_styles = require("@mui/material/styles");
var import_DrawerTitle = require("@northern.tech/common-ui/DrawerTitle");
var import_jsx_runtime5 = require("react/jsx-runtime");
var EventDetailsDrawer = ({ eventItem = {}, onClose, open, mapChangeToContent: mapChangeToContent2, fallbackComponent }) => {
  const theme = (0, import_styles.useTheme)();
  const { title, content: Component } = mapChangeToContent2(eventItem, fallbackComponent);
  return /* @__PURE__ */ (0, import_jsx_runtime5.jsxs)(import_material3.Drawer, { className: `${open ? "fadeIn" : "fadeOut"}`, anchor: "right", open, onClose, children: [
    /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_DrawerTitle.DrawerTitle, { title: /* @__PURE__ */ (0, import_jsx_runtime5.jsx)("div", { className: "capitalized-start", children: title }), onClose }),
    /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_material3.Divider, {}),
    /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(Component, { item: eventItem, onClose }),
    /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_material3.Divider, { light: true, style: { marginTop: theme.spacing(2) } })
  ] });
};
var EventDetailsDrawer_default = EventDetailsDrawer;

// src/auditlogs/eventdetails/DeviceConfiguration.tsx
var import_react2 = require("react");
var import_react_redux = require("react-redux");
var import_styles2 = require("@mui/material/styles");
var import_Loader3 = __toESM(require("@northern.tech/common-ui/Loader"), 1);
var import_selectors = require("@northern.tech/store/selectors");
var import_thunks = require("@northern.tech/store/thunks");

// src/auditlogs/eventdetails/DeviceDetails.tsx
var import_react_router_dom2 = require("react-router-dom");
var import_icons_material2 = require("@mui/icons-material");
var import_mui2 = require("tss-react/mui");
var import_ConfigurationObject = require("@northern.tech/common-ui/ConfigurationObject");
var import_DeviceIdentity2 = __toESM(require("@northern.tech/common-ui/DeviceIdentity"), 1);
var import_constants3 = require("@northern.tech/store/constants");
var import_locationutils = require("@northern.tech/store/locationutils");
var import_jsx_runtime6 = require("react/jsx-runtime");
var useStyles2 = (0, import_mui2.makeStyles)()((theme) => ({
  eventDetails: { gridTemplateColumns: "minmax(max-content, 150px) max-content", rowGap: theme.spacing(2.5) },
  deviceLink: { color: theme.palette.text.secondary, fontWeight: "initial" }
}));
var DetailInformation = ({ title, details }) => {
  const { classes } = useStyles2();
  return /* @__PURE__ */ (0, import_jsx_runtime6.jsxs)("div", { className: "flexbox column margin-top-small", children: [
    /* @__PURE__ */ (0, import_jsx_runtime6.jsxs)("b", { className: "margin-bottom-small capitalized-start", children: [
      title,
      " details"
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(import_ConfigurationObject.TwoColumns, { className: classes.eventDetails, items: details })
  ] }, `${title}-details`);
};
var deviceAuditlogType = import_constants3.AUDIT_LOGS_TYPES.find((type) => type.value === "device");
var DeviceDetails = ({ device, idAttribute, onClose }) => {
  const { classes } = useStyles2();
  const { attributes, id: deviceId } = device;
  const { name, device_type: deviceTypes, artifact_name } = attributes || {};
  const { attribute } = idAttribute;
  const usesId = attribute === "id" || attribute === "Device ID";
  const nameContainer = name ? { Name: name } : {};
  const deviceDetails = {
    ...nameContainer,
    [usesId ? "Device ID" : attribute]: /* @__PURE__ */ (0, import_jsx_runtime6.jsxs)(import_react_router_dom2.Link, { className: `flexbox center-aligned ${classes.deviceLink}`, to: `/devices?id=${deviceId}`, children: [
      /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(import_DeviceIdentity2.default, { device, isEditable: false }),
      /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(import_icons_material2.Launch, { className: "margin-left-small link-color", fontSize: "small" })
    ] }),
    "Device type": deviceTypes,
    "Operating system version": device[import_constants3.rootfsImageVersion] || artifact_name || "-",
    " ": /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(
      import_react_router_dom2.Link,
      {
        to: `/auditlog?${(0, import_locationutils.formatAuditlogs)({ pageState: { type: deviceAuditlogType, detail: deviceId, startDate: import_constants3.BEGINNING_OF_TIME } }, {})}`,
        onClick: onClose,
        children: "List all log entries for this device"
      }
    )
  };
  return /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(DetailInformation, { title: "device", details: deviceDetails });
};
var DeviceDetails_default = DeviceDetails;

// src/auditlogs/eventdetails/DeviceConfiguration.tsx
var import_jsx_runtime7 = require("react/jsx-runtime");
var DeviceConfiguration = ({ item, onClose }) => {
  const { object = {} } = item;
  const { canReadDevices } = (0, import_react_redux.useSelector)(import_selectors.getUserCapabilities);
  const device = (0, import_react_redux.useSelector)(import_selectors.getAuditlogDevice);
  const idAttribute = (0, import_react_redux.useSelector)(import_selectors.getIdAttribute);
  const dispatch = (0, import_react_redux.useDispatch)();
  const theme = (0, import_styles2.useTheme)();
  (0, import_react2.useEffect)(() => {
    if (canReadDevices) {
      dispatch((0, import_thunks.getDeviceById)(object.id));
    }
  }, [canReadDevices, dispatch, object.id]);
  if (canReadDevices && !device.id) {
    return /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_Loader3.default, { show: true });
  }
  const { actor, change } = item;
  let config;
  try {
    config = JSON.parse(change);
  } catch (error) {
    config = { error: `An error occurred processing the changed config:
${error}` };
  }
  return /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)("div", { className: "flexbox column", style: { margin: theme.spacing(3), minWidth: "min-content" }, children: [
    canReadDevices && /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(DeviceDetails_default, { device, idAttribute, onClose }),
    /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(DetailInformation, { title: "changed configuration", details: config }),
    /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(DetailInformation, { title: "change", details: { User: actor.email } })
  ] });
};
var DeviceConfiguration_default = DeviceConfiguration;

// src/auditlogs/eventdetails/FallbackComponent.tsx
var import_CopyCode = require("@northern.tech/common-ui/CopyCode");
var import_jsx_runtime8 = require("react/jsx-runtime");
var FallbackComponent = ({ item }) => {
  let content = "";
  try {
    content = JSON.stringify(item, null, 2);
  } catch (error) {
    content = `error parsing the logged event:
${error}`;
  }
  return /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_CopyCode.Code, { style: { whiteSpace: "pre" }, children: content });
};
var FallbackComponent_default = FallbackComponent;

// src/auditlogs/eventdetails/FileTransfer.tsx
var import_react3 = require("react");
var import_react_redux2 = require("react-redux");
var import_styles3 = require("@mui/material/styles");
var import_Loader4 = __toESM(require("@northern.tech/common-ui/Loader"), 1);
var import_selectors2 = require("@northern.tech/store/selectors");
var import_thunks2 = require("@northern.tech/store/thunks");
var import_jsx_runtime9 = require("react/jsx-runtime");
var FileTransfer = ({ item, onClose }) => {
  const dispatch = (0, import_react_redux2.useDispatch)();
  const {
    actor,
    meta: { path = [] },
    object = {}
  } = item;
  const device = (0, import_react_redux2.useSelector)(import_selectors2.getAuditlogDevice);
  const { canReadDevices } = (0, import_react_redux2.useSelector)(import_selectors2.getUserCapabilities);
  const idAttribute = (0, import_react_redux2.useSelector)(import_selectors2.getIdAttribute);
  const theme = (0, import_styles3.useTheme)();
  (0, import_react3.useEffect)(() => {
    if (canReadDevices) {
      dispatch((0, import_thunks2.getDeviceById)(object.id));
    }
  }, [canReadDevices, dispatch, object.id]);
  if (canReadDevices && !device) {
    return /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(import_Loader4.default, { show: true });
  }
  const sessionMeta = {
    Path: path.join(","),
    User: actor.email
  };
  return /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)("div", { className: "flexbox column", style: { margin: theme.spacing(3), minWidth: "min-content" }, children: [
    canReadDevices && /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(DeviceDetails_default, { device, idAttribute, onClose }),
    /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(DetailInformation, { title: "file transfer", details: sessionMeta })
  ] });
};
var FileTransfer_default = FileTransfer;

// src/auditlogs/eventdetails/PortForward.tsx
var import_react4 = require("react");
var import_react_redux3 = require("react-redux");
var import_styles4 = require("@mui/material/styles");
var import_Loader5 = __toESM(require("@northern.tech/common-ui/Loader"), 1);
var import_Time2 = __toESM(require("@northern.tech/common-ui/Time"), 1);
var import_selectors3 = require("@northern.tech/store/selectors");
var import_thunks3 = require("@northern.tech/store/thunks");
var import_dayjs = __toESM(require("dayjs"), 1);
var import_duration = __toESM(require("dayjs/plugin/duration.js"), 1);
var import_jsx_runtime10 = require("react/jsx-runtime");
import_dayjs.default.extend(import_duration.default);
var PortForward = ({ item, onClose }) => {
  const theme = (0, import_styles4.useTheme)();
  const [sessionDetails, setSessionDetails] = (0, import_react4.useState)();
  const dispatch = (0, import_react_redux3.useDispatch)();
  const { action, actor, meta, object = {}, time } = item;
  const { canReadDevices } = (0, import_react_redux3.useSelector)(import_selectors3.getUserCapabilities);
  const device = (0, import_react_redux3.useSelector)(import_selectors3.getAuditlogDevice);
  const idAttribute = (0, import_react_redux3.useSelector)(import_selectors3.getIdAttribute);
  (0, import_react4.useEffect)(() => {
    if (canReadDevices) {
      dispatch((0, import_thunks3.getDeviceById)(object.id));
    }
    dispatch(
      (0, import_thunks3.getSessionDetails)({
        sessionId: meta.session_id[0],
        deviceId: object.id,
        userId: actor.id,
        startDate: action.startsWith("open") ? time : void 0,
        endDate: action.startsWith("close") ? time : void 0
      })
    ).unwrap().then(setSessionDetails);
  }, [action, actor.id, canReadDevices, dispatch, meta.session_id, object.id, time]);
  if (!sessionDetails || canReadDevices && !device) {
    return /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(import_Loader5.default, { show: true });
  }
  const sessionMeta = {
    "Session ID": item.meta.session_id[0],
    "Start time": /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(import_Time2.default, { value: sessionDetails.start }),
    "End time": /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(import_Time2.default, { value: sessionDetails.end }),
    "Duration": import_dayjs.default.duration((0, import_dayjs.default)(sessionDetails.end).diff(sessionDetails.start)).format("HH:mm:ss:SSS"),
    User: item.actor.email
  };
  return /* @__PURE__ */ (0, import_jsx_runtime10.jsxs)("div", { className: "flexbox column", style: { margin: theme.spacing(3), minWidth: "min-content" }, children: [
    canReadDevices && /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(DeviceDetails_default, { device, idAttribute, onClose }),
    /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(DetailInformation, { title: "port forwarding", details: sessionMeta })
  ] });
};
var PortForward_default = PortForward;

// src/auditlogs/eventdetails/TerminalSession.tsx
var import_react6 = require("react");
var import_react_redux4 = require("react-redux");
var import_styles5 = require("@mui/material/styles");
var import_Loader6 = __toESM(require("@northern.tech/common-ui/Loader"), 1);
var import_Time3 = __toESM(require("@northern.tech/common-ui/Time"), 1);
var import_selectors4 = require("@northern.tech/store/selectors");
var import_thunks4 = require("@northern.tech/store/thunks");
var import_dayjs2 = __toESM(require("dayjs"), 1);
var import_duration2 = __toESM(require("dayjs/plugin/duration.js"), 1);

// src/auditlogs/eventdetails/TerminalPlayer.tsx
var import_react5 = __toESM(require("react"), 1);
var import_icons_material3 = require("@mui/icons-material");
var import_material4 = require("@mui/material");
var import_mui3 = require("tss-react/mui");
var import_xterm = __toESM(require("@northern.tech/common-ui/xterm"), 1);
var import_constants4 = require("@northern.tech/store/constants");
var import_helpers2 = require("@northern.tech/utils/helpers");
var import_msgpack5 = __toESM(require("msgpack5"), 1);
var import_universal_cookie = __toESM(require("universal-cookie"), 1);
var import_jsx_runtime11 = require("react/jsx-runtime");
var cookies = new import_universal_cookie.default();
var MessagePack = (0, import_msgpack5.default)();
var socket = null;
var buffer = [];
var timer;
var useStyles3 = (0, import_mui3.makeStyles)()((theme) => ({
  playArrow: { fontSize: "7rem", color: theme.palette.text.disabled }
}));
var generateHtml = (versions, content) => {
  const { fit, search, xterm } = Object.entries(versions).reduce((accu, [key, version]) => {
    accu[key] = version.match(/(?<version>\d.*)/).groups.version;
    return accu;
  }, {});
  return `
  <!DOCTYPE html>
  <html>
    <head>
      <link rel="stylesheet" href="https://unpkg.com/@xterm/xterm@${xterm}/css/xterm.css" />

      <script src="https://unpkg.com/@xterm/xterm@${xterm}/lib/xterm.js"></script>
      <script src="https://unpkg.com/@xterm/addon-search@${search}/lib/addon-search.js"></script>
      <script src="https://unpkg.com/@xterm/addon-fit@${fit}/lib/addon-fit.js"></script>
      <style type="text/css">
        body {
          display: grid;
          justify-items: center;
          max-width: 80vw;
          margin: 10vh auto;
          row-gap: 5vh;
          font-family: 'Segoe UI', Roboto, Ubuntu, 'Helvetica Neue', Helvetica, Arial, sans-serif;
        }
        h2 {
          color: #24444a;
        }
        button {
          background-color: #921267;
          padding: 1.3em 3.4em;
          color: #fff;
          font-weight: 700;
          text-transform: uppercase;
          border: 0;
          border-radius: 3px;
          cursor: pointer;
        }
        .disabled {
          background-color: lightgrey;
          opacity: 0.4;
        }
      </style>
    </head>
    <body>
      <img
        alt="mender-logo"
        src="data:image/png;base64,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"
      />
      <h2>Terminal playback</h2>
      <div id="terminal"></div>
      <div>
        <button id="start" onclick="handleStart()">Start</button>
        <button id="pause" class="disabled" disabled onclick="handlePause()">Pause</button>
        <button id="stop" class="disabled" disabled onclick="handleStop()">Stop</button>
      </div>
      <script>
        const byteArrayToString = body => String.fromCharCode(...body);
        const transfer = '${JSON.stringify(content.map((item) => ({ delay: item.delay, content: btoa(JSON.stringify(item.content)) })))}';
        const content = JSON.parse(transfer);
        let contentIndex = 0;
        let timer;
        const term = new Terminal();
        const fitAddon = new FitAddon.FitAddon();
        const searchAddon = new SearchAddon.SearchAddon();
        term.loadAddon(searchAddon);
        term.loadAddon(fitAddon);
        term.open(document.getElementById('terminal'));
        fitAddon.fit();
        const startButton = document.getElementById('start');
        const pauseButton = document.getElementById('pause');
        const stopButton = document.getElementById('stop');

        const resetPlayer = () => {
          contentIndex = 0;
          term.reset()
          startButton.toggleAttribute('disabled');
          pauseButton.toggleAttribute('disabled');
          stopButton.toggleAttribute('disabled');
          pauseButton.classList.toggle('disabled');
          stopButton.classList.toggle('disabled');
          startButton.classList.toggle('disabled');
        }

        const processContent = () => {
          if (contentIndex === content.length) {
            return handlePause();
          }
          const item = content[contentIndex];
          contentIndex += 1;
          let delay = 1;
          if (item.delay) {
            delay = item.delay;
          } else if (item.content) {
            const buffer = JSON.parse(atob(item.content));
            term.write(byteArrayToString(buffer.data || []))
          }
          timer = setTimeout(processContent, delay)
        };

        const handleStart = () => {
          contentIndex = 0;
          startButton.toggleAttribute('disabled');
          pauseButton.toggleAttribute('disabled');
          stopButton.toggleAttribute('disabled');
          startButton.classList.toggle('disabled');
          pauseButton.classList.toggle('disabled');
          stopButton.classList.toggle('disabled');
          timer = setTimeout(processContent, 1);
        };

        const handlePause = () => {
          startButton.toggleAttribute('disabled');
          pauseButton.toggleAttribute('disabled');
          startButton.classList.toggle('disabled');
          pauseButton.classList.toggle('disabled');
          clearTimeout(timer);
        };

        const handleStop = () => {
          clearTimeout(timer);
          resetPlayer();
        };
      </script>
    </body>
  </html>`;
};
var TerminalPlayer = ({ className, item, sessionInitialized, token }) => {
  const xtermRef = (0, import_react5.useRef)({ terminal: import_react5.default.createRef(), terminalRef: import_react5.default.createRef() });
  const [socketInitialized, setSocketInitialized] = (0, import_react5.useState)(false);
  const [bufferIndex, setBufferIndex] = (0, import_react5.useState)(0);
  const [isPlaying, setIsPlaying] = (0, import_react5.useState)(false);
  const [wasStarted, setWasStarted] = (0, import_react5.useState)(false);
  const [isPaused, setIsPaused] = (0, import_react5.useState)(false);
  const [isLoadingSession, setIsLoadingSession] = (0, import_react5.useState)(true);
  const [fitTrigger, setFitTrigger] = (0, import_react5.useState)(false);
  const { classes } = useStyles3();
  (0, import_react5.useEffect)(() => {
    if (!sessionInitialized) {
      return;
    }
    cookies.set("JWT", token, { path: "/", secure: true, sameSite: "strict", maxAge: 5 });
    socket = new WebSocket(`wss://${window.location.host}${import_constants4.deviceConnect}/sessions/${item.meta.session_id[0]}/playback`);
    socket.onopen = () => setSocketInitialized(true);
  }, [item.meta.session_id, sessionInitialized, token]);
  (0, import_react5.useEffect)(() => {
    if (!socketInitialized) {
      return;
    }
    buffer = [];
    socket.onmessage = (event) => (0, import_helpers2.blobToString)(event.data).then((data) => {
      const {
        hdr: { proto, typ, props = {} },
        body
      } = MessagePack.decode(data);
      if (proto !== import_constants4.DEVICE_MESSAGE_PROTOCOLS.Shell) {
        return;
      }
      clearTimeout(timer);
      timer = setTimeout(() => setIsLoadingSession(false), import_constants4.TIMEOUTS.oneSecond);
      switch (typ) {
        case import_constants4.DEVICE_MESSAGE_TYPES.Shell:
          return buffer.push({ content: body });
        case import_constants4.DEVICE_MESSAGE_TYPES.Delay:
          return buffer.push({ delay: props.delay_value });
        default:
          break;
      }
    });
  }, [socketInitialized]);
  (0, import_react5.useEffect)(() => {
    if (isPlaying && bufferIndex < buffer.length) {
      if (bufferIndex === 0) {
        xtermRef.current.terminal.current.reset();
      }
      if (buffer[bufferIndex].content) {
        xtermRef.current.terminal.current.write((0, import_helpers2.byteArrayToString)(buffer[bufferIndex].content));
        setTimeout(() => setBufferIndex(bufferIndex + 1), 20);
      }
      if (buffer[bufferIndex].delay) {
        setTimeout(() => {
          setBufferIndex(bufferIndex + 1);
        }, buffer[bufferIndex].delay);
      }
    } else if (!isPaused) {
      resetPlayer();
    }
  }, [bufferIndex, isPaused, isPlaying]);
  const resetPlayer = () => {
    setIsPlaying(false);
    setBufferIndex(0);
  };
  const onTogglePlayClick = (0, import_react5.useCallback)(() => {
    if (!wasStarted) {
      setWasStarted(true);
      return setTimeout(() => {
        setFitTrigger(import_helpers2.toggle);
        xtermRef.current.terminal.current.focus();
        setIsPlaying(!isPlaying);
      }, import_constants4.TIMEOUTS.debounceShort);
    }
    setIsPaused(isPlaying);
    setIsPlaying(!isPlaying);
  }, [isPlaying, wasStarted]);
  const onReplayClick = () => {
    resetPlayer();
    setIsPlaying(true);
  };
  const onDownloadClick = () => {
    const text = generateHtml({ fit: XTERM_FIT_VERSION, search: XTERM_SEARCH_VERSION, xterm: XTERM_VERSION }, buffer);
    (0, import_helpers2.createFileDownload)(text, "terminalsession.html", token);
  };
  return /* @__PURE__ */ (0, import_jsx_runtime11.jsxs)("div", { className: `${className} `, children: [
    /* @__PURE__ */ (0, import_jsx_runtime11.jsxs)("div", { className: "relative", children: [
      /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(import_xterm.default, { className: "xterm-min-screen", triggerResize: fitTrigger, xtermRef }),
      !wasStarted && /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(
        "div",
        {
          className: "flexbox centered clickable",
          style: { background: "black", width: "100%", height: "100%", position: "absolute", top: 0, zIndex: 10 },
          onClick: onTogglePlayClick,
          children: /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(import_icons_material3.PlayArrow, { className: classes.playArrow })
        }
      )
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime11.jsxs)("div", { className: "flexbox margin-top-small margin-bottom-small", children: [
      /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(import_material4.Button, { color: "primary", onClick: onTogglePlayClick, startIcon: isPlaying ? /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(import_icons_material3.Pause, {}) : /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(import_icons_material3.PlayArrow, {}), children: isPlaying ? "Pause" : "Play" }),
      /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(import_material4.Button, { color: "primary", onClick: onReplayClick, disabled: isPlaying, startIcon: /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(import_icons_material3.Refresh, {}), children: "Replay" }),
      /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(import_material4.Button, { color: "primary", onClick: onDownloadClick, startIcon: /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(import_icons_material3.CloudDownload, {}), disabled: isLoadingSession, children: "Download" })
    ] })
  ] });
};
var TerminalPlayer_default = TerminalPlayer;

// src/auditlogs/eventdetails/TerminalSession.tsx
var import_jsx_runtime12 = require("react/jsx-runtime");
import_dayjs2.default.extend(import_duration2.default);
var TerminalSession = ({ item, onClose }) => {
  const theme = (0, import_styles5.useTheme)();
  const [sessionDetails, setSessionDetails] = (0, import_react6.useState)();
  const dispatch = (0, import_react_redux4.useDispatch)();
  const { action, actor, meta, object = {}, time } = item;
  const { canReadDevices } = (0, import_react_redux4.useSelector)(import_selectors4.getUserCapabilities);
  const device = (0, import_react_redux4.useSelector)(import_selectors4.getAuditlogDevice);
  const idAttribute = (0, import_react_redux4.useSelector)(import_selectors4.getIdAttribute);
  const { token } = (0, import_react_redux4.useSelector)(import_selectors4.getCurrentSession);
  (0, import_react6.useEffect)(() => {
    if (canReadDevices) {
      dispatch((0, import_thunks4.getDeviceById)(object.id));
    }
    dispatch(
      (0, import_thunks4.getSessionDetails)({
        sessionId: meta.session_id[0],
        deviceId: object.id,
        userId: actor.id,
        startDate: action.startsWith("open") ? time : void 0,
        endDate: action.startsWith("close") ? time : void 0
      })
    ).unwrap().then(setSessionDetails);
  }, [action, actor.id, canReadDevices, dispatch, meta.session_id, object.id, time]);
  if (!sessionDetails || canReadDevices && !device) {
    return /* @__PURE__ */ (0, import_jsx_runtime12.jsx)(import_Loader6.default, { show: true });
  }
  const sessionMeta = {
    "Session ID": item.meta.session_id[0],
    "Start time": /* @__PURE__ */ (0, import_jsx_runtime12.jsx)(import_Time3.default, { value: sessionDetails.start }),
    "End time": /* @__PURE__ */ (0, import_jsx_runtime12.jsx)(import_Time3.default, { value: sessionDetails.end }),
    "Duration": import_dayjs2.default.duration((0, import_dayjs2.default)(sessionDetails.end).diff(sessionDetails.start)).format("HH:mm:ss:SSS"),
    User: item.actor.email
  };
  return /* @__PURE__ */ (0, import_jsx_runtime12.jsxs)("div", { className: "flexbox", style: { flexWrap: "wrap" }, children: [
    /* @__PURE__ */ (0, import_jsx_runtime12.jsx)(TerminalPlayer_default, { className: "flexbox column margin-top", item, sessionInitialized: !!sessionDetails, token }),
    /* @__PURE__ */ (0, import_jsx_runtime12.jsxs)("div", { className: "flexbox column", style: { margin: theme.spacing(3), minWidth: "min-content" }, children: [
      canReadDevices && /* @__PURE__ */ (0, import_jsx_runtime12.jsx)(DeviceDetails_default, { device, idAttribute, onClose }),
      /* @__PURE__ */ (0, import_jsx_runtime12.jsx)(DetailInformation, { title: "session", details: sessionMeta })
    ] })
  ] });
};
var TerminalSession_default = TerminalSession;

// src/auditlogs/eventdetails/UserChange.tsx
var import_CopyCode2 = require("@northern.tech/common-ui/CopyCode");
var import_jsx_runtime13 = require("react/jsx-runtime");
var UserChange = ({ item }) => /* @__PURE__ */ (0, import_jsx_runtime13.jsx)(import_CopyCode2.Code, { children: item.change });

// src/auditlogs/EventDetailsDrawerContentMap.tsx
var changeTypes = {
  user: "user",
  device: "device",
  tenant: "tenant"
};
var configChangeDescriptor = {
  set_configuration: "definition",
  deploy_configuration: "deployment"
};
var EventDetailsDrawerContentMap = (item, FallbackComponent2 = FallbackComponent_default) => {
  const { type } = item.object || {};
  let content = { title: "Entry details", content: FallbackComponent2 };
  if (type === changeTypes.user) {
    content = { title: `${item.action}d user`, content: UserChange };
  } else if (type === changeTypes.device && item.action.includes("terminal")) {
    content = { title: "Remote session log", content: TerminalSession_default };
  } else if (type === changeTypes.device && item.action.includes("file")) {
    content = { title: "File transfer", content: FileTransfer_default };
  } else if (type === changeTypes.device && item.action.includes("portforward")) {
    content = { title: "Port forward", content: PortForward_default };
  } else if (type === changeTypes.device && item.action.includes("configuration")) {
    content = { title: `Device configuration ${configChangeDescriptor[item.action] || ""}`, content: DeviceConfiguration_default };
  } else if (type === changeTypes.device) {
    content = { title: "Device change", content: FallbackComponent2 };
  } else if (type === changeTypes.tenant) {
    content = { title: `${item.action}d tenant`, content: UserChange };
  }
  return content;
};
var EventDetailsDrawerContentMap_default = EventDetailsDrawerContentMap;

// src/auditlogs/AuditLogs.tsx
var import_jsx_runtime14 = require("react/jsx-runtime");
var useStyles4 = (0, import_mui4.makeStyles)()((theme) => ({
  filters: {
    backgroundColor: theme.palette.background.lightgrey,
    padding: "0px 25px 5px",
    display: "grid",
    gridTemplateColumns: "400px 250px 250px 1fr",
    gridColumnGap: theme.spacing(2),
    gridRowGap: theme.spacing(2)
  },
  filterReset: { alignSelf: "flex-end", marginBottom: 5 },
  timeframe: { gridColumnStart: 2, gridColumnEnd: 4, marginLeft: 7.5 },
  typeDetails: { marginRight: 15, marginTop: theme.spacing(2) },
  upgradeNote: { marginTop: "5vh", placeSelf: "center" }
}));
var isUserOptionEqualToValue2 = ({ email, id }, value) => id === value || email === value || email === value?.email;
var locationDefaults = { sort: { direction: import_constants5.SORTING_OPTIONS.desc } };
var AuditLogs = () => {
  const [csvLoading, setCsvLoading] = (0, import_react7.useState)(false);
  const [date] = (0, import_react7.useState)((0, import_helpers3.getISOStringBoundaries)(/* @__PURE__ */ new Date()));
  const { start: today, end: tonight } = date;
  const isInitialized = (0, import_react7.useRef)();
  const [locationParams, setLocationParams] = (0, import_liststatehook.useLocationParams)("auditlogs", { today, tonight, defaults: locationDefaults });
  const { classes } = useStyles4();
  const dispatch = (0, import_react_redux5.useDispatch)();
  const events = (0, import_react_redux5.useSelector)(import_selectors5.getAuditLog);
  const eventItem = (0, import_react_redux5.useSelector)(import_selectors5.getAuditLogEntry);
  const groups = (0, import_react_redux5.useSelector)(import_selectors5.getGroupNames);
  const selectionState = (0, import_react_redux5.useSelector)(import_selectors5.getAuditLogSelectionState);
  const userCapabilities = (0, import_react_redux5.useSelector)(import_selectors5.getUserCapabilities);
  const tenantCapabilities = (0, import_react_redux5.useSelector)(import_selectors5.getTenantCapabilities);
  const users = (0, import_react_redux5.useSelector)((state) => state.users.byId);
  const { canReadUsers } = userCapabilities;
  const { hasAuditlogs } = tenantCapabilities;
  const [detailsReset, setDetailsReset] = (0, import_react7.useState)("");
  const [dirtyField, setDirtyField] = (0, import_react7.useState)("");
  const { token } = (0, import_react_redux5.useSelector)(import_selectors5.getCurrentSession);
  const isSP = (0, import_react_redux5.useSelector)(import_selectors5.getIsServiceProvider);
  const { detail, perPage, endDate, user, sort, startDate, type, total, isLoading } = selectionState;
  const [auditLogsTypes, setAuditLogsTypes] = (0, import_react7.useState)(import_constants5.AUDIT_LOGS_TYPES);
  const timers = (0, import_react7.useRef)({ init: null, detailsReset: null, dirtyField: null });
  (0, import_react7.useEffect)(() => {
    if (isSP) {
      setAuditLogsTypes(import_constants5.SP_AUDIT_LOGS_TYPES);
    }
  }, [isSP]);
  (0, import_react7.useEffect)(() => {
    if (!hasAuditlogs || !isInitialized.current) {
      return;
    }
    setLocationParams({ pageState: selectionState });
  }, [detail, endDate, hasAuditlogs, perPage, selectionState.page, selectionState.selectedId, setLocationParams, startDate, type, user]);
  (0, import_react7.useEffect)(() => {
    if (!isInitialized.current) {
      return;
    }
    setDetailsReset("detail");
    clearTimeout(timers.current.detailsReset);
    timers.current.detailsReset = setTimeout(() => setDetailsReset(""), import_constants5.TIMEOUTS.debounceShort);
  }, [type?.value]);
  (0, import_react7.useEffect)(() => {
    if (canReadUsers) {
      dispatch((0, import_thunks5.getUserList)());
    }
  }, [canReadUsers, dispatch]);
  const initAuditlogState = (0, import_react7.useCallback)(
    (result, state) => {
      const { detail: detail2, endDate: endDate2, startDate: startDate2, type: type2, user: user2 } = state;
      const resultList = result ? Object.values(result.events) : [];
      if (resultList.length && startDate2 === today) {
        const newStartDate = new Date(resultList[resultList.length - 1].time);
        const { start } = (0, import_helpers3.getISOStringBoundaries)(newStartDate);
        state.startDate = start;
      }
      dispatch((0, import_thunks5.setAuditlogsState)(state));
      clearTimeout(timers.current.dirtyField);
      timers.current.dirtyField = setTimeout(() => {
        let field = Object.entries({ detail: detail2, type: type2, user: user2 }).reduce((accu, [key, value]) => accu || value ? key : accu, "");
        field = field || (endDate2 !== tonight ? "endDate" : field);
        field = field || (state.startDate !== today ? "startDate" : field);
        setDirtyField(field);
      }, import_constants5.TIMEOUTS.debounceDefault);
      clearTimeout(timers.current.init);
      timers.current.init = setTimeout(() => isInitialized.current = true, import_constants5.TIMEOUTS.oneSecond + import_constants5.TIMEOUTS.debounceDefault);
    },
    [dispatch, today, tonight]
  );
  const updateState = (0, import_react7.useCallback)(
    (nextState) => {
      const state = { ...nextState };
      if (state.id && Boolean(state.open)) {
        state.selectedId = state.id[0];
        const [eventAction, eventTime] = atob(state.selectedId).split("|");
        if (eventTime && !events.some((item) => item.time === eventTime && item.action === eventAction)) {
          const { start, end } = (0, import_helpers3.getISOStringBoundaries)(new Date(eventTime));
          state.endDate = end;
          state.startDate = start;
        }
        let field = endDate !== tonight ? "endDate" : "";
        field = field || (startDate !== today ? "startDate" : field);
        setDirtyField(field);
      }
      dispatch((0, import_thunks5.setAuditlogsState)(state)).then(() => {
        clearTimeout(timers.current.init);
        timers.current.init = setTimeout(() => isInitialized.current = true, import_constants5.TIMEOUTS.oneSecond + import_constants5.TIMEOUTS.debounceDefault);
      });
      return;
    },
    // eslint-disable-next-line react-hooks/exhaustive-deps
    [dispatch, endDate, JSON.stringify(events), startDate, today, tonight]
  );
  (0, import_react7.useEffect)(() => {
    if (!hasAuditlogs || isInitialized.current !== void 0) {
      return;
    }
    isInitialized.current = false;
    const { id, open, detail: detail2, endDate: endDate2, startDate: startDate2, type: type2, user: user2 } = locationParams;
    const state = { ...locationParams };
    if (id && Boolean(open)) {
      updateState(state);
      return;
    }
    dispatch((0, import_thunks5.getAuditLogs)({ page: state.page ?? 1, perPage: 50, startDate: startDate2 !== today ? startDate2 : import_constants5.BEGINNING_OF_TIME, endDate: endDate2, user: user2, type: type2, detail: detail2 })).unwrap().then(({ payload: result }) => initAuditlogState(result, state));
  }, [dispatch, hasAuditlogs, JSON.stringify(events), JSON.stringify(locationParams), initAuditlogState, updateState, today, tonight]);
  (0, import_react7.useEffect)(() => {
    const currentTimers = timers.current;
    return () => {
      Object.values(currentTimers).forEach(clearTimeout);
    };
  }, []);
  const createCsvDownload = () => {
    setCsvLoading(true);
    dispatch((0, import_thunks5.getAuditLogsCsvLink)()).unwrap().then((address) => {
      (0, import_helpers3.createDownload)(encodeURI(address), `Mender-AuditLog-${(0, import_dayjs3.default)(startDate).format("YYYY-MM-DD")}-${(0, import_dayjs3.default)(endDate).format("YYYY-MM-DD")}.csv`, token);
      setCsvLoading(false);
    });
  };
  const onChangeSorting = () => {
    const currentSorting = sort.direction === import_constants5.SORTING_OPTIONS.desc ? import_constants5.SORTING_OPTIONS.asc : import_constants5.SORTING_OPTIONS.desc;
    dispatch((0, import_thunks5.setAuditlogsState)({ page: 1, sort: { direction: currentSorting } }));
  };
  const onChangePagination = (page, currentPerPage = perPage) => dispatch((0, import_thunks5.setAuditlogsState)({ page, perPage: currentPerPage }));
  const onIssueSelection = (selectedIssue) => dispatch((0, import_thunks5.setAuditlogsState)({ selectedId: selectedIssue ? btoa(`${selectedIssue.action}|${selectedIssue.time}`) : void 0 }));
  const onFiltersChange = (0, import_react7.useCallback)(
    ({ endDate: endDate2, detail: detail2, startDate: startDate2, user: user2, type: type2 }) => {
      if (!isInitialized.current) {
        return;
      }
      const selectedUser = Object.values(users).find((item) => isUserOptionEqualToValue2(item, user2));
      dispatch((0, import_thunks5.setAuditlogsState)({ page: 1, detail: detail2, startDate: startDate2, endDate: endDate2, user: selectedUser, type: type2 }));
    },
    // eslint-disable-next-line react-hooks/exhaustive-deps
    [dispatch, JSON.stringify(users)]
  );
  return /* @__PURE__ */ (0, import_jsx_runtime14.jsxs)(
    AuditlogsView_default,
    {
      createCsvDownload,
      hasAuditlogs,
      total,
      csvLoading,
      infoHintComponent: /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(import_EnterpriseNotification.default, { id: import_constants5.BENEFITS.auditlog.id }),
      auditLogsFilter: /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(
        AuditLogsFilter_default,
        {
          groups,
          users,
          disabled: !hasAuditlogs,
          onFiltersChange,
          detailsReset,
          selectionState,
          auditLogsTypes,
          dirtyField,
          setDirtyField
        }
      ),
      children: [
        !!total && /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(
          AuditLogsList_default,
          {
            items: events,
            onChangePage: onChangePagination,
            onChangeRowsPerPage: (newPerPage) => onChangePagination(1, newPerPage),
            onChangeSorting,
            selectionState,
            onIssueSelection,
            userCapabilities,
            auditLogColumns: [
              { title: "Performed by", sortable: false, render: UserDescriptor },
              { title: "Action", sortable: false, render: ActionDescriptor },
              { title: "Type", sortable: false, render: TypeDescriptor },
              { title: "Changed", sortable: false, render: ChangeDescriptor },
              { title: "More details", sortable: false, render: ChangeDetailsDescriptor },
              { title: "Time", sortable: true, render: TimeWrapper }
            ]
          }
        ),
        !(isLoading || total) && hasAuditlogs && /* @__PURE__ */ (0, import_jsx_runtime14.jsxs)("div", { className: "dashboard-placeholder", children: [
          /* @__PURE__ */ (0, import_jsx_runtime14.jsx)("p", { children: "No log entries were found." }),
          /* @__PURE__ */ (0, import_jsx_runtime14.jsx)("p", { children: "Try adjusting the filters." }),
          /* @__PURE__ */ (0, import_jsx_runtime14.jsx)("img", { src: history_default, alt: "Past" })
        ] }),
        !hasAuditlogs && /* @__PURE__ */ (0, import_jsx_runtime14.jsx)("div", { className: `dashboard-placeholder flexbox ${classes.upgradeNote}`, children: /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(import_EnterpriseNotification.DefaultUpgradeNotification, { className: "margin-right-small" }) }),
        /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(
          EventDetailsDrawer_default,
          {
            mapChangeToContent: EventDetailsDrawerContentMap_default,
            fallbackComponent: FallbackComponent_default,
            eventItem,
            open: Boolean(eventItem),
            onClose: () => onIssueSelection()
          }
        )
      ]
    }
  );
};

// src/button.tsx
var import_jsx_runtime15 = require("react/jsx-runtime");
function Button3({ children, ...other }) {
  return /* @__PURE__ */ (0, import_jsx_runtime15.jsx)("button", { type: "button", ...other, children });
}
Button3.displayName = "Button";
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AuditLogs,
  Button
});
//# sourceMappingURL=index.cjs.map