"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/appSlice/selectors.ts
var selectors_exports = {};
__export(selectors_exports, {
  getCommit: () => getCommit,
  getDocsVersion: () => getDocsVersion,
  getFeatures: () => getFeatures,
  getFeedbackProbability: () => getFeedbackProbability,
  getFullVersionInformation: () => getFullVersionInformation,
  getHostAddress: () => getHostAddress,
  getHostedAnnouncement: () => getHostedAnnouncement,
  getIsFirstLogin: () => getIsFirstLogin,
  getIsPreview: () => getIsPreview,
  getIsUploading: () => getIsUploading,
  getRecaptchaKey: () => getRecaptchaKey,
  getSearchState: () => getSearchState,
  getSearchedDevices: () => getSearchedDevices,
  getSentryConfig: () => getSentryConfig,
  getSnackbar: () => getSnackbar,
  getStripeKey: () => getStripeKey,
  getTrackerCode: () => getTrackerCode,
  getUploads: () => getUploads,
  getVersionInformation: () => getVersionInformation
});
module.exports = __toCommonJS(selectors_exports);
var import_helpers = require("@northern.tech/utils/helpers");
var import_toolkit = require("@reduxjs/toolkit");
var getDocsVersion = (state) => state.app.docsVersion;
var getFeatures = (state) => state.app.features;
var getFullVersionInformation = (state) => state.app.versionInformation;
var getSearchState = (state) => state.app.searchState;
var getUploads = (state) => state.app.uploadsById;
var getSnackbar = (state) => state.app.snackbar;
var getHostAddress = (state) => state.app.hostAddress;
var getHostedAnnouncement = (state) => state.app.hostedAnnouncement;
var getRecaptchaKey = (state) => state.app.recaptchaSiteKey;
var getStripeKey = (state) => state.app.stripeAPIKey;
var getTrackerCode = (state) => state.app.trackerCode;
var getSentryConfig = (state) => state.app.sentry;
var getCommit = (state) => state.app.commit;
var getIsFirstLogin = (state) => state.app.firstLoginAfterSignup;
var getFeedbackProbability = (state) => state.app.feedbackProbability;
var getIsUploading = (0, import_toolkit.createSelector)([getUploads], (uploadsById) => !!Object.keys(uploadsById).length);
var getSearchedDevices = (0, import_toolkit.createSelector)([getSearchState], ({ deviceIds }) => deviceIds);
var getVersionInformation = (0, import_toolkit.createSelector)(
  [getFullVersionInformation, getFeatures],
  ({ Integration, ...remainder }, { isHosted }) => isHosted && Integration !== "next" ? remainder : { ...remainder, Integration }
);
var getIsPreview = (0, import_toolkit.createSelector)([getFullVersionInformation], ({ Integration }) => (0, import_helpers.versionCompare)(Integration, "next") > -1);
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getCommit,
  getDocsVersion,
  getFeatures,
  getFeedbackProbability,
  getFullVersionInformation,
  getHostAddress,
  getHostedAnnouncement,
  getIsFirstLogin,
  getIsPreview,
  getIsUploading,
  getRecaptchaKey,
  getSearchState,
  getSearchedDevices,
  getSentryConfig,
  getSnackbar,
  getStripeKey,
  getTrackerCode,
  getUploads,
  getVersionInformation
});
//# sourceMappingURL=selectors.cjs.map