import {
  DEVICE_ISSUE_OPTIONS,
  DEVICE_LIST_DEFAULTS,
  alertChannels
} from "./chunk-7C4SQBEE.js";

// src/monitorSlice/index.ts
import { createSlice } from "@reduxjs/toolkit";
var sliceName = "monitor";
var initialState = {
  alerts: {
    alertList: { ...DEVICE_LIST_DEFAULTS, total: 0 },
    byDeviceId: {}
  },
  issueCounts: {
    byType: Object.keys(DEVICE_ISSUE_OPTIONS).reduce((accu, key) => ({ ...accu, [key]: { filtered: 0, total: 0 } }), {})
  },
  settings: {
    global: {
      channels: {
        ...Object.keys(alertChannels).reduce((accu, item) => ({ ...accu, [item]: { enabled: true } }), {})
      }
    }
  }
};
var monitorSlice = createSlice({
  name: sliceName,
  initialState,
  reducers: {
    changeAlertChannel: (state, action) => {
      const { channel, enabled } = action.payload;
      state.settings.global.channels[channel] = { enabled };
    },
    receiveDeviceAlerts: (state, action) => {
      const { deviceId, alerts } = action.payload;
      state.alerts.byDeviceId[deviceId] = { alerts };
    },
    receiveLatestDeviceAlerts: (state, action) => {
      const { deviceId, alerts } = action.payload;
      state.alerts.byDeviceId[deviceId] = { ...state.alerts.byDeviceId[deviceId], latest: alerts };
    },
    receiveDeviceIssueCounts: (state, action) => {
      const { issueType, counts } = action.payload;
      state.issueCounts.byType[issueType] = counts;
    },
    setAlertListState: (state, action) => {
      state.alerts.alertList = { ...state.alerts.alertList, ...action.payload };
    }
  }
});
var actions = monitorSlice.actions;
var monitorSlice_default = monitorSlice.reducer;

export {
  sliceName,
  initialState,
  monitorSlice,
  actions,
  monitorSlice_default
};
//# sourceMappingURL=chunk-PGFVHKP5.js.map