import {
  getReleasesById
} from "./chunk-MSOXMRF7.js";
import {
  getCurrentUser,
  getGlobalSettings,
  getRolesById,
  getRolesList,
  getUserSettings
} from "./chunk-R6KRH2IY.js";
import {
  getAuditLogEntry,
  getIsServiceProvider,
  getOrganization
} from "./chunk-YY6SKZDF.js";
import {
  getIssueCountsByType
} from "./chunk-YO22XLHI.js";
import {
  getOnboarding
} from "./chunk-JIS4PA3R.js";
import {
  getDeviceById,
  getDevicesById,
  getFilteringAttributes,
  getGroupsById,
  getListedDevices
} from "./chunk-KJNNEDRV.js";
import {
  getDeploymentsById,
  getDeploymentsSelectionState,
  getSelectedDeploymentDeviceIds
} from "./chunk-JXQUFKID.js";
import {
  getFeatures,
  getSearchedDevices
} from "./chunk-BYUPW7RA.js";
import {
  listItemMapper,
  mapUserRolesToUiPermissions
} from "./chunk-UE5N5VO3.js";
import {
  ALL_DEVICES,
  ATTRIBUTE_SCOPES,
  DEVICE_ISSUE_OPTIONS,
  DEVICE_LIST_MAXIMUM_LENGTH,
  UNGROUPED_GROUP,
  inventoryApiUrlV2,
  reportingApiUrl,
  rolesById,
  rolesByName,
  serviceProviderRolesById,
  uiPermissionsById
} from "./chunk-7C4SQBEE.js";
import {
  onboardingSteps
} from "./chunk-FAJ3I2UQ.js";
import {
  ADDONS,
  PLANS,
  defaultReports
} from "./chunk-HFOTAPIJ.js";

// src/commonSelectors.ts
import { attributeDuplicateFilter, getDemoDeviceAddress as getDemoDeviceAddressHelper } from "@northern.tech/utils/helpers";
import { createSelector } from "@reduxjs/toolkit";
var getIsEnterprise = createSelector(
  [getOrganization, getFeatures],
  ({ plan = PLANS.os.id }, { isEnterprise, isHosted }) => isEnterprise || isHosted && plan === PLANS.enterprise.id
);
var getAttrsEndpoint = createSelector(
  [getFeatures],
  ({ hasReporting }) => hasReporting ? `${reportingApiUrl}/devices/search/attributes` : `${inventoryApiUrlV2}/filters/attributes`
);
var getSearchEndpoint = createSelector(
  [getFeatures],
  ({ hasReporting }) => hasReporting ? `${reportingApiUrl}/devices/search` : `${inventoryApiUrlV2}/filters/search`
);
var getUserRoles = createSelector([getCurrentUser, getRolesById, getIsEnterprise], (currentUser, rolesById2, isEnterprise) => {
  const isAdmin = currentUser.roles?.length ? currentUser.roles.some((role) => role === rolesByName.admin) : !isEnterprise;
  const uiPermissions = isAdmin ? mapUserRolesToUiPermissions([rolesByName.admin], rolesById2) : mapUserRolesToUiPermissions(currentUser.roles || [], rolesById2);
  return { isAdmin, uiPermissions };
});
var hasPermission = (thing, permission) => Object.values(thing).some((permissions) => permissions.includes(permission));
var getUserCapabilities = createSelector([getUserRoles, getIsServiceProvider], ({ uiPermissions }, isServiceProvider) => {
  const canManageReleases = hasPermission(uiPermissions.releases, uiPermissionsById.manage.value);
  const canReadReleases = canManageReleases || hasPermission(uiPermissions.releases, uiPermissionsById.read.value);
  const canUploadReleases = canManageReleases || hasPermission(uiPermissions.releases, uiPermissionsById.upload.value);
  const canAuditlog = uiPermissions.auditlog.includes(uiPermissionsById.read.value);
  const canReadUsers = uiPermissions.userManagement.includes(uiPermissionsById.read.value);
  const canManageUsers = uiPermissions.userManagement.includes(uiPermissionsById.manage.value);
  const canReadDevices = hasPermission(uiPermissions.groups, uiPermissionsById.read.value);
  const canWriteDevices = Object.values(uiPermissions.groups).some(
    (groupPermissions) => groupPermissions.includes(uiPermissionsById.read.value) && groupPermissions.length > 1
  );
  const canTroubleshoot = hasPermission(uiPermissions.groups, uiPermissionsById.connect.value);
  const canManageDevices = hasPermission(uiPermissions.groups, uiPermissionsById.manage.value);
  const canConfigure = hasPermission(uiPermissions.groups, uiPermissionsById.configure.value);
  const canDeploy = uiPermissions.deployments.includes(uiPermissionsById.deploy.value) || hasPermission(uiPermissions.groups, uiPermissionsById.deploy.value);
  const canReadDeployments = uiPermissions.deployments.includes(uiPermissionsById.read.value);
  return {
    canAuditlog,
    canConfigure,
    canDeploy,
    canManageDevices,
    canManageReleases,
    canManageUsers,
    canReadDeployments,
    canReadDevices,
    canReadReleases,
    canReadUsers,
    canTroubleshoot,
    canUploadReleases,
    canWriteDevices,
    groupsPermissions: uiPermissions.groups,
    releasesPermissions: uiPermissions.releases,
    SPTenant: isServiceProvider
  };
});
var getTenantCapabilities = createSelector(
  [getFeatures, getOrganization, getIsEnterprise],
  ({
    hasAuditlogs: isAuditlogEnabled,
    hasDeviceConfig: isDeviceConfigEnabled,
    hasDeviceConnect: isDeviceConnectEnabled,
    hasMonitor: isMonitorEnabled,
    isHosted
  }, { addons = [], plan = PLANS.os.id }, isEnterprise) => {
    const canDelta = isEnterprise || plan === PLANS.professional.id;
    const hasAuditlogs = isAuditlogEnabled && isEnterprise;
    const hasDeviceConfig = addons.some((addon) => addon.name === ADDONS.configure.id && addon.enabled) || isDeviceConfigEnabled && !isHosted;
    const hasDeviceConnect = addons.some((addon) => addon.name === ADDONS.troubleshoot.id && addon.enabled) || isDeviceConnectEnabled && !isHosted;
    const hasMonitor = isMonitorEnabled && addons.some((addon) => addon.name === ADDONS.monitor.id && addon.enabled);
    return {
      canDelta,
      canRetry: canDelta,
      canSchedule: canDelta,
      hasAuditlogs,
      hasDeviceConfig,
      hasDeviceConnect,
      hasFullFiltering: canDelta,
      hasMonitor,
      isEnterprise,
      plan
    };
  }
);
var getFilterAttributes = createSelector(
  [getGlobalSettings, getFilteringAttributes],
  ({ previousFilters }, { identityAttributes, inventoryAttributes, systemAttributes, tagAttributes }) => {
    const deviceNameAttribute = { key: "name", value: "Name", scope: ATTRIBUTE_SCOPES.tags, category: ATTRIBUTE_SCOPES.tags, priority: 1 };
    const deviceIdAttribute = { key: "id", value: "Device ID", scope: ATTRIBUTE_SCOPES.identity, category: ATTRIBUTE_SCOPES.identity, priority: 1 };
    const checkInAttribute = { key: "check_in_time", value: "Latest activity", scope: ATTRIBUTE_SCOPES.system, category: ATTRIBUTE_SCOPES.system, priority: 4 };
    const updateAttribute = { ...checkInAttribute, key: "updated_ts", value: "Last inventory update" };
    const firstRequestAttribute = { key: "created_ts", value: "First request", scope: ATTRIBUTE_SCOPES.system, category: ATTRIBUTE_SCOPES.system, priority: 4 };
    const attributes = [
      ...previousFilters.map((item) => ({
        ...item,
        value: deviceIdAttribute.key === item.key ? deviceIdAttribute.value : item.key,
        category: "recently used",
        priority: 0
      })),
      deviceNameAttribute,
      deviceIdAttribute,
      ...identityAttributes.map((item) => ({ key: item, value: item, scope: ATTRIBUTE_SCOPES.identity, category: ATTRIBUTE_SCOPES.identity, priority: 1 })),
      ...inventoryAttributes.map((item) => ({ key: item, value: item, scope: ATTRIBUTE_SCOPES.inventory, category: ATTRIBUTE_SCOPES.inventory, priority: 2 })),
      ...tagAttributes.map((item) => ({ key: item, value: item, scope: ATTRIBUTE_SCOPES.tags, category: ATTRIBUTE_SCOPES.tags, priority: 3 })),
      checkInAttribute,
      updateAttribute,
      firstRequestAttribute,
      ...systemAttributes.map((item) => ({ key: item, value: item, scope: ATTRIBUTE_SCOPES.system, category: ATTRIBUTE_SCOPES.system, priority: 4 }))
    ];
    return attributeDuplicateFilter(attributes, "key");
  }
);
var getOnboardingState = createSelector([getOnboarding, getUserSettings], ({ complete, progress, showTips, ...remainder }, { onboarding = {} }) => ({
  ...remainder,
  ...onboarding,
  complete: onboarding.complete || complete,
  progress: Object.keys(onboardingSteps).findIndex((step) => step === progress) > Object.keys(onboardingSteps).findIndex((step) => step === onboarding.progress) ? progress : onboarding.progress,
  showTips: !onboarding.showTips ? onboarding.showTips : showTips
}));
var getDemoDeviceAddress = createSelector([getDevicesById, getOnboarding], (devicesById, { approach, demoArtifactPort }) => {
  const demoDeviceAddress = `http://${getDemoDeviceAddressHelper(Object.values(devicesById), approach)}`;
  return demoArtifactPort ? `${demoDeviceAddress}:${demoArtifactPort}` : demoDeviceAddress;
});
var getDeviceConfigDeployment = createSelector([getDeviceById, getDeploymentsById], (device, deploymentsById) => {
  const { config = {} } = device;
  const { deployment_id: configDeploymentId } = config;
  const deviceConfigDeployment = deploymentsById[configDeploymentId] || {};
  return { device, deviceConfigDeployment };
});
var getDeploymentRelease = createSelector(
  [getDeploymentsById, getDeploymentsSelectionState, getReleasesById],
  (deploymentsById, { selectedId }, releasesById) => {
    const deployment = deploymentsById[selectedId] || {};
    return deployment.artifact_name && releasesById[deployment.artifact_name] ? releasesById[deployment.artifact_name] : { device_types_compatible: [] };
  }
);
var getSelectedDeploymentData = createSelector(
  [getDeploymentsById, getDeploymentsSelectionState, getDevicesById, getSelectedDeploymentDeviceIds],
  (deploymentsById, { selectedId }, devicesById, selectedDeviceIds) => {
    const deployment = deploymentsById[selectedId] ?? {};
    const { devices = {} } = deployment;
    return {
      deployment,
      selectedDevices: selectedDeviceIds.map((deviceId) => ({ ...devicesById[deviceId], ...devices[deviceId] }))
    };
  }
);
var getAvailableIssueOptionsByType = createSelector(
  [getFeatures, getTenantCapabilities, getIssueCountsByType],
  ({ hasReporting }, { hasFullFiltering, hasMonitor }, issueCounts) => Object.values(DEVICE_ISSUE_OPTIONS).reduce((accu, { isCategory, key, needsFullFiltering, needsMonitor, needsReporting, title }) => {
    if (isCategory || needsReporting && !hasReporting || needsFullFiltering && !hasFullFiltering || needsMonitor && !hasMonitor) {
      return accu;
    }
    accu[key] = { count: issueCounts[key].filtered, key, title };
    return accu;
  }, {})
);
var getGroupNames = createSelector([getGroupsById, getUserRoles], (groupsById, { uiPermissions }) => {
  const { [UNGROUPED_GROUP.id]: ungrouped, ...groups } = groupsById;
  return Object.keys(
    Object.entries(groups).reduce((accu, [groupName, group]) => {
      if (group.filterId || uiPermissions.groups[ALL_DEVICES]) {
        accu[groupName] = group;
      }
      return accu;
    }, uiPermissions.groups)
  ).sort();
});
var getDeviceReportsForUser = createSelector(
  [getUserSettings, getCurrentUser, getGlobalSettings, getDevicesById],
  ({ reports }, { id: currentUserId }, globalSettings, devicesById) => reports || globalSettings[`${currentUserId}-reports`] || (Object.keys(devicesById).length ? defaultReports : [])
);
var listTypeDeviceIdMap = {
  deviceList: getListedDevices,
  search: getSearchedDevices
};
var deviceMapDefault = { defaultObject: { auth_sets: [] }, cutOffSize: DEVICE_LIST_MAXIMUM_LENGTH };
var getDeviceMappingDefaults = () => deviceMapDefault;
var getMappedDevicesList = createSelector(
  [getDevicesById, (state, listType) => listTypeDeviceIdMap[listType](state), getDeviceMappingDefaults],
  listItemMapper
);
var getAuditlogDevice = createSelector([getAuditLogEntry, getDevicesById], (auditlogEvent, devicesById) => {
  let auditlogDevice = {};
  if (auditlogEvent) {
    const { object = {} } = auditlogEvent;
    const { device = {}, id, type } = object;
    auditlogDevice = type === "device" ? { id, ...device } : auditlogDevice;
  }
  return { ...auditlogDevice, ...devicesById[auditlogDevice.id] };
});
var getRelevantRoles = createSelector([getOrganization, getRolesList], ({ service_provider }, roles) => {
  if (service_provider) {
    return roles.reduce((accu, role) => {
      if (rolesById[role.value]) {
        return accu;
      }
      accu.push(role);
      return accu;
    }, Object.values(serviceProviderRolesById));
  }
  return Object.keys(rolesById).reverse().reduce((accu, key) => {
    const index = accu.findIndex(({ value }) => value === key);
    accu = [accu[index], ...accu.filter((item, itemIndex) => index !== itemIndex)];
    return accu;
  }, roles);
});

export {
  getIsEnterprise,
  getAttrsEndpoint,
  getSearchEndpoint,
  getUserRoles,
  getUserCapabilities,
  getTenantCapabilities,
  getFilterAttributes,
  getOnboardingState,
  getDemoDeviceAddress,
  getDeviceConfigDeployment,
  getDeploymentRelease,
  getSelectedDeploymentData,
  getAvailableIssueOptionsByType,
  getGroupNames,
  getDeviceReportsForUser,
  getMappedDevicesList,
  getAuditlogDevice,
  getRelevantRoles
};
//# sourceMappingURL=chunk-SCZLNFB5.js.map