import {
  actions_default
} from "./chunk-F26IKSML.js";
import {
  releasesSlice_default
} from "./chunk-OOICURFL.js";
import {
  actions as actions2,
  usersSlice_default
} from "./chunk-UGSLGUS6.js";
import {
  actions,
  organizationSlice_default
} from "./chunk-MZNANSS2.js";
import {
  monitorSlice_default
} from "./chunk-PGFVHKP5.js";
import {
  onboardingSlice_default
} from "./chunk-VANBSJS5.js";
import {
  deploymentsSlice_default
} from "./chunk-VUFRP6P3.js";
import {
  appSlice_default
} from "./chunk-QYLGIR4W.js";
import {
  devicesSlice_default
} from "./chunk-ABJLRDCO.js";
import {
  getToken
} from "./chunk-ZJW3QIPM.js";
import {
  USER_LOGOUT,
  settingsKeys
} from "./chunk-7C4SQBEE.js";

// src/store.ts
import { useDispatch } from "react-redux";
import { extractErrorMessage, preformatWithRequestID } from "@northern.tech/utils/helpers";
import { combineReducers, configureStore, createAsyncThunk } from "@reduxjs/toolkit";
import { createReduxEnhancer } from "@sentry/react";
var { setSnackbar, uploadProgress } = actions_default;
var keys = ["sessionDeploymentChecker", settingsKeys.initialized];
var resetEnvironment = () => keys.forEach((key) => window.sessionStorage.removeItem(key));
resetEnvironment();
var commonErrorFallback = "Please check your connection.";
var commonErrorHandler = (err, errorContext, dispatch, fallback, mightBeAuthRelated = false) => {
  const errMsg = extractErrorMessage(err, fallback);
  if (mightBeAuthRelated || getToken()) {
    dispatch(setSnackbar({ message: preformatWithRequestID(err.response, `${errorContext} ${errMsg}`), action: "Copy to clipboard" }));
  }
  return Promise.reject(err);
};
var rootReducer = combineReducers({
  app: appSlice_default,
  devices: devicesSlice_default,
  deployments: deploymentsSlice_default,
  monitor: monitorSlice_default,
  onboarding: onboardingSlice_default,
  organization: organizationSlice_default,
  releases: releasesSlice_default,
  users: usersSlice_default
});
var sessionReducer = (state, action) => {
  if (action.type === USER_LOGOUT) {
    state = void 0;
  }
  return rootReducer(state, action);
};
var rejectionLoggerMiddleware = () => (next) => (action) => {
  if (action.type.endsWith("/rejected")) {
    const { error } = action;
    console.error("Rejection in action:", action);
    console.error(error.stack);
  }
  return next(action);
};
var tracingActionIgnoreList = [actions2.successfullyLoggedIn.type, "users/loginUser/pending", "users/loginUser/fulfilled", "users/loginUser/rejected"];
var sentryReduxEnhancer = createReduxEnhancer({
  actionTransformer: (action) => {
    if (tracingActionIgnoreList.includes(action.type)) {
      return null;
    }
    return action;
  },
  // Transform the state to remove sensitive information
  stateTransformer: (state) => {
    const transformedState = {
      ...state,
      users: { ...state.users, currentSession: null },
      organization: {
        ...state.organization,
        organization: {
          ...state.organization.organization,
          tenant_token: null
        }
      }
    };
    return transformedState;
  }
});
var getConfiguredStore = (options = {}) => {
  const { preloadedState = {}, ...config } = options;
  return configureStore({
    ...config,
    preloadedState,
    enhancers: (getDefaultEnhancers) => {
      if (window.mender_environment?.sentry?.isReduxEnabled) {
        return getDefaultEnhancers().concat(sentryReduxEnhancer);
      }
      return getDefaultEnhancers();
    },
    reducer: sessionReducer,
    middleware: (getDefaultMiddleware) => getDefaultMiddleware({
      immutableCheck: {
        ignoredPaths: ["app.uploadsById"]
      },
      serializableCheck: {
        ignoredActions: [actions.receiveExternalDeviceIntegrations.name, uploadProgress.name],
        ignoredActionPaths: ["uploads", /payload\..*$/, "meta.arg.file", "meta.arg.integration.configHint"],
        ignoredPaths: ["app.uploadsById", "organization.externalDeviceIntegrations"]
      }
    }).concat(rejectionLoggerMiddleware)
  });
};
var store = getConfiguredStore({
  preloadedState: {}
});
var useAppDispatch = useDispatch;
var createAppAsyncThunk = createAsyncThunk.withTypes();

export {
  commonErrorFallback,
  commonErrorHandler,
  sessionReducer,
  getConfiguredStore,
  store,
  useAppDispatch,
  createAppAsyncThunk
};
//# sourceMappingURL=chunk-V3QEONX7.js.map