import {
  TIMEOUTS,
  maxSessionAge
} from "./chunk-7C4SQBEE.js";

// src/auth.ts
import Cookies from "universal-cookie";
var cookies = new Cookies();
var emptySession = Object.freeze({ token: "", expiresAt: void 0 });
var tokenCache = "";
var getSessionInfo = () => {
  let sessionInfo = { ...emptySession };
  try {
    sessionInfo = JSON.parse(window.localStorage.getItem("JWT") ?? "");
  } catch {
  }
  if (sessionInfo.expiresAt && new Date(sessionInfo.expiresAt) < /* @__PURE__ */ new Date()) {
    cleanUp();
    return { ...emptySession };
  }
  if (!sessionInfo.token) {
    const jwtTokenFromCookie = cookies.get("JWT", { doNotParse: true }) ?? "";
    if (jwtTokenFromCookie) {
      setSessionInfo({ token: jwtTokenFromCookie });
      sessionInfo.token = jwtTokenFromCookie;
      cookies.remove("JWT");
      cookies.remove("JWT", { path: "/" });
    }
  }
  sessionInfo.token = sessionInfo.token || "";
  tokenCache = sessionInfo.token;
  return sessionInfo;
};
var getToken = () => tokenCache ? tokenCache : getSessionInfo().token;
var setSessionInfo = ({ token, expiresAt }) => {
  tokenCache = token;
  window.localStorage.setItem("JWT", JSON.stringify({ token, expiresAt }));
};
var cleanUp = () => {
  tokenCache = "";
  cookies.remove("JWT");
  cookies.remove("JWT", { path: "/" });
  window.localStorage.removeItem("JWT");
  window.localStorage.removeItem("oauth");
};
var updateMaxAge = ({ expiresAt, token }) => {
  const oAuthExpiration = Number(window.localStorage.getItem("oauth"));
  let updateWithOAuth = false;
  if (oAuthExpiration) {
    const soon = Date.now() + maxSessionAge * TIMEOUTS.oneSecond;
    updateWithOAuth = oAuthExpiration <= soon;
    if (updateWithOAuth) {
      window.localStorage.removeItem("oauth");
    }
  }
  if (token && expiresAt && (!oAuthExpiration || updateWithOAuth)) {
    const expiration = /* @__PURE__ */ new Date();
    expiration.setSeconds(expiration.getSeconds() + maxSessionAge);
    setSessionInfo({ token, expiresAt: expiration.toISOString() });
  }
};

export {
  getSessionInfo,
  getToken,
  setSessionInfo,
  cleanUp,
  updateMaxAge
};
//# sourceMappingURL=chunk-ZJW3QIPM.js.map