import { DeploymentStatistics } from '@northern.tech/types/MenderTypes';

declare const deploymentSubstates: {
    aborted: string;
    alreadyInstalled: string;
    decommissioned: string;
    downloading: string;
    failure: string;
    installing: string;
    noartifact: string;
    pause_before_committing: string;
    pause_before_installing: string;
    pause_before_rebooting: string;
    pending: string;
    rebooting: string;
    success: string;
};
declare const deploymentStatesToSubstates: {
    failures: string[];
    inprogress: string[];
    paused: string[];
    pending: string[];
    successes: string[];
};
declare const deploymentStatesToSubstatesWithSkipped: {
    failures: string[];
    skipped: string[];
    successes: string[];
    inprogress: string[];
    paused: string[];
    pending: string[];
};
declare const installationSubstatesMap: {
    download: {
        title: string;
        done: string;
        successIndicators: string[];
        failureIndicators: string[];
        pauseConfigurationIndicator: string;
    };
    install: {
        title: string;
        done: string;
        successIndicators: string[];
        failureIndicators: string[];
        pauseConfigurationIndicator: string;
    };
    reboot: {
        title: string;
        done: string;
        successIndicators: string[];
        failureIndicators: string[];
        pauseConfigurationIndicator: string;
    };
    commit: {
        title: string;
        done: string;
        successIndicators: string[];
        failureIndicators: string[];
        pauseConfigurationIndicator: undefined;
    };
};
declare const DEPLOYMENT_STATES: {
    readonly finished: "finished";
    readonly inprogress: "inprogress";
    readonly pending: "pending";
    readonly scheduled: "scheduled";
};
declare const listDefaultsByState: {
    inprogress: {
        page: number;
        perPage: number;
    };
    pending: {
        page: number;
        perPage: number;
    };
    scheduled: {
        page: number;
        perPage: number;
    };
    finished: {
        page: number;
        perPage: number;
    };
    sort: {
        direction: "desc";
    };
};
declare const DEFAULT_PENDING_INPROGRESS_COUNT = 10;
declare const DEPLOYMENT_ROUTES: {
    readonly active: {
        readonly key: "active";
        readonly route: "/deployments/active";
        readonly states: readonly ["pending", "inprogress"];
        readonly title: "Active";
    };
    readonly finished: {
        readonly key: "finished";
        readonly route: "/deployments/finished";
        readonly states: readonly ["finished"];
        readonly title: "Finished";
    };
    readonly scheduled: {
        readonly key: "scheduled";
        readonly route: "/deployments/scheduled";
        readonly states: readonly ["scheduled"];
        readonly title: "Scheduled";
    };
};
declare const DEPLOYMENT_TYPES: {
    software: string;
    configuration: string;
};
declare const defaultStats: {
    [deploymentSubstates.aborted]: number;
    [deploymentSubstates.alreadyInstalled]: number;
    [deploymentSubstates.decommissioned]: number;
    [deploymentSubstates.downloading]: number;
    [deploymentSubstates.failure]: number;
    [deploymentSubstates.installing]: number;
    [deploymentSubstates.noartifact]: number;
    [deploymentSubstates.pause_before_committing]: number;
    [deploymentSubstates.pause_before_installing]: number;
    [deploymentSubstates.pause_before_rebooting]: number;
    [deploymentSubstates.pending]: number;
    [deploymentSubstates.rebooting]: number;
    [deploymentSubstates.success]: number;
};
declare const deploymentDisplayStates: {
    finished: string;
    scheduled: string;
    skipped: string;
    paused: string;
    pending: string;
    inprogress: string;
    success: string;
    successes: string;
    failure: string;
    failures: string;
};
declare const deploymentPrototype: {
    devices: {};
    name: undefined;
    statistics: DeploymentStatistics;
};
declare const pauseMap: {
    [deploymentSubstates.pause_before_installing]: {
        title: string;
        followUp: string;
    };
    [deploymentSubstates.pause_before_rebooting]: {
        title: string;
        followUp: string;
    };
    [deploymentSubstates.pause_before_committing]: {
        title: string;
        followUp: string;
    };
};

export { DEFAULT_PENDING_INPROGRESS_COUNT, DEPLOYMENT_ROUTES, DEPLOYMENT_STATES, DEPLOYMENT_TYPES, defaultStats, deploymentDisplayStates, deploymentPrototype, deploymentStatesToSubstates, deploymentStatesToSubstatesWithSkipped, deploymentSubstates, installationSubstatesMap, listDefaultsByState, pauseMap };
