"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/deploymentsSlice/thunks.ts
var thunks_exports = {};
__export(thunks_exports, {
  abortDeployment: () => abortDeployment,
  createDeployment: () => createDeployment,
  deriveDeploymentGroup: () => deriveDeploymentGroup,
  getDeploymentDevices: () => getDeploymentDevices,
  getDeploymentsByStatus: () => getDeploymentsByStatus2,
  getDeploymentsConfig: () => getDeploymentsConfig,
  getDeviceDeployments: () => getDeviceDeployments,
  getDeviceLog: () => getDeviceLog,
  getSingleDeployment: () => getSingleDeployment,
  resetDeviceDeployments: () => resetDeviceDeployments,
  saveDeltaDeploymentsConfig: () => saveDeltaDeploymentsConfig,
  setDeploymentsState: () => setDeploymentsState,
  updateDeploymentControlMap: () => updateDeploymentControlMap
});
module.exports = __toCommonJS(thunks_exports);
var import_helpers10 = require("@northern.tech/utils/helpers");
var import_tracking = __toESM(require("@northern.tech/utils/tracking"), 1);
var import_validator = __toESM(require("validator"), 1);

// src/deploymentsSlice/index.ts
var import_toolkit = require("@reduxjs/toolkit");

// src/constants.ts
var import_constants5 = require("@northern.tech/utils/constants");

// src/appSlice/constants.ts
var import_icons_material = require("@mui/icons-material");
var startingDeviceCount = {
  os: "for first 50 devices",
  professional: "for first 250 devices"
};
var chartTypes = {
  bar: { key: "bar", Icon: import_icons_material.BarChart },
  pie: { key: "pie", Icon: import_icons_material.PieChartOutline }
};
var emptyChartSelection = { software: "", group: "", chartType: chartTypes.bar.key, attribute: "artifact_name" };
var defaultReportType = "distribution";
var defaultReports = [{ ...emptyChartSelection, group: null, attribute: "artifact_name", type: defaultReportType }];
var PLANS = {
  os: {
    id: "os",
    name: "Basic",
    minimalDeviceCount: 50,
    offer: true,
    price: "$34 / month",
    deviceCount: startingDeviceCount.os,
    description: "The core features of Mender. To continue using Enterprise Trial features\u2014like Delta updates, scheduled deployments, phased rollouts, device filtering, dynamic groups, RBAC, audit logs, and more\u2014please upgrade to a higher plan.",
    features: ["Access to core features of Mender", "Basic support"]
  },
  professional: {
    id: "professional",
    name: "Professional",
    minimalDeviceCount: 250,
    offer: true,
    price: "$291 / month",
    deviceCount: startingDeviceCount.professional,
    description: "Everything in Basic, plus enhanced update management and automation features.",
    features: ["Advanced OTA features", "Higher priority support"]
  },
  enterprise: {
    id: "enterprise",
    name: "Enterprise",
    minimalDeviceCount: 1e3,
    price: "Custom pricing",
    deviceCount: "Unlimited devices",
    description: "Every advanced feature of Mender, tailored for complex and large-scale deployments. Not available as a monthly subscription \u2014 ask us for a quote.",
    features: ["All Mender features", "Advanced security features", "SLA-backed support"]
  }
};
var ADDONS = {
  configure: {
    id: "configure",
    title: "Configure",
    description: "Expand your plan with device configuration features",
    needs: ["hasDeviceConfig"],
    os: {
      price: "$11/month",
      deviceCount: startingDeviceCount.os
    },
    professional: {
      price: "$65/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["os", "professional", "enterprise"]
  },
  monitor: {
    id: "monitor",
    title: "Monitor",
    description: "Expand your plan with device monitoring features",
    needs: ["hasMonitor"],
    os: {
      price: "-",
      deviceCount: "-"
    },
    professional: {
      price: "$86/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["professional", "enterprise"]
  },
  troubleshoot: {
    id: "troubleshoot",
    title: "Troubleshoot",
    description: "Expand your plan with device troubleshooting features",
    needs: ["hasDeviceConnect"],
    os: {
      price: "$27/month",
      deviceCount: startingDeviceCount.os
    },
    professional: {
      price: "$72/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["os", "professional", "enterprise"]
  }
};
var BENEFITS = {
  auditlog: { id: "auditlog", benefit: "trace change across your devices and access troubleshooting session replay", requiredPlan: PLANS.professional.id },
  dashboard: { id: "dashboard", benefit: "actionable insights into the devices you are updating with Mender", requiredPlan: PLANS.enterprise.id },
  deltaGeneration: {
    id: "deltaGeneration",
    benefit: "automatic delta artifacts generation to minimize data transfer and improve the update delivery",
    requiredPlan: PLANS.enterprise.id
  },
  deviceConfiguration: { id: "deviceConfiguration", benefit: "device configuration features", requiredAddon: ADDONS.configure.id },
  deviceMonitor: { id: "deviceMonitor", benefit: "device monitoring features", requiredAddon: ADDONS.monitor.id, requiredPlan: PLANS.professional.id },
  deviceTroubleshoot: { id: "deviceTroubleshoot", benefit: "device troubleshooting features", requiredAddon: ADDONS.troubleshoot.id },
  dynamicGroups: { id: "dynamicGroups", benefit: "create dynamic groups to ease device management", requiredPlan: PLANS.enterprise.id },
  fullFiltering: { id: "fullFiltering", benefit: "filtering by multiple attributes to improve the device overview", requiredPlan: PLANS.professional.id },
  gateway: { id: "gateway", benefit: "see devices connected to your gateway device for easy access", requiredPlans: PLANS.professional.id },
  pausedDeployments: {
    id: "pausedDeployments",
    benefit: "granular control about update rollout to allow synchronization across your fleet",
    requiredPlan: PLANS.enterprise.id
  },
  phasedDeployments: { id: "phasedDeployments", benefit: "choose to roll out deployments in multiple phases", requiredPlan: PLANS.enterprise.id },
  rbac: { id: "rbac", benefit: "granular role based access control", requiredPlan: PLANS.enterprise.id },
  retryDeployments: { id: "retryDeployments", benefit: "optional retries for failed rollout attempts", requiredPlan: PLANS.professional.id },
  scheduledDeployments: {
    id: "scheduledDeployments",
    benefit: "scheduled deployments to steer the distribution of your updates.",
    requiredPlan: PLANS.professional.id
  },
  webhookEvents: {
    id: "webhookEvents",
    benefit: "receive inventory events and select which type(s) of events the webhook will receive",
    requiredPlan: PLANS.professional.id
  },
  default: { id: "default", benefit: "gain access to this feature", requiredPlan: PLANS.enterprise.id }
};
var DARK_MODE = "dark";

// src/commonConstants.tsx
var import_js = require("@mdi/js");
var import_MenderTypes = require("@northern.tech/types/MenderTypes");
var import_jsx_runtime = require("react/jsx-runtime");
var timeUnits = {
  days: "days",
  minutes: "minutes",
  hours: "hours"
};
var UNGROUPED_GROUP = { id: "*|=ungrouped=|*", name: "Unassigned" };
var DEVICE_LIST_MAXIMUM_LENGTH = 50;
var oneSecond = 1e3;
var TIMEOUTS = {
  debounceDefault: 700,
  debounceShort: 300,
  halfASecond: 0.5 * oneSecond,
  oneSecond,
  twoSeconds: 2 * oneSecond,
  threeSeconds: 3 * oneSecond,
  fiveSeconds: 5 * oneSecond,
  refreshDefault: 10 * oneSecond,
  refreshLong: 60 * oneSecond
};
var DEVICE_ONLINE_CUTOFF = { interval: 1, intervalName: timeUnits.days };
var defaultIdAttribute = Object.freeze({ attribute: "id", scope: import_constants5.ATTRIBUTE_SCOPES.identity });
var credentialTypes = {
  aws: import_MenderTypes.Credentials.type.AWS,
  http: import_MenderTypes.Credentials.type.HTTP,
  sas: import_MenderTypes.Credentials.type.SAS,
  x509: "x509"
};
var EXTERNAL_PROVIDER = {
  "iot-core": {
    credentialsType: credentialTypes.aws,
    icon: import_js.mdiAws,
    title: "AWS IoT Core",
    twinTitle: "Device Shadow",
    provider: "iot-core",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_jsx_runtime.Fragment, { children: "For help finding your AWS IoT Core connection string, check the AWS IoT documentation." })
  },
  "iot-hub": {
    credentialsType: credentialTypes.sas,
    icon: import_js.mdiMicrosoftAzure,
    title: "Azure IoT Hub",
    twinTitle: "Device Twin",
    provider: "iot-hub",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("span", { children: [
      "For help finding your Azure IoT Hub connection string, look under 'Shared access policies' in the Microsoft Azure UI as described",
      " ",
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        "a",
        {
          href: "https://devblogs.microsoft.com/iotdev/understand-different-connection-strings-in-azure-iot-hub/#iothubconn",
          target: "_blank",
          rel: "noopener noreferrer",
          children: "here"
        }
      ),
      "."
    ] })
  },
  webhook: {
    credentialsType: credentialTypes.http,
    deviceTwin: false,
    twinTitle: "",
    // disable the webhook provider here, since it is treated different than other integrations, with a custom configuration & management view, etc.
    enabled: false,
    provider: "webhook"
  }
};
var emptyWebhook = {
  description: "",
  provider: import_MenderTypes.Integration.provider.WEBHOOK,
  credentials: {
    type: EXTERNAL_PROVIDER.webhook.credentialsType,
    [EXTERNAL_PROVIDER.webhook.credentialsType]: {
      secret: "",
      url: ""
    }
  }
};
var MAX_PAGE_SIZE = 500;
var regionNames = new Intl.DisplayNames(["en"], { type: "region" });
var countries = [
  "AD",
  "AE",
  "AF",
  "AG",
  "AI",
  "AL",
  "AM",
  "AO",
  "AQ",
  "AR",
  "AS",
  "AT",
  "AU",
  "AW",
  "AX",
  "AZ",
  "BA",
  "BB",
  "BD",
  "BE",
  "BF",
  "BG",
  "BH",
  "BI",
  "BJ",
  "BL",
  "BM",
  "BN",
  "BO",
  "BR",
  "BS",
  "BT",
  "BV",
  "BW",
  "BY",
  "BZ",
  "CA",
  "CC",
  "CD",
  "CF",
  "CG",
  "CH",
  "CI",
  "CK",
  "CL",
  "CM",
  "CN",
  "CO",
  "CR",
  "CU",
  "CV",
  "CW",
  "CX",
  "CY",
  "CZ",
  "DE",
  "DJ",
  "DK",
  "DM",
  "DO",
  "DZ",
  "EC",
  "EE",
  "EG",
  "EH",
  "ER",
  "ES",
  "ET",
  "FI",
  "FJ",
  "FK",
  "FM",
  "FO",
  "FR",
  "GA",
  "GB",
  "GD",
  "GE",
  "GF",
  "GG",
  "GH",
  "GI",
  "GL",
  "GM",
  "GN",
  "GP",
  "GQ",
  "GR",
  "GS",
  "GT",
  "GU",
  "GW",
  "GY",
  "HK",
  "HM",
  "HN",
  "HR",
  "HT",
  "HU",
  "ID",
  "IE",
  "IL",
  "IM",
  "IN",
  "IO",
  "IQ",
  "IR",
  "IS",
  "IT",
  "JE",
  "JM",
  "JO",
  "JP",
  "KE",
  "KG",
  "KH",
  "KI",
  "KM",
  "KN",
  "KP",
  "KR",
  "KW",
  "KY",
  "KZ",
  "LA",
  "LB",
  "LC",
  "LI",
  "LK",
  "LR",
  "LS",
  "LT",
  "LU",
  "LV",
  "LY",
  "MA",
  "MC",
  "MD",
  "ME",
  "MF",
  "MG",
  "MH",
  "MK",
  "ML",
  "MM",
  "MN",
  "MO",
  "MP",
  "MQ",
  "MR",
  "MS",
  "MT",
  "MU",
  "MV",
  "MW",
  "MX",
  "MY",
  "MZ",
  "NA",
  "NC",
  "NE",
  "NF",
  "NG",
  "NI",
  "NL",
  "NO",
  "NP",
  "NR",
  "NU",
  "NZ",
  "OM",
  "PA",
  "PE",
  "PF",
  "PG",
  "PH",
  "PK",
  "PL",
  "PM",
  "PN",
  "PR",
  "PS",
  "PT",
  "PW",
  "PY",
  "QA",
  "RE",
  "RO",
  "RS",
  "RU",
  "RW",
  "SA",
  "SB",
  "SC",
  "SD",
  "SE",
  "SG",
  "SH",
  "SI",
  "SJ",
  "SK",
  "SL",
  "SM",
  "SN",
  "SO",
  "SR",
  "SS",
  "ST",
  "SV",
  "SX",
  "SY",
  "SZ",
  "TC",
  "TD",
  "TF",
  "TG",
  "TH",
  "TJ",
  "TK",
  "TL",
  "TM",
  "TN",
  "TO",
  "TR",
  "TT",
  "TV",
  "TW",
  "TZ",
  "UA",
  "UG",
  "US",
  "UY",
  "UZ",
  "VA",
  "VC",
  "VE",
  "VG",
  "VI",
  "VN",
  "VU",
  "WF",
  "WS",
  "XK",
  "YE",
  "YT",
  "ZA",
  "ZM",
  "ZW"
].map((code) => ({ code, label: regionNames.of(code) })).sort((a, b) => a.label.localeCompare(b.label));

// src/deploymentsSlice/constants.ts
var alreadyInstalled = "already-installed";
var deploymentSubstates = {
  aborted: "aborted",
  alreadyInstalled,
  decommissioned: "decommissioned",
  downloading: "downloading",
  failure: "failure",
  installing: "installing",
  noartifact: "noartifact",
  pause_before_committing: "pause_before_committing",
  pause_before_installing: "pause_before_installing",
  pause_before_rebooting: "pause_before_rebooting",
  pending: "pending",
  rebooting: "rebooting",
  success: "success"
};
var deploymentStatesToSubstates = {
  failures: [deploymentSubstates.failure, deploymentSubstates.aborted, deploymentSubstates.decommissioned],
  inprogress: [deploymentSubstates.downloading, deploymentSubstates.installing, deploymentSubstates.rebooting],
  paused: [deploymentSubstates.pause_before_installing, deploymentSubstates.pause_before_rebooting, deploymentSubstates.pause_before_committing],
  pending: [deploymentSubstates.pending],
  successes: [deploymentSubstates.success, deploymentSubstates.alreadyInstalled, deploymentSubstates.noartifact]
};
var deploymentStatesToSubstatesWithSkipped = {
  ...deploymentStatesToSubstates,
  failures: [deploymentSubstates.failure],
  skipped: [deploymentSubstates.aborted, deploymentSubstates.noartifact, deploymentSubstates.alreadyInstalled, deploymentSubstates.decommissioned],
  successes: [deploymentSubstates.success]
};
var installationSubstatesMap = {
  download: {
    title: "download",
    done: "downloaded",
    successIndicators: [deploymentSubstates.installing, deploymentSubstates.rebooting, ...deploymentStatesToSubstates.paused, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactInstall_Enter"
  },
  install: {
    title: "install",
    done: "installed",
    successIndicators: [
      deploymentSubstates.rebooting,
      deploymentSubstates.pause_before_rebooting,
      deploymentSubstates.pause_before_committing,
      deploymentSubstates.success
    ],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactReboot_Enter"
  },
  reboot: {
    title: "reboot",
    done: "rebooted",
    successIndicators: [deploymentSubstates.pause_before_committing, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactCommit_Enter"
  },
  commit: {
    title: "commit",
    done: "committed",
    successIndicators: deploymentStatesToSubstates.successes,
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: void 0
  }
};
var DEPLOYMENT_STATES = {
  finished: "finished",
  inprogress: "inprogress",
  pending: "pending",
  scheduled: "scheduled"
};
var listDefaultsByState = {
  [DEPLOYMENT_STATES.inprogress]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.pending]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.scheduled]: { ...import_constants5.DEVICE_LIST_DEFAULTS },
  [DEPLOYMENT_STATES.finished]: { ...import_constants5.DEVICE_LIST_DEFAULTS },
  sort: { direction: import_constants5.SORTING_OPTIONS.desc }
};
var DEFAULT_PENDING_INPROGRESS_COUNT = 10;
var DEPLOYMENT_ROUTES = {
  active: {
    key: "active",
    route: "/deployments/active",
    states: [DEPLOYMENT_STATES.pending, DEPLOYMENT_STATES.inprogress],
    title: "Active"
  },
  finished: {
    key: "finished",
    route: "/deployments/finished",
    states: [DEPLOYMENT_STATES.finished],
    title: "Finished"
  },
  scheduled: {
    key: "scheduled",
    route: "/deployments/scheduled",
    states: [DEPLOYMENT_STATES.scheduled],
    title: "Scheduled"
  }
};
var DEPLOYMENT_TYPES = {
  software: "software",
  configuration: "configuration"
};
var defaultStats = {
  [deploymentSubstates.aborted]: 0,
  [deploymentSubstates.alreadyInstalled]: 0,
  [deploymentSubstates.decommissioned]: 0,
  [deploymentSubstates.downloading]: 0,
  [deploymentSubstates.failure]: 0,
  [deploymentSubstates.installing]: 0,
  [deploymentSubstates.noartifact]: 0,
  [deploymentSubstates.pause_before_committing]: 0,
  [deploymentSubstates.pause_before_installing]: 0,
  [deploymentSubstates.pause_before_rebooting]: 0,
  [deploymentSubstates.pending]: 0,
  [deploymentSubstates.rebooting]: 0,
  [deploymentSubstates.success]: 0
};
var deploymentPrototype = {
  devices: {},
  name: void 0,
  statistics: { status: {} }
};
var pauseMap = {
  [deploymentSubstates.pause_before_installing]: {
    title: installationSubstatesMap.download.done,
    followUp: installationSubstatesMap.download.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_rebooting]: {
    title: installationSubstatesMap.install.done,
    followUp: installationSubstatesMap.install.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_committing]: {
    title: installationSubstatesMap.reboot.done,
    followUp: installationSubstatesMap.reboot.pauseConfigurationIndicator
  }
};

// src/devicesSlice/constants.ts
var emptyFilter = { key: null, value: "", operator: import_constants5.DEVICE_FILTERING_OPTIONS.$eq.key, scope: "inventory" };
var geoAttributes = ["geo-lat", "geo-lon"].map((attribute) => ({ attribute, scope: "inventory" }));

// src/onboardingSlice/constants.ts
var onboardingSteps = {
  ONBOARDING_START: "onboarding-start",
  DEVICES_PENDING_ONBOARDING_START: "devices-pending-onboarding-start",
  DASHBOARD_ONBOARDING_START: "dashboard-onboarding-start",
  DASHBOARD_ONBOARDING_PENDINGS: "dashboard-onboarding-pendings",
  DEVICES_DELAYED_ONBOARDING: "devices-delayed-onboarding",
  DEVICES_PENDING_ONBOARDING: "devices-pending-onboarding",
  DEVICES_ACCEPTED_ONBOARDING: "devices-accepted-onboarding",
  DEVICES_PENDING_ACCEPTING_ONBOARDING: "devices-pending-accepting-onboarding",
  DEVICES_DEPLOY_RELEASE_ONBOARDING: "devices-deploy-release-onboarding",
  SCHEDULING_ARTIFACT_SELECTION: "scheduling-artifact-selection",
  SCHEDULING_ALL_DEVICES_SELECTION: "scheduling-all-devices-selection",
  SCHEDULING_GROUP_SELECTION: "scheduling-group-selection",
  SCHEDULING_RELEASE_TO_DEVICES: "scheduling-release-to-devices",
  DEPLOYMENTS_INPROGRESS: "deployments-inprogress",
  DEPLOYMENTS_COMPLETED: "deployments-completed",
  DEPLOYMENTS_PAST: "deployments-past",
  DEPLOYMENTS_PAST_COMPLETED: "deployments-past-completed",
  DEPLOYMENTS_PAST_COMPLETED_FAILURE: "deployments-past-completed-failure",
  ONBOARDING_CANCELED: "onboarding-canceled"
};
var orderedOnboardingSteps = [
  onboardingSteps.DASHBOARD_ONBOARDING_START,
  onboardingSteps.DEVICES_PENDING_ONBOARDING_START,
  onboardingSteps.DEVICES_DELAYED_ONBOARDING,
  onboardingSteps.DEVICES_PENDING_ONBOARDING,
  onboardingSteps.DEVICES_PENDING_ACCEPTING_ONBOARDING,
  onboardingSteps.DASHBOARD_ONBOARDING_PENDINGS,
  onboardingSteps.DEVICES_ACCEPTED_ONBOARDING,
  onboardingSteps.DEVICES_DEPLOY_RELEASE_ONBOARDING,
  onboardingSteps.SCHEDULING_ALL_DEVICES_SELECTION,
  onboardingSteps.SCHEDULING_GROUP_SELECTION,
  onboardingSteps.SCHEDULING_ARTIFACT_SELECTION,
  onboardingSteps.SCHEDULING_RELEASE_TO_DEVICES,
  onboardingSteps.DEPLOYMENTS_INPROGRESS,
  onboardingSteps.DEPLOYMENTS_PAST,
  onboardingSteps.DEPLOYMENTS_PAST_COMPLETED,
  onboardingSteps.DEPLOYMENTS_PAST_COMPLETED_FAILURE,
  onboardingSteps.ONBOARDING_CANCELED
];

// src/organizationSlice/constants.ts
var XML_METADATA_FORMAT = "xml";
var JSON_METADATA_FORMAT = "json";
var getSamlStartUrl = (id) => `${window.location.origin}${import_constants5.useradmApiUrl}/auth/sso/${id}/login`;
var getOidcStartUrl = (id) => `${window.location.origin}${import_constants5.useradmApiUrl}/oidc/${id}/start`;
var SSO_TYPES = {
  saml: {
    id: "saml",
    type: "saml",
    title: "SAML",
    metadataFormat: XML_METADATA_FORMAT,
    editorLanguage: XML_METADATA_FORMAT,
    contentType: "application/samlmetadata+xml",
    getStartUrl: getSamlStartUrl,
    configDetails: [
      { key: "entityID", label: "Entity ID", getValue: (id) => `${window.location.origin}${import_constants5.useradmApiUrl}/sso/sp/metadata/${id}` },
      { key: "acs", label: "ACS URL", getValue: (id) => `${window.location.origin}${import_constants5.useradmApiUrl}/auth/sso/${id}/acs` },
      { key: "startURL", label: "Start URL", getValue: getSamlStartUrl }
    ]
  },
  oidc: {
    id: "oidc",
    type: "oidc",
    title: "OpenID Connect",
    metadataFormat: JSON_METADATA_FORMAT,
    editorLanguage: JSON_METADATA_FORMAT,
    contentType: "application/json",
    getStartUrl: getOidcStartUrl,
    configDetails: [{ key: "startURL", label: "Start Url", getValue: getOidcStartUrl }]
  }
};
var auditlogTypes = {
  artifact: { title: "Artifact", queryParameter: "object_type", value: "artifact" },
  deployment: { title: "Deployment", queryParameter: "object_deployment_name", value: "deployment" },
  device: { title: "Device", queryParameter: "object_id", value: "device" },
  user_access_token: { title: "Personal Access Token", queryParameter: "user_access_token", value: "user_access_token" },
  user: { title: "User", queryParameter: "object_id", value: "user" },
  tenant: { title: "Tenant", queryParameter: "object_id", value: "tenant" }
};
var AUDIT_LOGS_TYPES = [auditlogTypes.artifact, auditlogTypes.deployment, auditlogTypes.device, auditlogTypes.user_access_token, auditlogTypes.user];
var SP_AUDIT_LOGS_TYPES = [auditlogTypes.user, auditlogTypes.tenant];
var TENANT_LIST_DEFAULT = {
  page: 1,
  perPage: 20
};

// src/releasesSlice/constants.ts
var rootfsImageVersion = "rootfs-image.version";
var softwareTitleMap = { [rootfsImageVersion]: { title: "Root filesystem", priority: 0, key: rootfsImageVersion } };

// src/usersSlice/constants.ts
var itemUiPermissionsReducer = (accu, { item, uiPermissions }) => item ? { ...accu, [item]: uiPermissions } : accu;
var USER_LOGOUT = "USER_LOGOUT";
var OWN_USER_ID = "me";
var settingsKeys = { initialized: "settings-initialized" };
var READ_STATES = {
  read: "read",
  seen: "seen",
  unread: "unread"
};

// src/deploymentsSlice/index.ts
var sliceName = "deployments";
var initialState = {
  byId: {
    // [id]: { statistics: { status: {}, total_size }, devices: { [deploymentId]: { id, log } }, totalDeviceCount }
  },
  byStatus: {
    finished: { deploymentIds: [], total: 0 },
    inprogress: { deploymentIds: [], total: 0 },
    pending: { deploymentIds: [], total: 0 },
    scheduled: { deploymentIds: [], total: 0 }
  },
  config: {
    binaryDelta: {
      timeout: -1,
      duplicatesWindow: -1,
      compressionLevel: -1,
      disableChecksum: false,
      disableDecompression: false,
      inputWindow: -1,
      instructionBuffer: -1,
      sourceWindow: -1
    },
    binaryDeltaLimits: {
      timeout: { ...import_constants5.limitDefault, default: 60, max: 3600, min: 60 },
      sourceWindow: import_constants5.limitDefault,
      inputWindow: import_constants5.limitDefault,
      duplicatesWindow: import_constants5.limitDefault,
      instructionBuffer: import_constants5.limitDefault
    }
  },
  deploymentDeviceLimit: 5e3,
  selectedDeviceIds: [],
  selectionState: {
    finished: { ...import_constants5.DEVICE_LIST_DEFAULTS, endDate: void 0, search: "", selection: [], startDate: void 0, total: 0, type: "" },
    inprogress: { ...import_constants5.DEVICE_LIST_DEFAULTS, perPage: DEFAULT_PENDING_INPROGRESS_COUNT, selection: [] },
    pending: { ...import_constants5.DEVICE_LIST_DEFAULTS, perPage: DEFAULT_PENDING_INPROGRESS_COUNT, selection: [] },
    scheduled: { ...import_constants5.DEVICE_LIST_DEFAULTS, selection: [] },
    general: {
      state: DEPLOYMENT_ROUTES.active.key,
      showCreationDialog: false,
      showReportDialog: false,
      reportType: null
      // DeploymentConstants.DEPLOYMENT_TYPES.configuration|DeploymentConstants.DEPLOYMENT_TYPES.software
    },
    selectedId: void 0
  }
};
var deploymentsSlice = (0, import_toolkit.createSlice)({
  name: sliceName,
  initialState,
  reducers: {
    createdDeployment: (state, action) => {
      state.byId[action.payload.id] = {
        ...deploymentPrototype,
        ...action.payload
      };
      state.byStatus[DEPLOYMENT_STATES.pending].total = state.byStatus[DEPLOYMENT_STATES.pending].total + 1;
      state.byStatus[DEPLOYMENT_STATES.pending].deploymentIds = [...state.byStatus.pending.deploymentIds, action.payload.id];
      state.selectionState[DEPLOYMENT_STATES.pending].selection = [action.payload.id, ...state.selectionState[DEPLOYMENT_STATES.pending].selection];
      state.selectionState[DEPLOYMENT_STATES.pending].total = (state.selectionState[DEPLOYMENT_STATES.pending].total || 0) + 1;
    },
    removedDeployment: (state, action) => {
      const { [action.payload]: removedDeployment, ...remainder } = state.byId;
      state.byId = remainder;
    },
    receivedDeployment: (state, action) => {
      state.byId[action.payload.id] = {
        ...state.byId[action.payload.id] || {},
        ...action.payload
      };
    },
    receivedDeploymentDeviceLog: (state, action) => {
      const { id, deviceId, log } = action.payload;
      const deployment = {
        ...deploymentPrototype,
        ...state.byId[id]
      };
      state.byId[id] = {
        ...deployment,
        devices: {
          ...deployment.devices,
          [deviceId]: {
            ...deployment.devices[deviceId],
            log
          }
        }
      };
    },
    receivedDeploymentDevices: (state, action) => {
      const { id, devices, selectedDeviceIds, totalDeviceCount } = action.payload;
      state.byId[id] = {
        ...state.byId[id],
        devices,
        totalDeviceCount
      };
      state.selectedDeviceIds = selectedDeviceIds;
    },
    receivedDeployments: (state, action) => {
      state.byId = {
        ...state.byId,
        ...action.payload
      };
    },
    receivedDeploymentsForStatus: (state, action) => {
      const { status, deploymentIds, total } = action.payload;
      state.byStatus[status].deploymentIds = deploymentIds;
      state.byStatus[status].total = total;
    },
    selectDeploymentsForStatus: (state, action) => {
      const { status, deploymentIds, total } = action.payload;
      state.selectionState[status].selection = deploymentIds;
      state.selectionState[status].total = total;
    },
    setDeploymentsState: (state, action) => {
      state.selectionState = action.payload;
    },
    setDeploymentsConfig: (state, action) => {
      state.config = action.payload;
    }
  }
});
var actions = deploymentsSlice.actions;
var deploymentsSlice_default = deploymentsSlice.reducer;

// src/appSlice/index.ts
var import_toolkit2 = require("@reduxjs/toolkit");
var sliceName2 = "app";
var getYesterday = () => {
  const today = /* @__PURE__ */ new Date();
  today.setDate(today.getDate() - 1);
  return today.toISOString();
};
var initialState2 = {
  cancelSource: void 0,
  commit: "",
  demoArtifactLink: "https://dgsbl4vditpls.cloudfront.net/mender-demo-artifact.mender",
  hostAddress: null,
  snackbar: {
    action: void 0,
    autoHideDuration: void 0,
    message: "",
    open: false,
    preventClickToCopy: false
  },
  // return boolean rather than organization details
  features: {
    hasAuditlogs: false,
    hasDeltaProgress: false,
    hasMultitenancy: false,
    hasDeviceConfig: false,
    hasDeviceConnect: false,
    hasFeedbackEnabled: false,
    hasMonitor: false,
    hasReporting: false,
    isHosted: true,
    isEnterprise: false
  },
  feedbackProbability: 0.3,
  firstLoginAfterSignup: false,
  hostedAnnouncement: "",
  docsVersion: "",
  recaptchaSiteKey: "",
  searchState: {
    deviceIds: [],
    searchTerm: "",
    searchTotal: 0,
    isSearching: false,
    sort: {
      direction: import_constants5.SORTING_OPTIONS.desc
      // key: null,
      // scope: null
    }
  },
  sentry: {
    location: "",
    replaysSessionSampleRate: 0.1,
    tracesSampleRate: 1
  },
  stripeAPIKey: "",
  trackerCode: "",
  uploadsById: {
    // id: { progress: 0, cancelSource: undefined }
  },
  newThreshold: getYesterday(),
  offlineThreshold: getYesterday(),
  versionInformation: {
    Integration: "",
    "Mender-Client": "",
    "Mender-Artifact": "",
    "Meta-Mender": ""
  },
  yesterday: void 0
};
var appSlice = (0, import_toolkit2.createSlice)({
  name: sliceName2,
  initialState: initialState2,
  reducers: {
    setFeatures: (state, action) => {
      state.features = {
        ...state.features,
        ...action.payload
      };
    },
    setSnackbar: (state, { payload }) => {
      if (typeof payload === "string" || payload instanceof String) {
        state.snackbar = {
          ...initialState2.snackbar,
          message: payload,
          open: !!payload
        };
        return;
      }
      const { message, autoHideDuration, action, preventClickToCopy = false } = payload;
      state.snackbar = {
        message,
        autoHideDuration,
        action,
        preventClickToCopy,
        open: !!message
      };
    },
    setFirstLoginAfterSignup: (state, action) => {
      state.firstLoginAfterSignup = action.payload;
    },
    setAnnouncement: (state, action) => {
      state.hostedAnnouncement = action.payload;
    },
    setSearchState: (state, action) => {
      state.searchState = {
        ...state.searchState,
        ...action.payload
      };
    },
    setOfflineThreshold: (state, action) => {
      state.offlineThreshold = action.payload;
    },
    initUpload: (state, action) => {
      const { id, upload } = action.payload;
      state.uploadsById[id] = upload;
    },
    uploadProgress: (state, action) => {
      const { id, progress: progress2 } = action.payload;
      state.uploadsById[id] = {
        ...state.uploadsById[id],
        progress: progress2
      };
    },
    cleanUpUpload: (state, action) => {
      const { [action.payload]: current, ...remainder } = state.uploadsById;
      state.uploadsById = remainder;
    },
    setVersionInformation: (state, action) => {
      state.versionInformation = {
        ...state.versionInformation,
        ...action.payload
      };
    },
    setEnvironmentData: (state, action) => ({ ...state, ...action.payload })
  }
});
var actions2 = appSlice.actions;
var appSlice_default = appSlice.reducer;

// src/devicesSlice/index.ts
var import_helpers = require("@northern.tech/utils/helpers");
var import_toolkit3 = require("@reduxjs/toolkit");
var sliceName3 = "devices";
var initialState3 = {
  byId: {
    // [deviceId]: {
    //   ...,
    //   twinsByIntegration: { [external.provider.id]: twinData }
    // }
  },
  byStatus: {
    [import_constants5.DEVICE_STATES.accepted]: { deviceIds: [], total: 0 },
    active: { deviceIds: [], total: 0 },
    inactive: { deviceIds: [], total: 0 },
    [import_constants5.DEVICE_STATES.pending]: { deviceIds: [], total: 0 },
    [import_constants5.DEVICE_STATES.preauth]: { deviceIds: [], total: 0 },
    [import_constants5.DEVICE_STATES.rejected]: { deviceIds: [], total: 0 }
  },
  deviceList: {
    deviceIds: [],
    ...import_constants5.DEVICE_LIST_DEFAULTS,
    selectedAttributes: [],
    selectedIssues: [],
    selection: [],
    sort: {
      direction: import_constants5.SORTING_OPTIONS.desc
      // key: null,
      // scope: null
    },
    state: import_constants5.DEVICE_STATES.accepted,
    total: 0,
    refreshTrigger: false,
    isLoading: false,
    detailsTab: "",
    open: false
  },
  filters: [
    // { key: 'device_type', value: 'raspberry', operator: '$eq', scope: 'inventory' }
  ],
  filteringAttributes: { identityAttributes: [], inventoryAttributes: [], systemAttributes: [], tagAttributes: [] },
  filteringAttributesLimit: 10,
  filteringAttributesConfig: {
    attributes: {
      // inventory: ['some_attribute']
    },
    count: 0,
    limit: 100
  },
  reports: [
    // { items: [{ key: "someKey", count: 42  }], otherCount: 123, total: <otherCount + itemsCount> }
  ],
  total: 0,
  limit: 0,
  groups: {
    byId: {
      // groupName: { deviceIds: [], total: 0, filters: [] },
      // dynamo: { deviceIds: [], total: 3, filters: [{ a: 1 }] }
    },
    selectedGroup: void 0
  }
};
var devicesSlice = (0, import_toolkit3.createSlice)({
  name: sliceName3,
  initialState: initialState3,
  reducers: {
    receivedGroups: (state, action) => {
      state.groups.byId = action.payload;
    },
    addToGroup: (state, action) => {
      const { group, deviceIds } = action.payload;
      const maybeExistingGroup = {
        filters: [],
        deviceIds: [],
        ...state.groups.byId[group]
      };
      state.groups.byId[group] = {
        ...maybeExistingGroup,
        deviceIds: [...maybeExistingGroup.deviceIds, ...deviceIds].filter(import_helpers.duplicateFilter),
        total: (maybeExistingGroup.total || 0) + 1
      };
    },
    removeFromGroup: (state, action) => {
      const { group, deviceIds: removedIds } = action.payload;
      const { deviceIds = [], total = 0, ...maybeExistingGroup } = state.groups.byId[group] || {};
      const changedGroup = {
        ...maybeExistingGroup,
        deviceIds: deviceIds.filter((id) => !removedIds.includes(id)),
        total: Math.max(total - removedIds.length, 0)
      };
      if (changedGroup.total || changedGroup.deviceIds.length) {
        state.groups.byId[group] = changedGroup;
        return;
      } else if (state.groups.selectedGroup === group) {
        state.groups.selectedGroup = void 0;
      }
      const { [group]: removal, ...remainingById } = state.groups.byId;
      state.groups.byId = remainingById;
    },
    addGroup: (state, action) => {
      const { groupName, group } = action.payload;
      state.groups.byId[groupName] = {
        ...state.groups.byId[groupName],
        ...group
      };
    },
    selectGroup: (state, { payload: group }) => {
      state.deviceList.deviceIds = group && state.groups.byId[group] && state.groups.byId[group].deviceIds && state.groups.byId[group].deviceIds.length > 0 ? state.groups.byId[group].deviceIds : [];
      state.groups.selectedGroup = group;
    },
    removeGroup: (state, action) => {
      const { [action.payload]: removal, ...remainingById } = state.groups.byId;
      state.groups.byId = remainingById;
      state.groups.selectedGroup = state.groups.selectedGroup === action.payload ? void 0 : state.groups.selectedGroup;
    },
    setDeviceListState: (state, action) => {
      state.deviceList = {
        ...state.deviceList,
        ...action.payload,
        sort: {
          ...state.deviceList.sort,
          ...action.payload.sort
        }
      };
    },
    setFilterAttributes: (state, action) => {
      state.filteringAttributes = action.payload;
    },
    setFilterablesConfig: (state, action) => {
      state.filteringAttributesConfig = action.payload;
    },
    receivedDevices: (state, action) => {
      state.byId = {
        ...state.byId,
        ...action.payload
      };
    },
    setDeviceFilters: (state, action) => {
      if ((0, import_helpers.deepCompare)(action.payload, state.filters)) {
        return;
      }
      state.filters = action.payload.filter((filter) => filter.key && filter.operator && filter.scope && typeof filter.value !== "undefined");
    },
    setInactiveDevices: (state, action) => {
      const { activeDeviceTotal, inactiveDeviceTotal } = action.payload;
      state.byStatus.active.total = activeDeviceTotal;
      state.byStatus.inactive.total = inactiveDeviceTotal;
    },
    setDeviceReports: (state, action) => {
      state.reports = action.payload;
    },
    setDevicesByStatus: (state, action) => {
      const { forceUpdate, status, total, deviceIds } = action.payload;
      state.byStatus[status] = total || forceUpdate ? { deviceIds, total } : state.byStatus[status];
    },
    setDevicesCountByStatus: (state, action) => {
      const { count, status } = action.payload;
      state.byStatus[status].total = count;
    },
    setDeviceLimit: (state, action) => {
      state.limit = action.payload;
    },
    receivedDevice: (state, action) => {
      state.byId[action.payload.id] = {
        ...state.byId[action.payload.id],
        ...action.payload
      };
    },
    maybeUpdateDevicesByStatus: (state, action) => {
      const { deviceId, authId } = action.payload;
      const device = state.byId[deviceId];
      const hasMultipleAuthSets = authId && device.auth_sets ? device.auth_sets.filter((authset) => authset.id !== authId).length > 0 : false;
      if (!hasMultipleAuthSets && Object.values(import_constants5.DEVICE_STATES).includes(device.status)) {
        const deviceIds = state.byStatus[device.status].deviceIds.filter((id) => id !== deviceId);
        state.byStatus[device.status] = { deviceIds, total: Math.max(0, state.byStatus[device.status].total - 1) };
      }
    }
  }
});
var actions3 = devicesSlice.actions;
var devicesSlice_default = devicesSlice.reducer;

// src/monitorSlice/index.ts
var import_toolkit4 = require("@reduxjs/toolkit");
var sliceName4 = "monitor";
var initialState4 = {
  alerts: {
    alertList: { ...import_constants5.DEVICE_LIST_DEFAULTS, total: 0 },
    byDeviceId: {}
  },
  issueCounts: {
    byType: Object.keys(import_constants5.DEVICE_ISSUE_OPTIONS).reduce((accu, key) => ({ ...accu, [key]: { filtered: 0, total: 0 } }), {})
  },
  settings: {
    global: {
      channels: {
        ...Object.keys(import_constants5.alertChannels).reduce((accu, item) => ({ ...accu, [item]: { enabled: true } }), {})
      }
    }
  }
};
var monitorSlice = (0, import_toolkit4.createSlice)({
  name: sliceName4,
  initialState: initialState4,
  reducers: {
    changeAlertChannel: (state, action) => {
      const { channel, enabled } = action.payload;
      state.settings.global.channels[channel] = { enabled };
    },
    receiveDeviceAlerts: (state, action) => {
      const { deviceId, alerts } = action.payload;
      state.alerts.byDeviceId[deviceId] = { alerts };
    },
    receiveLatestDeviceAlerts: (state, action) => {
      const { deviceId, alerts } = action.payload;
      state.alerts.byDeviceId[deviceId] = { ...state.alerts.byDeviceId[deviceId], latest: alerts };
    },
    receiveDeviceIssueCounts: (state, action) => {
      const { issueType, counts } = action.payload;
      state.issueCounts.byType[issueType] = counts;
    },
    setAlertListState: (state, action) => {
      state.alerts.alertList = { ...state.alerts.alertList, ...action.payload };
    }
  }
});
var actions4 = monitorSlice.actions;
var monitorSlice_default = monitorSlice.reducer;

// src/onboardingSlice/index.ts
var import_toolkit5 = require("@reduxjs/toolkit");
var sliceName5 = "onboarding";
var initialState5 = {
  approach: null,
  complete: false,
  deviceType: null,
  demoArtifactPort: 85,
  progress: null,
  showTips: null,
  showTipsDialog: false
};
var onboardingSlice = (0, import_toolkit5.createSlice)({
  name: sliceName5,
  initialState: initialState5,
  reducers: {
    setOnboardingState: (state, action) => ({ ...state, ...action.payload }),
    setDemoArtifactPort: (state, action) => {
      state.demoArtifactPort = action.payload;
    },
    setShowOnboardingHelp: (state, action) => {
      state.showTips = action.payload;
    },
    setShowDismissOnboardingTipsDialog: (state, action) => {
      state.showTipsDialog = action.payload;
    },
    setOnboardingComplete: (state, action) => {
      state.complete = action.payload;
    },
    setOnboardingProgress: (state, action) => {
      state.progress = action.payload;
    },
    setOnboardingDeviceType: (state, action) => {
      state.deviceType = action.payload;
    },
    setOnboardingApproach: (state, action) => {
      state.approach = action.payload;
    }
  }
});
var actions5 = onboardingSlice.actions;
var onboardingSlice_default = onboardingSlice.reducer;

// src/organizationSlice/index.ts
var import_toolkit6 = require("@reduxjs/toolkit");
var sliceName6 = "organization";
var initialState6 = {
  card: {
    last4: "",
    expiration: { month: 1, year: 2020 },
    brand: ""
  },
  intentId: null,
  tenantList: {
    ...TENANT_LIST_DEFAULT,
    total: 0,
    tenants: [],
    selectedTenant: null,
    sort: {
      direction: import_constants5.SORTING_OPTIONS.desc,
      key: "name"
    }
  },
  organization: {
    // id, name, status, tenant_token, plan
  },
  auditlog: {
    events: [],
    selectionState: {
      ...import_constants5.DEVICE_LIST_DEFAULTS,
      detail: void 0,
      endDate: void 0,
      selectedIssue: void 0,
      sort: { direction: import_constants5.SORTING_OPTIONS.desc },
      startDate: void 0,
      total: 0,
      type: void 0,
      user: void 0,
      isLoading: false
    }
  },
  externalDeviceIntegrations: [
    // { <connection_string|x509|...>, id, provider }
  ],
  ssoConfigs: [],
  webhooks: {
    // [id]: { events: [] }
    // for now:
    events: [],
    eventsTotal: 0
  }
};
var organizationSlice = (0, import_toolkit6.createSlice)({
  name: sliceName6,
  initialState: initialState6,
  reducers: {
    receiveAuditLogs: (state, action) => {
      const { events, total } = action.payload;
      state.auditlog.events = events;
      state.auditlog.selectionState.total = total;
    },
    setAuditLogState: (state, action) => {
      state.auditlog.selectionState = {
        ...state.auditlog.selectionState,
        ...action.payload
      };
    },
    receiveCurrentCard: (state, action) => {
      state.card = action.payload;
    },
    receiveSetupIntent: (state, action) => {
      state.intentId = action.payload;
    },
    setOrganization: (state, action) => {
      state.organization = { ...state.organization, ...action.payload };
    },
    setSubscription: (state, action) => {
      state.organization.subscription = { ...state.organization.subscription, ...action.payload };
    },
    setBillingProfile: (state, action) => {
      state.organization.billing_profile = action.payload;
    },
    setTenantListState: (state, action) => {
      state.tenantList = action.payload;
    },
    receiveExternalDeviceIntegrations: (state, action) => {
      state.externalDeviceIntegrations = action.payload;
    },
    receiveSsoConfigs: (state, action) => {
      state.ssoConfigs = action.payload;
    },
    receiveWebhookEvents: (state, action) => {
      const { value, total } = action.payload;
      state.webhooks.events = value;
      state.webhooks.eventsTotal = total;
    }
  }
});
var actions6 = organizationSlice.actions;
var organizationSlice_default = organizationSlice.reducer;

// src/releasesSlice/index.ts
var import_toolkit7 = require("@reduxjs/toolkit");
var sliceName7 = "releases";
var initialState7 = {
  /*
   * Return list of saved artifacts objects
   */
  /*
   * return list of artifacts where duplicate names are collated with device compatibility lists combined
   */
  // artifacts: AppStore.getCollatedArtifacts(AppStore.getArtifactsRepo()),
  artifacts: [],
  /*
   * Return list of saved release objects
   */
  byId: {
    /*
    [releaseName]: {
      artifacts: [
        {
          id: '',
          name: '',
          description: '',
          device_types_compatible: [],
          ...
          updates: [{
            files: [
              { size: 123, name: '' }
            ],
            type_info: { type: '' }
          }],
          url: '' // optional
        }
      ],
      modified: ''
      device_types_compatible,
      name: '',
      tags: ['something'],
      notes: ''
    }
    */
  },
  releasesList: {
    ...import_constants5.DEVICE_LIST_DEFAULTS,
    searchedIds: [],
    releaseIds: [],
    selection: [],
    sort: {
      direction: import_constants5.SORTING_OPTIONS.desc,
      key: "modified"
    },
    isLoading: void 0,
    searchTerm: "",
    searchTotal: 0,
    selectedTags: [],
    total: 0,
    type: ""
  },
  tags: [],
  updateTypes: [],
  /*
   * Return single release with corresponding Artifacts
   */
  selectedRelease: null
};
var releaseSlice = (0, import_toolkit7.createSlice)({
  name: sliceName7,
  initialState: initialState7,
  reducers: {
    receiveRelease: (state, action) => {
      const { name } = action.payload;
      state.byId[name] = action.payload;
    },
    receiveReleases: (state, action) => {
      state.byId = action.payload;
    },
    receiveReleaseTags: (state, action) => {
      state.tags = action.payload;
    },
    receiveReleaseTypes: (state, action) => {
      state.updateTypes = action.payload;
    },
    removeRelease: (state, action) => {
      const { [action.payload]: toBeRemoved, ...byId } = state.byId;
      state.byId = byId;
      state.selectedRelease = action.payload === state.selectedRelease ? null : state.selectedRelease;
    },
    selectedRelease: (state, action) => {
      state.selectedRelease = action.payload;
    },
    setReleaseListState: (state, action) => {
      state.releasesList = action.payload;
    }
  }
});
var actions7 = releaseSlice.actions;
var releasesSlice_default = releaseSlice.reducer;

// src/usersSlice/index.ts
var import_toolkit8 = require("@reduxjs/toolkit");
var sliceName8 = "users";
var initialState8 = {
  activationCode: void 0,
  byId: {},
  currentUser: null,
  currentSession: {
    // { token: window.localStorage.getItem('JWT'), expiresAt: '2023-01-01T00:15:00.000Z' | undefined }, // expiresAt depending on the stay logged in setting
  },
  customColumns: [],
  qrCode: null,
  globalSettings: {
    id_attribute: void 0,
    previousFilters: [],
    previousPhases: [],
    retries: 0
  },
  permissionSetsById: {
    ...import_constants5.defaultPermissionSets
  },
  rolesById: {
    ...import_constants5.rolesById
  },
  rolesInitialized: false,
  settingsInitialized: false,
  showConnectDeviceDialog: false,
  showFeedbackDialog: false,
  showStartupNotification: false,
  tooltips: {
    byId: {
      // <id>: { readState: <read|unread> } // this object is getting enhanced by the tooltip texts in the app constants
    }
  },
  userSettings: {
    columnSelection: [],
    onboarding: {}
  },
  userSettingsInitialized: false
};
var usersSlice = (0, import_toolkit8.createSlice)({
  name: sliceName8,
  initialState: initialState8,
  reducers: {
    receivedQrCode: (state, action) => {
      state.qrCode = action.payload;
    },
    successfullyLoggedIn: (state, action) => {
      state.currentSession = action.payload;
    },
    receivedUserList: (state, action) => {
      state.byId = action.payload;
    },
    receivedActivationCode: (state, action) => {
      state.activationCode = action.payload;
    },
    receivedUser: (state, action) => {
      state.byId[action.payload.id] = action.payload;
      state.currentUser = action.payload.id;
    },
    removedUser: (state, action) => {
      const { [action.payload]: removedUser, ...byId } = state.byId;
      state.byId = byId;
      state.currentUser = state.currentUser === action.payload ? null : state.currentUser;
    },
    updatedUser: (state, action) => {
      state.byId[action.payload.id] = {
        ...state.byId[action.payload.id],
        ...action.payload
      };
    },
    receivedPermissionSets: (state, action) => {
      state.permissionSetsById = action.payload;
    },
    receivedRoles: (state, action) => {
      state.rolesById = action.payload;
      state.rolesInitialized = true;
    },
    finishedRoleInitialization: (state, action) => {
      state.rolesInitialized = action.payload;
    },
    createdRole: (state, action) => {
      state.rolesById[action.payload.name] = {
        ...state.rolesById[action.payload.name],
        ...action.payload
      };
    },
    removedRole: (state, action) => {
      const { [action.payload]: toBeRemoved, ...rolesById2 } = state.rolesById;
      state.rolesById = rolesById2;
    },
    setCustomColumns: (state, action) => {
      state.customColumns = action.payload;
    },
    setGlobalSettings: (state, action) => {
      state.settingsInitialized = true;
      state.globalSettings = {
        ...state.globalSettings,
        ...action.payload
      };
    },
    setUserSettings: (state, action) => {
      state.userSettingsInitialized = true;
      state.userSettings = {
        ...state.userSettings,
        ...action.payload
      };
    },
    setTooltipState: (state, action) => {
      const { id, readState = READ_STATES.read } = action.payload;
      state.tooltips.byId[id] = { ...state.tooltips.byId[id], readState };
    },
    setTooltipsState: (state, action) => {
      state.tooltips.byId = {
        ...state.tooltips.byId,
        ...action.payload
      };
    },
    setShowFeedbackDialog: (state, action) => {
      state.showFeedbackDialog = action.payload;
    },
    setShowConnectingDialog: (state, action) => {
      state.showConnectDeviceDialog = action.payload;
    },
    setShowStartupNotification: (state, action) => {
      state.showStartupNotification = action.payload;
    }
  }
});
var actions8 = usersSlice.actions;
var usersSlice_default = usersSlice.reducer;

// src/actions.ts
var actions_default = {
  ...actions2,
  ...actions,
  ...actions3,
  ...actions4,
  ...actions5,
  ...actions6,
  ...actions7,
  ...actions8
};

// src/api/general-api.ts
var import_axios = __toESM(require("axios"), 1);

// src/auth.ts
var import_universal_cookie = __toESM(require("universal-cookie"), 1);
var cookies = new import_universal_cookie.default();
var emptySession = Object.freeze({ token: "", expiresAt: void 0 });
var tokenCache = "";
var getSessionInfo = () => {
  let sessionInfo = { ...emptySession };
  try {
    sessionInfo = JSON.parse(window.localStorage.getItem("JWT") ?? "");
  } catch {
  }
  if (sessionInfo.expiresAt && new Date(sessionInfo.expiresAt) < /* @__PURE__ */ new Date()) {
    cleanUp();
    return { ...emptySession };
  }
  if (!sessionInfo.token) {
    const jwtTokenFromCookie = cookies.get("JWT", { doNotParse: true }) ?? "";
    if (jwtTokenFromCookie) {
      setSessionInfo({ token: jwtTokenFromCookie });
      sessionInfo.token = jwtTokenFromCookie;
      cookies.remove("JWT");
      cookies.remove("JWT", { path: "/" });
    }
  }
  sessionInfo.token = sessionInfo.token || "";
  tokenCache = sessionInfo.token;
  return sessionInfo;
};
var getToken = () => tokenCache ? tokenCache : getSessionInfo().token;
var setSessionInfo = ({ token, expiresAt }) => {
  tokenCache = token;
  window.localStorage.setItem("JWT", JSON.stringify({ token, expiresAt }));
};
var cleanUp = () => {
  tokenCache = "";
  cookies.remove("JWT");
  cookies.remove("JWT", { path: "/" });
  window.localStorage.removeItem("JWT");
  window.localStorage.removeItem("oauth");
};

// src/api/general-api.ts
var unauthorizedRedirect = (error) => {
  if (!(0, import_axios.isCancel)(error) && error.response?.status === 401 && getToken()) {
    cleanUp();
    window.location.replace("/ui/");
  }
  return Promise.reject(error);
};
var commonRequestConfig = { timeout: TIMEOUTS.refreshDefault, headers: { "Content-Type": "application/json" } };
var authenticatedRequest = import_axios.default.create(commonRequestConfig);
authenticatedRequest.interceptors.response.use((res) => res, unauthorizedRedirect);
authenticatedRequest.interceptors.request.use(
  (config) => ({ ...config, headers: { ...config.headers, Authorization: `Bearer ${getToken()}` } }),
  (error) => Promise.reject(error)
);
var Api = {
  get: authenticatedRequest.get,
  delete: (url, data) => authenticatedRequest.request({ method: "delete", url, data }),
  patch: authenticatedRequest.patch,
  post: authenticatedRequest.post,
  postUnauthorized: (url, data, config = {}) => import_axios.default.post(url, data, { ...commonRequestConfig, ...config }),
  put: authenticatedRequest.put,
  upload: (url, formData, progress2, cancelSignal) => authenticatedRequest.post(url, formData, {
    headers: { "Content-Type": "multipart/form-data" },
    onUploadProgress: progress2,
    timeout: 0,
    signal: cancelSignal
  }),
  uploadPut: (url, formData, progress2, cancelSignal) => authenticatedRequest.put(url, formData, {
    headers: { "Content-Type": "multipart/form-data" },
    onUploadProgress: progress2,
    timeout: 0,
    signal: cancelSignal
  })
};
var general_api_default = Api;

// src/appSlice/selectors.ts
var import_helpers2 = require("@northern.tech/utils/helpers");
var import_toolkit9 = require("@reduxjs/toolkit");
var getFeatures = (state) => state.app.features;
var getFullVersionInformation = (state) => state.app.versionInformation;
var getSearchState = (state) => state.app.searchState;
var getUploads = (state) => state.app.uploadsById;
var getIsUploading = (0, import_toolkit9.createSelector)([getUploads], (uploadsById) => !!Object.keys(uploadsById).length);
var getSearchedDevices = (0, import_toolkit9.createSelector)([getSearchState], ({ deviceIds }) => deviceIds);
var getVersionInformation = (0, import_toolkit9.createSelector)(
  [getFullVersionInformation, getFeatures],
  ({ Integration: Integration2, ...remainder }, { isHosted }) => isHosted && Integration2 !== "next" ? remainder : { ...remainder, Integration: Integration2 }
);
var getIsPreview = (0, import_toolkit9.createSelector)([getFullVersionInformation], ({ Integration: Integration2 }) => (0, import_helpers2.versionCompare)(Integration2, "next") > -1);

// src/commonSelectors.ts
var import_helpers5 = require("@northern.tech/utils/helpers");
var import_toolkit15 = require("@reduxjs/toolkit");

// src/deploymentsSlice/selectors.ts
var import_toolkit10 = require("@reduxjs/toolkit");
var getDeploymentsById = (state) => state.deployments.byId;
var getDeploymentsByStatus = (state) => state.deployments.byStatus;
var getSelectedDeploymentDeviceIds = (state) => state.deployments.selectedDeviceIds;
var getDeploymentsSelectionState = (state) => state.deployments.selectionState;
var getMappedDeploymentSelection = (0, import_toolkit10.createSelector)(
  [getDeploymentsSelectionState, (_, deploymentsState) => deploymentsState, getDeploymentsById],
  (selectionState, deploymentsState, deploymentsById) => {
    const { selection = [] } = selectionState[deploymentsState] ?? {};
    return selection.reduce((accu, id) => {
      if (deploymentsById[id]) {
        accu.push(deploymentsById[id]);
      }
      return accu;
    }, []);
  }
);
var relevantDeploymentStates = [DEPLOYMENT_STATES.pending, DEPLOYMENT_STATES.inprogress, DEPLOYMENT_STATES.finished];
var DEPLOYMENT_CUTOFF = 3;
var getRecentDeployments = (0, import_toolkit10.createSelector)(
  [getDeploymentsById, getDeploymentsByStatus],
  (deploymentsById, deploymentsByStatus) => Object.entries(deploymentsByStatus).reduce(
    (accu, [state, byStatus]) => {
      if (!relevantDeploymentStates.includes(state) || !byStatus.deploymentIds.length) {
        return accu;
      }
      accu[state] = byStatus.deploymentIds.reduce((accu2, id) => {
        if (deploymentsById[id]) {
          accu2.push(deploymentsById[id]);
        }
        return accu2;
      }, []).slice(0, DEPLOYMENT_CUTOFF);
      accu.total += byStatus.total;
      return accu;
    },
    { total: 0 }
  )
);

// src/devicesSlice/selectors.ts
var import_helpers3 = require("@northern.tech/utils/helpers");
var import_toolkit11 = require("@reduxjs/toolkit");
var getAcceptedDevices = (state) => state.devices.byStatus.accepted;
var getDevicesByStatus = (state) => state.devices.byStatus;
var getDevicesById = (state) => state.devices.byId;
var getDeviceReports = (state) => state.devices.reports;
var getGroupsById = (state) => state.devices.groups.byId;
var getSelectedGroup = (state) => state.devices.groups.selectedGroup;
var getDeviceListState = (state) => state.devices.deviceList;
var getListedDevices = (state) => state.devices.deviceList.deviceIds;
var getFilteringAttributes = (state) => state.devices.filteringAttributes;
var getDeviceFilters = (state) => state.devices.filters || [];
var getFilteringAttributesFromConfig = (state) => state.devices.filteringAttributesConfig.attributes;
var getSortedFilteringAttributes = (0, import_toolkit11.createSelector)([getFilteringAttributes], (filteringAttributes) => ({
  ...filteringAttributes,
  identityAttributes: [...filteringAttributes.identityAttributes, "id"]
}));
var getDeviceLimit = (state) => state.devices.limit;
var getFilteringAttributesLimit = (state) => state.devices.filteringAttributesLimit;
var getDeviceIdentityAttributes = (0, import_toolkit11.createSelector)(
  [getFilteringAttributes, getFilteringAttributesLimit],
  ({ identityAttributes }, filteringAttributesLimit) => {
    const attributes = identityAttributes.slice(0, filteringAttributesLimit);
    return attributes.reduce(
      (accu, value) => {
        accu.push({ value, label: value, scope: "identity" });
        return accu;
      },
      [
        { value: "name", label: "Name", scope: "tags" },
        { value: "id", label: "Device ID", scope: "identity" }
      ]
    );
  }
);
var getDeviceCountsByStatus = (0, import_toolkit11.createSelector)(
  [getDevicesByStatus],
  (byStatus) => Object.values(import_constants5.DEVICE_STATES).reduce((accu, state) => {
    accu[state] = byStatus[state].total || 0;
    return accu;
  }, {})
);
var getDeviceById = (0, import_toolkit11.createSelector)([getDevicesById, (_, deviceId) => deviceId], (devicesById, deviceId = "") => devicesById[deviceId] ?? {});
var getSelectedGroupInfo = (0, import_toolkit11.createSelector)(
  [getAcceptedDevices, getGroupsById, getSelectedGroup],
  ({ total: acceptedDeviceTotal }, groupsById, selectedGroup) => {
    let groupCount = acceptedDeviceTotal;
    let groupFilters = [];
    if (selectedGroup && groupsById[selectedGroup]) {
      groupCount = groupsById[selectedGroup].total || 0;
      groupFilters = groupsById[selectedGroup].filters || [];
    }
    return { groupCount, selectedGroup, groupFilters };
  }
);
var getLimitMaxed = (0, import_toolkit11.createSelector)(
  [getAcceptedDevices, getDeviceLimit],
  ({ total: acceptedDevices = 0 }, deviceLimit) => Boolean(deviceLimit && deviceLimit <= acceptedDevices)
);
var getGroupsByIdWithoutUngrouped = (0, import_toolkit11.createSelector)([getGroupsById], ({ [UNGROUPED_GROUP.id]: ungrouped, ...groups }) => groups);
var getGroupData = (0, import_toolkit11.createSelector)([getGroupsByIdWithoutUngrouped], (groups) => {
  const createdGroup = Object.keys(groups).length ? Object.keys(groups)[0] : void 0;
  const hasDynamicGroups = Object.values(groups).some((group) => !!group.id);
  return { createdGroup, hasDynamicGroups, groups };
});
var getGroups = (0, import_toolkit11.createSelector)([getGroupsById], (groupsById) => {
  const groupNames = Object.keys(groupsById).sort();
  const groupedGroups = Object.entries(groupsById).sort((a, b) => a[0].localeCompare(b[0])).reduce(
    (accu, [groupname, group]) => {
      const name = groupname === UNGROUPED_GROUP.id ? UNGROUPED_GROUP.name : groupname;
      const groupItem = { ...group, groupId: name, name: groupname };
      if ((group.filters ?? []).length > 0) {
        if (groupname !== UNGROUPED_GROUP.id) {
          accu.dynamic.push(groupItem);
        } else {
          accu.ungrouped.push(groupItem);
        }
      } else {
        accu.static.push(groupItem);
      }
      return accu;
    },
    { dynamic: [], static: [], ungrouped: [] }
  );
  return { groupNames, ...groupedGroups };
});
var getAttributesList = (0, import_toolkit11.createSelector)(
  [getFilteringAttributes, getFilteringAttributesFromConfig],
  ({ identityAttributes = [], inventoryAttributes = [] }, { identity = [], inventory = [] }) => [...identityAttributes, ...inventoryAttributes, ...identity, ...inventory].filter(import_helpers3.duplicateFilter)
);
var getDeviceTypes = (0, import_toolkit11.createSelector)(
  [getAcceptedDevices, getDevicesById],
  ({ deviceIds = [] }, devicesById) => Object.keys(
    deviceIds.slice(0, 200).reduce((accu, item) => {
      const { device_type: deviceTypes = [] } = devicesById[item] ? devicesById[item].attributes : {};
      accu = deviceTypes.reduce((deviceTypeAccu, deviceType) => {
        if (deviceType.length > 1) {
          deviceTypeAccu[deviceType] = deviceTypeAccu[deviceType] ? deviceTypeAccu[deviceType] + 1 : 1;
        }
        return deviceTypeAccu;
      }, accu);
      return accu;
    }, {})
  )
);

// src/monitorSlice/selectors.ts
var getIssueCountsByType = (state) => state.monitor.issueCounts.byType;

// src/onboardingSlice/selectors.ts
var getOnboarding = (state) => state.onboarding;

// src/organizationSlice/selectors.ts
var import_toolkit12 = require("@reduxjs/toolkit");
var import_dayjs = __toESM(require("dayjs"), 1);
var import_relativeTime = __toESM(require("dayjs/plugin/relativeTime.js"), 1);
var getOrganization = (state) => state.organization.organization;
var getExternalIntegrations = (state) => state.organization.externalDeviceIntegrations;
var getAuditLog = (state) => state.organization.auditlog.events;
var getAuditLogSelectionState = (state) => state.organization.auditlog.selectionState;
var getWebhookEvents = (state) => state.organization.webhooks.events;
var getWebhookEventTotal = (state) => state.organization.webhooks.eventsTotal;
var getDeviceTwinIntegrations = (0, import_toolkit12.createSelector)(
  [getExternalIntegrations],
  (integrations) => integrations.filter((integration) => integration.id && EXTERNAL_PROVIDER[integration.provider]?.deviceTwin)
);
var getIsServiceProvider = (state) => state.organization.organization.service_provider;
var getWebhooks = (0, import_toolkit12.createSelector)(
  [getExternalIntegrations],
  (integrations) => integrations.filter((integration) => integration.id && integration.provider === EXTERNAL_PROVIDER.webhook.provider)
);
var getWebhookEventInfo = (0, import_toolkit12.createSelector)(
  [getWebhooks, getWebhookEvents, getWebhookEventTotal],
  (webhooks, events, eventTotal) => webhooks.length ? { events, eventTotal } : { events: [], eventTotal: 0 }
);
var getAuditLogEntry = (0, import_toolkit12.createSelector)([getAuditLog, getAuditLogSelectionState], (events, { selectedId }) => {
  if (!selectedId) {
    return;
  }
  const [eventAction, eventTime] = atob(selectedId).split("|");
  return events.find((item) => item.action === eventAction && item.time === eventTime);
});
import_dayjs.default.extend(import_relativeTime.default);
var newPricingIntroduction = (0, import_dayjs.default)("2025-06-03T00:00");
var getHasCurrentPricing = (0, import_toolkit12.createSelector)(
  [getOrganization],
  ({ id }) => !!id && (0, import_dayjs.default)(parseInt(id.substring(0, 8), 16) * 1e3) >= newPricingIntroduction
);

// src/releasesSlice/selectors.ts
var import_toolkit13 = require("@reduxjs/toolkit");

// src/utils.ts
var import_helpers4 = require("@northern.tech/utils/helpers");
var filterProcessors = {
  [import_constants5.DEVICE_FILTERING_OPTIONS.$gt.key]: (val) => Number(val) || val,
  [import_constants5.DEVICE_FILTERING_OPTIONS.$gte.key]: (val) => Number(val) || val,
  [import_constants5.DEVICE_FILTERING_OPTIONS.$lt.key]: (val) => Number(val) || val,
  [import_constants5.DEVICE_FILTERING_OPTIONS.$lte.key]: (val) => Number(val) || val,
  [import_constants5.DEVICE_FILTERING_OPTIONS.$ltne.key]: (val) => Number(val) || val,
  [import_constants5.DEVICE_FILTERING_OPTIONS.$in.key]: (val) => ("" + val).split(",").map((i) => i.trim()),
  [import_constants5.DEVICE_FILTERING_OPTIONS.$nin.key]: (val) => ("" + val).split(",").map((i) => i.trim()),
  [import_constants5.DEVICE_FILTERING_OPTIONS.$exists.key]: import_helpers4.yes,
  [import_constants5.DEVICE_FILTERING_OPTIONS.$nexists.key]: () => false
};
var filterAliases = {
  $nexists: { alias: import_constants5.DEVICE_FILTERING_OPTIONS.$exists.key, value: false }
};
var mapFiltersToTerms = (filters) => filters.map((filter) => ({
  scope: filter.scope,
  attribute: filter.key,
  type: filterAliases[filter.operator]?.alias || filter.operator,
  value: filterProcessors.hasOwnProperty(filter.operator) ? filterProcessors[filter.operator](filter.value) : filter.value
}));
var mapTermsToFilters = (terms) => terms.map((term) => {
  const aliasedFilter = Object.entries(filterAliases).find(
    (aliasDefinition) => aliasDefinition[1].alias === term.type && aliasDefinition[1].value === term.value
  );
  const operator = aliasedFilter ? aliasedFilter[0] : term.type;
  return { scope: term.scope, key: term.attribute, operator, value: term.value };
});
var convertIssueOptionsToFilters = (issuesSelection, filtersState = {}) => issuesSelection.map((item) => {
  if (typeof import_constants5.DEVICE_ISSUE_OPTIONS[item].filterRule.value === "function") {
    return { ...import_constants5.DEVICE_ISSUE_OPTIONS[item].filterRule, value: import_constants5.DEVICE_ISSUE_OPTIONS[item].filterRule.value(filtersState) };
  }
  return import_constants5.DEVICE_ISSUE_OPTIONS[item].filterRule;
});
var convertDeviceListStateToFilters = ({
  filters = [],
  group,
  groups = { byId: {} },
  offlineThreshold,
  selectedIssues = [],
  status
}) => {
  let applicableFilters = [...filters];
  if (typeof group === "string" && !(groups.byId[group]?.filters || applicableFilters).length) {
    applicableFilters.push({ key: "group", value: group, operator: import_constants5.DEVICE_FILTERING_OPTIONS.$eq.key, scope: "system" });
  }
  const nonMonitorFilters = applicableFilters.filter(
    (filter) => !Object.values(import_constants5.DEVICE_ISSUE_OPTIONS).some(
      ({ filterRule }) => filter.scope !== "inventory" && filterRule.scope === filter.scope && filterRule.key === filter.key
    )
  );
  const deviceIssueFilters = convertIssueOptionsToFilters(selectedIssues, { offlineThreshold });
  applicableFilters = [...nonMonitorFilters, ...deviceIssueFilters];
  const effectiveFilters = status ? [...applicableFilters, { key: "status", value: status, operator: import_constants5.DEVICE_FILTERING_OPTIONS.$eq.key, scope: "identity" }] : applicableFilters;
  return { applicableFilters: nonMonitorFilters, filterTerms: mapFiltersToTerms(effectiveFilters) };
};
var filterCompare = (filter, item) => Object.keys(emptyFilter).every((key) => item[key]?.toString() === filter[key]?.toString());
var filtersFilter = (item, index, array) => {
  const firstIndex = array.findIndex((filter) => filterCompare(filter, item));
  return firstIndex === index;
};
var listItemMapper = (byId, ids, { cutOffSize = DEVICE_LIST_MAXIMUM_LENGTH, defaultObject = {} }) => ids.slice(0, cutOffSize).reduce((accu, id) => {
  if (id && byId[id]) {
    accu.push({ ...defaultObject, ...byId[id] });
  }
  return accu;
}, []);
var mergePermissions = (existingPermissions = { ...import_constants5.emptyUiPermissions }, addedPermissions) => Object.entries(existingPermissions).reduce(
  (accu, [key, value]) => {
    let values;
    if (!accu[key]) {
      accu[key] = value;
      return accu;
    }
    if (Array.isArray(value)) {
      values = [...value, ...accu[key]].filter(import_helpers4.duplicateFilter);
    } else {
      values = mergePermissions(accu[key], { ...value });
    }
    accu[key] = values;
    return accu;
  },
  { ...addedPermissions }
);
var mapUserRolesToUiPermissions = (userRoles, roles) => userRoles.reduce(
  (accu, roleId) => {
    if (!(roleId && roles[roleId])) {
      return accu;
    }
    return mergePermissions(accu, roles[roleId].uiPermissions);
  },
  { ...import_constants5.emptyUiPermissions }
);
var progress = ({ loaded, total }) => {
  let uploadProgress3 = loaded / total * 100;
  return uploadProgress3 = uploadProgress3 < 50 ? Math.ceil(uploadProgress3) : Math.round(uploadProgress3);
};
var extractErrorMessage = (err, fallback = "") => err.response?.data?.error?.message || err.response?.data?.error || err.error || err.message || fallback;
var getComparisonCompatibleVersion = (version) => isNaN(version.charAt(0)) && version !== "next" ? "master" : version;
var mapDeviceAttributes = (attributes = []) => attributes.reduce(
  (accu, attribute) => {
    if (!(attribute.value && attribute.name) && attribute.scope === import_constants5.ATTRIBUTE_SCOPES.inventory) {
      return accu;
    }
    accu[attribute.scope || import_constants5.ATTRIBUTE_SCOPES.inventory] = {
      ...accu[attribute.scope || import_constants5.ATTRIBUTE_SCOPES.inventory],
      [attribute.name]: attribute.value
    };
    if (attribute.name === "device_type" && attribute.scope === import_constants5.ATTRIBUTE_SCOPES.inventory) {
      accu.inventory.device_type = [].concat(attribute.value);
    }
    return accu;
  },
  { inventory: { device_type: [], artifact_name: "" }, identity: {}, monitor: {}, system: {}, tags: {} }
);
var isDarkMode = (mode) => mode === DARK_MODE;

// src/releasesSlice/selectors.ts
var getSelectedReleaseId = (state) => state.releases.selectedRelease;
var getReleasesById = (state) => state.releases.byId;
var getReleaseTags = (state) => state.releases.tags;
var getReleaseListState = (state) => state.releases.releasesList;
var getListedReleases = (state) => state.releases.releasesList.releaseIds;
var releaseDefaults = {};
var getReleaseMappingDefaults = () => releaseDefaults;
var getReleasesList = (0, import_toolkit13.createSelector)([getReleasesById, getListedReleases, getReleaseMappingDefaults], listItemMapper);
var getReleaseTagsById = (0, import_toolkit13.createSelector)([getReleaseTags], (releaseTags) => releaseTags.reduce((accu, key) => ({ ...accu, [key]: key }), {}));
var getHasReleases = (0, import_toolkit13.createSelector)(
  [getReleaseListState, getReleasesById],
  ({ searchTotal, total }, byId) => !!(Object.keys(byId).length || total || searchTotal)
);
var getSelectedRelease = (0, import_toolkit13.createSelector)([getReleasesById, getSelectedReleaseId], (byId, id) => byId[id || ""] ?? {});
var getSelectedReleases = (0, import_toolkit13.createSelector)([getReleaseListState, getReleasesList], ({ selection }, releases) => selection.map((index) => releases[index]));

// src/usersSlice/selectors.ts
var import_toolkit14 = require("@reduxjs/toolkit");
var emptyObject = {};
var getRolesById = (state) => state.users.rolesById;
var getTooltipsById = (state) => state.users.tooltips.byId;
var getGlobalSettings = (state) => state.users.globalSettings;
var getCurrentUserId = (state) => state.users.currentUser;
var getUsersById = (state) => state.users.byId;
var getUsersList = (0, import_toolkit14.createSelector)([getUsersById], (usersById) => Object.values(usersById));
var getCurrentUser = (0, import_toolkit14.createSelector)(
  [getUsersById, getCurrentUserId],
  (usersById, userId) => userId ? usersById[userId] ?? emptyObject : emptyObject
);
var getUserSettings = (state) => state.users.userSettings;
var getSelectedDeviceAttribute = (0, import_toolkit14.createSelector)(
  [getUserSettings],
  ({ columnSelection }) => columnSelection.map((attribute) => ({ attribute: attribute.key, scope: attribute.scope }))
);
var getIsDarkMode = (0, import_toolkit14.createSelector)([getUserSettings], ({ mode }) => isDarkMode(mode));
var getReadAllHelptips = (0, import_toolkit14.createSelector)(
  [getTooltipsById],
  (tooltips) => Object.values(tooltips).every(({ readState }) => readState === READ_STATES.read)
);
var getTooltipsState = (0, import_toolkit14.createSelector)(
  [getTooltipsById, getUserSettings],
  (byId, { tooltips = {} }) => Object.entries(byId).reduce(
    (accu, [id, value]) => {
      accu[id] = { ...accu[id], ...value };
      return accu;
    },
    { ...tooltips }
  )
);
var getHas2FA = (0, import_toolkit14.createSelector)(
  [getCurrentUser],
  (currentUser) => currentUser.hasOwnProperty("tfa_status") && currentUser.tfa_status === import_constants5.twoFAStates.enabled
);
var getIdAttribute = (0, import_toolkit14.createSelector)([getGlobalSettings], ({ id_attribute = { ...defaultIdAttribute } }) => id_attribute);
var getOfflineThresholdSettings = (0, import_toolkit14.createSelector)([getGlobalSettings], ({ offlineThreshold }) => ({
  interval: offlineThreshold?.interval || DEVICE_ONLINE_CUTOFF.interval,
  intervalUnit: offlineThreshold?.intervalUnit || DEVICE_ONLINE_CUTOFF.intervalName
}));
var getRolesList = (0, import_toolkit14.createSelector)([getRolesById], (rolesById2) => Object.entries(rolesById2).map(([value, role]) => ({ value, ...role })));

// src/commonSelectors.ts
var getIsEnterprise = (0, import_toolkit15.createSelector)(
  [getOrganization, getFeatures],
  ({ plan = PLANS.os.id }, { isEnterprise, isHosted }) => isEnterprise || isHosted && plan === PLANS.enterprise.id
);
var getAttrsEndpoint = (0, import_toolkit15.createSelector)(
  [getFeatures],
  ({ hasReporting }) => hasReporting ? `${import_constants5.reportingApiUrl}/devices/search/attributes` : `${import_constants5.inventoryApiUrlV2}/filters/attributes`
);
var getSearchEndpoint = (0, import_toolkit15.createSelector)(
  [getFeatures],
  ({ hasReporting }) => hasReporting ? `${import_constants5.reportingApiUrl}/devices/search` : `${import_constants5.inventoryApiUrlV2}/filters/search`
);
var getUserRoles = (0, import_toolkit15.createSelector)([getCurrentUser, getRolesById, getIsEnterprise], (currentUser, rolesById2, isEnterprise) => {
  const isAdmin = currentUser.roles?.length ? currentUser.roles.some((role) => role === import_constants5.rolesByName.admin) : !isEnterprise;
  const uiPermissions = isAdmin ? mapUserRolesToUiPermissions([import_constants5.rolesByName.admin], rolesById2) : mapUserRolesToUiPermissions(currentUser.roles || [], rolesById2);
  return { isAdmin, uiPermissions };
});
var hasPermission = (thing, permission) => Object.values(thing).some((permissions) => permissions.includes(permission));
var getUserCapabilities = (0, import_toolkit15.createSelector)([getUserRoles, getIsServiceProvider], ({ uiPermissions }, isServiceProvider) => {
  const canManageReleases = hasPermission(uiPermissions.releases, import_constants5.uiPermissionsById.manage.value);
  const canReadReleases = canManageReleases || hasPermission(uiPermissions.releases, import_constants5.uiPermissionsById.read.value);
  const canUploadReleases = canManageReleases || hasPermission(uiPermissions.releases, import_constants5.uiPermissionsById.upload.value);
  const canAuditlog = uiPermissions.auditlog.includes(import_constants5.uiPermissionsById.read.value);
  const canReadUsers = uiPermissions.userManagement.includes(import_constants5.uiPermissionsById.read.value);
  const canManageUsers = uiPermissions.userManagement.includes(import_constants5.uiPermissionsById.manage.value);
  const canReadDevices = hasPermission(uiPermissions.groups, import_constants5.uiPermissionsById.read.value);
  const canWriteDevices = Object.values(uiPermissions.groups).some(
    (groupPermissions) => groupPermissions.includes(import_constants5.uiPermissionsById.read.value) && groupPermissions.length > 1
  );
  const canTroubleshoot = hasPermission(uiPermissions.groups, import_constants5.uiPermissionsById.connect.value);
  const canManageDevices = hasPermission(uiPermissions.groups, import_constants5.uiPermissionsById.manage.value);
  const canConfigure = hasPermission(uiPermissions.groups, import_constants5.uiPermissionsById.configure.value);
  const canDeploy = uiPermissions.deployments.includes(import_constants5.uiPermissionsById.deploy.value) || hasPermission(uiPermissions.groups, import_constants5.uiPermissionsById.deploy.value);
  const canReadDeployments = uiPermissions.deployments.includes(import_constants5.uiPermissionsById.read.value);
  return {
    canAuditlog,
    canConfigure,
    canDeploy,
    canManageDevices,
    canManageReleases,
    canManageUsers,
    canReadDeployments,
    canReadDevices,
    canReadReleases,
    canReadUsers,
    canTroubleshoot,
    canUploadReleases,
    canWriteDevices,
    groupsPermissions: uiPermissions.groups,
    releasesPermissions: uiPermissions.releases,
    SPTenant: isServiceProvider
  };
});
var getTenantCapabilities = (0, import_toolkit15.createSelector)(
  [getFeatures, getOrganization, getIsEnterprise],
  ({
    hasAuditlogs: isAuditlogEnabled,
    hasDeviceConfig: isDeviceConfigEnabled,
    hasDeviceConnect: isDeviceConnectEnabled,
    hasMonitor: isMonitorEnabled,
    isHosted
  }, { addons = [], plan = PLANS.os.id }, isEnterprise) => {
    const canDelta = isEnterprise || plan === PLANS.professional.id;
    const hasAuditlogs = isAuditlogEnabled && isEnterprise;
    const hasDeviceConfig = addons.some((addon) => addon.name === ADDONS.configure.id && addon.enabled) || isDeviceConfigEnabled && !isHosted;
    const hasDeviceConnect = addons.some((addon) => addon.name === ADDONS.troubleshoot.id && addon.enabled) || isDeviceConnectEnabled && !isHosted;
    const hasMonitor = isMonitorEnabled && addons.some((addon) => addon.name === ADDONS.monitor.id && addon.enabled);
    return {
      canDelta,
      canRetry: canDelta,
      canSchedule: canDelta,
      hasAuditlogs,
      hasDeviceConfig,
      hasDeviceConnect,
      hasFullFiltering: canDelta,
      hasMonitor,
      isEnterprise,
      plan
    };
  }
);
var getFilterAttributes = (0, import_toolkit15.createSelector)(
  [getGlobalSettings, getFilteringAttributes],
  ({ previousFilters }, { identityAttributes, inventoryAttributes, systemAttributes, tagAttributes }) => {
    const deviceNameAttribute = { key: "name", value: "Name", scope: import_constants5.ATTRIBUTE_SCOPES.tags, category: import_constants5.ATTRIBUTE_SCOPES.tags, priority: 1 };
    const deviceIdAttribute = { key: "id", value: "Device ID", scope: import_constants5.ATTRIBUTE_SCOPES.identity, category: import_constants5.ATTRIBUTE_SCOPES.identity, priority: 1 };
    const checkInAttribute = { key: "check_in_time", value: "Latest activity", scope: import_constants5.ATTRIBUTE_SCOPES.system, category: import_constants5.ATTRIBUTE_SCOPES.system, priority: 4 };
    const updateAttribute = { ...checkInAttribute, key: "updated_ts", value: "Last inventory update" };
    const firstRequestAttribute = { key: "created_ts", value: "First request", scope: import_constants5.ATTRIBUTE_SCOPES.system, category: import_constants5.ATTRIBUTE_SCOPES.system, priority: 4 };
    const attributes = [
      ...previousFilters.map((item) => ({
        ...item,
        value: deviceIdAttribute.key === item.key ? deviceIdAttribute.value : item.key,
        category: "recently used",
        priority: 0
      })),
      deviceNameAttribute,
      deviceIdAttribute,
      ...identityAttributes.map((item) => ({ key: item, value: item, scope: import_constants5.ATTRIBUTE_SCOPES.identity, category: import_constants5.ATTRIBUTE_SCOPES.identity, priority: 1 })),
      ...inventoryAttributes.map((item) => ({ key: item, value: item, scope: import_constants5.ATTRIBUTE_SCOPES.inventory, category: import_constants5.ATTRIBUTE_SCOPES.inventory, priority: 2 })),
      ...tagAttributes.map((item) => ({ key: item, value: item, scope: import_constants5.ATTRIBUTE_SCOPES.tags, category: import_constants5.ATTRIBUTE_SCOPES.tags, priority: 3 })),
      checkInAttribute,
      updateAttribute,
      firstRequestAttribute,
      ...systemAttributes.map((item) => ({ key: item, value: item, scope: import_constants5.ATTRIBUTE_SCOPES.system, category: import_constants5.ATTRIBUTE_SCOPES.system, priority: 4 }))
    ];
    return (0, import_helpers5.attributeDuplicateFilter)(attributes, "key");
  }
);
var getOnboardingState = (0, import_toolkit15.createSelector)([getOnboarding, getUserSettings], ({ complete, progress: progress2, showTips, ...remainder }, { onboarding = {} }) => ({
  ...remainder,
  ...onboarding,
  complete: onboarding.complete || complete,
  progress: Object.keys(onboardingSteps).findIndex((step) => step === progress2) > Object.keys(onboardingSteps).findIndex((step) => step === onboarding.progress) ? progress2 : onboarding.progress,
  showTips: !onboarding.showTips ? onboarding.showTips : showTips
}));
var getDemoDeviceAddress = (0, import_toolkit15.createSelector)([getDevicesById, getOnboarding], (devicesById, { approach, demoArtifactPort }) => {
  const demoDeviceAddress = `http://${(0, import_helpers5.getDemoDeviceAddress)(Object.values(devicesById), approach)}`;
  return demoArtifactPort ? `${demoDeviceAddress}:${demoArtifactPort}` : demoDeviceAddress;
});
var getDeviceConfigDeployment = (0, import_toolkit15.createSelector)([getDeviceById, getDeploymentsById], (device, deploymentsById) => {
  const { config = {} } = device;
  const { deployment_id: configDeploymentId } = config;
  const deviceConfigDeployment = deploymentsById[configDeploymentId] || {};
  return { device, deviceConfigDeployment };
});
var getDeploymentRelease = (0, import_toolkit15.createSelector)(
  [getDeploymentsById, getDeploymentsSelectionState, getReleasesById],
  (deploymentsById, { selectedId }, releasesById) => {
    const deployment = deploymentsById[selectedId] || {};
    return deployment.artifact_name && releasesById[deployment.artifact_name] ? releasesById[deployment.artifact_name] : { device_types_compatible: [] };
  }
);
var getSelectedDeploymentData = (0, import_toolkit15.createSelector)(
  [getDeploymentsById, getDeploymentsSelectionState, getDevicesById, getSelectedDeploymentDeviceIds],
  (deploymentsById, { selectedId }, devicesById, selectedDeviceIds) => {
    const deployment = deploymentsById[selectedId] ?? {};
    const { devices = {} } = deployment;
    return {
      deployment,
      selectedDevices: selectedDeviceIds.map((deviceId) => ({ ...devicesById[deviceId], ...devices[deviceId] }))
    };
  }
);
var getAvailableIssueOptionsByType = (0, import_toolkit15.createSelector)(
  [getFeatures, getTenantCapabilities, getIssueCountsByType],
  ({ hasReporting }, { hasFullFiltering, hasMonitor }, issueCounts) => Object.values(import_constants5.DEVICE_ISSUE_OPTIONS).reduce((accu, { isCategory, key, needsFullFiltering, needsMonitor, needsReporting, title }) => {
    if (isCategory || needsReporting && !hasReporting || needsFullFiltering && !hasFullFiltering || needsMonitor && !hasMonitor) {
      return accu;
    }
    accu[key] = { count: issueCounts[key].filtered, key, title };
    return accu;
  }, {})
);
var getGroupNames = (0, import_toolkit15.createSelector)([getGroupsById, getUserRoles], (groupsById, { uiPermissions }) => {
  const { [UNGROUPED_GROUP.id]: ungrouped, ...groups } = groupsById;
  return Object.keys(
    Object.entries(groups).reduce((accu, [groupName, group]) => {
      if (group.filterId || uiPermissions.groups[import_constants5.ALL_DEVICES]) {
        accu[groupName] = group;
      }
      return accu;
    }, uiPermissions.groups)
  ).sort();
});
var getDeviceReportsForUser = (0, import_toolkit15.createSelector)(
  [getUserSettings, getCurrentUser, getGlobalSettings, getDevicesById],
  ({ reports }, { id: currentUserId }, globalSettings, devicesById) => reports || globalSettings[`${currentUserId}-reports`] || (Object.keys(devicesById).length ? defaultReports : [])
);
var listTypeDeviceIdMap = {
  deviceList: getListedDevices,
  search: getSearchedDevices
};
var deviceMapDefault = { defaultObject: { auth_sets: [] }, cutOffSize: DEVICE_LIST_MAXIMUM_LENGTH };
var getDeviceMappingDefaults = () => deviceMapDefault;
var getMappedDevicesList = (0, import_toolkit15.createSelector)(
  [getDevicesById, (state, listType) => listTypeDeviceIdMap[listType](state), getDeviceMappingDefaults],
  listItemMapper
);
var getAuditlogDevice = (0, import_toolkit15.createSelector)([getAuditLogEntry, getDevicesById], (auditlogEvent, devicesById) => {
  let auditlogDevice = {};
  if (auditlogEvent) {
    const { object = {} } = auditlogEvent;
    const { device = {}, id, type } = object;
    auditlogDevice = type === "device" ? { id, ...device } : auditlogDevice;
  }
  return { ...auditlogDevice, ...devicesById[auditlogDevice.id] };
});
var getRelevantRoles = (0, import_toolkit15.createSelector)([getOrganization, getRolesList], ({ service_provider }, roles) => {
  if (service_provider) {
    return roles.reduce((accu, role) => {
      if (import_constants5.rolesById[role.value]) {
        return accu;
      }
      accu.push(role);
      return accu;
    }, Object.values(import_constants5.serviceProviderRolesById));
  }
  return Object.keys(import_constants5.rolesById).reverse().reduce((accu, key) => {
    const index = accu.findIndex(({ value }) => value === key);
    accu = [accu[index], ...accu.filter((item, itemIndex) => index !== itemIndex)];
    return accu;
  }, roles);
});

// src/store.ts
var import_react_redux = require("react-redux");
var import_helpers6 = require("@northern.tech/utils/helpers");
var import_toolkit16 = require("@reduxjs/toolkit");
var import_react = require("@sentry/react");
var { setSnackbar, uploadProgress } = actions_default;
var keys = ["sessionDeploymentChecker", settingsKeys.initialized];
var resetEnvironment = () => keys.forEach((key) => window.sessionStorage.removeItem(key));
resetEnvironment();
var commonErrorFallback = "Please check your connection.";
var commonErrorHandler = (err, errorContext, dispatch, fallback, mightBeAuthRelated = false) => {
  const errMsg = (0, import_helpers6.extractErrorMessage)(err, fallback);
  if (mightBeAuthRelated || getToken()) {
    dispatch(setSnackbar({ message: (0, import_helpers6.preformatWithRequestID)(err.response, `${errorContext} ${errMsg}`), action: "Copy to clipboard" }));
  }
  return Promise.reject(err);
};
var rootReducer = (0, import_toolkit16.combineReducers)({
  app: appSlice_default,
  devices: devicesSlice_default,
  deployments: deploymentsSlice_default,
  monitor: monitorSlice_default,
  onboarding: onboardingSlice_default,
  organization: organizationSlice_default,
  releases: releasesSlice_default,
  users: usersSlice_default
});
var sessionReducer = (state, action) => {
  if (action.type === USER_LOGOUT) {
    state = void 0;
  }
  return rootReducer(state, action);
};
var rejectionLoggerMiddleware = () => (next) => (action) => {
  if (action.type.endsWith("/rejected")) {
    const { error } = action;
    console.error("Rejection in action:", action);
    console.error(error.stack);
  }
  return next(action);
};
var tracingActionIgnoreList = [actions8.successfullyLoggedIn.type, "users/loginUser/pending", "users/loginUser/fulfilled", "users/loginUser/rejected"];
var sentryReduxEnhancer = (0, import_react.createReduxEnhancer)({
  actionTransformer: (action) => {
    if (tracingActionIgnoreList.includes(action.type)) {
      return null;
    }
    return action;
  },
  // Transform the state to remove sensitive information
  stateTransformer: (state) => {
    const transformedState = {
      ...state,
      users: { ...state.users, currentSession: null },
      organization: {
        ...state.organization,
        organization: {
          ...state.organization.organization,
          tenant_token: null
        }
      }
    };
    return transformedState;
  }
});
var getConfiguredStore = (options = {}) => {
  const { preloadedState = {}, ...config } = options;
  return (0, import_toolkit16.configureStore)({
    ...config,
    preloadedState,
    enhancers: (getDefaultEnhancers) => {
      if (window.mender_environment?.sentry?.isReduxEnabled) {
        return getDefaultEnhancers().concat(sentryReduxEnhancer);
      }
      return getDefaultEnhancers();
    },
    reducer: sessionReducer,
    middleware: (getDefaultMiddleware) => getDefaultMiddleware({
      immutableCheck: {
        ignoredPaths: ["app.uploadsById"]
      },
      serializableCheck: {
        ignoredActions: [actions6.receiveExternalDeviceIntegrations.name, uploadProgress.name],
        ignoredActionPaths: ["uploads", /payload\..*$/, "meta.arg.file", "meta.arg.integration.configHint"],
        ignoredPaths: ["app.uploadsById", "organization.externalDeviceIntegrations"]
      }
    }).concat(rejectionLoggerMiddleware)
  });
};
var store = getConfiguredStore({
  preloadedState: {}
});
var createAppAsyncThunk = import_toolkit16.createAsyncThunk.withTypes();

// src/appSlice/thunks.ts
var import_helpers7 = require("@northern.tech/utils/helpers");
var import_universal_cookie2 = __toESM(require("universal-cookie"), 1);
var cookies2 = new import_universal_cookie2.default();
var setFirstLoginAfterSignup = createAppAsyncThunk(`${sliceName2}/setFirstLoginAfterSignup`, (firstLoginAfterSignup, { dispatch }) => {
  cookies2.set("firstLoginAfterSignup", !!firstLoginAfterSignup, { maxAge: 60, path: "/", domain: ".mender.io", sameSite: false });
  dispatch(actions2.setFirstLoginAfterSignup(!!firstLoginAfterSignup));
});
var dateFunctionMap = {
  getDays: "getDate",
  setDays: "setDate"
};
var setOfflineThreshold = createAppAsyncThunk(`${sliceName2}/setOfflineThreshold`, (_, { dispatch, getState }) => {
  const { interval, intervalUnit } = getOfflineThresholdSettings(getState());
  const today = /* @__PURE__ */ new Date();
  const intervalName = `${intervalUnit.charAt(0).toUpperCase()}${intervalUnit.substring(1)}`;
  const setter = dateFunctionMap[`set${intervalName}`] ?? `set${intervalName}`;
  const getter = dateFunctionMap[`get${intervalName}`] ?? `get${intervalName}`;
  today[setter](today[getter]() - interval);
  let value;
  try {
    value = today.toISOString();
  } catch {
    return Promise.resolve(dispatch(actions2.setSnackbar("There was an error saving the offline threshold, please check your settings.")));
  }
  return Promise.resolve(dispatch(actions2.setOfflineThreshold(value)));
});
var versionRegex = new RegExp(/\d+\.\d+/);
var getLatestRelease = (thing) => {
  const latestKey = Object.keys(thing).filter((key) => versionRegex.test(key)).sort().reverse()[0];
  return thing[latestKey];
};
var repoKeyMap = {
  integration: "Integration",
  mender: "Mender-Client",
  "mender-artifact": "Mender-Artifact"
};
var deductSaasState = (latestRelease, guiTags) => {
  const latestGuiTag = guiTags.length ? guiTags[0].name : "";
  return latestGuiTag ? latestGuiTag : latestRelease.release;
};
var getLatestReleaseInfo = createAppAsyncThunk(`${sliceName2}/getLatestReleaseInfo`, (_, { dispatch, getState }) => {
  if (!getFeatures(getState()).isHosted) {
    return Promise.resolve();
  }
  return Promise.all([general_api_default.get("/versions.json"), general_api_default.get("/tags.json")]).catch((err) => {
    console.log("init error:", (0, import_helpers7.extractErrorMessage)(err));
    return Promise.resolve([{ data: {} }, { data: [] }]);
  }).then(([{ data }, { data: guiTags }]) => {
    if (!guiTags.length) {
      return Promise.resolve();
    }
    const { releases } = data;
    const latestRelease = getLatestRelease(getLatestRelease(releases));
    const { latestRepos, latestVersions } = latestRelease.repos.reduce(
      (accu, item) => {
        if (repoKeyMap[item.name]) {
          accu.latestVersions[repoKeyMap[item.name]] = getComparisonCompatibleVersion(item.version);
        }
        accu.latestRepos[item.name] = getComparisonCompatibleVersion(item.version);
        return accu;
      },
      { latestVersions: { ...getState().app.versionInformation }, latestRepos: {} }
    );
    const info = deductSaasState(latestRelease, guiTags);
    return Promise.resolve(
      dispatch(
        actions2.setVersionInformation({
          ...latestVersions,
          Server: info,
          latestRelease: {
            releaseDate: latestRelease.release_date,
            repos: latestRepos
          }
        })
      )
    );
  });
});
var setSearchState = createAppAsyncThunk(`${sliceName2}/setSearchState`, (searchState, { dispatch, getState }) => {
  const currentState = getSearchState(getState());
  const nextState = {
    ...currentState,
    ...searchState,
    sort: {
      ...currentState.sort,
      ...searchState.sort
    }
  };
  const tasks = [];
  const { isSearching: currentSearching, deviceIds: currentDevices, searchTotal: currentTotal, ...currentRequestState } = currentState;
  const { isSearching: nextSearching, deviceIds: nextDevices, searchTotal: nextTotal, ...nextRequestState } = nextState;
  if (nextRequestState.searchTerm && !(0, import_helpers7.deepCompare)(currentRequestState, nextRequestState)) {
    nextState.isSearching = true;
    tasks.push(
      dispatch(searchDevices(nextState)).unwrap().then((results) => {
        const searchResult = results[results.length - 1];
        return dispatch(actions2.setSearchState({ ...searchResult, isSearching: false }));
      }).catch(() => dispatch(actions2.setSearchState({ isSearching: false, searchTotal: 0 })))
    );
  }
  tasks.push(dispatch(actions2.setSearchState(nextState)));
  return Promise.all(tasks);
});

// src/devicesSlice/thunks.tsx
var import_react_router_dom = require("react-router-dom");
var import_helpers8 = require("@northern.tech/utils/helpers");
var import_axios2 = require("axios");
var import_pluralize = __toESM(require("pluralize"), 1);
var import_uuid = require("uuid");
var import_jsx_runtime2 = require("react/jsx-runtime");
var { cleanUpUpload, initUpload, setSnackbar: setSnackbar2, uploadProgress: uploadProgress2 } = actions_default;
var { page: defaultPage, perPage: defaultPerPage } = import_constants5.DEVICE_LIST_DEFAULTS;
var defaultAttributes = [
  { scope: "identity", attribute: "status" },
  { scope: "inventory", attribute: "artifact_name" },
  { scope: "inventory", attribute: "device_type" },
  { scope: "inventory", attribute: "mender_is_gateway" },
  { scope: "inventory", attribute: "mender_gateway_system_id" },
  { scope: "inventory", attribute: rootfsImageVersion },
  { scope: "monitor", attribute: "alerts" },
  { scope: "system", attribute: "created_ts" },
  { scope: "system", attribute: "updated_ts" },
  { scope: "system", attribute: "check_in_time" },
  { scope: "system", attribute: "group" },
  { scope: "tags", attribute: "name" }
];
var getGroups2 = createAppAsyncThunk(
  `${sliceName3}/getGroups`,
  (_, { dispatch, getState }) => general_api_default.get(`${import_constants5.inventoryApiUrl}/groups`).then((res) => {
    const state = getGroupsById(getState());
    const dynamicGroups = Object.entries(state).reduce((accu, [id, group]) => {
      if (group.id || group.filters?.length && id !== UNGROUPED_GROUP.id) {
        accu[id] = group;
      }
      return accu;
    }, {});
    const groups = res.data.reduce((accu, group) => {
      accu[group] = { deviceIds: [], filters: [], total: 0, ...state[group] };
      return accu;
    }, dynamicGroups);
    const filters = [{ key: "group", value: res.data, operator: import_constants5.DEVICE_FILTERING_OPTIONS.$nin.key, scope: "system" }];
    return Promise.all([
      dispatch(actions3.receivedGroups(groups)),
      dispatch(getDevicesByStatus2({ filterSelection: filters, group: "", page: 1, perPage: 1, status: void 0 }))
    ]).then((promises) => {
      const devicesRetrieval = promises[promises.length - 1] || [];
      const { payload } = devicesRetrieval || {};
      const result = payload[payload.length - 1] || {};
      if (!result.total) {
        return Promise.resolve();
      }
      return Promise.resolve(
        dispatch(
          actions3.addGroup({
            groupName: UNGROUPED_GROUP.id,
            group: { filters: [{ key: "group", value: res.data, operator: import_constants5.DEVICE_FILTERING_OPTIONS.$nin.key, scope: "system" }] }
          })
        )
      );
    });
  })
);
var addDevicesToGroup = createAppAsyncThunk(
  `${sliceName3}/addDevicesToGroup`,
  ({ group, deviceIds, isCreation }, { dispatch }) => general_api_default.patch(`${import_constants5.inventoryApiUrl}/groups/${group}/devices`, deviceIds).then(() => dispatch(actions3.addToGroup({ group, deviceIds }))).finally(() => isCreation ? Promise.resolve(dispatch(getGroups2())) : {})
);
var removeDevicesFromGroup = createAppAsyncThunk(
  `${sliceName3}/removeDevicesFromGroup`,
  ({ group, deviceIds }, { dispatch }) => general_api_default.delete(`${import_constants5.inventoryApiUrl}/groups/${group}/devices`, deviceIds).then(
    () => Promise.all([
      dispatch(actions3.removeFromGroup({ group, deviceIds })),
      dispatch(
        setSnackbar2({
          message: `The ${(0, import_pluralize.default)("devices", deviceIds.length)} ${(0, import_pluralize.default)("were", deviceIds.length)} removed from the group`,
          autoHideDuration: TIMEOUTS.fiveSeconds
        })
      )
    ])
  )
);
var getGroupNotification = (newGroup, selectedGroup) => {
  const successMessage = "The group was updated successfully";
  if (newGroup === selectedGroup) {
    return { message: successMessage, autoHideDuration: TIMEOUTS.fiveSeconds };
  }
  return {
    action: "",
    autoHideDuration: TIMEOUTS.fiveSeconds,
    message: /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_jsx_runtime2.Fragment, { children: [
      successMessage,
      " - ",
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_react_router_dom.Link, { to: `/devices?inventory=group:eq:${newGroup}`, children: "click here" }),
      " to see it."
    ] }),
    preventClickToCopy: true
  };
};
var addStaticGroup = createAppAsyncThunk(
  `${sliceName3}/addStaticGroup`,
  ({ group, devices }, { dispatch, getState }) => Promise.resolve(dispatch(addDevicesToGroup({ group, deviceIds: devices.map(({ id }) => id), isCreation: true }))).then(
    () => Promise.resolve(
      dispatch(
        actions3.addGroup({
          group: { deviceIds: [], total: 0, filters: [], ...getState().devices.groups.byId[group] },
          groupName: group
        })
      )
    ).then(
      () => Promise.all([
        dispatch(setDeviceListState({ setOnly: true })),
        dispatch(getGroups2()),
        dispatch(setSnackbar2(getGroupNotification(group, getState().devices.groups.selectedGroup)))
      ])
    )
  ).catch((err) => commonErrorHandler(err, `Group could not be updated:`, dispatch))
);
var removeStaticGroup = createAppAsyncThunk(
  `${sliceName3}/removeStaticGroup`,
  (groupName, { dispatch }) => general_api_default.delete(`${import_constants5.inventoryApiUrl}/groups/${groupName}`).then(
    () => Promise.all([
      dispatch(actions3.removeGroup(groupName)),
      dispatch(getGroups2()),
      dispatch(setSnackbar2({ message: "Group was removed successfully", autoHideDuration: TIMEOUTS.fiveSeconds }))
    ])
  )
);
var getDynamicGroups = createAppAsyncThunk(
  `${sliceName3}/getDynamicGroups`,
  (_, { dispatch, getState }) => general_api_default.get(`${import_constants5.inventoryApiUrlV2}/filters?per_page=${MAX_PAGE_SIZE}`).then(({ data: filters }) => {
    const state = getGroupsById(getState());
    const staticGroups = Object.entries(state).reduce((accu, [id, group]) => {
      if (!(group.id || group.filters?.length)) {
        accu[id] = group;
      }
      return accu;
    }, {});
    const groups = (filters || []).reduce((accu, filter) => {
      accu[filter.name] = {
        deviceIds: [],
        total: 0,
        ...state[filter.name],
        id: filter.id,
        filters: mapTermsToFilters(filter.terms)
      };
      return accu;
    }, staticGroups);
    return Promise.resolve(dispatch(actions3.receivedGroups(groups)));
  }).catch(() => console.log("Dynamic group retrieval failed - likely accessing a non-enterprise backend"))
);
var addDynamicGroup = createAppAsyncThunk(
  `${sliceName3}/addDynamicGroup`,
  ({ groupName, filterPredicates }, { dispatch, getState }) => general_api_default.post(`${import_constants5.inventoryApiUrlV2}/filters`, { name: groupName, terms: mapFiltersToTerms(filterPredicates) }).then(
    (res) => Promise.resolve(
      dispatch(
        actions3.addGroup({
          groupName,
          group: {
            id: res.headers[import_constants5.headerNames.location].substring(res.headers[import_constants5.headerNames.location].lastIndexOf("/") + 1),
            filters: filterPredicates
          }
        })
      )
    ).then(() => {
      const { cleanedFilters } = getGroupFilters(groupName, getState().devices.groups);
      return Promise.all([
        dispatch(actions3.setDeviceFilters(cleanedFilters)),
        dispatch(setSnackbar2(getGroupNotification(groupName, getState().devices.groups.selectedGroup))),
        dispatch(getDynamicGroups())
      ]);
    })
  ).catch((err) => commonErrorHandler(err, `Group could not be updated:`, dispatch))
);
var updateDynamicGroup = createAppAsyncThunk(
  `${sliceName3}/updateDynamicGroup`,
  ({ groupName, filterPredicates }, { dispatch, getState }) => {
    const filterId = getState().devices.groups.byId[groupName].id;
    return general_api_default.delete(`${import_constants5.inventoryApiUrlV2}/filters/${filterId}`).then(
      () => Promise.resolve(dispatch(addDynamicGroup({ groupName, filterPredicates })))
    );
  }
);
var removeDynamicGroup = createAppAsyncThunk(`${sliceName3}/removeDynamicGroup`, (groupName, { dispatch, getState }) => {
  const filterId = getState().devices.groups.byId[groupName].id;
  return general_api_default.delete(`${import_constants5.inventoryApiUrlV2}/filters/${filterId}`).then(
    () => Promise.all([
      dispatch(actions3.removeGroup(groupName)),
      dispatch(setSnackbar2({ message: "Group was removed successfully", autoHideDuration: TIMEOUTS.fiveSeconds }))
    ])
  );
});
var getGroupFilters = (group, groupsState, filters = []) => {
  const groupName = group === UNGROUPED_GROUP.id || group === UNGROUPED_GROUP.name ? UNGROUPED_GROUP.id : group;
  const selectedGroup = groupsState.byId[groupName];
  const groupFilterLength = selectedGroup?.filters?.length || 0;
  const cleanedFilters = groupFilterLength ? [...filters, ...selectedGroup.filters || []].filter(filtersFilter) : filters;
  return { cleanedFilters, groupName, selectedGroup, groupFilterLength };
};
var selectGroup = createAppAsyncThunk(
  `${sliceName3}/selectGroup`,
  ({ group, filters = [] }, { dispatch, getState }) => {
    const { cleanedFilters, groupName, selectedGroup, groupFilterLength } = getGroupFilters(group, getState().devices.groups, filters);
    if (getSelectedGroup(getState()) === groupName && (filters.length === 0 && !groupFilterLength || filters.length === cleanedFilters.length)) {
      return Promise.resolve();
    }
    const tasks = [];
    if (groupFilterLength) {
      tasks.push(dispatch(actions3.setDeviceFilters(cleanedFilters)));
    } else {
      tasks.push(dispatch(actions3.setDeviceFilters(filters)));
      tasks.push(dispatch(getGroupDevices({ group: groupName, perPage: 1, shouldIncludeAllStates: true })));
    }
    const selectedGroupName = selectedGroup || !Object.keys(getGroupsById(getState())).length ? groupName : void 0;
    tasks.push(dispatch(actions3.selectGroup(selectedGroupName)));
    return Promise.all(tasks);
  }
);
var getEarliestTs = (dateA = "", dateB = "") => !dateA || !dateB ? dateA || dateB : dateA < dateB ? dateA : dateB;
var reduceReceivedDevices = (devices, ids, state, status) => devices.reduce(
  (accu, device) => {
    const stateDevice = getDeviceById(state, device.id);
    const {
      attributes: storedAttributes = {},
      identity_data: storedIdentity = {},
      monitor: storedMonitor = {},
      tags: storedTags = {},
      group: storedGroup
    } = stateDevice;
    const { identity, inventory, monitor, system = {}, tags } = mapDeviceAttributes(device.attributes);
    device.tags = { ...storedTags, ...tags };
    device.group = system.group ?? storedGroup;
    device.monitor = { ...storedMonitor, ...monitor };
    device.identity_data = { ...storedIdentity, ...identity, ...device.identity_data ? device.identity_data : {} };
    device.status = status ? status : device.status || identity.status;
    device.check_in_time_rounded = system.check_in_time ?? stateDevice.check_in_time_rounded;
    device.check_in_time_exact = device.check_in_time ?? stateDevice.check_in_time_exact;
    device.created_ts = getEarliestTs(getEarliestTs(system.created_ts, device.created_ts), stateDevice.created_ts);
    device.updated_ts = device.attributes ? device.updated_ts : stateDevice.updated_ts;
    device.isNew = new Date(device.created_ts) > new Date(state.app.newThreshold);
    device.isOffline = new Date(device.check_in_time_rounded) < new Date(state.app.offlineThreshold) || device.check_in_time_rounded === void 0;
    device.attributes = device.attributes ? { ...storedAttributes, ...inventory } : storedAttributes;
    accu.devicesById[device.id] = { ...stateDevice, ...device };
    accu.ids.push(device.id);
    return accu;
  },
  { ids, devicesById: {} }
);
var getGroupDevices = createAppAsyncThunk(`${sliceName3}/getGroupDevices`, (options, { dispatch, getState }) => {
  const { group, shouldIncludeAllStates, ...remainder } = options;
  const { cleanedFilters: filterSelection } = getGroupFilters(group, getState().devices.groups);
  return dispatch(
    getDevicesByStatus2({
      ...remainder,
      filterSelection,
      group,
      status: shouldIncludeAllStates ? void 0 : import_constants5.DEVICE_STATES.accepted
    })
  ).unwrap().then((results) => {
    if (!group) {
      return Promise.resolve();
    }
    const { deviceAccu, total } = results[results.length - 1];
    const stateGroup = getState().devices.groups.byId[group];
    if (!stateGroup && !total && !deviceAccu.ids.length) {
      return Promise.resolve();
    }
    return Promise.resolve(
      dispatch(
        actions3.addGroup({
          group: {
            deviceIds: deviceAccu.ids.length === total || stateGroup && stateGroup.deviceIds && deviceAccu.ids.length > stateGroup.deviceIds ? deviceAccu.ids : stateGroup.deviceIds,
            total
          },
          groupName: group
        })
      )
    );
  });
});
var getAllGroupDevices = createAppAsyncThunk(
  `${sliceName3}/getAllGroupDevices`,
  ({ group, attribute }, { dispatch, getState }) => {
    if (!group || !!group && (!getGroupsById(getState())[group] || getGroupsById(getState())[group].filters.length)) {
      return Promise.resolve();
    }
    const { attributes, filterTerms } = prepareSearchArguments({
      filters: [],
      group,
      state: getState(),
      status: import_constants5.DEVICE_STATES.accepted
    });
    const getAllDevices = (perPage = MAX_PAGE_SIZE, page = defaultPage, devices = []) => general_api_default.post(getSearchEndpoint(getState()), {
      page,
      per_page: perPage,
      filters: filterTerms,
      attributes: [...attributes, { scope: "inventory", attribute }]
    }).then((res) => {
      const state = getState();
      const deviceAccu = reduceReceivedDevices(res.data, devices, state);
      dispatch(actions3.receivedDevices(deviceAccu.devicesById));
      const total = Number(res.headers[import_constants5.headerNames.total]);
      if (total > perPage * page) {
        return getAllDevices(perPage, page + 1, deviceAccu.ids);
      }
      return Promise.resolve(dispatch(actions3.addGroup({ group: { deviceIds: deviceAccu.ids, total: deviceAccu.ids.length }, groupName: group })));
    });
    return getAllDevices();
  }
);
var getAllDynamicGroupDevices = createAppAsyncThunk(
  `${sliceName3}/getAllDynamicGroupDevices`,
  ({ group, attribute }, { dispatch, getState }) => {
    if (!!group && (!getGroupsById(getState())[group] || !getGroupsById(getState())[group].filters.length)) {
      return Promise.resolve();
    }
    const { attributes, filterTerms: filters } = prepareSearchArguments({
      filters: getState().devices.groups.byId[group].filters,
      state: getState(),
      status: import_constants5.DEVICE_STATES.accepted
    });
    const getAllDevices = (perPage = MAX_PAGE_SIZE, page = defaultPage, devices = []) => general_api_default.post(getSearchEndpoint(getState()), { page, per_page: perPage, filters, attributes: [...attributes, { scope: "inventory", attribute }] }).then(
      (res) => {
        const state = getState();
        const deviceAccu = reduceReceivedDevices(res.data, devices, state);
        dispatch(actions3.receivedDevices(deviceAccu.devicesById));
        const total = Number(res.headers[import_constants5.headerNames.total]);
        if (total > deviceAccu.ids.length) {
          return getAllDevices(perPage, page + 1, deviceAccu.ids);
        }
        return Promise.resolve(dispatch(actions3.addGroup({ group: { deviceIds: deviceAccu.ids, total }, groupName: group })));
      }
    );
    return getAllDevices();
  }
);
var getDeviceById2 = createAppAsyncThunk(
  `${sliceName3}/getDeviceById`,
  (id, { dispatch, getState }) => general_api_default.get(`${import_constants5.inventoryApiUrl}/devices/${id}`).then((res) => {
    const device = reduceReceivedDevices([res.data], [], getState()).devicesById[id];
    device.etag = res.headers.etag;
    dispatch(actions3.receivedDevice(device));
    return Promise.resolve(device);
  }).catch((err) => {
    const errMsg = extractErrorMessage(err);
    if (errMsg.includes("Not Found")) {
      console.log(`${id} does not have any inventory information`);
      const device = reduceReceivedDevices(
        [
          {
            id,
            attributes: [
              { name: "status", value: "decomissioned", scope: "identity" },
              { name: "decomissioned", value: "true", scope: "inventory" }
            ],
            log: false
          }
        ],
        [],
        getState()
      ).devicesById[id];
      dispatch(actions3.receivedDevice(device));
    }
  })
);
var getDeviceInfo = createAppAsyncThunk(`${sliceName3}/getDeviceInfo`, (deviceId, { dispatch, getState }) => {
  const device = getDeviceById(getState(), deviceId);
  const { hasDeviceConfig, hasDeviceConnect, hasMonitor } = getTenantCapabilities(getState());
  const { canConfigure } = getUserCapabilities(getState());
  const integrations = getDeviceTwinIntegrations(getState());
  const tasks = [
    dispatch(getDeviceAuth(deviceId)),
    dispatch(getDeviceById2(deviceId)),
    ...integrations.map((integration) => dispatch(getDeviceTwin({ deviceId, integration })))
  ];
  if (hasDeviceConfig && canConfigure && (device.status === import_constants5.DEVICE_STATES.accepted || device.status === import_constants5.DEVICE_STATES.preauth)) {
    tasks.push(dispatch(getDeviceConfig(deviceId)));
  }
  if (device.status === import_constants5.DEVICE_STATES.accepted) {
    if (hasDeviceConnect) {
      tasks.push(dispatch(getDeviceConnect(deviceId)));
    }
    if (hasMonitor) {
      tasks.push(dispatch(getLatestDeviceAlerts({ id: deviceId })));
      tasks.push(dispatch(getDeviceMonitorConfig(deviceId)));
    }
  }
  return Promise.all(tasks);
});
var getDeviceCount = createAppAsyncThunk(
  `${sliceName3}/getDeviceCount`,
  (status, { dispatch, getState }) => general_api_default.post(getSearchEndpoint(getState()), {
    page: 1,
    per_page: 1,
    filters: mapFiltersToTerms([{ key: "status", value: status, operator: import_constants5.DEVICE_FILTERING_OPTIONS.$eq.key, scope: "identity" }]),
    attributes: defaultAttributes
  }).then((response) => {
    const count = Number(response.headers[import_constants5.headerNames.total]);
    return dispatch(actions3.setDevicesCountByStatus({ count, status }));
  })
);
var getAllDeviceCounts = createAppAsyncThunk(
  `${sliceName3}/getAllDeviceCounts`,
  (_, { dispatch }) => Promise.all([import_constants5.DEVICE_STATES.accepted, import_constants5.DEVICE_STATES.pending].map((status) => dispatch(getDeviceCount(status))))
);
var getDeviceLimit2 = createAppAsyncThunk(
  `${sliceName3}/getDeviceLimit`,
  (_, { dispatch }) => general_api_default.get(`${import_constants5.deviceAuthV2}/limits/max_devices`).then((res) => dispatch(actions3.setDeviceLimit(res.data.limit)))
);
var setDeviceListState = createAppAsyncThunk(
  `${sliceName3}/setDeviceListState`,
  ({ shouldSelectDevices = true, forceRefresh, fetchAuth = true, ...selectionState }, { dispatch, getState }) => {
    const currentState = getDeviceListState(getState());
    const refreshTrigger = forceRefresh ? !currentState.refreshTrigger : selectionState.refreshTrigger;
    const nextState = {
      ...currentState,
      setOnly: false,
      refreshTrigger,
      ...selectionState,
      sort: { ...currentState.sort, ...selectionState.sort }
    };
    const tasks = [];
    const { isLoading: currentLoading, deviceIds: currentDevices, selection: currentSelection, ...currentRequestState } = currentState;
    const { isLoading: nextLoading, deviceIds: nextDevices, selection: nextSelection, ...nextRequestState } = nextState;
    if (!nextState.setOnly && !(0, import_helpers8.deepCompare)(currentRequestState, nextRequestState)) {
      const { direction: sortDown = import_constants5.SORTING_OPTIONS.desc, key: sortCol, scope: sortScope = "" } = nextState.sort ?? {};
      const sortBy = sortCol ? [{ attribute: sortCol, order: sortDown, scope: sortScope }] : void 0;
      const applicableSelectedState = nextState.state === import_constants5.ALL_DEVICE_STATES ? void 0 : nextState.state;
      nextState.isLoading = true;
      tasks.push(
        dispatch(getDevicesByStatus2({ ...nextState, status: applicableSelectedState, sortOptions: sortBy, fetchAuth })).unwrap().then((results) => {
          const { deviceAccu, total } = results[results.length - 1];
          const devicesState = shouldSelectDevices ? { deviceIds: deviceAccu.ids, total, isLoading: false } : { isLoading: false };
          return Promise.resolve(dispatch(actions3.setDeviceListState(devicesState)));
        }).catch(() => Promise.resolve({ isLoading: false }))
      );
    }
    tasks.push(dispatch(actions3.setDeviceListState(nextState)));
    return Promise.all(tasks);
  }
);
var getDevicesByStatus2 = createAppAsyncThunk(
  `${sliceName3}/getDevicesByStatus`,
  (options, { dispatch, getState }) => {
    const {
      status,
      fetchAuth = true,
      filterSelection,
      group,
      selectedIssues = [],
      page = defaultPage,
      perPage = defaultPerPage,
      sortOptions = [],
      selectedAttributes = getSelectedDeviceAttribute(getState())
    } = options;
    const state = getState();
    const { applicableFilters, filterTerms } = convertDeviceListStateToFilters({
      filters: filterSelection ?? getDeviceFilters(state),
      group: group ?? getSelectedGroup(state),
      groups: state.devices.groups,
      offlineThreshold: state.app.offlineThreshold,
      selectedIssues,
      status
    });
    const attributes = [...defaultAttributes, getIdAttribute(getState()), ...selectedAttributes];
    return general_api_default.post(getSearchEndpoint(getState()), {
      page,
      per_page: perPage,
      filters: filterTerms,
      sort: sortOptions,
      attributes
    }).then((response) => {
      const state2 = getState();
      const deviceAccu = reduceReceivedDevices(response.data, [], state2, status);
      let total = !applicableFilters.length ? Number(response.headers[import_constants5.headerNames.total]) : 0;
      if (status && state2.devices.byStatus[status].total === deviceAccu.ids.length) {
        total = deviceAccu.ids.length;
      }
      const tasks = [dispatch(actions3.receivedDevices(deviceAccu.devicesById))];
      if (status) {
        tasks.push(dispatch(actions3.setDevicesByStatus({ deviceIds: deviceAccu.ids, status, total })));
      }
      const receivedDevices = Object.values(deviceAccu.devicesById);
      if (receivedDevices.length && fetchAuth) {
        tasks.push(dispatch(getDevicesWithAuth(receivedDevices)));
      }
      tasks.push(Promise.resolve({ deviceAccu, total: Number(response.headers[import_constants5.headerNames.total]) }));
      return Promise.all(tasks);
    }).catch((err) => commonErrorHandler(err, `${status} devices couldn't be loaded.`, dispatch, commonErrorFallback));
  }
);
var getAllDevicesByStatus = createAppAsyncThunk(
  `${sliceName3}/getAllDevicesByStatus`,
  ({ status, attribute }, { dispatch, getState }) => {
    const attributes = [...defaultAttributes, getIdAttribute(getState())];
    const getAllDevices = (perPage = MAX_PAGE_SIZE, page = 1, devices = []) => general_api_default.post(getSearchEndpoint(getState()), {
      page,
      per_page: perPage,
      filters: mapFiltersToTerms([{ key: "status", value: status, operator: import_constants5.DEVICE_FILTERING_OPTIONS.$eq.key, scope: "identity" }]),
      attributes: [...attributes, { scope: "inventory", attribute }]
    }).then((res) => {
      const state = getState();
      const deviceAccu = reduceReceivedDevices(res.data, devices, state, status);
      dispatch(actions3.receivedDevices(deviceAccu.devicesById));
      const total = Number(res.headers[import_constants5.headerNames.total]);
      if (total > state.deployments.deploymentDeviceLimit) {
        return Promise.resolve();
      }
      if (total > perPage * page) {
        return getAllDevices(perPage, page + 1, deviceAccu.ids);
      }
      return Promise.resolve();
    });
    return getAllDevices();
  }
);
var searchDevices = createAppAsyncThunk(`${sliceName3}/searchDevices`, (passedOptions = {}, { dispatch, getState }) => {
  const state = getState();
  const options = { ...state.app.searchState, ...passedOptions };
  const { page = defaultPage, searchTerm, sortOptions = [] } = options;
  const { columnSelection = [] } = getUserSettings(state);
  const selectedAttributes = columnSelection.map((column) => ({ attribute: column.key, scope: column.scope }));
  const attributes = (0, import_helpers8.attributeDuplicateFilter)([...defaultAttributes, getIdAttribute(state), ...selectedAttributes], "attribute");
  return general_api_default.post(getSearchEndpoint(getState()), {
    page,
    per_page: 10,
    filters: [],
    sort: sortOptions,
    text: searchTerm,
    attributes
  }).then((response) => {
    const deviceAccu = reduceReceivedDevices(response.data, [], getState());
    return Promise.all([
      dispatch(actions3.receivedDevices(deviceAccu.devicesById)),
      Promise.resolve({ deviceIds: deviceAccu.ids, searchTotal: Number(response.headers[import_constants5.headerNames.total]) })
    ]);
  }).catch((err) => commonErrorHandler(err, `devices couldn't be searched.`, dispatch, commonErrorFallback));
});
var ATTRIBUTE_LIST_CUTOFF = 100;
var attributeReducer = (attributes = []) => attributes.slice(0, ATTRIBUTE_LIST_CUTOFF).reduce(
  (accu, { name, scope }) => {
    if (!accu[scope]) {
      accu[scope] = [];
    }
    accu[scope].push(name);
    return accu;
  },
  { identity: [], inventory: [], system: [], tags: [] }
);
var getDeviceAttributes = createAppAsyncThunk(
  `${sliceName3}/getDeviceAttributes`,
  (_, { dispatch, getState }) => general_api_default.get(getAttrsEndpoint(getState())).then(({ data }) => {
    const { identity: identityAttributes, inventory: inventoryAttributes, system: systemAttributes, tags: tagAttributes } = attributeReducer(data || []);
    return dispatch(actions3.setFilterAttributes({ identityAttributes, inventoryAttributes, systemAttributes, tagAttributes }));
  })
);
var initializeDistributionData = (report, groups, devices, totalDeviceCount) => {
  const { attribute, group = "", software = "" } = report;
  const effectiveAttribute = software ? software : attribute;
  const { deviceIds, total = 0 } = groups[group] || {};
  const relevantDevices = deviceIds ? deviceIds.map((id) => devices[id]) : Object.values(devices);
  const distributionByAttribute = relevantDevices.reduce((accu, item) => {
    if (!item.attributes || item.status !== import_constants5.DEVICE_STATES.accepted) return accu;
    const attributeValue = item.attributes[effectiveAttribute];
    if (!accu[attributeValue]) {
      accu[attributeValue] = 0;
    }
    accu[attributeValue] = accu[attributeValue] + 1;
    return accu;
  }, {});
  const distributionByAttributeSorted = Object.entries(distributionByAttribute).sort((pairA, pairB) => pairB[1] - pairA[1]);
  const items = distributionByAttributeSorted.map(([key, count]) => ({ key, count }));
  const dataCount = items.reduce((accu, item) => accu + item.count, 0);
  const otherCount = (groups[group] ? total : totalDeviceCount) - dataCount;
  return { items, otherCount, total: otherCount + dataCount };
};
var updateReportData = createAppAsyncThunk(`${sliceName3}/updateReportData`, (reportIndex, { dispatch, getState }) => {
  const reports = getDeviceReportsForUser(getState());
  const report = reports[reportIndex];
  const { group = "" } = report;
  const devicesById = getDevicesById(getState());
  const groups = getGroupsById(getState());
  const acceptedDevices = getAcceptedDevices(getState());
  const totalDeviceCount = groups[group] ? groups[group].total : acceptedDevices.total;
  const reportsData = getDeviceReports(getState());
  const newReports = [...reportsData];
  newReports[reportIndex] = initializeDistributionData(report, groups, devicesById, totalDeviceCount);
  return Promise.resolve(dispatch(actions3.setDeviceReports(newReports)));
});
var getReportDataWithoutBackendSupport = createAppAsyncThunk(
  `${sliceName3}/getReportDataWithoutBackendSupport`,
  (reportIndex, { dispatch, getState }) => {
    const reports = getDeviceReportsForUser(getState());
    const report = reports[reportIndex];
    if (!report) {
      return;
    }
    const { attribute, group = "", software = "" } = report;
    const effectiveAttribute = software ? software : attribute;
    const devicesById = getDevicesById(getState());
    const acceptedDevices = getAcceptedDevices(getState());
    const groups = getGroupsById(getState());
    const { deviceIds = [], filters = [], total = 0 } = groups[group] || {};
    let groupDevicesRequest = Promise.resolve({
      payload: { groupName: "", group: { deviceIds: Object.keys(devicesById), total: Object.keys(devicesById).length } }
    });
    if (group && (!(deviceIds.length && total) || deviceIds.length !== total || !deviceIds.every((id) => !!devicesById[id]))) {
      groupDevicesRequest = filters.length ? dispatch(getAllDynamicGroupDevices({ group, attribute: effectiveAttribute })).unwrap() : dispatch(getAllGroupDevices({ group, attribute: effectiveAttribute })).unwrap();
    } else if (!group && (acceptedDevices.deviceIds.length !== acceptedDevices.total || !acceptedDevices.deviceIds.every((id) => !!devicesById[id]))) {
      groupDevicesRequest = dispatch(getAllDevicesByStatus({ status: import_constants5.DEVICE_STATES.accepted, attribute: effectiveAttribute })).unwrap();
    }
    return groupDevicesRequest.then(() => dispatch(updateReportData(reportIndex)));
  }
);
var getDeviceConnect = createAppAsyncThunk(
  `${sliceName3}/getDeviceConnect`,
  (id, { dispatch }) => general_api_default.get(`${import_constants5.deviceConnect}/devices/${id}`).then(
    ({ data }) => Promise.all([dispatch(actions3.receivedDevice({ connect_status: data.status, connect_updated_ts: data.updated_ts, id })), Promise.resolve(data)])
  )
);
var updateTypeMap = { deploymentUpdate: "check-update", inventoryUpdate: "send-inventory" };
var triggerDeviceUpdate = createAppAsyncThunk(
  `${sliceName3}/triggerDeviceUpdate`,
  ({ id, type }, { dispatch }) => general_api_default.post(`${import_constants5.deviceConnect}/devices/${id}/${updateTypeMap[type] ?? updateTypeMap.deploymentUpdate}`).then(
    () => new Promise((resolve) => setTimeout(() => resolve(dispatch(getDeviceById2(id))), TIMEOUTS.threeSeconds))
  )
);
var getSessionDetails = createAppAsyncThunk(
  `${sliceName3}/getSessionDetails`,
  ({ sessionId, deviceId, userId, startDate, endDate }) => {
    const { start: startUnix, end: endUnix } = (0, import_helpers8.dateRangeToUnix)(startDate, endDate);
    const createdAfter = startDate ? `&created_after=${startUnix}` : "";
    const createdBefore = endDate ? `&created_before=${endUnix}` : "";
    const objectSearch = `&object_id=${deviceId}`;
    return general_api_default.get(`${import_constants5.auditLogsApiUrl}/logs?per_page=500${createdAfter}${createdBefore}&actor_id=${userId}${objectSearch}`).then(
      ({ data: auditLogEntries }) => {
        const { start, end } = auditLogEntries.reduce(
          (accu, item) => {
            if (item.meta?.session_id?.includes(sessionId)) {
              accu.start = new Date(item.action.startsWith("open") ? item.time : accu.start);
              accu.end = new Date(item.action.startsWith("close") ? item.time : accu.end);
            }
            return accu;
          },
          { start: startDate || endDate, end: endDate || startDate }
        );
        return Promise.resolve({ start, end });
      }
    );
  }
);
var getDeviceFileDownloadLink = createAppAsyncThunk(
  `${sliceName3}/getDeviceFileDownloadLink`,
  ({ deviceId, path }) => Promise.resolve(`${window.location.origin}${import_constants5.deviceConnect}/devices/${deviceId}/download?path=${encodeURIComponent(path)}`)
);
var deviceFileUpload = createAppAsyncThunk(
  `${sliceName3}/deviceFileUpload`,
  ({ deviceId, path, file }, { dispatch }) => {
    const formData = new FormData();
    formData.append("path", path);
    formData.append("file", file);
    const uploadId = (0, import_uuid.v4)();
    const cancelSource = new AbortController();
    return Promise.all([
      dispatch(setSnackbar2("Uploading file")),
      dispatch(initUpload({ id: uploadId, upload: { progress: 0, cancelSource } })),
      general_api_default.uploadPut(
        `${import_constants5.deviceConnect}/devices/${deviceId}/upload`,
        formData,
        (e) => dispatch(uploadProgress2({ id: uploadId, progress: progress(e) })),
        cancelSource.signal
      )
    ]).then(() => Promise.resolve(dispatch(setSnackbar2({ message: "Upload successful", autoHideDuration: TIMEOUTS.fiveSeconds })))).catch((err) => {
      if ((0, import_axios2.isCancel)(err)) {
        return dispatch(setSnackbar2({ message: "The upload has been cancelled", autoHideDuration: TIMEOUTS.fiveSeconds }));
      }
      return commonErrorHandler(err, `Error uploading file to device.`, dispatch);
    }).finally(() => dispatch(cleanUpUpload(uploadId)));
  }
);
var getDeviceAuth = createAppAsyncThunk(
  `${sliceName3}/getDeviceAuth`,
  (id, { dispatch }) => dispatch(getDevicesWithAuth([{ id }])).unwrap().then((results) => {
    if (results[results.length - 1]) {
      return Promise.resolve(results[results.length - 1][0]);
    }
    return Promise.resolve();
  })
);
var getDevicesWithAuth = createAppAsyncThunk(
  `${sliceName3}/getDevicesWithAuth`,
  (devices, { dispatch, getState }) => devices.length ? general_api_default.get(`${import_constants5.deviceAuthV2}/devices?id=${devices.map((device) => device.id).join("&id=")}`).then(({ data: receivedDevices }) => {
    const { devicesById } = reduceReceivedDevices(receivedDevices, [], getState());
    return Promise.all([dispatch(actions3.receivedDevices(devicesById)), Promise.resolve(receivedDevices)]);
  }).catch((err) => commonErrorHandler(err, `Error: ${err}`, dispatch)) : Promise.resolve([[], []])
);
var updateDeviceAuth = createAppAsyncThunk(
  `${sliceName3}/updateDeviceAuth`,
  ({ deviceId, authId, status }, { dispatch, getState }) => general_api_default.put(`${import_constants5.deviceAuthV2}/devices/${deviceId}/auth/${authId}/status`, { status }).then(() => Promise.all([dispatch(getDeviceAuth(deviceId)), dispatch(setSnackbar2("Device authorization status was updated successfully"))])).catch((err) => commonErrorHandler(err, "There was a problem updating the device authorization status:", dispatch)).then(() => Promise.resolve(dispatch(actions3.maybeUpdateDevicesByStatus({ deviceId, authId })))).finally(() => dispatch(setDeviceListState({ refreshTrigger: !getDeviceListState(getState()).refreshTrigger })))
);
var updateDevicesAuth = createAppAsyncThunk(
  `${sliceName3}/updateDevicesAuth`,
  ({ deviceIds, status }, { dispatch, getState }) => {
    let devices = getDevicesById(getState());
    const deviceIdsWithoutAuth = deviceIds.reduce((accu, id) => devices[id].auth_sets ? accu : [...accu, { id }], []);
    return dispatch(getDevicesWithAuth(deviceIdsWithoutAuth)).then(() => {
      devices = getDevicesById(getState());
      const deviceAuthUpdates = deviceIds.map((id) => {
        const device = devices[id];
        if (device.auth_sets && device.auth_sets.length !== 1) {
          return Promise.reject();
        }
        return dispatch(updateDeviceAuth({ authId: device.auth_sets[0].id, deviceId: device.id, status })).unwrap().catch((err) => commonErrorHandler(err, "The action was stopped as there was a problem updating a device authorization status: ", dispatch, "", false));
      });
      return Promise.allSettled(deviceAuthUpdates).then((results) => {
        const { skipped, count } = results.reduce(
          (accu, item) => {
            if (item.status === "rejected") {
              accu.skipped = accu.skipped + 1;
            } else {
              accu.count = accu.count + 1;
            }
            return accu;
          },
          { skipped: 0, count: 0 }
        );
        const message = (0, import_helpers8.getSnackbarMessage)(skipped, count);
        return dispatch(setSnackbar2(message));
      });
    });
  }
);
var deleteAuthset = createAppAsyncThunk(
  `${sliceName3}/deleteAuthset`,
  ({ deviceId, authId }, { dispatch, getState }) => general_api_default.delete(`${import_constants5.deviceAuthV2}/devices/${deviceId}/auth/${authId}`).then(() => Promise.all([dispatch(setSnackbar2("Device authorization status was updated successfully"))])).catch((err) => commonErrorHandler(err, "There was a problem updating the device authorization status:", dispatch)).then(() => Promise.resolve(dispatch(actions3.maybeUpdateDevicesByStatus({ deviceId, authId })))).finally(() => dispatch(setDeviceListState({ refreshTrigger: !getState().devices.deviceList.refreshTrigger })))
);
var preauthDevice = createAppAsyncThunk(
  `${sliceName3}/preauthDevice`,
  (authset, { dispatch, rejectWithValue }) => general_api_default.post(`${import_constants5.deviceAuthV2}/devices`, authset).then(
    () => Promise.resolve(dispatch(setSnackbar2({ message: "Device was successfully added to the preauthorization list", autoHideDuration: TIMEOUTS.fiveSeconds })))
  ).catch((err) => {
    if (err.response.status === 409) {
      return rejectWithValue("A device with a matching identity data set already exists");
    }
    return commonErrorHandler(err, "The device could not be added:", dispatch);
  })
);
var decommissionDevice = createAppAsyncThunk(
  `${sliceName3}/decommissionDevice`,
  ({ deviceId, authId }, { dispatch, getState }) => general_api_default.delete(`${import_constants5.deviceAuthV2}/devices/${deviceId}`).then(() => Promise.resolve(dispatch(setSnackbar2("Device was decommissioned successfully")))).catch((err) => commonErrorHandler(err, "There was a problem decommissioning the device:", dispatch)).then(() => Promise.resolve(dispatch(actions3.maybeUpdateDevicesByStatus({ deviceId, authId })))).finally(() => dispatch(setDeviceListState({ refreshTrigger: !getState().devices.deviceList.refreshTrigger })))
);
var getDeviceConfig = createAppAsyncThunk(
  `${sliceName3}/getDeviceConfig`,
  (deviceId, { dispatch }) => general_api_default.get(`${import_constants5.deviceConfig}/${deviceId}`).then(({ data }) => Promise.all([dispatch(actions3.receivedDevice({ id: deviceId, config: data })), Promise.resolve(data)])).catch((err) => {
    if (err.response?.data?.error.status_code !== 404) {
      return commonErrorHandler(err, `There was an error retrieving the configuration for device ${deviceId}.`, dispatch, commonErrorFallback);
    }
  })
);
var setDeviceConfig = createAppAsyncThunk(
  `${sliceName3}/setDeviceConfig`,
  ({ deviceId, config }, { dispatch }) => general_api_default.put(`${import_constants5.deviceConfig}/${deviceId}`, config).catch((err) => commonErrorHandler(err, `There was an error setting the configuration for device ${deviceId}.`, dispatch, commonErrorFallback)).then(() => Promise.resolve(dispatch(getDeviceConfig(deviceId))))
);
var applyDeviceConfig = createAppAsyncThunk(
  `${sliceName3}/applyDeviceConfig`,
  ({ deviceId, configDeploymentConfiguration, isDefault, config }, { dispatch, getState }) => general_api_default.post(`${import_constants5.deviceConfig}/${deviceId}/deploy`, configDeploymentConfiguration).catch((err) => commonErrorHandler(err, `There was an error deploying the configuration to device ${deviceId}.`, dispatch, commonErrorFallback)).then(({ data }) => {
    const device = getDeviceById(getState(), deviceId);
    const { canManageUsers } = getUserCapabilities(getState());
    const tasks = [
      dispatch(actions3.receivedDevice({ ...device, config: { ...device.config, deployment_id: data.deployment_id } })),
      new Promise((resolve) => setTimeout(() => resolve(dispatch(getSingleDeployment(data.deployment_id))), TIMEOUTS.oneSecond))
    ];
    if (isDefault && canManageUsers) {
      const { previous } = getGlobalSettings(getState()).defaultDeviceConfig ?? {};
      tasks.push(dispatch(saveGlobalSettings({ defaultDeviceConfig: { current: config, previous } })));
    }
    return Promise.all(tasks);
  })
);
var setDeviceTags = createAppAsyncThunk(
  `${sliceName3}/setDeviceTags`,
  ({ deviceId, tags }, { dispatch }) => (
    // to prevent tag set failures, retrieve the device & use the freshest etag we can get
    dispatch(getDeviceById2(deviceId)).unwrap().then((device) => {
      const headers = device.etag ? { "If-Match": device.etag } : {};
      const tagList = Object.entries(tags).map(([name, value]) => ({ name, value }));
      const isNameChange = tagList.some(({ name }) => name === "name");
      return general_api_default.put(`${import_constants5.inventoryApiUrl}/devices/${deviceId}/tags`, tagList, { headers }).catch((err) => commonErrorHandler(err, `There was an error setting tags for device ${deviceId}.`, dispatch, "Please check your connection.")).then(
        () => Promise.all([
          dispatch(actions3.receivedDevice({ ...device, id: deviceId, tags })),
          dispatch(setSnackbar2(`Device ${tagList.length === 1 && isNameChange ? "name" : "tags"} changed`))
        ])
      );
    })
  )
);
var getDeviceTwin = createAppAsyncThunk(`${sliceName3}/getDeviceTwin`, ({ deviceId, integration }, { dispatch, getState }) => {
  let providerResult = {};
  return general_api_default.get(`${import_constants5.iotManagerBaseURL}/devices/${deviceId}/state`).then(({ data }) => {
    providerResult = { ...data, twinError: "" };
  }).catch((err) => {
    providerResult = {
      twinError: `There was an error getting the ${EXTERNAL_PROVIDER[integration.provider].twinTitle.toLowerCase()} for device ${deviceId}. ${err}`
    };
  }).finally(() => {
    const device = getDeviceById(getState(), deviceId);
    Promise.resolve(dispatch(actions3.receivedDevice({ ...device, twinsByIntegration: { ...device.twinsByIntegration, ...providerResult } })));
  });
});
var setDeviceTwin = createAppAsyncThunk(
  `${sliceName3}/setDeviceTwin`,
  ({ deviceId, integration, settings }, { dispatch, getState }) => general_api_default.put(`${import_constants5.iotManagerBaseURL}/devices/${deviceId}/state/${integration.id}`, { desired: settings }).catch(
    (err) => commonErrorHandler(
      err,
      `There was an error updating the ${EXTERNAL_PROVIDER[integration.provider].twinTitle.toLowerCase()} for device ${deviceId}.`,
      dispatch
    )
  ).then(() => {
    const device = getDeviceById(getState(), deviceId);
    const { twinsByIntegration = {} } = device;
    const { [integration.id]: currentState = {} } = twinsByIntegration;
    return Promise.resolve(
      dispatch(
        actions3.receivedDevice({ ...device, twinsByIntegration: { ...twinsByIntegration, [integration.id]: { ...currentState, desired: settings } } })
      )
    );
  })
);
var prepareSearchArguments = ({ filters, group, state, status }) => {
  const { filterTerms } = convertDeviceListStateToFilters({ filters, group, offlineThreshold: state.app.offlineThreshold, selectedIssues: [], status });
  const { columnSelection = [] } = getUserSettings(state);
  const selectedAttributes = columnSelection.map((column) => ({ attribute: column.key, scope: column.scope }));
  const attributes = [...defaultAttributes, getIdAttribute(state), ...selectedAttributes];
  return { attributes, filterTerms };
};
var getSystemDevices = createAppAsyncThunk(`${sliceName3}/getSystemDevices`, (options, { dispatch, getState }) => {
  const { id, page = defaultPage, perPage = defaultPerPage, sortOptions = [] } = options;
  const state = getState();
  const { hasFullFiltering } = getTenantCapabilities(state);
  if (!hasFullFiltering) {
    return Promise.resolve();
  }
  const { attributes: deviceAttributes = {} } = getDeviceById(state, id);
  const { mender_gateway_system_id = "" } = deviceAttributes;
  const filters = [
    { ...emptyFilter, key: "mender_is_gateway", operator: import_constants5.DEVICE_FILTERING_OPTIONS.$ne.key, value: "true", scope: "inventory" },
    { ...emptyFilter, key: "mender_gateway_system_id", value: mender_gateway_system_id, scope: "inventory" }
  ];
  const { attributes, filterTerms } = prepareSearchArguments({ filters, state });
  return general_api_default.post(getSearchEndpoint(getState()), {
    page,
    per_page: perPage,
    filters: filterTerms,
    sort: sortOptions,
    attributes
  }).catch((err) => commonErrorHandler(err, `There was an error getting system devices device ${id}.`, dispatch, "Please check your connection.")).then(({ data, headers }) => {
    const state2 = getState();
    const { devicesById, ids } = reduceReceivedDevices(data, [], state2);
    const device = {
      ...getDeviceById(state2, id),
      systemDeviceIds: ids,
      systemDeviceTotal: Number(headers[import_constants5.headerNames.total])
    };
    return Promise.resolve(dispatch(actions3.receivedDevices({ ...devicesById, [id]: device })));
  });
});
var getGatewayDevices = createAppAsyncThunk(`${sliceName3}/getGatewayDevices`, (deviceId, { dispatch, getState }) => {
  const state = getState();
  const { attributes = {} } = getDeviceById(state, deviceId);
  const { mender_gateway_system_id = "" } = attributes;
  const filters = [
    { ...emptyFilter, key: "id", operator: import_constants5.DEVICE_FILTERING_OPTIONS.$ne.key, value: deviceId, scope: "identity" },
    { ...emptyFilter, key: "mender_is_gateway", value: "true", scope: "inventory" },
    { ...emptyFilter, key: "mender_gateway_system_id", value: mender_gateway_system_id, scope: "inventory" }
  ];
  const { attributes: attributeSelection, filterTerms } = prepareSearchArguments({ filters, state });
  return general_api_default.post(getSearchEndpoint(getState()), {
    page: 1,
    per_page: MAX_PAGE_SIZE,
    filters: filterTerms,
    attributes: attributeSelection
  }).then(({ data }) => {
    const { ids } = reduceReceivedDevices(data, [], getState());
    const tasks = ids.map((deviceId2) => dispatch(getDeviceInfo(deviceId2)));
    tasks.push(dispatch(actions3.receivedDevice({ id: deviceId, gatewayIds: ids })));
    return Promise.all(tasks);
  });
});

// src/monitorSlice/thunks.ts
var { page: defaultPage2, perPage: defaultPerPage2 } = import_constants5.DEVICE_LIST_DEFAULTS;
var cutoffLength = 75;
var ellipsis = "...";
var longTextTrimmer = (text) => text.length >= cutoffLength + ellipsis.length ? `${text.substring(0, cutoffLength + ellipsis.length)}${ellipsis}` : text;
var sanitizeDeviceAlerts = (alerts) => alerts.map((alert) => ({ ...alert, fullName: alert.name, name: longTextTrimmer(alert.name || "") }));
var getDeviceAlerts = createAppAsyncThunk(`${sliceName4}/getDeviceAlerts`, ({ id, config = {} }, { dispatch }) => {
  const { page = defaultPage2, perPage = defaultPerPage2, issuedBefore, issuedAfter, sortAscending = false } = config;
  const issued_after = issuedAfter ? `&issued_after=${issuedAfter}` : "";
  const issued_before = issuedBefore ? `&issued_before=${issuedBefore}` : "";
  return general_api_default.get(
    `${import_constants5.monitorApiUrlv1}/devices/${id}/alerts?page=${page}&per_page=${perPage}${issued_after}${issued_before}&sort_ascending=${sortAscending}`
  ).catch((err) => commonErrorHandler(err, `Retrieving device alerts for device ${id} failed:`, dispatch)).then(
    (res) => Promise.all([
      dispatch(actions4.receiveDeviceAlerts({ deviceId: id, alerts: sanitizeDeviceAlerts(res.data) })),
      dispatch(actions4.setAlertListState({ total: Number(res.headers[import_constants5.headerNames.total]) }))
    ])
  );
});
var getLatestDeviceAlerts = createAppAsyncThunk(
  `${sliceName4}/getLatestDeviceAlerts`,
  ({ id, config = {} }, { dispatch }) => {
    const { page = defaultPage2, perPage = 10 } = config;
    return general_api_default.get(`${import_constants5.monitorApiUrlv1}/devices/${id}/alerts/latest?page=${page}&per_page=${perPage}`).catch((err) => commonErrorHandler(err, `Retrieving device alerts for device ${id} failed:`, dispatch)).then((res) => Promise.resolve(dispatch(actions4.receiveLatestDeviceAlerts({ deviceId: id, alerts: sanitizeDeviceAlerts(res.data) }))));
  }
);
var getIssueCountsByType2 = createAppAsyncThunk(
  `${sliceName4}/getIssueCountsByType`,
  ({ type, options = {} }, { dispatch, getState }) => {
    const state = getState();
    const { filters = getDeviceFilters(state), group, status, ...remainder } = options;
    const { applicableFilters: nonMonitorFilters, filterTerms } = convertDeviceListStateToFilters({
      ...remainder,
      filters,
      group,
      offlineThreshold: state.app.offlineThreshold,
      selectedIssues: [type],
      status
    });
    return general_api_default.post(getSearchEndpoint(getState()), {
      page: 1,
      per_page: 1,
      filters: filterTerms,
      attributes: [{ scope: "identity", attribute: "status" }]
    }).catch((err) => commonErrorHandler(err, `Retrieving issue counts failed:`, dispatch, commonErrorFallback)).then((res) => {
      const total = nonMonitorFilters.length ? state.monitor.issueCounts.byType[type].total : Number(res.headers[import_constants5.headerNames.total]);
      const filtered = nonMonitorFilters.length ? Number(res.headers[import_constants5.headerNames.total]) : total;
      if (total === state.monitor.issueCounts.byType[type].total && filtered === state.monitor.issueCounts.byType[type].filtered) {
        return Promise.resolve();
      }
      return Promise.resolve(dispatch(actions4.receiveDeviceIssueCounts({ counts: { filtered, total }, issueType: type })));
    });
  }
);
var getDeviceMonitorConfig = createAppAsyncThunk(
  `${sliceName4}/getDeviceMonitorConfig`,
  (id, { dispatch }) => general_api_default.get(`${import_constants5.monitorApiUrlv1}/devices/${id}/config`).catch((err) => commonErrorHandler(err, `Retrieving device monitor config for device ${id} failed:`, dispatch)).then(({ data }) => Promise.all([dispatch(actions_default.receivedDevice({ id, monitors: data }), Promise.resolve(data))]))
);
var changeNotificationSetting = createAppAsyncThunk(
  `${sliceName4}/changeNotificationSetting`,
  ({ enabled, channel = import_constants5.alertChannels.email }, { dispatch }) => general_api_default.put(`${import_constants5.monitorApiUrlv1}/settings/global/channel/alerts/${channel}/status`, { enabled }).catch((err) => commonErrorHandler(err, `${enabled ? "En" : "Dis"}abling  ${channel} alerts failed:`, dispatch)).then(
    () => Promise.all([
      dispatch(actions4.changeAlertChannel({ channel, enabled })),
      dispatch(
        actions_default.setSnackbar({ message: `Successfully ${enabled ? "en" : "dis"}abled ${channel} alerts`, autoHideDuration: TIMEOUTS.fiveSeconds })
      )
    ])
  )
);

// src/usersSlice/thunks.ts
var import_helpers9 = require("@northern.tech/utils/helpers");
var import_retrytimer = require("@northern.tech/utils/retrytimer");
var import_md5 = __toESM(require("md5"), 1);
var import_universal_cookie3 = __toESM(require("universal-cookie"), 1);

// src/api/users-api.ts
var import_axios3 = __toESM(require("axios"), 1);
var Api2 = {
  postLogin: (url, { email: username, password, ...body }) => import_axios3.default.post(url, body, { ...commonRequestConfig, auth: { username, password } }).then((res) => ({ text: res.data, code: res.status, contentType: res.headers?.["content-type"] })),
  putVerifyTFA: (url, userData) => {
    let body = {};
    if (userData.hasOwnProperty("token2fa")) {
      body = { token2fa: userData.token2fa };
    }
    return import_axios3.default.put(url, body, { ...commonRequestConfig, headers: { ...commonRequestConfig.headers, Authorization: `Bearer ${getToken()}` } });
  }
};
var users_api_default = Api2;

// src/usersSlice/thunks.ts
var cookies3 = new import_universal_cookie3.default();
var { setAnnouncement, setSnackbar: setSnackbar3 } = actions_default;
var handleLoginError = (err, { token2fa: has2FA, password }, rejectWithValue) => () => {
  const errorText = (0, import_helpers9.extractErrorMessage)(err);
  const is2FABackend = errorText.includes("2fa");
  if (is2FABackend && !has2FA) {
    return rejectWithValue({ error: "2fa code missing" });
  }
  if (password === void 0) {
    return Promise.reject();
  }
  const twoFAError = is2FABackend ? " and verification code" : "";
  const errorMessage = `There was a problem logging in. Please check your email${twoFAError ? "," : " and"} password${twoFAError}. If you still have problems, contact an administrator.`;
  return rejectWithValue({ error: errorMessage });
};
var loginUser = createAppAsyncThunk(
  `${sliceName8}/loginUser`,
  ({ stayLoggedIn, ...userData }, { dispatch, rejectWithValue }) => users_api_default.postLogin(`${import_constants5.useradmApiUrl}/auth/login`, { ...userData, no_expiry: stayLoggedIn }).catch((err) => {
    cleanUp();
    return Promise.reject(dispatch(handleLoginError(err, userData, rejectWithValue)));
  }).then(({ text: token, contentType }) => {
    if (contentType.includes(import_constants5.APPLICATION_JSON_CONTENT_TYPE)) {
      const { id, kind } = token;
      const type = kind.split("/")[1];
      const ssoLoginUrl = SSO_TYPES[type].getStartUrl(id);
      window.location.replace(ssoLoginUrl);
      return;
    }
    if (contentType !== import_constants5.APPLICATION_JWT_CONTENT_TYPE || !token) {
      return;
    }
    const now = /* @__PURE__ */ new Date();
    now.setSeconds(now.getSeconds() + import_constants5.maxSessionAge);
    const expiresAt = stayLoggedIn ? void 0 : now.toISOString();
    setSessionInfo({ token, expiresAt });
    cookies3.remove("JWT", { path: "/" });
    return dispatch(getUser(OWN_USER_ID)).unwrap().catch((e) => {
      cleanUp();
      return Promise.reject(dispatch(setSnackbar3((0, import_helpers9.extractErrorMessage)(e))));
    }).then(() => {
      window.sessionStorage.removeItem("pendings-redirect");
      if (window.location.pathname !== "/ui/") {
        window.location.replace("/ui/");
      }
      return Promise.resolve(dispatch(actions8.successfullyLoggedIn({ expiresAt, token })));
    });
  })
);
var logoutUser = createAppAsyncThunk(`${sliceName8}/logoutUser`, (_, { dispatch, getState }) => {
  if (Object.keys(getState().app.uploadsById).length) {
    return Promise.reject();
  }
  return general_api_default.post(`${import_constants5.useradmApiUrl}/auth/logout`).finally(() => {
    cleanUp();
    (0, import_retrytimer.clearAllRetryTimers)(setSnackbar3);
    return Promise.resolve(dispatch({ type: USER_LOGOUT }));
  });
});
var switchUserOrganization = createAppAsyncThunk(`${sliceName8}/switchUserOrganization`, (tenantId, { getState }) => {
  if (Object.keys(getState().app.uploadsById).length) {
    return Promise.reject();
  }
  return general_api_default.get(`${import_constants5.useradmApiUrl}/users/tenants/${tenantId}/token`).then(({ data: token }) => {
    window.sessionStorage.setItem("tenantChanged", "true");
    setSessionInfo({ ...getSessionInfo(), token });
    window.location.reload();
  });
});
var passwordResetStart = createAppAsyncThunk(
  `${sliceName8}/passwordResetStart`,
  (email, { dispatch }) => general_api_default.post(`${import_constants5.useradmApiUrl}/auth/password-reset/start`, { email }).catch(
    (err) => commonErrorHandler(err, `The password reset request cannot be processed:`, dispatch, void 0, true)
  )
);
var passwordResetComplete = createAppAsyncThunk(
  `${sliceName8}/passwordResetComplete`,
  ({ secretHash, newPassword }, { dispatch }) => general_api_default.post(`${import_constants5.useradmApiUrl}/auth/password-reset/complete`, { secret_hash: secretHash, password: newPassword }).catch((err = {}) => {
    const { error, response = {} } = err;
    let errorMsg = "";
    if (response.status == 400) {
      errorMsg = "the link you are using expired or the request is not valid, please try again.";
    } else {
      errorMsg = error;
    }
    dispatch(setSnackbar3("The password reset request cannot be processed: " + errorMsg));
    return Promise.reject(err);
  })
);
var verifyEmailStart = createAppAsyncThunk(
  `${sliceName8}/verifyEmailStart`,
  (_, { dispatch, getState }) => general_api_default.post(`${import_constants5.useradmApiUrl}/auth/verify-email/start`, { email: getCurrentUser(getState()).email }).catch((err) => commonErrorHandler(err, "An error occured starting the email verification process:", dispatch)).finally(() => Promise.resolve(dispatch(getUser(OWN_USER_ID))))
);
var verifyEmailComplete = createAppAsyncThunk(
  `${sliceName8}/verifyEmailComplete`,
  (secret_hash, { dispatch }) => general_api_default.post(`${import_constants5.useradmApiUrl}/auth/verify-email/complete`, { secret_hash }).catch((err) => commonErrorHandler(err, "An error occured completing the email verification process:", dispatch)).finally(() => Promise.resolve(dispatch(getUser(OWN_USER_ID))))
);
var verify2FA = createAppAsyncThunk(
  `${sliceName8}/verify2FA`,
  (tfaData, { dispatch }) => users_api_default.putVerifyTFA(`${import_constants5.useradmApiUrl}/2faverify`, tfaData).then(() => Promise.resolve(dispatch(getUser(OWN_USER_ID)))).catch(
    (err) => commonErrorHandler(err, "An error occured validating the verification code: failed to verify token, please try again.", dispatch, void 0, true)
  )
);
var getUserList = createAppAsyncThunk(
  `${sliceName8}/getUserList`,
  (_, { dispatch, getState }) => general_api_default.get(`${import_constants5.useradmApiUrl}/users`).then((res) => {
    const currentUsersById = getUsersById(getState());
    const users = res.data.reduce(
      (accu, item) => {
        accu[item.id] = {
          ...accu[item.id],
          ...item
        };
        return accu;
      },
      { ...currentUsersById }
    );
    return dispatch(actions8.receivedUserList(users));
  }).catch((err) => commonErrorHandler(err, `Users couldn't be loaded.`, dispatch, commonErrorFallback))
);
var getUser = createAppAsyncThunk(
  `${sliceName8}/getUser`,
  (id, { dispatch, rejectWithValue }) => general_api_default.get(`${import_constants5.useradmApiUrl}/users/${id}`).then(
    ({ data: user }) => Promise.all([
      dispatch(actions8.receivedUser(user)),
      dispatch(setHideAnnouncement({ shouldHide: false, userId: user.id })),
      dispatch(updateUserColumnSettings({ currentUserId: user.id })),
      user
    ])
  ).catch((e) => rejectWithValue(e))
);
var initializeSelf = createAppAsyncThunk(`${sliceName8}/initializeSelf`, (_, { dispatch }) => dispatch(getUser(OWN_USER_ID)));
var updateUserColumnSettings = createAppAsyncThunk(
  `${sliceName8}/updateUserColumnSettings`,
  ({ columns, currentUserId }, { dispatch, getState }) => {
    const userId = currentUserId ?? getCurrentUser(getState()).id;
    const storageKey = `${userId}-column-widths`;
    let customColumns = [];
    if (!columns) {
      try {
        customColumns = JSON.parse(window.localStorage.getItem(storageKey) || "") || customColumns;
      } catch {
      }
    } else {
      customColumns = columns;
    }
    window.localStorage.setItem(storageKey, JSON.stringify(customColumns));
    return Promise.resolve(dispatch(actions8.setCustomColumns(customColumns)));
  }
);
var userActions = {
  add: {
    successMessage: "The user was added successfully.",
    errorMessage: "adding"
  },
  create: {
    successMessage: "The user was created successfully.",
    errorMessage: "creating"
  },
  edit: {
    successMessage: "The user has been updated.",
    errorMessage: "editing"
  },
  remove: {
    successMessage: "The user was removed from the system.",
    errorMessage: "removing"
  }
};
var userActionErrorHandler = (err, type, dispatch) => commonErrorHandler(err, `There was an error ${userActions[type].errorMessage} the user.`, dispatch);
var createUser = createAppAsyncThunk(
  `${sliceName8}/createUser`,
  ({ shouldResetPassword, ...userData }, { dispatch }) => general_api_default.post(`${import_constants5.useradmApiUrl}/users`, { ...userData, send_reset_password: shouldResetPassword }).then(() => Promise.all([dispatch(getUserList()), dispatch(setSnackbar3(userActions.create.successMessage))])).catch((err) => userActionErrorHandler(err, "create", dispatch))
);
var removeUser = createAppAsyncThunk(
  `${sliceName8}/removeUser`,
  (userId, { dispatch }) => general_api_default.delete(`${import_constants5.useradmApiUrl}/users/${userId}`).then(() => Promise.all([dispatch(actions8.removedUser(userId)), dispatch(getUserList()), dispatch(setSnackbar3(userActions.remove.successMessage))])).catch((err) => userActionErrorHandler(err, "remove", dispatch))
);
var editUser = createAppAsyncThunk(
  `${sliceName8}/editUser`,
  ({ id, ...userData }, { dispatch, getState }) => general_api_default.put(`${import_constants5.useradmApiUrl}/users/${id}`, userData).then(
    () => Promise.all([
      dispatch(actions8.updatedUser({ ...userData, id: id === OWN_USER_ID ? getCurrentUser(getState()).id : id })),
      dispatch(setSnackbar3(userActions.edit.successMessage))
    ])
  ).catch((err) => userActionErrorHandler(err, "edit", dispatch))
);
var checkEmailExists = createAppAsyncThunk(`${sliceName8}/checkEmailExists`, async (email) => {
  const response = await general_api_default.get(`${import_constants5.useradmApiUrl}/users/exists?email=${encodeURIComponent(email)}`);
  return response.data.exists;
});
var addUserToCurrentTenant = createAppAsyncThunk(`${sliceName8}/addUserToTenant`, (userId, { dispatch, getState }) => {
  const { id } = getOrganization(getState());
  return general_api_default.post(`${import_constants5.useradmApiUrl}/users/${userId}/assign`, { tenant_ids: [id] }).catch((err) => commonErrorHandler(err, `There was an error adding the user to your organization:`, dispatch)).then(() => Promise.all([dispatch(setSnackbar3(userActions.add.successMessage)), dispatch(getUserList())]));
});
var enableUser2fa = createAppAsyncThunk(
  `${sliceName8}/enableUser2fa`,
  (userId = OWN_USER_ID, { dispatch }) => general_api_default.post(`${import_constants5.useradmApiUrl}/users/${userId}/2fa/enable`).catch((err) => commonErrorHandler(err, `There was an error enabling Two Factor authentication for the user.`, dispatch)).then(() => Promise.resolve(dispatch(getUser(userId))))
);
var disableUser2fa = createAppAsyncThunk(
  `${sliceName8}/disableUser2fa`,
  (userId = OWN_USER_ID, { dispatch }) => general_api_default.post(`${import_constants5.useradmApiUrl}/users/${userId}/2fa/disable`).catch((err) => commonErrorHandler(err, `There was an error disabling Two Factor authentication for the user.`, dispatch)).then(() => Promise.all([dispatch(getUser(userId)), dispatch(actions8.receivedQrCode(null))]))
);
var mapHttpPermission = (permission) => Object.entries(import_constants5.uiPermissionsByArea).reduce(
  (accu, [area, definition]) => {
    const endpointMatches = definition.endpoints.filter(
      (endpoint) => endpoint.path.test(permission.value) && (endpoint.types.includes(permission.type) || permission.type === import_constants5.PermissionTypes.Any)
    );
    if (permission.value === import_constants5.PermissionTypes.Any || permission.value.includes(import_constants5.apiRoot) && endpointMatches.length) {
      const endpointUiPermission = endpointMatches.reduce((endpointAccu, endpoint) => [...endpointAccu, ...endpoint.uiPermissions], []);
      const collector = (endpointUiPermission || definition.uiPermissions).reduce((permissionsAccu, uiPermission) => {
        if (permission.type === import_constants5.PermissionTypes.Any || !endpointMatches.length && uiPermission.verbs.some((verb) => verb === permission.type)) {
          permissionsAccu.push(uiPermission.value);
        }
        return permissionsAccu;
      }, []).filter(import_helpers9.duplicateFilter);
      if (Array.isArray(accu[area])) {
        accu[area] = [...accu[area], ...collector].filter(import_helpers9.duplicateFilter);
      } else {
        accu[area] = mergePermissions(accu[area], { [import_constants5.scopedPermissionAreas[area].excessiveAccessSelector]: collector });
      }
    }
    return accu;
  },
  { ...import_constants5.emptyUiPermissions }
);
var permissionActionTypes = {
  any: mapHttpPermission,
  CREATE_DEPLOYMENT: (permission) => permission.type === import_constants5.PermissionTypes.DeviceGroup ? {
    deployments: [import_constants5.uiPermissionsById.deploy.value],
    groups: { [permission.value]: [import_constants5.uiPermissionsById.deploy.value] }
  } : {},
  http: mapHttpPermission,
  REMOTE_TERMINAL: (permission) => permission.type === import_constants5.PermissionTypes.DeviceGroup ? {
    groups: { [permission.value]: [import_constants5.uiPermissionsById.connect.value] }
  } : {},
  VIEW_DEVICE: (permission) => permission.type === import_constants5.PermissionTypes.DeviceGroup ? {
    groups: { [permission.value]: [import_constants5.uiPermissionsById.read.value] }
  } : {}
};
var combinePermissions = (existingPermissions, additionalPermissions = {}) => Object.entries(additionalPermissions).reduce((accu, [name, permissions]) => {
  const maybeExistingPermissions = accu[name] || [];
  accu[name] = [...permissions, ...maybeExistingPermissions].filter(import_helpers9.duplicateFilter);
  return accu;
}, existingPermissions);
var tryParseCustomPermission = (permission) => {
  const uiPermissions = permissionActionTypes[permission.action](permission.object);
  const result = mergePermissions({ ...import_constants5.emptyUiPermissions }, uiPermissions);
  return { isCustom: true, permission, result };
};
var customPermissionHandler = (accu, permission) => {
  const processor = tryParseCustomPermission(permission);
  return {
    ...accu,
    isCustom: accu.isCustom || processor.isCustom,
    uiPermissions: mergePermissions(accu.uiPermissions, processor.result)
  };
};
var mapPermissionSet = (permissionSetName, names, scope, existingGroupsPermissions = {}) => {
  const permission = Object.values(import_constants5.uiPermissionsById).find((permission2) => permission2.permissionSets[scope] === permissionSetName)?.value;
  const scopedPermissions = names.reduce((accu, name) => combinePermissions(accu, { [name]: [permission] }), existingGroupsPermissions);
  return Object.entries(scopedPermissions).reduce((accu, [key, permissions]) => ({ ...accu, [key]: deriveImpliedAreaPermissions(scope, permissions) }), {});
};
var isEmptyPermissionSet = (permissionSet) => !Object.values(permissionSet).reduce((accu, permissions) => {
  if (Array.isArray(permissions)) {
    return accu || !!permissions.length;
  }
  return accu || !(0, import_helpers9.isEmpty)(permissions);
}, false);
var parseRolePermissions = ({ permission_sets_with_scope = [], permissions = [] }, permissionSets) => {
  const preliminaryResult = permission_sets_with_scope.reduce(
    (accu, permissionSet) => {
      const processor = permissionSets[permissionSet.name];
      if (!processor) {
        return accu;
      }
      const scope = Object.keys(import_constants5.scopedPermissionAreas).find((scope2) => import_constants5.uiPermissionsByArea[scope2].scope === permissionSet.scope?.type);
      if (scope) {
        const result = mapPermissionSet(
          permissionSet.name,
          permissionSet.scope.value,
          scope,
          accu.uiPermissions[scope]
        );
        return { ...accu, uiPermissions: { ...accu.uiPermissions, [scope]: result } };
      } else if (isEmptyPermissionSet(processor.result)) {
        return processor.permissions?.reduce(customPermissionHandler, accu);
      }
      return {
        ...accu,
        isCustom: accu.isCustom || processor.isCustom,
        uiPermissions: mergePermissions(accu.uiPermissions, processor.result)
      };
    },
    { isCustom: false, uiPermissions: { ...import_constants5.emptyUiPermissions, groups: {}, releases: {} } }
  );
  return permissions.reduce(customPermissionHandler, preliminaryResult);
};
var normalizeRbacRoles = (roles, rolesById2, permissionSets) => roles.reduce(
  (accu, role) => {
    let normalizedPermissions;
    let isCustom = false;
    if (rolesById2[role.name]) {
      normalizedPermissions = {
        ...rolesById2[role.name].uiPermissions,
        groups: { ...rolesById2[role.name].uiPermissions.groups },
        releases: { ...rolesById2[role.name].uiPermissions.releases }
      };
    } else {
      const result = parseRolePermissions(role, permissionSets);
      normalizedPermissions = result.uiPermissions;
      isCustom = result.isCustom;
    }
    const roleState = accu[role.name] ?? { ...import_constants5.emptyRole };
    accu[role.name] = {
      ...roleState,
      ...role,
      description: roleState.description ? roleState.description : role.description,
      editable: !import_constants5.rolesById[role.name] && !isCustom && (typeof roleState.editable !== "undefined" ? roleState.editable : true),
      isCustom,
      name: roleState.name ? roleState.name : role.name,
      uiPermissions: normalizedPermissions
    };
    return accu;
  },
  { ...rolesById2 }
);
var getPermissionSets = createAppAsyncThunk(
  `${sliceName8}/getPermissionSets`,
  (_, { dispatch, getState }) => general_api_default.get(`${import_constants5.useradmApiUrlv2}/permission_sets?per_page=500`).then(({ data }) => {
    const permissionSets = data.reduce(
      (accu, permissionSet) => {
        const permissionSetState = accu[permissionSet.name] ?? {};
        let permissionSetObject = { ...permissionSetState, ...permissionSet };
        permissionSetObject.result = Object.values(import_constants5.uiPermissionsById).reduce(
          (accu2, item) => Object.entries(item.permissionSets).reduce((collector, [area, permissionSet2]) => {
            if (import_constants5.scopedPermissionAreas[area]) {
              return collector;
            }
            if (permissionSet2 === permissionSetObject.name) {
              collector[area] = [...collector[area], item.value].filter(import_helpers9.duplicateFilter);
            }
            return collector;
          }, accu2),
          { ...import_constants5.emptyUiPermissions, ...permissionSetObject.result ?? {} }
        );
        const scopes = Object.values(import_constants5.scopedPermissionAreas).reduce((accu2, { key, scopeType }) => {
          if (permissionSetObject.supported_scope_types?.includes(key) || permissionSetObject.supported_scope_types?.includes(scopeType)) {
            accu2.push(key);
          }
          return accu2;
        }, []);
        permissionSetObject = scopes.reduce((accu2, scope) => {
          accu2.result = {
            ...accu2.result,
            [scope]: mapPermissionSet(permissionSetObject.name, [import_constants5.scopedPermissionAreas[scope].excessiveAccessSelector], scope)
          };
          return accu2;
        }, permissionSetObject);
        accu[permissionSet.name] = permissionSetObject;
        return accu;
      },
      { ...getState().users.permissionSetsById }
    );
    return Promise.all([dispatch(actions8.receivedPermissionSets(permissionSets)), permissionSets]);
  }).catch(() => console.log("Permission set retrieval failed - likely accessing a non-RBAC backend"))
);
var getRoles = createAppAsyncThunk(
  `${sliceName8}/getRoles`,
  (_, { dispatch, getState }) => Promise.all([general_api_default.get(`${import_constants5.useradmApiUrlv2}/roles?per_page=500`), dispatch(getPermissionSets())]).then((results) => {
    if (!results) {
      return Promise.resolve();
    }
    const [{ data: roles }, { payload: permissionSetTasks }] = results;
    const rolesById2 = normalizeRbacRoles(roles, getRolesById(getState()), permissionSetTasks[permissionSetTasks.length - 1]);
    return Promise.resolve(dispatch(actions8.receivedRoles(rolesById2)));
  }).catch(() => console.log("Role retrieval failed - likely accessing a non-RBAC backend")).finally(() => Promise.resolve(dispatch(actions8.finishedRoleInitialization(true))))
);
var deriveImpliedAreaPermissions = (area, areaPermissions, skipPermissions = []) => {
  const highestAreaPermissionLevelSelected = areaPermissions.reduce(
    (highest, current) => import_constants5.uiPermissionsById[current].permissionLevel > highest ? import_constants5.uiPermissionsById[current].permissionLevel : highest,
    1
  );
  return import_constants5.uiPermissionsByArea[area].uiPermissions.reduce((permissions, current) => {
    if ((current.permissionLevel < highestAreaPermissionLevelSelected || areaPermissions.includes(current.value)) && !skipPermissions.includes(current.value)) {
      permissions.push(current.value);
    }
    return permissions;
  }, []);
};
var transformAreaRoleDataToScopedPermissionsSets = (area, areaPermissions, excessiveAccessSelector) => {
  const permissionSetObject = areaPermissions.reduce((accu, { item, uiPermissions }) => {
    const skipPermissions = import_constants5.scopedPermissionAreas.releases.key === area && item !== import_constants5.ALL_RELEASES ? [import_constants5.uiPermissionsById.upload.value] : [];
    const impliedPermissions = deriveImpliedAreaPermissions(area, uiPermissions, skipPermissions);
    accu = impliedPermissions.reduce((itemPermissionAccu, impliedPermission) => {
      const permissionSetState = itemPermissionAccu[import_constants5.uiPermissionsById[impliedPermission].permissionSets[area]] ?? {
        type: import_constants5.uiPermissionsByArea[area].scope,
        value: []
      };
      itemPermissionAccu[import_constants5.uiPermissionsById[impliedPermission].permissionSets[area]] = {
        ...permissionSetState,
        value: [...permissionSetState.value, item]
      };
      return itemPermissionAccu;
    }, accu);
    return accu;
  }, {});
  return Object.entries(permissionSetObject).map(([name, { value, ...scope }]) => {
    if (value.includes(excessiveAccessSelector)) {
      return { name };
    }
    return { name, scope: { ...scope, value: value.filter(import_helpers9.duplicateFilter) } };
  });
};
var transformRoleDataToRole = (roleData, roleState = {}) => {
  const role = { ...roleState, ...roleData };
  const { description = "", name, uiPermissions = import_constants5.emptyUiPermissions } = role;
  const { maybeUiPermissions, remainderKeys } = Object.entries(import_constants5.emptyUiPermissions).reduce(
    (accu, [key, emptyPermissions]) => {
      if (!import_constants5.scopedPermissionAreas[key]) {
        accu.remainderKeys.push(key);
      } else if (uiPermissions[key]) {
        accu.maybeUiPermissions[key] = uiPermissions[key].reduce(itemUiPermissionsReducer, emptyPermissions);
      }
      return accu;
    },
    { maybeUiPermissions: {}, remainderKeys: [] }
  );
  const { permissionSetsWithScope, roleUiPermissions } = remainderKeys.reduce(
    (accu, area) => {
      const areaPermissions = role.uiPermissions[area];
      if (!Array.isArray(areaPermissions)) {
        return accu;
      }
      const impliedPermissions = deriveImpliedAreaPermissions(area, areaPermissions);
      accu.roleUiPermissions[area] = impliedPermissions;
      const mappedPermissions = impliedPermissions.map((uiPermission) => ({ name: import_constants5.uiPermissionsById[uiPermission].permissionSets[area] }));
      accu.permissionSetsWithScope.push(...mappedPermissions);
      return accu;
    },
    { permissionSetsWithScope: [{ name: import_constants5.defaultPermissionSets.Basic.name }], roleUiPermissions: {} }
  );
  const scopedPermissionSets = Object.values(import_constants5.scopedPermissionAreas).reduce((accu, { key, excessiveAccessSelector }) => {
    if (!uiPermissions[key]) {
      return accu;
    }
    accu.push(
      ...transformAreaRoleDataToScopedPermissionsSets(
        key,
        uiPermissions[key],
        excessiveAccessSelector
      )
    );
    return accu;
  }, []);
  return {
    permissionSetsWithScope: [...permissionSetsWithScope, ...scopedPermissionSets],
    role: {
      ...import_constants5.emptyRole,
      name,
      description: description ? description : roleState.description || "",
      uiPermissions: {
        ...import_constants5.emptyUiPermissions,
        ...roleUiPermissions,
        ...maybeUiPermissions
      }
    }
  };
};
var roleActions = {
  create: {
    successMessage: "The role was created successfully.",
    errorMessage: "creating"
  },
  edit: {
    successMessage: "The role has been updated.",
    errorMessage: "editing"
  },
  remove: {
    successMessage: "The role was deleted successfully.",
    errorMessage: "removing"
  }
};
var roleActionErrorHandler = (err, type, dispatch, meta) => {
  let errorContext = `There was an error ${roleActions[type].errorMessage} the role.`;
  if (meta) {
    const { permissionSetsCreated, name } = meta;
    errorContext += ` Tried to ${type} role ${name} with ${permissionSetsCreated} permission sets.`;
  }
  return commonErrorHandler(err, errorContext, dispatch);
};
var createRole = createAppAsyncThunk(`${sliceName8}/createRole`, (roleData, { dispatch }) => {
  const { permissionSetsWithScope, role } = transformRoleDataToRole(roleData);
  return general_api_default.post(`${import_constants5.useradmApiUrlv2}/roles`, {
    name: role.name,
    description: role.description,
    permission_sets_with_scope: permissionSetsWithScope
  }).then(() => Promise.all([dispatch(actions8.createdRole(role)), dispatch(getRoles()), dispatch(setSnackbar3(roleActions.create.successMessage))])).catch((err) => roleActionErrorHandler(err, "create", dispatch, { permissionSetsCreated: permissionSetsWithScope.length, name: role.name }));
});
var editRole = createAppAsyncThunk(`${sliceName8}/editRole`, (roleData, { dispatch, getState }) => {
  const { permissionSetsWithScope, role } = transformRoleDataToRole(roleData, getRolesById(getState())[roleData.name]);
  return general_api_default.put(`${import_constants5.useradmApiUrlv2}/roles/${role.name}`, {
    description: role.description,
    name: role.name,
    permission_sets_with_scope: permissionSetsWithScope
  }).then(() => Promise.all([dispatch(actions8.createdRole(role)), dispatch(getRoles()), dispatch(setSnackbar3(roleActions.edit.successMessage))])).catch((err) => roleActionErrorHandler(err, "edit", dispatch, { permissionSetsCreated: permissionSetsWithScope.length, name: role.name }));
});
var removeRole = createAppAsyncThunk(
  `${sliceName8}/removeRole`,
  (roleId, { dispatch }) => general_api_default.delete(`${import_constants5.useradmApiUrlv2}/roles/${roleId}`).then(() => Promise.all([dispatch(actions8.removedRole(roleId)), dispatch(getRoles()), dispatch(setSnackbar3(roleActions.remove.successMessage))])).catch((err) => roleActionErrorHandler(err, "remove", dispatch))
);
var getGlobalSettings2 = createAppAsyncThunk(
  `${sliceName8}/getGlobalSettings`,
  (_, { dispatch }) => general_api_default.get(`${import_constants5.useradmApiUrl}/settings`).then(({ data: settings, headers: { etag } }) => {
    window.sessionStorage.setItem(settingsKeys.initialized, "true");
    return Promise.all([dispatch(actions8.setGlobalSettings(settings)), dispatch(setOfflineThreshold()), etag]);
  })
);
var saveGlobalSettings = createAppAsyncThunk(
  `${sliceName8}/saveGlobalSettings`,
  ({ beOptimistic = false, notify = false, ...settings }, { dispatch, getState }) => {
    if (!window.sessionStorage.getItem(settingsKeys.initialized) && !beOptimistic) {
      return;
    }
    return dispatch(getGlobalSettings2()).unwrap().then((result) => {
      const updatedSettings = { ...getState().users.globalSettings, ...settings };
      if (getCurrentUser(getState()).verified) {
        updatedSettings["2fa"] = import_constants5.twoFAStates.enabled;
      } else {
        delete updatedSettings["2fa"];
      }
      const tasks = [dispatch(actions8.setGlobalSettings(updatedSettings))];
      const headers = result[result.length - 1] ? { "If-Match": result[result.length - 1] } : {};
      return general_api_default.post(`${import_constants5.useradmApiUrl}/settings`, updatedSettings, { headers }).then(() => {
        if (notify) {
          tasks.push(dispatch(setSnackbar3("Settings saved successfully")));
        }
        return Promise.all(tasks);
      }).catch((err) => {
        if (beOptimistic) {
          return Promise.all([tasks]);
        }
        console.log(err);
        return commonErrorHandler(err, `The settings couldn't be saved.`, dispatch);
      });
    });
  }
);
var getUserSettings2 = createAppAsyncThunk(
  `${sliceName8}/getUserSettings`,
  (_, { dispatch }) => general_api_default.get(`${import_constants5.useradmApiUrl}/settings/me`).then(({ data: settings, headers: { etag } }) => {
    window.sessionStorage.setItem(settingsKeys.initialized, "true");
    return Promise.all([dispatch(actions8.setUserSettings(settings)), etag]);
  })
);
var saveUserSettings = createAppAsyncThunk(
  `${sliceName8}/saveUserSettings`,
  (settings = { onboarding: {} }, { dispatch, getState }) => {
    if (!getCurrentUser(getState()).id) {
      return Promise.resolve();
    }
    return dispatch(getUserSettings2()).unwrap().then((result) => {
      const userSettings = getUserSettings(getState());
      const onboardingState = getOnboardingState(getState());
      const tooltipState = getTooltipsState(getState());
      const updatedSettings = {
        ...userSettings,
        ...settings,
        onboarding: {
          ...onboardingState,
          ...settings.onboarding
        },
        tooltips: tooltipState
      };
      const headers = result[result.length - 1] ? { "If-Match": result[result.length - 1] } : {};
      return Promise.all([
        Promise.resolve(dispatch(actions8.setUserSettings(updatedSettings))),
        general_api_default.post(`${import_constants5.useradmApiUrl}/settings/me`, updatedSettings, { headers })
      ]).catch(() => dispatch(actions8.setUserSettings(userSettings)));
    });
  }
);
var get2FAQRCode = createAppAsyncThunk(
  `${sliceName8}/get2FAQRCode`,
  (_, { dispatch }) => general_api_default.get(`${import_constants5.useradmApiUrl}/2faqr`).then((res) => dispatch(actions8.receivedQrCode(res.data.qr)))
);
var setHideAnnouncement = createAppAsyncThunk(
  `${sliceName8}/setHideAnnouncement`,
  ({ shouldHide, userId }, { dispatch, getState }) => {
    const currentUserId = userId || getCurrentUser(getState()).id;
    const hash = getState().app.hostedAnnouncement ? (0, import_md5.default)(getState().app.hostedAnnouncement) : "";
    const announceCookie = cookies3.get(`${currentUserId}${hash}`);
    if (shouldHide || hash.length && typeof announceCookie !== "undefined") {
      cookies3.set(`${currentUserId}${hash}`, true, { maxAge: 604800 });
      dispatch(setAnnouncement(""));
    }
  }
);
var getTokens = createAppAsyncThunk(
  `${sliceName8}/getTokens`,
  (_, { dispatch, getState }) => general_api_default.get(`${import_constants5.useradmApiUrl}/settings/tokens`).then(({ data: tokens }) => {
    const user = getCurrentUser(getState());
    const updatedUser = {
      ...user,
      tokens
    };
    return Promise.resolve(dispatch(actions8.updatedUser(updatedUser)));
  })
);
var ONE_YEAR = 31536e3;
var generateToken = createAppAsyncThunk(
  `${sliceName8}/generateToken`,
  ({ expiresIn = ONE_YEAR, name }, { dispatch }) => general_api_default.post(`${import_constants5.useradmApiUrl}/settings/tokens`, { name, expires_in: expiresIn }).then(({ data: token }) => Promise.all([dispatch(getTokens()), token])).catch((err) => commonErrorHandler(err, "There was an error creating the token:", dispatch))
);
var revokeToken = createAppAsyncThunk(
  `${sliceName8}/revokeToken`,
  (token, { dispatch }) => general_api_default.delete(`${import_constants5.useradmApiUrl}/settings/tokens/${token.id}`).then(() => Promise.resolve(dispatch(getTokens())))
);
var setTooltipReadState = createAppAsyncThunk(
  `${sliceName8}/setTooltipReadState`,
  async ({ persist, ...remainder }, { dispatch }) => {
    dispatch(actions8.setTooltipState(remainder));
    if (persist) {
      await dispatch(saveUserSettings());
    }
  }
);
var setAllTooltipsReadState = createAppAsyncThunk(
  `${sliceName8}/toggleHelptips`,
  ({ readState = READ_STATES.read, tooltipIds }, { dispatch }) => {
    const updatedTips = tooltipIds.reduce((accu, id) => ({ ...accu, [id]: { readState } }), {});
    return Promise.resolve(dispatch(actions8.setTooltipsState(updatedTips))).then(() => dispatch(saveUserSettings()));
  }
);
var submitFeedback = createAppAsyncThunk(
  `${sliceName8}/submitFeedback`,
  ({ satisfaction, feedback, ...meta }, { dispatch }) => general_api_default.post(`${import_constants5.tenantadmApiUrlv2}/contact/support`, {
    subject: "feedback submission",
    body: JSON.stringify({ feedback, satisfaction, meta })
  }).then(() => {
    const today = /* @__PURE__ */ new Date();
    dispatch(saveUserSettings({ feedbackCollectedAt: today.toISOString().split("T")[0] }));
    setTimeout(() => dispatch(actions8.setShowFeedbackDialog(false)), TIMEOUTS.threeSeconds);
  })
);

// src/deploymentsSlice/thunks.ts
var { isUUID } = import_validator.default;
var { receivedDevice, setSnackbar: setSnackbar4 } = actions_default;
var { page: defaultPage3, perPage: defaultPerPage3 } = import_constants5.DEVICE_LIST_DEFAULTS;
var deriveDeploymentGroup = ({ filter, group, groups = [], name }) => group || groups.length === 1 && !isUUID(name) ? groups[0] : filter?.name;
var transformDeployments = (deployments, deploymentsById) => deployments.sort((0, import_helpers10.customSort)(true, "created")).reduce(
  (accu, item) => {
    const filter = item.filter;
    let deployment = {
      ...deploymentPrototype,
      ...deploymentsById[item.id],
      ...item,
      filter: filter ? { ...filter, name: filter.name ?? filter.id, filters: mapTermsToFilters(filter.terms) } : void 0,
      name: decodeURIComponent(item.name)
    };
    deployment = { ...deployment, group: deriveDeploymentGroup(deployment) };
    accu.deployments[item.id] = deployment;
    accu.deploymentIds.push(item.id);
    return accu;
  },
  { deployments: {}, deploymentIds: [] }
);
var getDeploymentsByStatus2 = createAppAsyncThunk(
  `${sliceName}/getDeploymentsByStatus`,
  (options, { dispatch, getState }) => {
    const { status, page = defaultPage3, perPage = defaultPerPage3, startDate, endDate, group, type, shouldSelect = true, sort = import_constants5.SORTING_OPTIONS.desc } = options;
    const created_after = startDate ? `&created_after=${startDate}` : "";
    const created_before = endDate ? `&created_before=${endDate}` : "";
    const search = group ? `&search=${group}` : "";
    const typeFilter = type ? `&type=${type}` : "";
    return general_api_default.get(
      `${import_constants5.deploymentsApiUrl}/deployments?status=${status}&per_page=${perPage}&page=${page}${created_after}${created_before}${search}${typeFilter}&sort=${sort}`
    ).then((res) => {
      const { deployments, deploymentIds } = transformDeployments(res.data, getState().deployments.byId);
      const total = Number(res.headers[import_constants5.headerNames.total]);
      let tasks = [
        dispatch(actions.receivedDeployments(deployments)),
        dispatch(
          actions.receivedDeploymentsForStatus({
            deploymentIds,
            status,
            total: !(startDate || endDate || group || type) ? total : getState().deployments.byStatus[status].total
          })
        )
      ];
      tasks = deploymentIds.reduce((accu, deploymentId) => {
        if (deployments[deploymentId].type === DEPLOYMENT_TYPES.configuration) {
          accu.push(dispatch(getSingleDeployment(deploymentId)));
        }
        return accu;
      }, tasks);
      if (shouldSelect) {
        tasks.push(dispatch(actions.selectDeploymentsForStatus({ deploymentIds, status, total })));
      }
      tasks.push({ deploymentIds, total });
      return Promise.all(tasks);
    });
  }
);
var isWithinFirstMonth = (expirationDate) => {
  if (!expirationDate) {
    return false;
  }
  const endOfFirstMonth = new Date(expirationDate);
  endOfFirstMonth.setMonth(endOfFirstMonth.getMonth() - 11);
  return endOfFirstMonth > /* @__PURE__ */ new Date();
};
var trackDeploymentCreation = (totalDeploymentCount, hasDeployments, trial_expiration) => {
  import_tracking.default.event({ category: "deployments", action: "create" });
  if (!totalDeploymentCount) {
    if (!hasDeployments) {
      import_tracking.default.event({ category: "deployments", action: "create_initial_deployment" });
      if (isWithinFirstMonth(trial_expiration)) {
        import_tracking.default.event({ category: "deployments", action: "create_initial_deployment_first_month" });
      }
    }
    import_tracking.default.event({ category: "deployments", action: "create_initial_deployment_user" });
  }
};
var MAX_PREVIOUS_PHASES_COUNT = 5;
var createDeployment = createAppAsyncThunk(
  `${sliceName}/createDeployment`,
  ({
    newDeployment,
    hasNewRetryDefault = false
  }, { dispatch, getState }) => {
    let request;
    if ("filter_id" in newDeployment && newDeployment.filter_id) {
      request = general_api_default.post(`${import_constants5.deploymentsApiUrlV2}/deployments`, newDeployment);
    } else if ("group" in newDeployment && newDeployment.group) {
      request = general_api_default.post(`${import_constants5.deploymentsApiUrl}/deployments/group/${newDeployment.group}`, newDeployment);
    } else {
      request = general_api_default.post(`${import_constants5.deploymentsApiUrl}/deployments`, newDeployment);
    }
    const totalDeploymentCount = Object.values(getDeploymentsByStatus(getState())).reduce(
      (accu, item) => accu + item.total,
      0
    );
    const { hasDeployments } = getGlobalSettings(getState());
    const { trial_expiration } = getOrganization(getState());
    return request.catch((err) => commonErrorHandler(err, "Error creating deployment.", dispatch)).then((data) => {
      const lastslashindex = data.headers.location.lastIndexOf("/");
      const deploymentId = data.headers.location.substring(lastslashindex + 1);
      const deployment = {
        ...newDeployment,
        id: deploymentId,
        devices: "devices" in newDeployment && newDeployment.devices ? newDeployment.devices.map((id) => ({ id, status: "pending" })) : [],
        statistics: { status: {} }
      };
      const tasks = [
        dispatch(actions.createdDeployment(deployment)),
        dispatch(getSingleDeployment(deploymentId)),
        dispatch(setSnackbar4({ message: "Deployment created successfully", autoHideDuration: TIMEOUTS.fiveSeconds }))
      ];
      trackDeploymentCreation(totalDeploymentCount, hasDeployments, trial_expiration);
      const { canManageUsers } = getUserCapabilities(getState());
      if (canManageUsers) {
        const { phases, retries } = newDeployment;
        const { previousPhases = [], retries: previousRetries = 0 } = getGlobalSettings(getState());
        const newSettings = { retries: hasNewRetryDefault ? retries : previousRetries, hasDeployments: true };
        if (phases) {
          const standardPhases = (0, import_helpers10.standardizePhases)(phases);
          const prevPhases = previousPhases.map(import_helpers10.standardizePhases);
          if (!prevPhases.find((previousPhaseList) => previousPhaseList.every((oldPhase) => standardPhases.find((phase) => (0, import_helpers10.deepCompare)(phase, oldPhase))))) {
            prevPhases.push(standardPhases);
          }
          newSettings.previousPhases = prevPhases.slice(-1 * MAX_PREVIOUS_PHASES_COUNT);
        }
        tasks.push(dispatch(saveGlobalSettings(newSettings)));
      }
      return Promise.all(tasks);
    });
  }
);
var getDeploymentDevices = createAppAsyncThunk(
  `${sliceName}/getDeploymentDevices`,
  (options, { dispatch, getState }) => {
    const { id, page = defaultPage3, perPage = defaultPerPage3 } = options;
    return general_api_default.get(`${import_constants5.deploymentsApiUrl}/deployments/${id}/devices/list?&page=${page}&per_page=${perPage}`).then((response) => {
      const { devices: deploymentDevices = {} } = getState().deployments.byId[id] || {};
      const devices = response.data.reduce((accu, item) => {
        accu[item.id] = item;
        const log = (deploymentDevices[item.id] || {}).log;
        if (log) {
          accu[item.id].log = log;
        }
        return accu;
      }, {});
      const selectedDeviceIds = Object.keys(devices);
      let tasks = [
        dispatch(
          actions.receivedDeploymentDevices({
            id,
            devices,
            selectedDeviceIds,
            totalDeviceCount: Number(response.headers[import_constants5.headerNames.total])
          })
        )
      ];
      const devicesById = getDevicesById(getState());
      const lackingData = selectedDeviceIds.reduce((accu, deviceId) => {
        const device = devicesById[deviceId];
        if (!device || !device.identity_data || !device.attributes || Object.keys(device.attributes).length === 0) {
          accu.push(deviceId);
        }
        return accu;
      }, []);
      tasks = lackingData.reduce((accu, deviceId) => [...accu, dispatch(getDeviceById2(deviceId)), dispatch(getDeviceAuth(deviceId))], tasks);
      return Promise.all(tasks);
    });
  }
);
var parseDeviceDeployment = ({
  deployment: { id, artifact_name: release, status: deploymentStatus },
  device: { created, deleted, id: deviceId, finished, status, log }
}) => ({
  id,
  release,
  created,
  deleted,
  deviceId,
  finished,
  status,
  log,
  route: Object.values(DEPLOYMENT_ROUTES).reduce((accu, { key, states }) => {
    if (!accu) {
      return states.includes(deploymentStatus) ? key : accu;
    }
    return accu;
  }, "")
});
var getDeviceDeployments = createAppAsyncThunk(`${sliceName}/getDeviceDeployments`, (options, { dispatch }) => {
  const { deviceId, filterSelection = [], page = defaultPage3, perPage = defaultPerPage3 } = options;
  const filters = filterSelection.map((item) => `&status=${item}`).join("");
  return general_api_default.get(`${import_constants5.deploymentsApiUrl}/deployments/devices/${deviceId}?page=${page}&per_page=${perPage}${filters}`).then(
    ({ data, headers }) => Promise.resolve(
      dispatch(
        receivedDevice({
          id: deviceId,
          deviceDeployments: data.map(parseDeviceDeployment),
          deploymentsCount: Number(headers[import_constants5.headerNames.total])
        })
      )
    )
  ).catch((err) => commonErrorHandler(err, "There was an error retrieving the device deployment history:", dispatch));
});
var resetDeviceDeployments = createAppAsyncThunk(
  `${sliceName}/resetDeviceDeployments`,
  (deviceId, { dispatch }) => general_api_default.delete(`${import_constants5.deploymentsApiUrl}/deployments/devices/${deviceId}/history`).then(() => Promise.resolve(dispatch(getDeviceDeployments({ deviceId })))).catch((err) => commonErrorHandler(err, "There was an error resetting the device deployment history:", dispatch))
);
var getSingleDeployment = createAppAsyncThunk(
  `${sliceName}/getSingleDeployment`,
  (id, { dispatch, getState }) => general_api_default.get(`${import_constants5.deploymentsApiUrl}/deployments/${id}`).then(({ data }) => {
    const { deployments } = transformDeployments([data], getState().deployments.byId);
    return Promise.resolve(dispatch(actions.receivedDeployment(deployments[id])));
  })
);
var getDeviceLog = createAppAsyncThunk(
  `${sliceName}/getDeviceLog`,
  ({ deploymentId, deviceId }, { dispatch }) => general_api_default.get(`${import_constants5.deploymentsApiUrl}/deployments/${deploymentId}/devices/${deviceId}/log`).catch((e) => {
    console.log("no log here", e);
    return Promise.reject();
  }).then(
    ({ data: log }) => Promise.all([Promise.resolve(dispatch(actions.receivedDeploymentDeviceLog({ id: deploymentId, deviceId, log }))), Promise.resolve(log)])
  )
);
var abortDeployment = createAppAsyncThunk(
  `${sliceName}/abortDeployment`,
  (deploymentId, { dispatch, getState }) => general_api_default.put(`${import_constants5.deploymentsApiUrl}/deployments/${deploymentId}/status`, { status: "aborted" }).then(() => {
    const deploymentsByStatus = getDeploymentsByStatus(getState());
    let status = DEPLOYMENT_STATES.pending;
    let index = deploymentsByStatus.pending.deploymentIds.findIndex((id) => id === deploymentId);
    if (index < 0) {
      status = DEPLOYMENT_STATES.inprogress;
      index = deploymentsByStatus.inprogress.deploymentIds.findIndex((id) => id === deploymentId);
    }
    const deploymentIds = [...deploymentsByStatus[status].deploymentIds.slice(0, index), ...deploymentsByStatus[status].deploymentIds.slice(index + 1)];
    const deploymentsById = getDeploymentsById(getState());
    const deployments = deploymentIds.reduce((accu, id) => {
      accu[id] = deploymentsById[id];
      return accu;
    }, {});
    const total = Math.max(deploymentsByStatus[status].total - 1, 0);
    return Promise.all([
      dispatch(actions.receivedDeployments(deployments)),
      dispatch(actions.receivedDeploymentsForStatus({ deploymentIds, status, total })),
      dispatch(actions.removedDeployment(deploymentId)),
      dispatch(setSnackbar4("The deployment was successfully aborted"))
    ]);
  }).catch((err) => commonErrorHandler(err, "There was an error while aborting the deployment:", dispatch))
);
var updateDeploymentControlMap = createAppAsyncThunk(
  `${sliceName}/updateDeploymentControlMap`,
  ({ deploymentId, updateControlMap }, { dispatch }) => general_api_default.patch(`${import_constants5.deploymentsApiUrl}/deployments/${deploymentId}`, { update_control_map: updateControlMap }).catch((err) => commonErrorHandler(err, "There was an error while updating the deployment status:", dispatch)).then(() => Promise.resolve(dispatch(getSingleDeployment(deploymentId))))
);
var setDeploymentsState = createAppAsyncThunk(`${sliceName}/setDeploymentsState`, (selection, { dispatch, getState }) => {
  const { page, perPage, ...selectionState } = selection;
  const currentState = getState().deployments.selectionState;
  const nextState = {
    ...currentState,
    ...selectionState,
    ...Object.keys(DEPLOYMENT_STATES).reduce((accu, item) => {
      accu[item] = {
        ...currentState[item],
        ...selectionState[item]
      };
      return accu;
    }, {}),
    general: {
      ...currentState.general,
      ...selectionState.general
    }
  };
  const tasks = [dispatch(actions.setDeploymentsState(nextState))];
  if (nextState.selectedId && currentState.selectedId !== nextState.selectedId) {
    tasks.push(dispatch(getSingleDeployment(nextState.selectedId)));
  }
  return Promise.all(tasks);
});
var deltaAttributeMappings = [
  { here: "compressionLevel", there: "compression_level" },
  { here: "disableChecksum", there: "disable_checksum" },
  { here: "disableDecompression", there: "disable_external_decompression" },
  { here: "sourceWindow", there: "source_window_size" },
  { here: "inputWindow", there: "input_window_size" },
  { here: "duplicatesWindow", there: "compression_duplicates_window" },
  { here: "instructionBuffer", there: "instruction_buffer_size" }
];
var mapExternalDeltaConfig = (config = {}) => deltaAttributeMappings.reduce((accu, { here, there }) => {
  if (config[there] !== void 0) {
    accu[here] = config[there];
  }
  return accu;
}, {});
var getDeploymentsConfig = createAppAsyncThunk(
  `${sliceName}/getDeploymentsConfig`,
  (_, { dispatch, getState }) => general_api_default.get(`${import_constants5.deploymentsApiUrl}/config`).then(({ data }) => {
    const oldConfig = getState().deployments.config;
    const { delta = {} } = data;
    const { binary_delta = {}, binary_delta_limits = {} } = delta;
    const { xdelta_args = {} } = binary_delta;
    const { xdelta_args_limits = {} } = binary_delta_limits;
    const config = {
      ...oldConfig,
      hasDelta: Boolean(delta.enabled),
      binaryDelta: {
        ...oldConfig.binaryDelta,
        ...mapExternalDeltaConfig(xdelta_args)
      },
      binaryDeltaLimits: {
        ...oldConfig.binaryDeltaLimits,
        ...mapExternalDeltaConfig(xdelta_args_limits)
      }
    };
    return Promise.resolve(dispatch(actions.setDeploymentsConfig(config)));
  })
);
var deepClean = (source) => Object.entries(source).reduce((accu, [key, value]) => {
  if (value !== void 0) {
    const cleanedValue = typeof value === "object" ? deepClean(value) : value;
    if (cleanedValue === void 0 || typeof cleanedValue === "object" && (0, import_helpers10.isEmpty)(cleanedValue)) {
      return accu;
    }
    accu = { ...accu ?? {}, [key]: cleanedValue };
  }
  return accu;
}, void 0);
var saveDeltaDeploymentsConfig = createAppAsyncThunk(
  `${sliceName}/saveDeltaDeploymentsConfig`,
  (config, { dispatch, getState }) => {
    const configChange = {
      xdelta_args: deltaAttributeMappings.reduce((accu, { here, there }) => {
        if (config[here] !== void 0) {
          accu[there] = config[here];
        }
        return accu;
      }, {})
    };
    const result = deepClean(configChange);
    if (!result) {
      return Promise.resolve();
    }
    return general_api_default.put(`${import_constants5.deploymentsApiUrl}/config/binary_delta`, result).catch((err) => commonErrorHandler(err, "There was a problem storing your delta artifact generation configuration.", dispatch)).then(() => {
      const oldConfig = getState().deployments.config;
      const newConfig = {
        ...oldConfig,
        binaryDelta: {
          ...oldConfig.binaryDelta,
          ...config
        }
      };
      return Promise.all([dispatch(actions.setDeploymentsConfig(newConfig)), dispatch(setSnackbar4("Settings saved successfully"))]);
    });
  }
);
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  abortDeployment,
  createDeployment,
  deriveDeploymentGroup,
  getDeploymentDevices,
  getDeploymentsByStatus,
  getDeploymentsConfig,
  getDeviceDeployments,
  getDeviceLog,
  getSingleDeployment,
  resetDeviceDeployments,
  saveDeltaDeploymentsConfig,
  setDeploymentsState,
  updateDeploymentControlMap
});
//# sourceMappingURL=thunks.cjs.map