import {
  initialState
} from "../chunk-ABJLRDCO.js";
import {
  DEVICE_STATES,
  SORTING_OPTIONS
} from "../chunk-7C4SQBEE.js";
import "../chunk-2DYA3X77.js";
import "../chunk-FAJ3I2UQ.js";
import "../chunk-ZKAH3APE.js";
import "../chunk-HFOTAPIJ.js";

// src/devicesSlice/mocks.ts
var deviceTypes = { qemu: "qemux86-64" };
var checkInTimeRounded = "2019-01-01T00:00:00.000Z";
var checkInTimeExact = "2019-01-01T10:25:00.000Z";
var defaultMacAddress = "dc:a6:32:12:ad:bf";
var defaultCreationDate = "2019-01-13T06:25:00.000Z";
var mockState = {
  ...initialState,
  byId: {
    a1: {
      id: "a1",
      attributes: {
        device_type: ["raspberrypi4"],
        ipv4_wlan0: "192.168.10.141/24"
      },
      system: {
        check_in_time: checkInTimeRounded
      },
      check_in_time: checkInTimeExact,
      check_in_time_exact: checkInTimeExact,
      check_in_time_rounded: checkInTimeRounded,
      identity_data: { mac: defaultMacAddress },
      status: "accepted",
      decommissioning: false,
      created_ts: defaultCreationDate,
      updated_ts: "2019-01-01T09:25:00.000Z",
      auth_sets: [
        {
          id: "auth1",
          identity_data: { mac: defaultMacAddress },
          pubkey: "-----BEGIN PUBLIC KEY-----\nMIIBojWELzgJ62hcXIhAfqfoNiaB1326XZByZwcnHr5BuSPAgMBAAE=\n-----END PUBLIC KEY-----\n",
          ts: defaultCreationDate,
          status: "accepted"
        }
      ]
    },
    b1: {
      id: "b1",
      attributes: {
        ipv4_wlan0: "192.168.10.141/24",
        device_type: [deviceTypes.qemu]
      },
      system: {
        check_in_time: checkInTimeRounded
      },
      check_in_time: checkInTimeExact,
      check_in_time_exact: checkInTimeExact,
      check_in_time_rounded: checkInTimeRounded,
      identity_data: { mac: defaultMacAddress },
      status: "accepted",
      decommissioning: false,
      created_ts: defaultCreationDate,
      updated_ts: "2019-01-01T09:25:00.000Z",
      auth_sets: [
        {
          id: "auth1",
          identity_data: { mac: defaultMacAddress },
          pubkey: "-----BEGIN PUBLIC KEY-----\nMIIBojWELzgJ62hcXIhAfqfoNiaB1326XZByZwcnHr5BuSPAgMBAAE=\n-----END PUBLIC KEY-----\n",
          ts: defaultCreationDate,
          status: "accepted"
        }
      ]
    },
    c1: {
      id: "c1",
      auth_sets: [],
      attributes: {
        device_type: ["qemux86-128"]
      }
    }
  },
  byStatus: {
    accepted: { deviceIds: ["a1", "b1"], total: 2 },
    active: { deviceIds: [], total: 0 },
    inactive: { deviceIds: [], total: 0 },
    pending: { deviceIds: ["c1"], total: 1 },
    preauthorized: { deviceIds: [], total: 0 },
    rejected: { deviceIds: [], total: 0 }
  },
  deviceList: {
    deviceIds: [],
    isLoading: false,
    page: 1,
    perPage: 20,
    selectedAttributes: [],
    selectedIssues: [],
    selection: [],
    sort: {
      direction: SORTING_OPTIONS.desc
      // key: null,
      // scope: null
    },
    state: DEVICE_STATES.accepted,
    total: 0
  },
  filteringAttributes: {
    identityAttributes: ["mac"],
    inventoryAttributes: ["artifact_name"],
    systemAttributes: [],
    tagAttributes: []
  },
  filteringAttributesLimit: 10,
  filters: [],
  groups: {
    byId: {
      testGroup: {
        deviceIds: ["a1", "b1"],
        filters: [],
        total: 2
      },
      testGroupDynamic: {
        id: "filter1",
        name: "filter1",
        filters: [{ scope: "system", key: "group", operator: "$eq", value: "things" }]
      }
    },
    selectedGroup: void 0
  },
  limit: 500
};
export {
  mockState
};
//# sourceMappingURL=mocks.js.map