import {
  commonProcessor,
  formatAuditlogs,
  formatDeployments,
  formatDeviceSearch,
  formatPageState,
  formatReleases,
  formatTenants,
  generateDeploymentsPath,
  generateDevicePath,
  generateReleasesPath,
  generateTenantPath,
  parseAuditlogsQuery,
  parseDeploymentsQuery,
  parseDeviceQuery,
  parseReleasesQuery,
  parseTenantsQuery
} from "./chunk-KC7SKI3U.js";
import "./chunk-7C4SQBEE.js";
import "./chunk-2DYA3X77.js";
import "./chunk-FAJ3I2UQ.js";
import "./chunk-ZKAH3APE.js";
import "./chunk-HFOTAPIJ.js";

// src/liststatehook.ts
import { useCallback, useMemo } from "react";
import { useLocation, useNavigate, useSearchParams } from "react-router-dom";
var defaultProcessors = {
  auditlogs: {
    format: formatAuditlogs,
    locate: () => void 0,
    parse: parseAuditlogsQuery
  },
  common: {
    format: formatPageState,
    locate: () => void 0,
    parse: commonProcessor
  },
  deployments: {
    format: formatDeployments,
    locate: generateDeploymentsPath,
    parse: parseDeploymentsQuery
  },
  devices: {
    format: formatDeviceSearch,
    locate: generateDevicePath,
    parse: parseDeviceQuery
  },
  releases: {
    format: formatReleases,
    locate: generateReleasesPath,
    parse: parseReleasesQuery
  },
  tenants: {
    format: formatTenants,
    locate: generateTenantPath,
    parse: parseTenantsQuery
  }
};
var useLocationParams = (key, extras, processors = defaultProcessors) => {
  const [searchParams] = useSearchParams();
  const navigate = useNavigate();
  const location = useLocation();
  const value = useMemo(() => {
    const { pageState, params, sort } = processors.common.parse(searchParams);
    const extendedExtras = { ...extras, pageState, location };
    return {
      ...pageState,
      sort,
      ...processors[key].parse(params, extendedExtras)
    };
  }, [JSON.stringify(extras), key, location.search, location.pathname, searchParams.toString()]);
  const setValue = useCallback(
    (newValue, options = {}) => {
      const pathname = processors[key].locate({ pageState: newValue.pageState, location });
      const searchQuery = [processors.common.format(newValue.pageState, extras), processors[key].format(newValue, extras)].filter((i) => i).join("&");
      navigate({ pathname, replace: true, search: `?${searchQuery}`, ...options });
    },
    // eslint-disable-next-line react-hooks/exhaustive-deps
    [JSON.stringify(extras), key]
  );
  return [value, setValue];
};
export {
  defaultProcessors,
  useLocationParams
};
//# sourceMappingURL=liststatehook.js.map