import { SnackbarContent } from '../appSlice/index.js';
import { DeviceFilter, Device } from '../devicesSlice/index.js';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { AppDispatch, RootState } from '../store.js';
import { Alert } from '@northern.tech/types/MenderTypes';
import { DeviceIssueOptionKey } from '@northern.tech/utils/constants';
import { AlertChannelKey } from './constants.js';
import 'redux';
import 'immer';
import '@mui/material';
import '../commonConstants.js';
import 'react/jsx-runtime';
import '../devicesSlice/constants.js';
import '../deploymentsSlice/index.js';
import 'redux-thunk';
import '../usersSlice/constants.js';
import '../usersSlice/index.js';
import '../releasesSlice/index.js';
import '../organizationSlice/types.js';
import '../appSlice/constants.js';
import '@mui/material/OverridableComponent';
import '../organizationSlice/constants.js';
import '../onboardingSlice/index.js';
import '@northern.tech/types/Alert';

interface GetDeviceAlertsPayload {
    config?: {
        issuedAfter?: string;
        issuedBefore?: string;
        page?: number;
        perPage?: number;
        sortAscending?: boolean;
    };
    id: string;
}
declare const getDeviceAlerts: _reduxjs_toolkit.AsyncThunk<[{
    payload: {
        alerts: (Alert & {
            fullName?: string;
        })[];
        deviceId: string;
    };
    type: "monitor/receiveDeviceAlerts";
}, {
    payload: any;
    type: "monitor/setAlertListState";
}], GetDeviceAlertsPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
interface GetLatestDeviceAlertsPayload {
    config?: {
        page?: number;
        perPage?: number;
    };
    id: string;
}
declare const getLatestDeviceAlerts: _reduxjs_toolkit.AsyncThunk<{
    payload: {
        alerts: (Alert & {
            fullName?: string;
        })[];
        deviceId: string;
    };
    type: "monitor/receiveLatestDeviceAlerts";
}, GetLatestDeviceAlertsPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
interface GetIssueCountsByTypePayload {
    options?: Partial<{
        filters: DeviceFilter[];
        group: string;
        status: string;
        type: string;
    }>;
    type: DeviceIssueOptionKey;
}
declare const getIssueCountsByType: _reduxjs_toolkit.AsyncThunk<any, GetIssueCountsByTypePayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDeviceMonitorConfig: _reduxjs_toolkit.AsyncThunk<[{
    payload: {
        id: string;
    } & Partial<Device>;
    type: "devices/receivedDevice";
}], string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
interface ChangeNotificationSettingPayload {
    channel?: AlertChannelKey;
    enabled: boolean;
}
declare const changeNotificationSetting: _reduxjs_toolkit.AsyncThunk<[{
    payload: {
        channel: AlertChannelKey;
        enabled: boolean;
    };
    type: "monitor/changeAlertChannel";
}, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}], ChangeNotificationSettingPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;

export { changeNotificationSetting, getDeviceAlerts, getDeviceMonitorConfig, getIssueCountsByType, getLatestDeviceAlerts };
