import { AppDispatch, RootState } from '../store.cjs';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { UserSettings } from '../usersSlice/index.cjs';
import { OnboardingApproach } from './index.cjs';
import { OnboardingStep } from './constants.cjs';
import 'redux-thunk';
import 'redux';
import '@northern.tech/utils/constants';
import '../usersSlice/constants.cjs';
import '../releasesSlice/index.cjs';
import 'immer';
import '@northern.tech/types/MenderTypes';
import '../organizationSlice/types.cjs';
import '../appSlice/constants.cjs';
import '@mui/material/OverridableComponent';
import '@mui/material';
import '../organizationSlice/constants.cjs';
import '@northern.tech/types/Alert';
import '../deploymentsSlice/index.cjs';
import '../devicesSlice/index.cjs';
import '../commonConstants.cjs';
import 'react/jsx-runtime';
import '../devicesSlice/constants.cjs';
import '../appSlice/index.cjs';

declare const getOnboardingState: _reduxjs_toolkit.AsyncThunk<[{
    payload: boolean;
    type: "onboarding/setOnboardingComplete";
}, {
    payload: Partial<{
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    }>;
    type: "onboarding/setOnboardingState";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>], void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setOnboardingDeviceType: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | string[];
    type: "onboarding/setOnboardingDeviceType";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>], string | string[], {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setOnboardingApproach: _reduxjs_toolkit.AsyncThunk<[{
    payload: OnboardingApproach;
    type: "onboarding/setOnboardingApproach";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>], OnboardingApproach, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setOnboardingComplete: _reduxjs_toolkit.AsyncThunk<any[], boolean, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setOnboardingCanceled: _reduxjs_toolkit.AsyncThunk<void, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const advanceOnboarding: _reduxjs_toolkit.AsyncThunk<[{
    payload: string;
    type: "onboarding/setOnboardingProgress";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>] | undefined, OnboardingStep, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;

export { advanceOnboarding, getOnboardingState, setOnboardingApproach, setOnboardingCanceled, setOnboardingComplete, setOnboardingDeviceType };
