import { SSOConfig, TenantList, Webhook } from './types.js';
import * as _northern_tech_types_Integration from '@northern.tech/types/Integration';
import '@northern.tech/types/MenderTypes';
import '@northern.tech/utils/constants';
import '../appSlice/constants.js';
import '@mui/material/OverridableComponent';
import '@mui/material';
import './constants.js';

declare const mockState: {
    card: {
        brand: string;
        last4: string;
        expiration: {
            month: number;
            year: number;
        };
    };
    auditlog: {
        events: ({
            actor: {
                id: string;
                type: string;
                email: string;
                identity_data?: undefined;
            };
            time: string;
            action: string;
            object: {
                id: string;
                type: string;
                user: {
                    email: string;
                };
                deployment?: undefined;
            };
            change: string;
            meta?: undefined;
        } | {
            actor: {
                id: string;
                type: string;
                email: string;
                identity_data: string;
            };
            time: string;
            action: string;
            object: {
                id: string;
                type: string;
                deployment: {
                    name: string;
                    artifact_name: string;
                };
                user?: undefined;
            };
            change: string;
            meta?: undefined;
        } | {
            actor: {
                id: string;
                type: string;
                email: string;
                identity_data?: undefined;
            };
            time: string;
            action: string;
            meta: {
                session_id: string[];
            };
            object: {
                id: string;
                type: string;
                user?: undefined;
                deployment?: undefined;
            };
            change: string;
        })[];
        selectionState: {
            detail: undefined;
            endDate: undefined;
            selectedIssue: undefined;
            startDate: undefined;
            type: undefined;
            user: undefined;
            isLoading: boolean;
            sort: {};
            total: number;
            page: number;
            perPage: number;
        };
    };
    intentId: string;
    organization: {
        addons: never[];
        id: string;
        name: string;
        plan: string;
        trial: boolean;
    };
    externalDeviceIntegrations: _northern_tech_types_Integration.Integration[];
    ssoConfigs: SSOConfig[];
    tenantList: TenantList;
    webhooks: Webhook;
};

export { mockState };
