import * as redux from 'redux';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { PayloadAction } from '@reduxjs/toolkit';
import * as immer from 'immer';
import { Release as Release$1, Artifact as Artifact$1 } from '@northern.tech/types/MenderTypes';
import { SortOptions } from '@northern.tech/utils/constants';

type Artifact = Artifact$1 & {
    installCount?: number;
    url?: string;
};
type Release = Release$1 & {
    artifacts: Artifact[];
    name: string;
};
declare const sliceName = "releases";
type ReleasesList = {
    isLoading?: boolean;
    page: number;
    perPage: number;
    releaseIds: string[];
    searchedIds: string[];
    searchOnly?: boolean;
    searchTerm: string;
    searchTotal: number;
    selectedTags: string[];
    selection: number[];
    sort?: SortOptions;
    tab?: 'releases' | 'delta';
    total: number;
    type: string;
};
type ReleaseSliceType = {
    artifacts: never[];
    byId: Record<string, Release>;
    releasesList: ReleasesList;
    selectedRelease: string | null;
    tags: string[];
    updateTypes: string[];
};
declare const initialState: ReleaseSliceType;
declare const releaseSlice: _reduxjs_toolkit.Slice<ReleaseSliceType, {
    receiveRelease: (state: immer.WritableDraft<ReleaseSliceType>, action: PayloadAction<Release>) => void;
    receiveReleases: (state: immer.WritableDraft<ReleaseSliceType>, action: PayloadAction<Record<string, Release>>) => void;
    receiveReleaseTags: (state: immer.WritableDraft<ReleaseSliceType>, action: PayloadAction<string[]>) => void;
    receiveReleaseTypes: (state: immer.WritableDraft<ReleaseSliceType>, action: PayloadAction<string[]>) => void;
    removeRelease: (state: immer.WritableDraft<ReleaseSliceType>, action: PayloadAction<string>) => void;
    selectedRelease: (state: immer.WritableDraft<ReleaseSliceType>, action: PayloadAction<string | null>) => void;
    setReleaseListState: (state: immer.WritableDraft<ReleaseSliceType>, action: PayloadAction<ReleasesList>) => void;
}, "releases", "releases", _reduxjs_toolkit.SliceSelectors<ReleaseSliceType>>;
declare const actions: _reduxjs_toolkit.CaseReducerActions<{
    receiveRelease: (state: immer.WritableDraft<ReleaseSliceType>, action: PayloadAction<Release>) => void;
    receiveReleases: (state: immer.WritableDraft<ReleaseSliceType>, action: PayloadAction<Record<string, Release>>) => void;
    receiveReleaseTags: (state: immer.WritableDraft<ReleaseSliceType>, action: PayloadAction<string[]>) => void;
    receiveReleaseTypes: (state: immer.WritableDraft<ReleaseSliceType>, action: PayloadAction<string[]>) => void;
    removeRelease: (state: immer.WritableDraft<ReleaseSliceType>, action: PayloadAction<string>) => void;
    selectedRelease: (state: immer.WritableDraft<ReleaseSliceType>, action: PayloadAction<string | null>) => void;
    setReleaseListState: (state: immer.WritableDraft<ReleaseSliceType>, action: PayloadAction<ReleasesList>) => void;
}, "releases">;
declare const _default: redux.Reducer<ReleaseSliceType>;

export { type Artifact, type Release, type ReleaseSliceType, type ReleasesList, actions, _default as default, initialState, releaseSlice, sliceName };
