"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/selectors.ts
var selectors_exports = {};
__export(selectors_exports, {
  DEPLOYMENT_CUTOFF: () => DEPLOYMENT_CUTOFF,
  getAcceptedDevices: () => getAcceptedDevices,
  getAttributesList: () => getAttributesList,
  getAttrsEndpoint: () => getAttrsEndpoint,
  getAuditLog: () => getAuditLog,
  getAuditLogEntry: () => getAuditLogEntry,
  getAuditLogSelectionState: () => getAuditLogSelectionState,
  getAuditlogDevice: () => getAuditlogDevice,
  getAuditlogState: () => getAuditlogState,
  getAvailableIssueOptionsByType: () => getAvailableIssueOptionsByType,
  getBillingProfile: () => getBillingProfile,
  getCard: () => getCard,
  getCommit: () => getCommit,
  getCurrentSession: () => getCurrentSession,
  getCurrentUser: () => getCurrentUser,
  getDemoDeviceAddress: () => getDemoDeviceAddress,
  getDeploymentRelease: () => getDeploymentRelease,
  getDeploymentsById: () => getDeploymentsById,
  getDeploymentsByStatus: () => getDeploymentsByStatus,
  getDeploymentsSelectionState: () => getDeploymentsSelectionState,
  getDeviceById: () => getDeviceById,
  getDeviceConfigDeployment: () => getDeviceConfigDeployment,
  getDeviceCountsByStatus: () => getDeviceCountsByStatus,
  getDeviceFilters: () => getDeviceFilters,
  getDeviceIdentityAttributes: () => getDeviceIdentityAttributes,
  getDeviceLimit: () => getDeviceLimit,
  getDeviceListState: () => getDeviceListState,
  getDeviceReports: () => getDeviceReports,
  getDeviceReportsForUser: () => getDeviceReportsForUser,
  getDeviceTwinIntegrations: () => getDeviceTwinIntegrations,
  getDeviceTypes: () => getDeviceTypes,
  getDevicesById: () => getDevicesById,
  getDevicesByStatus: () => getDevicesByStatus,
  getDocsVersion: () => getDocsVersion,
  getExternalIntegrations: () => getExternalIntegrations,
  getFeatures: () => getFeatures,
  getFeedbackProbability: () => getFeedbackProbability,
  getFilterAttributes: () => getFilterAttributes,
  getFilteringAttributes: () => getFilteringAttributes,
  getFullVersionInformation: () => getFullVersionInformation,
  getGlobalSettings: () => getGlobalSettings,
  getGroupData: () => getGroupData,
  getGroupNames: () => getGroupNames,
  getGroups: () => getGroups,
  getGroupsById: () => getGroupsById,
  getGroupsByIdWithoutUngrouped: () => getGroupsByIdWithoutUngrouped,
  getHas2FA: () => getHas2FA,
  getHasCurrentPricing: () => getHasCurrentPricing,
  getHasReleases: () => getHasReleases,
  getHostAddress: () => getHostAddress,
  getHostedAnnouncement: () => getHostedAnnouncement,
  getIdAttribute: () => getIdAttribute,
  getIsDarkMode: () => getIsDarkMode,
  getIsEnterprise: () => getIsEnterprise,
  getIsFirstLogin: () => getIsFirstLogin,
  getIsPreview: () => getIsPreview,
  getIsServiceProvider: () => getIsServiceProvider,
  getIsUploading: () => getIsUploading,
  getIssueCountsByType: () => getIssueCountsByType,
  getLimitMaxed: () => getLimitMaxed,
  getListedDevices: () => getListedDevices,
  getMappedDeploymentSelection: () => getMappedDeploymentSelection,
  getMappedDevicesList: () => getMappedDevicesList,
  getOfflineThresholdSettings: () => getOfflineThresholdSettings,
  getOnboarding: () => getOnboarding,
  getOnboardingState: () => getOnboardingState,
  getOrganization: () => getOrganization,
  getReadAllHelptips: () => getReadAllHelptips,
  getRecaptchaKey: () => getRecaptchaKey,
  getRecentDeployments: () => getRecentDeployments,
  getReleaseListState: () => getReleaseListState,
  getReleaseTags: () => getReleaseTags,
  getReleaseTagsById: () => getReleaseTagsById,
  getReleasesById: () => getReleasesById,
  getReleasesList: () => getReleasesList,
  getRelevantRoles: () => getRelevantRoles,
  getRolesById: () => getRolesById,
  getRolesInitialized: () => getRolesInitialized,
  getRolesList: () => getRolesList,
  getSearchEndpoint: () => getSearchEndpoint,
  getSearchState: () => getSearchState,
  getSearchedDevices: () => getSearchedDevices,
  getSelectedDeploymentData: () => getSelectedDeploymentData,
  getSelectedDeploymentDeviceIds: () => getSelectedDeploymentDeviceIds,
  getSelectedDeviceAttribute: () => getSelectedDeviceAttribute,
  getSelectedGroup: () => getSelectedGroup,
  getSelectedGroupInfo: () => getSelectedGroupInfo,
  getSelectedRelease: () => getSelectedRelease,
  getSelectedReleases: () => getSelectedReleases,
  getSentryConfig: () => getSentryConfig,
  getSnackbar: () => getSnackbar,
  getSortedFilteringAttributes: () => getSortedFilteringAttributes,
  getSsoConfig: () => getSsoConfig,
  getStripeKey: () => getStripeKey,
  getSubscription: () => getSubscription,
  getTenantCapabilities: () => getTenantCapabilities,
  getTenantsList: () => getTenantsList,
  getTooltipsById: () => getTooltipsById,
  getTooltipsState: () => getTooltipsState,
  getTrackerCode: () => getTrackerCode,
  getUpdateTypes: () => getUpdateTypes,
  getUploads: () => getUploads,
  getUserCapabilities: () => getUserCapabilities,
  getUserRoles: () => getUserRoles,
  getUserSettings: () => getUserSettings,
  getUserSettingsInitialized: () => getUserSettingsInitialized,
  getUsersById: () => getUsersById,
  getUsersList: () => getUsersList,
  getVersionInformation: () => getVersionInformation,
  getWebhookEventInfo: () => getWebhookEventInfo,
  getWebhookEventTotal: () => getWebhookEventTotal,
  getWebhookEvents: () => getWebhookEvents,
  getWebhooks: () => getWebhooks
});
module.exports = __toCommonJS(selectors_exports);

// src/appSlice/selectors.ts
var import_helpers = require("@northern.tech/utils/helpers");
var import_toolkit = require("@reduxjs/toolkit");
var getDocsVersion = (state) => state.app.docsVersion;
var getFeatures = (state) => state.app.features;
var getFullVersionInformation = (state) => state.app.versionInformation;
var getSearchState = (state) => state.app.searchState;
var getUploads = (state) => state.app.uploadsById;
var getSnackbar = (state) => state.app.snackbar;
var getHostAddress = (state) => state.app.hostAddress;
var getHostedAnnouncement = (state) => state.app.hostedAnnouncement;
var getRecaptchaKey = (state) => state.app.recaptchaSiteKey;
var getStripeKey = (state) => state.app.stripeAPIKey;
var getTrackerCode = (state) => state.app.trackerCode;
var getSentryConfig = (state) => state.app.sentry;
var getCommit = (state) => state.app.commit;
var getIsFirstLogin = (state) => state.app.firstLoginAfterSignup;
var getFeedbackProbability = (state) => state.app.feedbackProbability;
var getIsUploading = (0, import_toolkit.createSelector)([getUploads], (uploadsById) => !!Object.keys(uploadsById).length);
var getSearchedDevices = (0, import_toolkit.createSelector)([getSearchState], ({ deviceIds }) => deviceIds);
var getVersionInformation = (0, import_toolkit.createSelector)(
  [getFullVersionInformation, getFeatures],
  ({ Integration: Integration2, ...remainder }, { isHosted }) => isHosted && Integration2 !== "next" ? remainder : { ...remainder, Integration: Integration2 }
);
var getIsPreview = (0, import_toolkit.createSelector)([getFullVersionInformation], ({ Integration: Integration2 }) => (0, import_helpers.versionCompare)(Integration2, "next") > -1);

// src/commonSelectors.ts
var import_helpers4 = require("@northern.tech/utils/helpers");
var import_toolkit7 = require("@reduxjs/toolkit");

// src/appSlice/constants.ts
var import_icons_material = require("@mui/icons-material");
var startingDeviceCount = {
  os: "for first 50 devices",
  professional: "for first 250 devices"
};
var chartTypes = {
  bar: { key: "bar", Icon: import_icons_material.BarChart },
  pie: { key: "pie", Icon: import_icons_material.PieChartOutline }
};
var emptyChartSelection = { software: "", group: "", chartType: chartTypes.bar.key, attribute: "artifact_name" };
var defaultReportType = "distribution";
var defaultReports = [{ ...emptyChartSelection, group: null, attribute: "artifact_name", type: defaultReportType }];
var PLANS = {
  os: {
    id: "os",
    name: "Basic",
    minimalDeviceCount: 50,
    offer: true,
    price: "$34 / month",
    deviceCount: startingDeviceCount.os,
    description: "The core features of Mender. To continue using Enterprise Trial features\u2014like Delta updates, scheduled deployments, phased rollouts, device filtering, dynamic groups, RBAC, audit logs, and more\u2014please upgrade to a higher plan.",
    features: ["Access to core features of Mender", "Basic support"]
  },
  professional: {
    id: "professional",
    name: "Professional",
    minimalDeviceCount: 250,
    offer: true,
    price: "$291 / month",
    deviceCount: startingDeviceCount.professional,
    description: "Everything in Basic, plus enhanced update management and automation features.",
    features: ["Advanced OTA features", "Higher priority support"]
  },
  enterprise: {
    id: "enterprise",
    name: "Enterprise",
    minimalDeviceCount: 1e3,
    price: "Custom pricing",
    deviceCount: "Unlimited devices",
    description: "Every advanced feature of Mender, tailored for complex and large-scale deployments. Not available as a monthly subscription \u2014 ask us for a quote.",
    features: ["All Mender features", "Advanced security features", "SLA-backed support"]
  }
};
var ADDONS = {
  configure: {
    id: "configure",
    title: "Configure",
    description: "Expand your plan with device configuration features",
    needs: ["hasDeviceConfig"],
    os: {
      price: "$11/month",
      deviceCount: startingDeviceCount.os
    },
    professional: {
      price: "$65/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["os", "professional", "enterprise"]
  },
  monitor: {
    id: "monitor",
    title: "Monitor",
    description: "Expand your plan with device monitoring features",
    needs: ["hasMonitor"],
    os: {
      price: "-",
      deviceCount: "-"
    },
    professional: {
      price: "$86/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["professional", "enterprise"]
  },
  troubleshoot: {
    id: "troubleshoot",
    title: "Troubleshoot",
    description: "Expand your plan with device troubleshooting features",
    needs: ["hasDeviceConnect"],
    os: {
      price: "$27/month",
      deviceCount: startingDeviceCount.os
    },
    professional: {
      price: "$72/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["os", "professional", "enterprise"]
  }
};
var BENEFITS = {
  auditlog: { id: "auditlog", benefit: "trace change across your devices and access troubleshooting session replay", requiredPlan: PLANS.professional.id },
  dashboard: { id: "dashboard", benefit: "actionable insights into the devices you are updating with Mender", requiredPlan: PLANS.enterprise.id },
  deltaGeneration: {
    id: "deltaGeneration",
    benefit: "automatic delta artifacts generation to minimize data transfer and improve the update delivery",
    requiredPlan: PLANS.enterprise.id
  },
  deviceConfiguration: { id: "deviceConfiguration", benefit: "device configuration features", requiredAddon: ADDONS.configure.id },
  deviceMonitor: { id: "deviceMonitor", benefit: "device monitoring features", requiredAddon: ADDONS.monitor.id, requiredPlan: PLANS.professional.id },
  deviceTroubleshoot: { id: "deviceTroubleshoot", benefit: "device troubleshooting features", requiredAddon: ADDONS.troubleshoot.id },
  dynamicGroups: { id: "dynamicGroups", benefit: "create dynamic groups to ease device management", requiredPlan: PLANS.enterprise.id },
  fullFiltering: { id: "fullFiltering", benefit: "filtering by multiple attributes to improve the device overview", requiredPlan: PLANS.professional.id },
  gateway: { id: "gateway", benefit: "see devices connected to your gateway device for easy access", requiredPlans: PLANS.professional.id },
  pausedDeployments: {
    id: "pausedDeployments",
    benefit: "granular control about update rollout to allow synchronization across your fleet",
    requiredPlan: PLANS.enterprise.id
  },
  phasedDeployments: { id: "phasedDeployments", benefit: "choose to roll out deployments in multiple phases", requiredPlan: PLANS.enterprise.id },
  rbac: { id: "rbac", benefit: "granular role based access control", requiredPlan: PLANS.enterprise.id },
  retryDeployments: { id: "retryDeployments", benefit: "optional retries for failed rollout attempts", requiredPlan: PLANS.professional.id },
  scheduledDeployments: {
    id: "scheduledDeployments",
    benefit: "scheduled deployments to steer the distribution of your updates.",
    requiredPlan: PLANS.professional.id
  },
  webhookEvents: {
    id: "webhookEvents",
    benefit: "receive inventory events and select which type(s) of events the webhook will receive",
    requiredPlan: PLANS.professional.id
  },
  default: { id: "default", benefit: "gain access to this feature", requiredPlan: PLANS.enterprise.id }
};
var DARK_MODE = "dark";

// src/commonConstants.tsx
var import_js = require("@mdi/js");
var import_MenderTypes = require("@northern.tech/types/MenderTypes");

// src/constants.ts
var import_constants2 = require("@northern.tech/utils/constants");

// src/deploymentsSlice/constants.ts
var alreadyInstalled = "already-installed";
var deploymentSubstates = {
  aborted: "aborted",
  alreadyInstalled,
  decommissioned: "decommissioned",
  downloading: "downloading",
  failure: "failure",
  installing: "installing",
  noartifact: "noartifact",
  pause_before_committing: "pause_before_committing",
  pause_before_installing: "pause_before_installing",
  pause_before_rebooting: "pause_before_rebooting",
  pending: "pending",
  rebooting: "rebooting",
  success: "success"
};
var deploymentStatesToSubstates = {
  failures: [deploymentSubstates.failure, deploymentSubstates.aborted, deploymentSubstates.decommissioned],
  inprogress: [deploymentSubstates.downloading, deploymentSubstates.installing, deploymentSubstates.rebooting],
  paused: [deploymentSubstates.pause_before_installing, deploymentSubstates.pause_before_rebooting, deploymentSubstates.pause_before_committing],
  pending: [deploymentSubstates.pending],
  successes: [deploymentSubstates.success, deploymentSubstates.alreadyInstalled, deploymentSubstates.noartifact]
};
var deploymentStatesToSubstatesWithSkipped = {
  ...deploymentStatesToSubstates,
  failures: [deploymentSubstates.failure],
  skipped: [deploymentSubstates.aborted, deploymentSubstates.noartifact, deploymentSubstates.alreadyInstalled, deploymentSubstates.decommissioned],
  successes: [deploymentSubstates.success]
};
var installationSubstatesMap = {
  download: {
    title: "download",
    done: "downloaded",
    successIndicators: [deploymentSubstates.installing, deploymentSubstates.rebooting, ...deploymentStatesToSubstates.paused, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactInstall_Enter"
  },
  install: {
    title: "install",
    done: "installed",
    successIndicators: [
      deploymentSubstates.rebooting,
      deploymentSubstates.pause_before_rebooting,
      deploymentSubstates.pause_before_committing,
      deploymentSubstates.success
    ],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactReboot_Enter"
  },
  reboot: {
    title: "reboot",
    done: "rebooted",
    successIndicators: [deploymentSubstates.pause_before_committing, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactCommit_Enter"
  },
  commit: {
    title: "commit",
    done: "committed",
    successIndicators: deploymentStatesToSubstates.successes,
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: void 0
  }
};
var DEPLOYMENT_STATES = {
  finished: "finished",
  inprogress: "inprogress",
  pending: "pending",
  scheduled: "scheduled"
};
var listDefaultsByState = {
  [DEPLOYMENT_STATES.inprogress]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.pending]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.scheduled]: { ...import_constants2.DEVICE_LIST_DEFAULTS },
  [DEPLOYMENT_STATES.finished]: { ...import_constants2.DEVICE_LIST_DEFAULTS },
  sort: { direction: import_constants2.SORTING_OPTIONS.desc }
};
var DEPLOYMENT_ROUTES = {
  active: {
    key: "active",
    route: "/deployments/active",
    states: [DEPLOYMENT_STATES.pending, DEPLOYMENT_STATES.inprogress],
    title: "Active"
  },
  finished: {
    key: "finished",
    route: "/deployments/finished",
    states: [DEPLOYMENT_STATES.finished],
    title: "Finished"
  },
  scheduled: {
    key: "scheduled",
    route: "/deployments/scheduled",
    states: [DEPLOYMENT_STATES.scheduled],
    title: "Scheduled"
  }
};
var defaultStats = {
  [deploymentSubstates.aborted]: 0,
  [deploymentSubstates.alreadyInstalled]: 0,
  [deploymentSubstates.decommissioned]: 0,
  [deploymentSubstates.downloading]: 0,
  [deploymentSubstates.failure]: 0,
  [deploymentSubstates.installing]: 0,
  [deploymentSubstates.noartifact]: 0,
  [deploymentSubstates.pause_before_committing]: 0,
  [deploymentSubstates.pause_before_installing]: 0,
  [deploymentSubstates.pause_before_rebooting]: 0,
  [deploymentSubstates.pending]: 0,
  [deploymentSubstates.rebooting]: 0,
  [deploymentSubstates.success]: 0
};
var pauseMap = {
  [deploymentSubstates.pause_before_installing]: {
    title: installationSubstatesMap.download.done,
    followUp: installationSubstatesMap.download.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_rebooting]: {
    title: installationSubstatesMap.install.done,
    followUp: installationSubstatesMap.install.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_committing]: {
    title: installationSubstatesMap.reboot.done,
    followUp: installationSubstatesMap.reboot.pauseConfigurationIndicator
  }
};

// src/onboardingSlice/constants.ts
var onboardingSteps = {
  ONBOARDING_START: "onboarding-start",
  DEVICES_PENDING_ONBOARDING_START: "devices-pending-onboarding-start",
  DASHBOARD_ONBOARDING_START: "dashboard-onboarding-start",
  DASHBOARD_ONBOARDING_PENDINGS: "dashboard-onboarding-pendings",
  DEVICES_DELAYED_ONBOARDING: "devices-delayed-onboarding",
  DEVICES_PENDING_ONBOARDING: "devices-pending-onboarding",
  DEVICES_ACCEPTED_ONBOARDING: "devices-accepted-onboarding",
  DEVICES_PENDING_ACCEPTING_ONBOARDING: "devices-pending-accepting-onboarding",
  DEVICES_DEPLOY_RELEASE_ONBOARDING: "devices-deploy-release-onboarding",
  SCHEDULING_ARTIFACT_SELECTION: "scheduling-artifact-selection",
  SCHEDULING_ALL_DEVICES_SELECTION: "scheduling-all-devices-selection",
  SCHEDULING_GROUP_SELECTION: "scheduling-group-selection",
  SCHEDULING_RELEASE_TO_DEVICES: "scheduling-release-to-devices",
  DEPLOYMENTS_INPROGRESS: "deployments-inprogress",
  DEPLOYMENTS_COMPLETED: "deployments-completed",
  DEPLOYMENTS_PAST: "deployments-past",
  DEPLOYMENTS_PAST_COMPLETED: "deployments-past-completed",
  DEPLOYMENTS_PAST_COMPLETED_FAILURE: "deployments-past-completed-failure",
  ONBOARDING_CANCELED: "onboarding-canceled"
};
var orderedOnboardingSteps = [
  onboardingSteps.DASHBOARD_ONBOARDING_START,
  onboardingSteps.DEVICES_PENDING_ONBOARDING_START,
  onboardingSteps.DEVICES_DELAYED_ONBOARDING,
  onboardingSteps.DEVICES_PENDING_ONBOARDING,
  onboardingSteps.DEVICES_PENDING_ACCEPTING_ONBOARDING,
  onboardingSteps.DASHBOARD_ONBOARDING_PENDINGS,
  onboardingSteps.DEVICES_ACCEPTED_ONBOARDING,
  onboardingSteps.DEVICES_DEPLOY_RELEASE_ONBOARDING,
  onboardingSteps.SCHEDULING_ALL_DEVICES_SELECTION,
  onboardingSteps.SCHEDULING_GROUP_SELECTION,
  onboardingSteps.SCHEDULING_ARTIFACT_SELECTION,
  onboardingSteps.SCHEDULING_RELEASE_TO_DEVICES,
  onboardingSteps.DEPLOYMENTS_INPROGRESS,
  onboardingSteps.DEPLOYMENTS_PAST,
  onboardingSteps.DEPLOYMENTS_PAST_COMPLETED,
  onboardingSteps.DEPLOYMENTS_PAST_COMPLETED_FAILURE,
  onboardingSteps.ONBOARDING_CANCELED
];

// src/usersSlice/constants.ts
var READ_STATES = {
  read: "read",
  seen: "seen",
  unread: "unread"
};

// src/commonConstants.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var timeUnits = {
  days: "days",
  minutes: "minutes",
  hours: "hours"
};
var UNGROUPED_GROUP = { id: "*|=ungrouped=|*", name: "Unassigned" };
var DEVICE_LIST_MAXIMUM_LENGTH = 50;
var oneSecond = 1e3;
var TIMEOUTS = {
  debounceDefault: 700,
  debounceShort: 300,
  halfASecond: 0.5 * oneSecond,
  oneSecond,
  twoSeconds: 2 * oneSecond,
  threeSeconds: 3 * oneSecond,
  fiveSeconds: 5 * oneSecond,
  refreshDefault: 10 * oneSecond,
  refreshLong: 60 * oneSecond
};
var DEVICE_ONLINE_CUTOFF = { interval: 1, intervalName: timeUnits.days };
var defaultIdAttribute = Object.freeze({ attribute: "id", scope: import_constants2.ATTRIBUTE_SCOPES.identity });
var credentialTypes = {
  aws: import_MenderTypes.Credentials.type.AWS,
  http: import_MenderTypes.Credentials.type.HTTP,
  sas: import_MenderTypes.Credentials.type.SAS,
  x509: "x509"
};
var EXTERNAL_PROVIDER = {
  "iot-core": {
    credentialsType: credentialTypes.aws,
    icon: import_js.mdiAws,
    title: "AWS IoT Core",
    twinTitle: "Device Shadow",
    provider: "iot-core",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_jsx_runtime.Fragment, { children: "For help finding your AWS IoT Core connection string, check the AWS IoT documentation." })
  },
  "iot-hub": {
    credentialsType: credentialTypes.sas,
    icon: import_js.mdiMicrosoftAzure,
    title: "Azure IoT Hub",
    twinTitle: "Device Twin",
    provider: "iot-hub",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("span", { children: [
      "For help finding your Azure IoT Hub connection string, look under 'Shared access policies' in the Microsoft Azure UI as described",
      " ",
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        "a",
        {
          href: "https://devblogs.microsoft.com/iotdev/understand-different-connection-strings-in-azure-iot-hub/#iothubconn",
          target: "_blank",
          rel: "noopener noreferrer",
          children: "here"
        }
      ),
      "."
    ] })
  },
  webhook: {
    credentialsType: credentialTypes.http,
    deviceTwin: false,
    twinTitle: "",
    // disable the webhook provider here, since it is treated different than other integrations, with a custom configuration & management view, etc.
    enabled: false,
    provider: "webhook"
  }
};
var emptyWebhook = {
  description: "",
  provider: import_MenderTypes.Integration.provider.WEBHOOK,
  credentials: {
    type: EXTERNAL_PROVIDER.webhook.credentialsType,
    [EXTERNAL_PROVIDER.webhook.credentialsType]: {
      secret: "",
      url: ""
    }
  }
};
var regionNames = new Intl.DisplayNames(["en"], { type: "region" });
var countries = [
  "AD",
  "AE",
  "AF",
  "AG",
  "AI",
  "AL",
  "AM",
  "AO",
  "AQ",
  "AR",
  "AS",
  "AT",
  "AU",
  "AW",
  "AX",
  "AZ",
  "BA",
  "BB",
  "BD",
  "BE",
  "BF",
  "BG",
  "BH",
  "BI",
  "BJ",
  "BL",
  "BM",
  "BN",
  "BO",
  "BR",
  "BS",
  "BT",
  "BV",
  "BW",
  "BY",
  "BZ",
  "CA",
  "CC",
  "CD",
  "CF",
  "CG",
  "CH",
  "CI",
  "CK",
  "CL",
  "CM",
  "CN",
  "CO",
  "CR",
  "CU",
  "CV",
  "CW",
  "CX",
  "CY",
  "CZ",
  "DE",
  "DJ",
  "DK",
  "DM",
  "DO",
  "DZ",
  "EC",
  "EE",
  "EG",
  "EH",
  "ER",
  "ES",
  "ET",
  "FI",
  "FJ",
  "FK",
  "FM",
  "FO",
  "FR",
  "GA",
  "GB",
  "GD",
  "GE",
  "GF",
  "GG",
  "GH",
  "GI",
  "GL",
  "GM",
  "GN",
  "GP",
  "GQ",
  "GR",
  "GS",
  "GT",
  "GU",
  "GW",
  "GY",
  "HK",
  "HM",
  "HN",
  "HR",
  "HT",
  "HU",
  "ID",
  "IE",
  "IL",
  "IM",
  "IN",
  "IO",
  "IQ",
  "IR",
  "IS",
  "IT",
  "JE",
  "JM",
  "JO",
  "JP",
  "KE",
  "KG",
  "KH",
  "KI",
  "KM",
  "KN",
  "KP",
  "KR",
  "KW",
  "KY",
  "KZ",
  "LA",
  "LB",
  "LC",
  "LI",
  "LK",
  "LR",
  "LS",
  "LT",
  "LU",
  "LV",
  "LY",
  "MA",
  "MC",
  "MD",
  "ME",
  "MF",
  "MG",
  "MH",
  "MK",
  "ML",
  "MM",
  "MN",
  "MO",
  "MP",
  "MQ",
  "MR",
  "MS",
  "MT",
  "MU",
  "MV",
  "MW",
  "MX",
  "MY",
  "MZ",
  "NA",
  "NC",
  "NE",
  "NF",
  "NG",
  "NI",
  "NL",
  "NO",
  "NP",
  "NR",
  "NU",
  "NZ",
  "OM",
  "PA",
  "PE",
  "PF",
  "PG",
  "PH",
  "PK",
  "PL",
  "PM",
  "PN",
  "PR",
  "PS",
  "PT",
  "PW",
  "PY",
  "QA",
  "RE",
  "RO",
  "RS",
  "RU",
  "RW",
  "SA",
  "SB",
  "SC",
  "SD",
  "SE",
  "SG",
  "SH",
  "SI",
  "SJ",
  "SK",
  "SL",
  "SM",
  "SN",
  "SO",
  "SR",
  "SS",
  "ST",
  "SV",
  "SX",
  "SY",
  "SZ",
  "TC",
  "TD",
  "TF",
  "TG",
  "TH",
  "TJ",
  "TK",
  "TL",
  "TM",
  "TN",
  "TO",
  "TR",
  "TT",
  "TV",
  "TW",
  "TZ",
  "UA",
  "UG",
  "US",
  "UY",
  "UZ",
  "VA",
  "VC",
  "VE",
  "VG",
  "VI",
  "VN",
  "VU",
  "WF",
  "WS",
  "XK",
  "YE",
  "YT",
  "ZA",
  "ZM",
  "ZW"
].map((code) => ({ code, label: regionNames.of(code) })).sort((a, b) => a.label.localeCompare(b.label));

// src/deploymentsSlice/selectors.ts
var import_toolkit2 = require("@reduxjs/toolkit");
var getDeploymentsById = (state) => state.deployments.byId;
var getDeploymentsByStatus = (state) => state.deployments.byStatus;
var getSelectedDeploymentDeviceIds = (state) => state.deployments.selectedDeviceIds;
var getDeploymentsSelectionState = (state) => state.deployments.selectionState;
var getMappedDeploymentSelection = (0, import_toolkit2.createSelector)(
  [getDeploymentsSelectionState, (_, deploymentsState) => deploymentsState, getDeploymentsById],
  (selectionState, deploymentsState, deploymentsById) => {
    const { selection = [] } = selectionState[deploymentsState] ?? {};
    return selection.reduce((accu, id) => {
      if (deploymentsById[id]) {
        accu.push(deploymentsById[id]);
      }
      return accu;
    }, []);
  }
);
var relevantDeploymentStates = [DEPLOYMENT_STATES.pending, DEPLOYMENT_STATES.inprogress, DEPLOYMENT_STATES.finished];
var DEPLOYMENT_CUTOFF = 3;
var getRecentDeployments = (0, import_toolkit2.createSelector)(
  [getDeploymentsById, getDeploymentsByStatus],
  (deploymentsById, deploymentsByStatus) => Object.entries(deploymentsByStatus).reduce(
    (accu, [state, byStatus]) => {
      if (!relevantDeploymentStates.includes(state) || !byStatus.deploymentIds.length) {
        return accu;
      }
      accu[state] = byStatus.deploymentIds.reduce((accu2, id) => {
        if (deploymentsById[id]) {
          accu2.push(deploymentsById[id]);
        }
        return accu2;
      }, []).slice(0, DEPLOYMENT_CUTOFF);
      accu.total += byStatus.total;
      return accu;
    },
    { total: 0 }
  )
);

// src/devicesSlice/selectors.ts
var import_helpers2 = require("@northern.tech/utils/helpers");
var import_toolkit3 = require("@reduxjs/toolkit");
var getAcceptedDevices = (state) => state.devices.byStatus.accepted;
var getDevicesByStatus = (state) => state.devices.byStatus;
var getDevicesById = (state) => state.devices.byId;
var getDeviceReports = (state) => state.devices.reports;
var getGroupsById = (state) => state.devices.groups.byId;
var getSelectedGroup = (state) => state.devices.groups.selectedGroup;
var getDeviceListState = (state) => state.devices.deviceList;
var getListedDevices = (state) => state.devices.deviceList.deviceIds;
var getFilteringAttributes = (state) => state.devices.filteringAttributes;
var getDeviceFilters = (state) => state.devices.filters || [];
var getFilteringAttributesFromConfig = (state) => state.devices.filteringAttributesConfig.attributes;
var getSortedFilteringAttributes = (0, import_toolkit3.createSelector)([getFilteringAttributes], (filteringAttributes) => ({
  ...filteringAttributes,
  identityAttributes: [...filteringAttributes.identityAttributes, "id"]
}));
var getDeviceLimit = (state) => state.devices.limit;
var getFilteringAttributesLimit = (state) => state.devices.filteringAttributesLimit;
var getDeviceIdentityAttributes = (0, import_toolkit3.createSelector)(
  [getFilteringAttributes, getFilteringAttributesLimit],
  ({ identityAttributes }, filteringAttributesLimit) => {
    const attributes = identityAttributes.slice(0, filteringAttributesLimit);
    return attributes.reduce(
      (accu, value) => {
        accu.push({ value, label: value, scope: "identity" });
        return accu;
      },
      [
        { value: "name", label: "Name", scope: "tags" },
        { value: "id", label: "Device ID", scope: "identity" }
      ]
    );
  }
);
var getDeviceCountsByStatus = (0, import_toolkit3.createSelector)(
  [getDevicesByStatus],
  (byStatus) => Object.values(import_constants2.DEVICE_STATES).reduce((accu, state) => {
    accu[state] = byStatus[state].total || 0;
    return accu;
  }, {})
);
var getDeviceById = (0, import_toolkit3.createSelector)([getDevicesById, (_, deviceId) => deviceId], (devicesById, deviceId = "") => devicesById[deviceId] ?? {});
var getSelectedGroupInfo = (0, import_toolkit3.createSelector)(
  [getAcceptedDevices, getGroupsById, getSelectedGroup],
  ({ total: acceptedDeviceTotal }, groupsById, selectedGroup) => {
    let groupCount = acceptedDeviceTotal;
    let groupFilters = [];
    if (selectedGroup && groupsById[selectedGroup]) {
      groupCount = groupsById[selectedGroup].total || 0;
      groupFilters = groupsById[selectedGroup].filters || [];
    }
    return { groupCount, selectedGroup, groupFilters };
  }
);
var getLimitMaxed = (0, import_toolkit3.createSelector)(
  [getAcceptedDevices, getDeviceLimit],
  ({ total: acceptedDevices = 0 }, deviceLimit) => Boolean(deviceLimit && deviceLimit <= acceptedDevices)
);
var getGroupsByIdWithoutUngrouped = (0, import_toolkit3.createSelector)([getGroupsById], ({ [UNGROUPED_GROUP.id]: ungrouped, ...groups }) => groups);
var getGroupData = (0, import_toolkit3.createSelector)([getGroupsByIdWithoutUngrouped], (groups) => {
  const createdGroup = Object.keys(groups).length ? Object.keys(groups)[0] : void 0;
  const hasDynamicGroups = Object.values(groups).some((group) => !!group.id);
  return { createdGroup, hasDynamicGroups, groups };
});
var getGroups = (0, import_toolkit3.createSelector)([getGroupsById], (groupsById) => {
  const groupNames = Object.keys(groupsById).sort();
  const groupedGroups = Object.entries(groupsById).sort((a, b) => a[0].localeCompare(b[0])).reduce(
    (accu, [groupname, group]) => {
      const name = groupname === UNGROUPED_GROUP.id ? UNGROUPED_GROUP.name : groupname;
      const groupItem = { ...group, groupId: name, name: groupname };
      if ((group.filters ?? []).length > 0) {
        if (groupname !== UNGROUPED_GROUP.id) {
          accu.dynamic.push(groupItem);
        } else {
          accu.ungrouped.push(groupItem);
        }
      } else {
        accu.static.push(groupItem);
      }
      return accu;
    },
    { dynamic: [], static: [], ungrouped: [] }
  );
  return { groupNames, ...groupedGroups };
});
var getAttributesList = (0, import_toolkit3.createSelector)(
  [getFilteringAttributes, getFilteringAttributesFromConfig],
  ({ identityAttributes = [], inventoryAttributes = [] }, { identity = [], inventory = [] }) => [...identityAttributes, ...inventoryAttributes, ...identity, ...inventory].filter(import_helpers2.duplicateFilter)
);
var getDeviceTypes = (0, import_toolkit3.createSelector)(
  [getAcceptedDevices, getDevicesById],
  ({ deviceIds = [] }, devicesById) => Object.keys(
    deviceIds.slice(0, 200).reduce((accu, item) => {
      const { device_type: deviceTypes = [] } = devicesById[item] ? devicesById[item].attributes : {};
      accu = deviceTypes.reduce((deviceTypeAccu, deviceType) => {
        if (deviceType.length > 1) {
          deviceTypeAccu[deviceType] = deviceTypeAccu[deviceType] ? deviceTypeAccu[deviceType] + 1 : 1;
        }
        return deviceTypeAccu;
      }, accu);
      return accu;
    }, {})
  )
);

// src/monitorSlice/selectors.ts
var getIssueCountsByType = (state) => state.monitor.issueCounts.byType;

// src/onboardingSlice/selectors.ts
var getOnboarding = (state) => state.onboarding;

// src/organizationSlice/selectors.ts
var import_toolkit4 = require("@reduxjs/toolkit");
var import_dayjs = __toESM(require("dayjs"), 1);
var import_relativeTime = __toESM(require("dayjs/plugin/relativeTime.js"), 1);
var getOrganization = (state) => state.organization.organization;
var getExternalIntegrations = (state) => state.organization.externalDeviceIntegrations;
var getAuditlogState = (state) => state.organization.auditlog.selectionState;
var getAuditLog = (state) => state.organization.auditlog.events;
var getAuditLogSelectionState = (state) => state.organization.auditlog.selectionState;
var getBillingProfile = (state) => state.organization.organization.billing_profile;
var getSubscription = (state) => state.organization.organization.subscription;
var getCard = (state) => state.organization.card;
var getSsoConfig = ({ organization: { ssoConfigs = [] } }) => ssoConfigs[0];
var getTenantsList = (state) => state.organization.tenantList;
var getWebhookEvents = (state) => state.organization.webhooks.events;
var getWebhookEventTotal = (state) => state.organization.webhooks.eventsTotal;
var getDeviceTwinIntegrations = (0, import_toolkit4.createSelector)(
  [getExternalIntegrations],
  (integrations) => integrations.filter((integration) => integration.id && EXTERNAL_PROVIDER[integration.provider]?.deviceTwin)
);
var getIsServiceProvider = (state) => state.organization.organization.service_provider;
var getWebhooks = (0, import_toolkit4.createSelector)(
  [getExternalIntegrations],
  (integrations) => integrations.filter((integration) => integration.id && integration.provider === EXTERNAL_PROVIDER.webhook.provider)
);
var getWebhookEventInfo = (0, import_toolkit4.createSelector)(
  [getWebhooks, getWebhookEvents, getWebhookEventTotal],
  (webhooks, events, eventTotal) => webhooks.length ? { events, eventTotal } : { events: [], eventTotal: 0 }
);
var getAuditLogEntry = (0, import_toolkit4.createSelector)([getAuditLog, getAuditLogSelectionState], (events, { selectedId }) => {
  if (!selectedId) {
    return;
  }
  const [eventAction, eventTime] = atob(selectedId).split("|");
  return events.find((item) => item.action === eventAction && item.time === eventTime);
});
import_dayjs.default.extend(import_relativeTime.default);
var newPricingIntroduction = (0, import_dayjs.default)("2025-06-03T00:00");
var getHasCurrentPricing = (0, import_toolkit4.createSelector)(
  [getOrganization],
  ({ id }) => !!id && (0, import_dayjs.default)(parseInt(id.substring(0, 8), 16) * 1e3) >= newPricingIntroduction
);

// src/releasesSlice/selectors.ts
var import_toolkit5 = require("@reduxjs/toolkit");

// src/utils.ts
var import_helpers3 = require("@northern.tech/utils/helpers");
var filterProcessors = {
  [import_constants2.DEVICE_FILTERING_OPTIONS.$gt.key]: (val) => Number(val) || val,
  [import_constants2.DEVICE_FILTERING_OPTIONS.$gte.key]: (val) => Number(val) || val,
  [import_constants2.DEVICE_FILTERING_OPTIONS.$lt.key]: (val) => Number(val) || val,
  [import_constants2.DEVICE_FILTERING_OPTIONS.$lte.key]: (val) => Number(val) || val,
  [import_constants2.DEVICE_FILTERING_OPTIONS.$ltne.key]: (val) => Number(val) || val,
  [import_constants2.DEVICE_FILTERING_OPTIONS.$in.key]: (val) => ("" + val).split(",").map((i) => i.trim()),
  [import_constants2.DEVICE_FILTERING_OPTIONS.$nin.key]: (val) => ("" + val).split(",").map((i) => i.trim()),
  [import_constants2.DEVICE_FILTERING_OPTIONS.$exists.key]: import_helpers3.yes,
  [import_constants2.DEVICE_FILTERING_OPTIONS.$nexists.key]: () => false
};
var filterAliases = {
  $nexists: { alias: import_constants2.DEVICE_FILTERING_OPTIONS.$exists.key, value: false }
};
var listItemMapper = (byId, ids, { cutOffSize = DEVICE_LIST_MAXIMUM_LENGTH, defaultObject = {} }) => ids.slice(0, cutOffSize).reduce((accu, id) => {
  if (id && byId[id]) {
    accu.push({ ...defaultObject, ...byId[id] });
  }
  return accu;
}, []);
var mergePermissions = (existingPermissions = { ...import_constants2.emptyUiPermissions }, addedPermissions) => Object.entries(existingPermissions).reduce(
  (accu, [key, value]) => {
    let values;
    if (!accu[key]) {
      accu[key] = value;
      return accu;
    }
    if (Array.isArray(value)) {
      values = [...value, ...accu[key]].filter(import_helpers3.duplicateFilter);
    } else {
      values = mergePermissions(accu[key], { ...value });
    }
    accu[key] = values;
    return accu;
  },
  { ...addedPermissions }
);
var mapUserRolesToUiPermissions = (userRoles, roles) => userRoles.reduce(
  (accu, roleId) => {
    if (!(roleId && roles[roleId])) {
      return accu;
    }
    return mergePermissions(accu, roles[roleId].uiPermissions);
  },
  { ...import_constants2.emptyUiPermissions }
);
var isDarkMode = (mode) => mode === DARK_MODE;

// src/releasesSlice/selectors.ts
var getSelectedReleaseId = (state) => state.releases.selectedRelease;
var getReleasesById = (state) => state.releases.byId;
var getReleaseTags = (state) => state.releases.tags;
var getReleaseListState = (state) => state.releases.releasesList;
var getListedReleases = (state) => state.releases.releasesList.releaseIds;
var getUpdateTypes = (state) => state.releases.updateTypes;
var releaseDefaults = {};
var getReleaseMappingDefaults = () => releaseDefaults;
var getReleasesList = (0, import_toolkit5.createSelector)([getReleasesById, getListedReleases, getReleaseMappingDefaults], listItemMapper);
var getReleaseTagsById = (0, import_toolkit5.createSelector)([getReleaseTags], (releaseTags) => releaseTags.reduce((accu, key) => ({ ...accu, [key]: key }), {}));
var getHasReleases = (0, import_toolkit5.createSelector)(
  [getReleaseListState, getReleasesById],
  ({ searchTotal, total }, byId) => !!(Object.keys(byId).length || total || searchTotal)
);
var getSelectedRelease = (0, import_toolkit5.createSelector)([getReleasesById, getSelectedReleaseId], (byId, id) => byId[id || ""] ?? {});
var getSelectedReleases = (0, import_toolkit5.createSelector)([getReleaseListState, getReleasesList], ({ selection }, releases) => selection.map((index) => releases[index]));

// src/usersSlice/selectors.ts
var import_toolkit6 = require("@reduxjs/toolkit");
var emptyObject = {};
var getRolesById = (state) => state.users.rolesById;
var getTooltipsById = (state) => state.users.tooltips.byId;
var getGlobalSettings = (state) => state.users.globalSettings;
var getUserSettingsInitialized = (state) => state.users.settingsInitialized;
var getCurrentUserId = (state) => state.users.currentUser;
var getUsersById = (state) => state.users.byId;
var getUsersList = (0, import_toolkit6.createSelector)([getUsersById], (usersById) => Object.values(usersById));
var getCurrentUser = (0, import_toolkit6.createSelector)(
  [getUsersById, getCurrentUserId],
  (usersById, userId) => userId ? usersById[userId] ?? emptyObject : emptyObject
);
var getUserSettings = (state) => state.users.userSettings;
var getSelectedDeviceAttribute = (0, import_toolkit6.createSelector)(
  [getUserSettings],
  ({ columnSelection }) => columnSelection.map((attribute) => ({ attribute: attribute.key, scope: attribute.scope }))
);
var getIsDarkMode = (0, import_toolkit6.createSelector)([getUserSettings], ({ mode }) => isDarkMode(mode));
var getReadAllHelptips = (0, import_toolkit6.createSelector)(
  [getTooltipsById],
  (tooltips) => Object.values(tooltips).every(({ readState }) => readState === READ_STATES.read)
);
var getTooltipsState = (0, import_toolkit6.createSelector)(
  [getTooltipsById, getUserSettings],
  (byId, { tooltips = {} }) => Object.entries(byId).reduce(
    (accu, [id, value]) => {
      accu[id] = { ...accu[id], ...value };
      return accu;
    },
    { ...tooltips }
  )
);
var getHas2FA = (0, import_toolkit6.createSelector)(
  [getCurrentUser],
  (currentUser) => currentUser.hasOwnProperty("tfa_status") && currentUser.tfa_status === import_constants2.twoFAStates.enabled
);
var getIdAttribute = (0, import_toolkit6.createSelector)([getGlobalSettings], ({ id_attribute = { ...defaultIdAttribute } }) => id_attribute);
var getOfflineThresholdSettings = (0, import_toolkit6.createSelector)([getGlobalSettings], ({ offlineThreshold }) => ({
  interval: offlineThreshold?.interval || DEVICE_ONLINE_CUTOFF.interval,
  intervalUnit: offlineThreshold?.intervalUnit || DEVICE_ONLINE_CUTOFF.intervalName
}));
var getRolesList = (0, import_toolkit6.createSelector)([getRolesById], (rolesById2) => Object.entries(rolesById2).map(([value, role]) => ({ value, ...role })));
var getCurrentSession = (state) => state.users.currentSession;
var getRolesInitialized = (state) => state.users.rolesInitialized;

// src/commonSelectors.ts
var getIsEnterprise = (0, import_toolkit7.createSelector)(
  [getOrganization, getFeatures],
  ({ plan = PLANS.os.id }, { isEnterprise, isHosted }) => isEnterprise || isHosted && plan === PLANS.enterprise.id
);
var getAttrsEndpoint = (0, import_toolkit7.createSelector)(
  [getFeatures],
  ({ hasReporting }) => hasReporting ? `${import_constants2.reportingApiUrl}/devices/search/attributes` : `${import_constants2.inventoryApiUrlV2}/filters/attributes`
);
var getSearchEndpoint = (0, import_toolkit7.createSelector)(
  [getFeatures],
  ({ hasReporting }) => hasReporting ? `${import_constants2.reportingApiUrl}/devices/search` : `${import_constants2.inventoryApiUrlV2}/filters/search`
);
var getUserRoles = (0, import_toolkit7.createSelector)([getCurrentUser, getRolesById, getIsEnterprise], (currentUser, rolesById2, isEnterprise) => {
  const isAdmin = currentUser.roles?.length ? currentUser.roles.some((role) => role === import_constants2.rolesByName.admin) : !isEnterprise;
  const uiPermissions = isAdmin ? mapUserRolesToUiPermissions([import_constants2.rolesByName.admin], rolesById2) : mapUserRolesToUiPermissions(currentUser.roles || [], rolesById2);
  return { isAdmin, uiPermissions };
});
var hasPermission = (thing, permission) => Object.values(thing).some((permissions) => permissions.includes(permission));
var getUserCapabilities = (0, import_toolkit7.createSelector)([getUserRoles, getIsServiceProvider], ({ uiPermissions }, isServiceProvider) => {
  const canManageReleases = hasPermission(uiPermissions.releases, import_constants2.uiPermissionsById.manage.value);
  const canReadReleases = canManageReleases || hasPermission(uiPermissions.releases, import_constants2.uiPermissionsById.read.value);
  const canUploadReleases = canManageReleases || hasPermission(uiPermissions.releases, import_constants2.uiPermissionsById.upload.value);
  const canAuditlog = uiPermissions.auditlog.includes(import_constants2.uiPermissionsById.read.value);
  const canReadUsers = uiPermissions.userManagement.includes(import_constants2.uiPermissionsById.read.value);
  const canManageUsers = uiPermissions.userManagement.includes(import_constants2.uiPermissionsById.manage.value);
  const canReadDevices = hasPermission(uiPermissions.groups, import_constants2.uiPermissionsById.read.value);
  const canWriteDevices = Object.values(uiPermissions.groups).some(
    (groupPermissions) => groupPermissions.includes(import_constants2.uiPermissionsById.read.value) && groupPermissions.length > 1
  );
  const canTroubleshoot = hasPermission(uiPermissions.groups, import_constants2.uiPermissionsById.connect.value);
  const canManageDevices = hasPermission(uiPermissions.groups, import_constants2.uiPermissionsById.manage.value);
  const canConfigure = hasPermission(uiPermissions.groups, import_constants2.uiPermissionsById.configure.value);
  const canDeploy = uiPermissions.deployments.includes(import_constants2.uiPermissionsById.deploy.value) || hasPermission(uiPermissions.groups, import_constants2.uiPermissionsById.deploy.value);
  const canReadDeployments = uiPermissions.deployments.includes(import_constants2.uiPermissionsById.read.value);
  return {
    canAuditlog,
    canConfigure,
    canDeploy,
    canManageDevices,
    canManageReleases,
    canManageUsers,
    canReadDeployments,
    canReadDevices,
    canReadReleases,
    canReadUsers,
    canTroubleshoot,
    canUploadReleases,
    canWriteDevices,
    groupsPermissions: uiPermissions.groups,
    releasesPermissions: uiPermissions.releases,
    SPTenant: isServiceProvider
  };
});
var getTenantCapabilities = (0, import_toolkit7.createSelector)(
  [getFeatures, getOrganization, getIsEnterprise],
  ({
    hasAuditlogs: isAuditlogEnabled,
    hasDeviceConfig: isDeviceConfigEnabled,
    hasDeviceConnect: isDeviceConnectEnabled,
    hasMonitor: isMonitorEnabled,
    isHosted
  }, { addons = [], plan = PLANS.os.id }, isEnterprise) => {
    const canDelta = isEnterprise || plan === PLANS.professional.id;
    const hasAuditlogs = isAuditlogEnabled && isEnterprise;
    const hasDeviceConfig = addons.some((addon) => addon.name === ADDONS.configure.id && addon.enabled) || isDeviceConfigEnabled && !isHosted;
    const hasDeviceConnect = addons.some((addon) => addon.name === ADDONS.troubleshoot.id && addon.enabled) || isDeviceConnectEnabled && !isHosted;
    const hasMonitor = isMonitorEnabled && addons.some((addon) => addon.name === ADDONS.monitor.id && addon.enabled);
    return {
      canDelta,
      canRetry: canDelta,
      canSchedule: canDelta,
      hasAuditlogs,
      hasDeviceConfig,
      hasDeviceConnect,
      hasFullFiltering: canDelta,
      hasMonitor,
      isEnterprise,
      plan
    };
  }
);
var getFilterAttributes = (0, import_toolkit7.createSelector)(
  [getGlobalSettings, getFilteringAttributes],
  ({ previousFilters }, { identityAttributes, inventoryAttributes, systemAttributes, tagAttributes }) => {
    const deviceNameAttribute = { key: "name", value: "Name", scope: import_constants2.ATTRIBUTE_SCOPES.tags, category: import_constants2.ATTRIBUTE_SCOPES.tags, priority: 1 };
    const deviceIdAttribute = { key: "id", value: "Device ID", scope: import_constants2.ATTRIBUTE_SCOPES.identity, category: import_constants2.ATTRIBUTE_SCOPES.identity, priority: 1 };
    const checkInAttribute = { key: "check_in_time", value: "Latest activity", scope: import_constants2.ATTRIBUTE_SCOPES.system, category: import_constants2.ATTRIBUTE_SCOPES.system, priority: 4 };
    const updateAttribute = { ...checkInAttribute, key: "updated_ts", value: "Last inventory update" };
    const firstRequestAttribute = { key: "created_ts", value: "First request", scope: import_constants2.ATTRIBUTE_SCOPES.system, category: import_constants2.ATTRIBUTE_SCOPES.system, priority: 4 };
    const attributes = [
      ...previousFilters.map((item) => ({
        ...item,
        value: deviceIdAttribute.key === item.key ? deviceIdAttribute.value : item.key,
        category: "recently used",
        priority: 0
      })),
      deviceNameAttribute,
      deviceIdAttribute,
      ...identityAttributes.map((item) => ({ key: item, value: item, scope: import_constants2.ATTRIBUTE_SCOPES.identity, category: import_constants2.ATTRIBUTE_SCOPES.identity, priority: 1 })),
      ...inventoryAttributes.map((item) => ({ key: item, value: item, scope: import_constants2.ATTRIBUTE_SCOPES.inventory, category: import_constants2.ATTRIBUTE_SCOPES.inventory, priority: 2 })),
      ...tagAttributes.map((item) => ({ key: item, value: item, scope: import_constants2.ATTRIBUTE_SCOPES.tags, category: import_constants2.ATTRIBUTE_SCOPES.tags, priority: 3 })),
      checkInAttribute,
      updateAttribute,
      firstRequestAttribute,
      ...systemAttributes.map((item) => ({ key: item, value: item, scope: import_constants2.ATTRIBUTE_SCOPES.system, category: import_constants2.ATTRIBUTE_SCOPES.system, priority: 4 }))
    ];
    return (0, import_helpers4.attributeDuplicateFilter)(attributes, "key");
  }
);
var getOnboardingState = (0, import_toolkit7.createSelector)([getOnboarding, getUserSettings], ({ complete, progress, showTips, ...remainder }, { onboarding = {} }) => ({
  ...remainder,
  ...onboarding,
  complete: onboarding.complete || complete,
  progress: Object.keys(onboardingSteps).findIndex((step) => step === progress) > Object.keys(onboardingSteps).findIndex((step) => step === onboarding.progress) ? progress : onboarding.progress,
  showTips: !onboarding.showTips ? onboarding.showTips : showTips
}));
var getDemoDeviceAddress = (0, import_toolkit7.createSelector)([getDevicesById, getOnboarding], (devicesById, { approach, demoArtifactPort }) => {
  const demoDeviceAddress = `http://${(0, import_helpers4.getDemoDeviceAddress)(Object.values(devicesById), approach)}`;
  return demoArtifactPort ? `${demoDeviceAddress}:${demoArtifactPort}` : demoDeviceAddress;
});
var getDeviceConfigDeployment = (0, import_toolkit7.createSelector)([getDeviceById, getDeploymentsById], (device, deploymentsById) => {
  const { config = {} } = device;
  const { deployment_id: configDeploymentId } = config;
  const deviceConfigDeployment = deploymentsById[configDeploymentId] || {};
  return { device, deviceConfigDeployment };
});
var getDeploymentRelease = (0, import_toolkit7.createSelector)(
  [getDeploymentsById, getDeploymentsSelectionState, getReleasesById],
  (deploymentsById, { selectedId }, releasesById) => {
    const deployment = deploymentsById[selectedId] || {};
    return deployment.artifact_name && releasesById[deployment.artifact_name] ? releasesById[deployment.artifact_name] : { device_types_compatible: [] };
  }
);
var getSelectedDeploymentData = (0, import_toolkit7.createSelector)(
  [getDeploymentsById, getDeploymentsSelectionState, getDevicesById, getSelectedDeploymentDeviceIds],
  (deploymentsById, { selectedId }, devicesById, selectedDeviceIds) => {
    const deployment = deploymentsById[selectedId] ?? {};
    const { devices = {} } = deployment;
    return {
      deployment,
      selectedDevices: selectedDeviceIds.map((deviceId) => ({ ...devicesById[deviceId], ...devices[deviceId] }))
    };
  }
);
var getAvailableIssueOptionsByType = (0, import_toolkit7.createSelector)(
  [getFeatures, getTenantCapabilities, getIssueCountsByType],
  ({ hasReporting }, { hasFullFiltering, hasMonitor }, issueCounts) => Object.values(import_constants2.DEVICE_ISSUE_OPTIONS).reduce((accu, { isCategory, key, needsFullFiltering, needsMonitor, needsReporting, title }) => {
    if (isCategory || needsReporting && !hasReporting || needsFullFiltering && !hasFullFiltering || needsMonitor && !hasMonitor) {
      return accu;
    }
    accu[key] = { count: issueCounts[key].filtered, key, title };
    return accu;
  }, {})
);
var getGroupNames = (0, import_toolkit7.createSelector)([getGroupsById, getUserRoles], (groupsById, { uiPermissions }) => {
  const { [UNGROUPED_GROUP.id]: ungrouped, ...groups } = groupsById;
  return Object.keys(
    Object.entries(groups).reduce((accu, [groupName, group]) => {
      if (group.filterId || uiPermissions.groups[import_constants2.ALL_DEVICES]) {
        accu[groupName] = group;
      }
      return accu;
    }, uiPermissions.groups)
  ).sort();
});
var getDeviceReportsForUser = (0, import_toolkit7.createSelector)(
  [getUserSettings, getCurrentUser, getGlobalSettings, getDevicesById],
  ({ reports }, { id: currentUserId }, globalSettings, devicesById) => reports || globalSettings[`${currentUserId}-reports`] || (Object.keys(devicesById).length ? defaultReports : [])
);
var listTypeDeviceIdMap = {
  deviceList: getListedDevices,
  search: getSearchedDevices
};
var deviceMapDefault = { defaultObject: { auth_sets: [] }, cutOffSize: DEVICE_LIST_MAXIMUM_LENGTH };
var getDeviceMappingDefaults = () => deviceMapDefault;
var getMappedDevicesList = (0, import_toolkit7.createSelector)(
  [getDevicesById, (state, listType) => listTypeDeviceIdMap[listType](state), getDeviceMappingDefaults],
  listItemMapper
);
var getAuditlogDevice = (0, import_toolkit7.createSelector)([getAuditLogEntry, getDevicesById], (auditlogEvent, devicesById) => {
  let auditlogDevice = {};
  if (auditlogEvent) {
    const { object = {} } = auditlogEvent;
    const { device = {}, id, type } = object;
    auditlogDevice = type === "device" ? { id, ...device } : auditlogDevice;
  }
  return { ...auditlogDevice, ...devicesById[auditlogDevice.id] };
});
var getRelevantRoles = (0, import_toolkit7.createSelector)([getOrganization, getRolesList], ({ service_provider }, roles) => {
  if (service_provider) {
    return roles.reduce((accu, role) => {
      if (import_constants2.rolesById[role.value]) {
        return accu;
      }
      accu.push(role);
      return accu;
    }, Object.values(import_constants2.serviceProviderRolesById));
  }
  return Object.keys(import_constants2.rolesById).reverse().reduce((accu, key) => {
    const index = accu.findIndex(({ value }) => value === key);
    accu = [accu[index], ...accu.filter((item, itemIndex) => index !== itemIndex)];
    return accu;
  }, roles);
});
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DEPLOYMENT_CUTOFF,
  getAcceptedDevices,
  getAttributesList,
  getAttrsEndpoint,
  getAuditLog,
  getAuditLogEntry,
  getAuditLogSelectionState,
  getAuditlogDevice,
  getAuditlogState,
  getAvailableIssueOptionsByType,
  getBillingProfile,
  getCard,
  getCommit,
  getCurrentSession,
  getCurrentUser,
  getDemoDeviceAddress,
  getDeploymentRelease,
  getDeploymentsById,
  getDeploymentsByStatus,
  getDeploymentsSelectionState,
  getDeviceById,
  getDeviceConfigDeployment,
  getDeviceCountsByStatus,
  getDeviceFilters,
  getDeviceIdentityAttributes,
  getDeviceLimit,
  getDeviceListState,
  getDeviceReports,
  getDeviceReportsForUser,
  getDeviceTwinIntegrations,
  getDeviceTypes,
  getDevicesById,
  getDevicesByStatus,
  getDocsVersion,
  getExternalIntegrations,
  getFeatures,
  getFeedbackProbability,
  getFilterAttributes,
  getFilteringAttributes,
  getFullVersionInformation,
  getGlobalSettings,
  getGroupData,
  getGroupNames,
  getGroups,
  getGroupsById,
  getGroupsByIdWithoutUngrouped,
  getHas2FA,
  getHasCurrentPricing,
  getHasReleases,
  getHostAddress,
  getHostedAnnouncement,
  getIdAttribute,
  getIsDarkMode,
  getIsEnterprise,
  getIsFirstLogin,
  getIsPreview,
  getIsServiceProvider,
  getIsUploading,
  getIssueCountsByType,
  getLimitMaxed,
  getListedDevices,
  getMappedDeploymentSelection,
  getMappedDevicesList,
  getOfflineThresholdSettings,
  getOnboarding,
  getOnboardingState,
  getOrganization,
  getReadAllHelptips,
  getRecaptchaKey,
  getRecentDeployments,
  getReleaseListState,
  getReleaseTags,
  getReleaseTagsById,
  getReleasesById,
  getReleasesList,
  getRelevantRoles,
  getRolesById,
  getRolesInitialized,
  getRolesList,
  getSearchEndpoint,
  getSearchState,
  getSearchedDevices,
  getSelectedDeploymentData,
  getSelectedDeploymentDeviceIds,
  getSelectedDeviceAttribute,
  getSelectedGroup,
  getSelectedGroupInfo,
  getSelectedRelease,
  getSelectedReleases,
  getSentryConfig,
  getSnackbar,
  getSortedFilteringAttributes,
  getSsoConfig,
  getStripeKey,
  getSubscription,
  getTenantCapabilities,
  getTenantsList,
  getTooltipsById,
  getTooltipsState,
  getTrackerCode,
  getUpdateTypes,
  getUploads,
  getUserCapabilities,
  getUserRoles,
  getUserSettings,
  getUserSettingsInitialized,
  getUsersById,
  getUsersList,
  getVersionInformation,
  getWebhookEventInfo,
  getWebhookEventTotal,
  getWebhookEvents,
  getWebhooks
});
//# sourceMappingURL=selectors.cjs.map