import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import * as redux_thunk from 'redux-thunk';
import * as redux from 'redux';
import * as _northern_tech_utils_constants from '@northern.tech/utils/constants';
import { ReadState } from './usersSlice/constants.js';
import { User, UserSession, CustomColumn, GlobalSettings, UserSettings } from './usersSlice/index.js';
import { ReleaseSliceType } from './releasesSlice/index.js';
import { OrganizationState } from './organizationSlice/types.js';
import { OnboardingApproach } from './onboardingSlice/index.js';
import * as _northern_tech_types_Alert from '@northern.tech/types/Alert';
import { Deployment, DeploymentByStatus, DeploymentConfig, SelectionState } from './deploymentsSlice/index.js';
import { DeviceSliceType } from './devicesSlice/index.js';
import { SearchState, SentryConfig, SnackbarContent, Upload } from './appSlice/index.js';
import 'immer';
import '@northern.tech/types/MenderTypes';
import './commonConstants.js';
import 'react/jsx-runtime';
import './appSlice/constants.js';
import '@mui/material/OverridableComponent';
import '@mui/material';
import './organizationSlice/constants.js';
import './devicesSlice/constants.js';

declare const commonErrorFallback = "Please check your connection.";
declare const commonErrorHandler: (err: any, errorContext: any, dispatch: any, fallback?: string, mightBeAuthRelated?: boolean) => Promise<never>;
declare const sessionReducer: (state: any, action: any) => {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
};
declare const getConfiguredStore: (options?: {}) => _reduxjs_toolkit.EnhancedStore<{
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}, any, _reduxjs_toolkit.Tuple<[redux.StoreEnhancer<{
    dispatch: redux_thunk.ThunkDispatch<{
        app: {
            cancelSource: any;
            commit: string;
            demoArtifactLink: string;
            docsVersion: string;
            features: Record<string, boolean>;
            feedbackProbability: number;
            firstLoginAfterSignup: boolean;
            hostAddress: string | null;
            hostedAnnouncement: string;
            newThreshold: string;
            offlineThreshold: string;
            recaptchaSiteKey: string;
            searchState: SearchState;
            sentry: SentryConfig;
            snackbar: SnackbarContent;
            stripeAPIKey: string;
            trackerCode: string;
            uploadsById: Record<string, Upload>;
            versionInformation: {
                [key: string]: string | {
                    releaseDate: string;
                    repos: Record<string, string>;
                } | undefined;
                backend?: string;
                GUI?: string;
                latestRelease?: {
                    releaseDate: string;
                    repos: Record<string, string>;
                };
            };
            yesterday?: string;
        };
        devices: DeviceSliceType;
        deployments: {
            byId: Record<string, Deployment>;
            byStatus: DeploymentByStatus;
            config: DeploymentConfig;
            deploymentDeviceLimit: number;
            selectedDeviceIds: string[];
            selectionState: SelectionState;
        };
        monitor: {
            alerts: {
                alertList: {
                    page: number;
                    perPage: number;
                    total: number;
                };
                byDeviceId: {
                    alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                    latest?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                };
            };
            issueCounts: {
                byType: {
                    issues: {
                        filtered: number;
                        total: number;
                    };
                    offline: {
                        filtered: number;
                        total: number;
                    };
                    failedLastUpdate: {
                        filtered: number;
                        total: number;
                    };
                    monitoring: {
                        filtered: number;
                        total: number;
                    };
                    authRequests: {
                        filtered: number;
                        total: number;
                    };
                    gatewayDevices: {
                        filtered: number;
                        total: number;
                    };
                };
            };
            settings: {
                global: {
                    channels: {
                        email: {
                            enabled: boolean;
                        };
                    };
                };
            };
        };
        onboarding: {
            address?: string;
            approach: OnboardingApproach | null;
            complete: boolean;
            demoArtifactPort: number;
            deviceConnection?: string;
            deviceType: string[] | string | null;
            progress: string | null;
            showTips: boolean | null;
            showTipsDialog: boolean;
        };
        organization: OrganizationState;
        releases: ReleaseSliceType;
        users: {
            activationCode?: string;
            byId: Record<string, User>;
            currentSession?: UserSession | object;
            currentUser: string | null;
            customColumns: CustomColumn[];
            globalSettings: GlobalSettings;
            permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
            qrCode: string | null;
            rolesById: Record<string, _northern_tech_utils_constants.Role>;
            rolesInitialized: boolean;
            settingsInitialized: boolean;
            showConnectDeviceDialog: boolean;
            showFeedbackDialog: boolean;
            showStartupNotification: boolean;
            tooltips: {
                byId: Record<string, {
                    readState: ReadState;
                }>;
            };
            userSettings: UserSettings;
            userSettingsInitialized: boolean;
        };
    }, undefined, redux.UnknownAction>;
}>, redux.StoreEnhancer]>>;
declare const store: _reduxjs_toolkit.EnhancedStore<{
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}, any, _reduxjs_toolkit.Tuple<[redux.StoreEnhancer<{
    dispatch: redux_thunk.ThunkDispatch<{
        app: {
            cancelSource: any;
            commit: string;
            demoArtifactLink: string;
            docsVersion: string;
            features: Record<string, boolean>;
            feedbackProbability: number;
            firstLoginAfterSignup: boolean;
            hostAddress: string | null;
            hostedAnnouncement: string;
            newThreshold: string;
            offlineThreshold: string;
            recaptchaSiteKey: string;
            searchState: SearchState;
            sentry: SentryConfig;
            snackbar: SnackbarContent;
            stripeAPIKey: string;
            trackerCode: string;
            uploadsById: Record<string, Upload>;
            versionInformation: {
                [key: string]: string | {
                    releaseDate: string;
                    repos: Record<string, string>;
                } | undefined;
                backend?: string;
                GUI?: string;
                latestRelease?: {
                    releaseDate: string;
                    repos: Record<string, string>;
                };
            };
            yesterday?: string;
        };
        devices: DeviceSliceType;
        deployments: {
            byId: Record<string, Deployment>;
            byStatus: DeploymentByStatus;
            config: DeploymentConfig;
            deploymentDeviceLimit: number;
            selectedDeviceIds: string[];
            selectionState: SelectionState;
        };
        monitor: {
            alerts: {
                alertList: {
                    page: number;
                    perPage: number;
                    total: number;
                };
                byDeviceId: {
                    alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                    latest?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                };
            };
            issueCounts: {
                byType: {
                    issues: {
                        filtered: number;
                        total: number;
                    };
                    offline: {
                        filtered: number;
                        total: number;
                    };
                    failedLastUpdate: {
                        filtered: number;
                        total: number;
                    };
                    monitoring: {
                        filtered: number;
                        total: number;
                    };
                    authRequests: {
                        filtered: number;
                        total: number;
                    };
                    gatewayDevices: {
                        filtered: number;
                        total: number;
                    };
                };
            };
            settings: {
                global: {
                    channels: {
                        email: {
                            enabled: boolean;
                        };
                    };
                };
            };
        };
        onboarding: {
            address?: string;
            approach: OnboardingApproach | null;
            complete: boolean;
            demoArtifactPort: number;
            deviceConnection?: string;
            deviceType: string[] | string | null;
            progress: string | null;
            showTips: boolean | null;
            showTipsDialog: boolean;
        };
        organization: OrganizationState;
        releases: ReleaseSliceType;
        users: {
            activationCode?: string;
            byId: Record<string, User>;
            currentSession?: UserSession | object;
            currentUser: string | null;
            customColumns: CustomColumn[];
            globalSettings: GlobalSettings;
            permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
            qrCode: string | null;
            rolesById: Record<string, _northern_tech_utils_constants.Role>;
            rolesInitialized: boolean;
            settingsInitialized: boolean;
            showConnectDeviceDialog: boolean;
            showFeedbackDialog: boolean;
            showStartupNotification: boolean;
            tooltips: {
                byId: Record<string, {
                    readState: ReadState;
                }>;
            };
            userSettings: UserSettings;
            userSettingsInitialized: boolean;
        };
    }, undefined, redux.UnknownAction>;
}>, redux.StoreEnhancer]>>;
type AppDispatch = typeof store.dispatch;
declare const useAppDispatch: () => AppDispatch;
type RootState = ReturnType<typeof store.getState>;
declare const createAppAsyncThunk: _reduxjs_toolkit.CreateAsyncThunkFunction<{
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}> & {
    withTypes<ThunkApiConfig extends {
        state?: unknown;
        dispatch?: redux_thunk.ThunkDispatch<unknown, unknown, redux.UnknownAction>;
        extra?: unknown;
        rejectValue?: unknown;
        serializedErrorType?: unknown;
        pendingMeta?: unknown;
        fulfilledMeta?: unknown;
        rejectedMeta?: unknown;
    }>(): _reduxjs_toolkit.CreateAsyncThunkFunction<ThunkApiConfig & Omit<{
        dispatch: AppDispatch;
        state: RootState;
        extra?: unknown;
        rejectValue?: unknown;
        serializedErrorType?: unknown;
        pendingMeta?: unknown;
        fulfilledMeta?: unknown;
        rejectedMeta?: unknown;
    }, keyof ThunkApiConfig> extends infer T ? { [K in keyof T]: T[K]; } : never> & {
        withTypes<ThunkApiConfig_1 extends {
            state?: unknown;
            dispatch?: redux_thunk.ThunkDispatch<unknown, unknown, redux.UnknownAction>;
            extra?: unknown;
            rejectValue?: unknown;
            serializedErrorType?: unknown;
            pendingMeta?: unknown;
            fulfilledMeta?: unknown;
            rejectedMeta?: unknown;
        }>(): _reduxjs_toolkit.CreateAsyncThunkFunction<ThunkApiConfig_1 & Omit<ThunkApiConfig & Omit<{
            dispatch: AppDispatch;
            state: RootState;
            extra?: unknown;
            rejectValue?: unknown;
            serializedErrorType?: unknown;
            pendingMeta?: unknown;
            fulfilledMeta?: unknown;
            rejectedMeta?: unknown;
        }, keyof ThunkApiConfig> extends infer T_2 ? { [K in keyof T_2]: T_2[K]; } : never, keyof ThunkApiConfig_1> extends infer T_1 ? { [K_1 in keyof T_1]: T_1[K_1]; } : never> & {
            withTypes<ThunkApiConfig_2 extends {
                state?: unknown;
                dispatch?: redux_thunk.ThunkDispatch<unknown, unknown, redux.UnknownAction>;
                extra?: unknown;
                rejectValue?: unknown;
                serializedErrorType?: unknown;
                pendingMeta?: unknown;
                fulfilledMeta?: unknown;
                rejectedMeta?: unknown;
            }>(): _reduxjs_toolkit.CreateAsyncThunkFunction<ThunkApiConfig_2 & Omit<ThunkApiConfig_1 & Omit<ThunkApiConfig & Omit<{
                dispatch: AppDispatch;
                state: RootState;
                extra?: unknown;
                rejectValue?: unknown;
                serializedErrorType?: unknown;
                pendingMeta?: unknown;
                fulfilledMeta?: unknown;
                rejectedMeta?: unknown;
            }, keyof ThunkApiConfig> extends infer T_5 ? { [K in keyof T_5]: T_5[K]; } : never, keyof ThunkApiConfig_1> extends infer T_4 ? { [K_1 in keyof T_4]: T_4[K_1]; } : never, keyof ThunkApiConfig_2> extends infer T_3 ? { [K_2 in keyof T_3]: T_3[K_2]; } : never> & {
                withTypes<ThunkApiConfig_3 extends {
                    state?: unknown;
                    dispatch?: redux_thunk.ThunkDispatch<unknown, unknown, redux.UnknownAction>;
                    extra?: unknown;
                    rejectValue?: unknown;
                    serializedErrorType?: unknown;
                    pendingMeta?: unknown;
                    fulfilledMeta?: unknown;
                    rejectedMeta?: unknown;
                }>(): _reduxjs_toolkit.CreateAsyncThunkFunction<ThunkApiConfig_3 & Omit<ThunkApiConfig_2 & Omit<ThunkApiConfig_1 & Omit<ThunkApiConfig & Omit<{
                    dispatch: AppDispatch;
                    state: RootState;
                    extra?: unknown;
                    rejectValue?: unknown;
                    serializedErrorType?: unknown;
                    pendingMeta?: unknown;
                    fulfilledMeta?: unknown;
                    rejectedMeta?: unknown;
                }, keyof ThunkApiConfig> extends infer T_9 ? { [K in keyof T_9]: T_9[K]; } : never, keyof ThunkApiConfig_1> extends infer T_8 ? { [K_1 in keyof T_8]: T_8[K_1]; } : never, keyof ThunkApiConfig_2> extends infer T_7 ? { [K_2 in keyof T_7]: T_7[K_2]; } : never, keyof ThunkApiConfig_3> extends infer T_6 ? { [K_3 in keyof T_6]: T_6[K_3]; } : never> & {
                    withTypes<ThunkApiConfig_4 extends {
                        state?: unknown;
                        dispatch?: redux_thunk.ThunkDispatch<unknown, unknown, redux.UnknownAction>;
                        extra?: unknown;
                        rejectValue?: unknown;
                        serializedErrorType?: unknown;
                        pendingMeta?: unknown;
                        fulfilledMeta?: unknown;
                        rejectedMeta?: unknown;
                    }>(): _reduxjs_toolkit.CreateAsyncThunkFunction<ThunkApiConfig_4 & Omit<ThunkApiConfig_3 & Omit<ThunkApiConfig_2 & Omit<ThunkApiConfig_1 & Omit<ThunkApiConfig & Omit<{
                        dispatch: AppDispatch;
                        state: RootState;
                        extra?: unknown;
                        rejectValue?: unknown;
                        serializedErrorType?: unknown;
                        pendingMeta?: unknown;
                        fulfilledMeta?: unknown;
                        rejectedMeta?: unknown;
                    }, keyof ThunkApiConfig> extends infer T_14 ? { [K in keyof T_14]: T_14[K]; } : never, keyof ThunkApiConfig_1> extends infer T_13 ? { [K_1 in keyof T_13]: T_13[K_1]; } : never, keyof ThunkApiConfig_2> extends infer T_12 ? { [K_2 in keyof T_12]: T_12[K_2]; } : never, keyof ThunkApiConfig_3> extends infer T_11 ? { [K_3 in keyof T_11]: T_11[K_3]; } : never, keyof ThunkApiConfig_4> extends infer T_10 ? { [K_4 in keyof T_10]: T_10[K_4]; } : never> & {
                        withTypes<ThunkApiConfig_5 extends {
                            state?: unknown;
                            dispatch?: redux_thunk.ThunkDispatch<unknown, unknown, redux.UnknownAction>;
                            extra?: unknown;
                            rejectValue?: unknown;
                            serializedErrorType?: unknown;
                            pendingMeta?: unknown;
                            fulfilledMeta?: unknown;
                            rejectedMeta?: unknown;
                        }>(): _reduxjs_toolkit.CreateAsyncThunkFunction<ThunkApiConfig_5 & Omit<ThunkApiConfig_4 & Omit<ThunkApiConfig_3 & Omit<ThunkApiConfig_2 & Omit<ThunkApiConfig_1 & Omit<ThunkApiConfig & Omit<{
                            dispatch: AppDispatch;
                            state: RootState;
                            extra?: unknown;
                            rejectValue?: unknown;
                            serializedErrorType?: unknown;
                            pendingMeta?: unknown;
                            fulfilledMeta?: unknown;
                            rejectedMeta?: unknown;
                        }, keyof ThunkApiConfig> extends infer T_20 ? { [K in keyof T_20]: T_20[K]; } : never, keyof ThunkApiConfig_1> extends infer T_19 ? { [K_1 in keyof T_19]: T_19[K_1]; } : never, keyof ThunkApiConfig_2> extends infer T_18 ? { [K_2 in keyof T_18]: T_18[K_2]; } : never, keyof ThunkApiConfig_3> extends infer T_17 ? { [K_3 in keyof T_17]: T_17[K_3]; } : never, keyof ThunkApiConfig_4> extends infer T_16 ? { [K_4 in keyof T_16]: T_16[K_4]; } : never, keyof ThunkApiConfig_5> extends infer T_15 ? { [K_5 in keyof T_15]: T_15[K_5]; } : never> & {
                            withTypes<ThunkApiConfig_6 extends {
                                state?: unknown;
                                dispatch?: redux_thunk.ThunkDispatch<unknown, unknown, redux.UnknownAction>;
                                extra?: unknown;
                                rejectValue?: unknown;
                                serializedErrorType?: unknown;
                                pendingMeta?: unknown;
                                fulfilledMeta?: unknown;
                                rejectedMeta?: unknown;
                            }>(): _reduxjs_toolkit.CreateAsyncThunkFunction<ThunkApiConfig_6 & Omit<ThunkApiConfig_5 & Omit<ThunkApiConfig_4 & Omit<ThunkApiConfig_3 & Omit<ThunkApiConfig_2 & Omit<ThunkApiConfig_1 & Omit<ThunkApiConfig & Omit<{
                                dispatch: AppDispatch;
                                state: RootState;
                                extra?: unknown;
                                rejectValue?: unknown;
                                serializedErrorType?: unknown;
                                pendingMeta?: unknown;
                                fulfilledMeta?: unknown;
                                rejectedMeta?: unknown;
                            }, keyof ThunkApiConfig> extends infer T_27 ? { [K in keyof T_27]: T_27[K]; } : never, keyof ThunkApiConfig_1> extends infer T_26 ? { [K_1 in keyof T_26]: T_26[K_1]; } : never, keyof ThunkApiConfig_2> extends infer T_25 ? { [K_2 in keyof T_25]: T_25[K_2]; } : never, keyof ThunkApiConfig_3> extends infer T_24 ? { [K_3 in keyof T_24]: T_24[K_3]; } : never, keyof ThunkApiConfig_4> extends infer T_23 ? { [K_4 in keyof T_23]: T_23[K_4]; } : never, keyof ThunkApiConfig_5> extends infer T_22 ? { [K_5 in keyof T_22]: T_22[K_5]; } : never, keyof ThunkApiConfig_6> extends infer T_21 ? { [K_6 in keyof T_21]: T_21[K_6]; } : never> & {
                                withTypes<ThunkApiConfig_7 extends {
                                    state?: unknown;
                                    dispatch?: redux_thunk.ThunkDispatch<unknown, unknown, redux.UnknownAction>;
                                    extra?: unknown;
                                    rejectValue?: unknown;
                                    serializedErrorType?: unknown;
                                    pendingMeta?: unknown;
                                    fulfilledMeta?: unknown;
                                    rejectedMeta?: unknown;
                                }>(): _reduxjs_toolkit.CreateAsyncThunkFunction<ThunkApiConfig_7 & Omit<ThunkApiConfig_6 & Omit<ThunkApiConfig_5 & Omit<ThunkApiConfig_4 & Omit<ThunkApiConfig_3 & Omit<ThunkApiConfig_2 & Omit<ThunkApiConfig_1 & Omit<ThunkApiConfig & Omit<{
                                    dispatch: AppDispatch;
                                    state: RootState;
                                    extra?: unknown;
                                    rejectValue?: unknown;
                                    serializedErrorType?: unknown;
                                    pendingMeta?: unknown;
                                    fulfilledMeta?: unknown;
                                    rejectedMeta?: unknown;
                                }, keyof ThunkApiConfig> extends infer T_35 ? { [K in keyof T_35]: T_35[K]; } : never, keyof ThunkApiConfig_1> extends infer T_34 ? { [K_1 in keyof T_34]: T_34[K_1]; } : never, keyof ThunkApiConfig_2> extends infer T_33 ? { [K_2 in keyof T_33]: T_33[K_2]; } : never, keyof ThunkApiConfig_3> extends infer T_32 ? { [K_3 in keyof T_32]: T_32[K_3]; } : never, keyof ThunkApiConfig_4> extends infer T_31 ? { [K_4 in keyof T_31]: T_31[K_4]; } : never, keyof ThunkApiConfig_5> extends infer T_30 ? { [K_5 in keyof T_30]: T_30[K_5]; } : never, keyof ThunkApiConfig_6> extends infer T_29 ? { [K_6 in keyof T_29]: T_29[K_6]; } : never, keyof ThunkApiConfig_7> extends infer T_28 ? { [K_7 in keyof T_28]: T_28[K_7]; } : never> & {
                                    withTypes<ThunkApiConfig_8 extends {
                                        state?: unknown;
                                        dispatch?: redux_thunk.ThunkDispatch<unknown, unknown, redux.UnknownAction>;
                                        extra?: unknown;
                                        rejectValue?: unknown;
                                        serializedErrorType?: unknown;
                                        pendingMeta?: unknown;
                                        fulfilledMeta?: unknown;
                                        rejectedMeta?: unknown;
                                    }>(): _reduxjs_toolkit.CreateAsyncThunkFunction<ThunkApiConfig_8 & Omit<ThunkApiConfig_7 & Omit<ThunkApiConfig_6 & Omit<ThunkApiConfig_5 & Omit<ThunkApiConfig_4 & Omit<ThunkApiConfig_3 & Omit<ThunkApiConfig_2 & Omit<ThunkApiConfig_1 & Omit<ThunkApiConfig & Omit<{
                                        dispatch: AppDispatch;
                                        state: RootState;
                                        extra?: unknown;
                                        rejectValue?: unknown;
                                        serializedErrorType?: unknown;
                                        pendingMeta?: unknown;
                                        fulfilledMeta?: unknown;
                                        rejectedMeta?: unknown;
                                    }, keyof ThunkApiConfig> extends infer T_44 ? { [K in keyof T_44]: T_44[K]; } : never, keyof ThunkApiConfig_1> extends infer T_43 ? { [K_1 in keyof T_43]: T_43[K_1]; } : never, keyof ThunkApiConfig_2> extends infer T_42 ? { [K_2 in keyof T_42]: T_42[K_2]; } : never, keyof ThunkApiConfig_3> extends infer T_41 ? { [K_3 in keyof T_41]: T_41[K_3]; } : never, keyof ThunkApiConfig_4> extends infer T_40 ? { [K_4 in keyof T_40]: T_40[K_4]; } : never, keyof ThunkApiConfig_5> extends infer T_39 ? { [K_5 in keyof T_39]: T_39[K_5]; } : never, keyof ThunkApiConfig_6> extends infer T_38 ? { [K_6 in keyof T_38]: T_38[K_6]; } : never, keyof ThunkApiConfig_7> extends infer T_37 ? { [K_7 in keyof T_37]: T_37[K_7]; } : never, keyof ThunkApiConfig_8> extends infer T_36 ? { [K_8 in keyof T_36]: T_36[K_8]; } : never> & {
                                        withTypes<ThunkApiConfig_9 extends {
                                            state?: unknown;
                                            dispatch?: redux_thunk.ThunkDispatch<unknown, unknown, redux.UnknownAction>;
                                            extra?: unknown;
                                            rejectValue?: unknown;
                                            serializedErrorType?: unknown;
                                            pendingMeta?: unknown;
                                            fulfilledMeta?: unknown;
                                            rejectedMeta?: unknown;
                                        }>(): _reduxjs_toolkit.CreateAsyncThunkFunction<ThunkApiConfig_9 & Omit<ThunkApiConfig_8 & Omit<ThunkApiConfig_7 & Omit<ThunkApiConfig_6 & Omit<ThunkApiConfig_5 & Omit<ThunkApiConfig_4 & Omit<ThunkApiConfig_3 & Omit<ThunkApiConfig_2 & Omit<ThunkApiConfig_1 & Omit<ThunkApiConfig & Omit<{
                                            dispatch: AppDispatch;
                                            state: RootState;
                                            extra?: unknown;
                                            rejectValue?: unknown;
                                            serializedErrorType?: unknown;
                                            pendingMeta?: unknown;
                                            fulfilledMeta?: unknown;
                                            rejectedMeta?: unknown;
                                        }, keyof ThunkApiConfig> extends infer T_54 ? { [K in keyof T_54]: T_54[K]; } : never, keyof ThunkApiConfig_1> extends infer T_53 ? { [K_1 in keyof T_53]: T_53[K_1]; } : never, keyof ThunkApiConfig_2> extends infer T_52 ? { [K_2 in keyof T_52]: T_52[K_2]; } : never, keyof ThunkApiConfig_3> extends infer T_51 ? { [K_3 in keyof T_51]: T_51[K_3]; } : never, keyof ThunkApiConfig_4> extends infer T_50 ? { [K_4 in keyof T_50]: T_50[K_4]; } : never, keyof ThunkApiConfig_5> extends infer T_49 ? { [K_5 in keyof T_49]: T_49[K_5]; } : never, keyof ThunkApiConfig_6> extends infer T_48 ? { [K_6 in keyof T_48]: T_48[K_6]; } : never, keyof ThunkApiConfig_7> extends infer T_47 ? { [K_7 in keyof T_47]: T_47[K_7]; } : never, keyof ThunkApiConfig_8> extends infer T_46 ? { [K_8 in keyof T_46]: T_46[K_8]; } : never, keyof ThunkApiConfig_9> extends infer T_45 ? { [K_9 in keyof T_45]: T_45[K_9]; } : never> & {
                                            withTypes<ThunkApiConfig_10 extends {
                                                state?: unknown;
                                                dispatch?: redux_thunk.ThunkDispatch<unknown, unknown, redux.UnknownAction>;
                                                extra?: unknown;
                                                rejectValue?: unknown;
                                                serializedErrorType?: unknown;
                                                pendingMeta?: unknown;
                                                fulfilledMeta?: unknown;
                                                rejectedMeta?: unknown;
                                            }>(): _reduxjs_toolkit.CreateAsyncThunkFunction<ThunkApiConfig_10 & Omit<ThunkApiConfig_9 & Omit<ThunkApiConfig_8 & Omit<ThunkApiConfig_7 & Omit<ThunkApiConfig_6 & Omit<ThunkApiConfig_5 & Omit<ThunkApiConfig_4 & Omit<ThunkApiConfig_3 & Omit<ThunkApiConfig_2 & Omit<ThunkApiConfig_1 & Omit<ThunkApiConfig & Omit</*elided*/ any, keyof ThunkApiConfig> extends infer T_65 ? { [K in keyof T_65]: T_65[K]; } : never, keyof ThunkApiConfig_1> extends infer T_64 ? { [K_1 in keyof T_64]: T_64[K_1]; } : never, keyof ThunkApiConfig_2> extends infer T_63 ? { [K_2 in keyof T_63]: T_63[K_2]; } : never, keyof ThunkApiConfig_3> extends infer T_62 ? { [K_3 in keyof T_62]: T_62[K_3]; } : never, keyof ThunkApiConfig_4> extends infer T_61 ? { [K_4 in keyof T_61]: T_61[K_4]; } : never, keyof ThunkApiConfig_5> extends infer T_60 ? { [K_5 in keyof T_60]: T_60[K_5]; } : never, keyof ThunkApiConfig_6> extends infer T_59 ? { [K_6 in keyof T_59]: T_59[K_6]; } : never, keyof ThunkApiConfig_7> extends infer T_58 ? { [K_7 in keyof T_58]: T_58[K_7]; } : never, keyof ThunkApiConfig_8> extends infer T_57 ? { [K_8 in keyof T_57]: T_57[K_8]; } : never, keyof ThunkApiConfig_9> extends infer T_56 ? { [K_9 in keyof T_56]: T_56[K_9]; } : never, keyof ThunkApiConfig_10> extends infer T_55 ? { [K_10 in keyof T_55]: T_55[K_10]; } : never> & /*elided*/ any;
                                        };
                                    };
                                };
                            };
                        };
                    };
                };
            };
        };
    };
};

export { type AppDispatch, type RootState, commonErrorFallback, commonErrorHandler, createAppAsyncThunk, getConfiguredStore, sessionReducer, store, useAppDispatch };
