type UiPermission = {
    explanations: object;
    permissionLevel: number;
    permissionSets: Record<string, string>;
    title: string;
    value: string;
    verbs: string[];
};
type ExcessiveAccessConfig = {
    selector: string;
    warning: string;
};
type EndpointDefinition = {
    path: RegExp;
    types: string[];
    uiPermissions: UiPermission[];
};
/**
 * _uiPermissions_ represent the possible permissions/ rights that can be given for the area
 * _endpoints_ represent the possible endpoints this definition might be affecting in the UI and what
 *              functionality might be affected
 *
 */
type PermissionsArea = {
    endpoints: EndpointDefinition[];
    excessiveAccessConfig?: ExcessiveAccessConfig;
    explanation: string;
    filter?: (object: any) => string[];
    key: string;
    placeholder?: string;
    scope?: string;
    title: string;
    uiPermissions: UiPermission[];
};
declare const itemUiPermissionsReducer: (accu: any, { item, uiPermissions }: {
    item: any;
    uiPermissions: any;
}) => any;
declare const checkPermissionsObject: (permissions: any, requiredPermission: any, scopedAccess: any, superAccess: any) => any;
declare const USER_LOGOUT = "USER_LOGOUT";
declare const OWN_USER_ID = "me";
declare const settingsKeys: {
    initialized: string;
};
declare const READ_STATES: {
    readonly read: "read";
    readonly seen: "seen";
    readonly unread: "unread";
};
type ReadState = keyof typeof READ_STATES;

export { OWN_USER_ID, type PermissionsArea, READ_STATES, type ReadState, USER_LOGOUT, type UiPermission, checkPermissionsObject, itemUiPermissionsReducer, settingsKeys };
