import { Limit } from './Limit.cjs';
import { XDeltaArgsLimits } from './XDeltaArgsLimits.cjs';

/**
 * The mender-binary-delta-generator configuration limits.
 */
type BinaryDeltaLimits = {
    xdelta_args_limits?: XDeltaArgsLimits;
    timeout?: Limit;
    /**
     * Maximum number of delta generation jobs which can be run in parallel.
     */
    jobs_in_parallel?: Limit;
    /**
     * Maximum number of queued delta generation jobs.
     */
    queue_length?: Limit;
};

export type { BinaryDeltaLimits };
