import { Permission } from './Permission.cjs';
import './PermissionObject.cjs';

/**
 * Permission set descriptor.
 */
type PermissionSet = {
    /**
     * A unique name.
     */
    name: string;
    action?: string;
    object?: string;
    /**
     * Description of the permission set.
     */
    description?: string;
    permissions: Array<Permission>;
    supported_scope_types?: Array<string>;
};

export type { PermissionSet };
