"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/constants/index.ts
var constants_exports = {};
__export(constants_exports, {
  ALL_DEVICES: () => ALL_DEVICES,
  ALL_DEVICE_STATES: () => ALL_DEVICE_STATES,
  ALL_RELEASES: () => ALL_RELEASES,
  APPLICATION_JSON_CONTENT_TYPE: () => APPLICATION_JSON_CONTENT_TYPE,
  APPLICATION_JWT_CONTENT_TYPE: () => APPLICATION_JWT_CONTENT_TYPE,
  ATTRIBUTE_SCOPES: () => ATTRIBUTE_SCOPES,
  DEVICE_FILTERING_OPTIONS: () => DEVICE_FILTERING_OPTIONS,
  DEVICE_ISSUE_OPTIONS: () => DEVICE_ISSUE_OPTIONS,
  DEVICE_LIST_DEFAULTS: () => DEVICE_LIST_DEFAULTS,
  DEVICE_STATES: () => DEVICE_STATES,
  PermissionTypes: () => PermissionTypes,
  SORTING_OPTIONS: () => SORTING_OPTIONS,
  alertChannels: () => alertChannels,
  apiRoot: () => apiRoot,
  apiUrl: () => apiUrl,
  auditLogsApiUrl: () => auditLogsApiUrl,
  defaultPermissionSets: () => defaultPermissionSets,
  deploymentsApiUrl: () => deploymentsApiUrl,
  deploymentsApiUrlV1: () => deploymentsApiUrlV1,
  deploymentsApiUrlV2: () => deploymentsApiUrlV2,
  deviceAuthV2: () => deviceAuthV2,
  deviceConfig: () => deviceConfig,
  deviceConnect: () => deviceConnect,
  emptyRole: () => emptyRole,
  emptyUiPermissions: () => emptyUiPermissions,
  headerNames: () => headerNames,
  inventoryApiUrl: () => inventoryApiUrl,
  inventoryApiUrlV1: () => inventoryApiUrlV1,
  inventoryApiUrlV2: () => inventoryApiUrlV2,
  iotManagerBaseURL: () => iotManagerBaseURL,
  limitDefault: () => limitDefault,
  maxSessionAge: () => maxSessionAge,
  monitorApiUrlv1: () => monitorApiUrlv1,
  reportingApiUrl: () => reportingApiUrl,
  rolesById: () => rolesById,
  rolesByName: () => rolesByName,
  scopedPermissionAreas: () => scopedPermissionAreas,
  serviceProviderRolesById: () => serviceProviderRolesById,
  ssoIdpApiUrlv1: () => ssoIdpApiUrlv1,
  tenantadmApiUrlv1: () => tenantadmApiUrlv1,
  tenantadmApiUrlv2: () => tenantadmApiUrlv2,
  twoFAStates: () => twoFAStates,
  uiPermissionsByArea: () => uiPermissionsByArea,
  uiPermissionsById: () => uiPermissionsById,
  useradmApiUrl: () => useradmApiUrl,
  useradmApiUrlv1: () => useradmApiUrlv1,
  useradmApiUrlv2: () => useradmApiUrlv2
});
module.exports = __toCommonJS(constants_exports);

// src/constants/api.ts
var apiRoot = "/api/management";
var apiUrl = {
  v1: `${apiRoot}/v1`,
  v2: `${apiRoot}/v2`
};
var auditLogsApiUrl = `${apiUrl.v1}/auditlogs`;
var deploymentsApiUrl = `${apiUrl.v1}/deployments`;
var deploymentsApiUrlV1 = deploymentsApiUrl;
var deploymentsApiUrlV2 = `${apiUrl.v2}/deployments`;
var deviceAuthV2 = `${apiUrl.v2}/devauth`;
var deviceConfig = `${apiUrl.v1}/deviceconfig/configurations/device`;
var deviceConnect = `${apiUrl.v1}/deviceconnect`;
var inventoryApiUrl = `${apiUrl.v1}/inventory`;
var inventoryApiUrlV1 = inventoryApiUrl;
var inventoryApiUrlV2 = `${apiUrl.v2}/inventory`;
var iotManagerBaseURL = `${apiUrl.v1}/iot-manager`;
var monitorApiUrlv1 = `${apiUrl.v1}/devicemonitor`;
var reportingApiUrl = `${apiUrl.v1}/reporting`;
var ssoIdpApiUrlv1 = `${apiUrl.v1}/useradm/sso/idp/metadata`;
var tenantadmApiUrlv1 = `${apiUrl.v1}/tenantadm`;
var tenantadmApiUrlv2 = `${apiUrl.v2}/tenantadm`;
var useradmApiUrl = `${apiUrl.v1}/useradm`;
var useradmApiUrlv1 = useradmApiUrl;
var useradmApiUrlv2 = `${apiUrl.v2}/useradm`;
var maxSessionAge = 900;
var headerNames = {
  link: "link",
  location: "location",
  total: "x-total-count"
};

// src/constants/app.ts
var APPLICATION_JSON_CONTENT_TYPE = "application/json";
var APPLICATION_JWT_CONTENT_TYPE = "application/jwt";

// src/constants/devices.ts
var DEVICE_STATES = {
  accepted: "accepted",
  pending: "pending",
  preauth: "preauthorized",
  rejected: "rejected"
};
var ALL_DEVICE_STATES = "any";
var DEVICE_FILTERING_OPTIONS = {
  $eq: { key: "$eq", title: "equals", shortform: "=" },
  $ne: { key: "$ne", title: "not equal", shortform: "!=" },
  $gt: {
    key: "$gt",
    title: ">",
    shortform: ">",
    help: 'The "greater than" operator can work both on numbers and strings. In the latter case, the operator applies the lexicographical order to the value strings.'
  },
  $gte: {
    title: ">=",
    shortform: ">=",
    help: 'The "greater than or equal" operator can work both on numbers and strings. In the latter case, the operator applies the lexicographical order to the value strings.'
  },
  $lt: {
    key: "$lt",
    title: "<",
    shortform: "<",
    help: 'The "lesser than" operator can work both on numbers and strings. In the latter case, the operator applies the lexicographical order to the value strings.'
  },
  $lte: {
    title: "<=",
    shortform: "<=",
    help: 'The "lesser than or equal" operator can work both on numbers and strings. In the latter case, the operator applies the lexicographical order to the value strings.'
  },
  $ltne: {
    key: "$ltne",
    title: "$ltne",
    shortform: "ltne",
    help: 'The "lesser than or does not exist" operator can work both on numbers and strings. In the latter case, the operator applies the lexicographical order to the value strings.'
  },
  $in: {
    key: "$in",
    title: "in",
    shortform: "in",
    help: 'The "in" operator accepts a list of comma-separated values. It matches if the selected field is equal to one of the specified values.'
  },
  $nin: {
    key: "$nin",
    title: "not in",
    shortform: "not in",
    help: `The "not in" operator accepts a list of comma-separated values. It matches if the selected field's value is not equal to any of the specified options.`
  },
  $exists: {
    key: "$exists",
    title: "exists",
    shortform: "exists",
    value: true,
    help: `The "exists" operator matches if the selected field's value has a value. No value needs to be provided for this operator.`
  },
  $nexists: {
    key: "$nexists",
    title: `doesn't exist`,
    shortform: `doesn't exist`,
    value: true,
    help: `The "doesn't exist" operator matches if the selected field's value has no value. No value needs to be provided for this operator.`
  },
  $regex: {
    key: "$regex",
    title: `matches regular expression`,
    shortform: `matches`,
    help: `The "regular expression" operator matches the selected field's value with a Perl compatible regular expression (PCRE), automatically anchored by ^. If the regular expression is not valid, the filter will produce no results. If you need to specify options and flags, you can provide the full regex in the format of /regex/flags, for example.`
  }
};
var ATTRIBUTE_SCOPES = {
  inventory: "inventory",
  identity: "identity",
  monitor: "monitor",
  system: "system",
  tags: "tags"
};
var ALL_DEVICES = "All devices";
var DEVICE_ISSUE_OPTIONS = {
  issues: {
    isCategory: true,
    key: "issues",
    title: "Devices with issues",
    filterRule: {}
  },
  offline: {
    issueCategory: "issues",
    key: "offline",
    needsFullFiltering: true,
    needsMonitor: false,
    needsReporting: false,
    filterRule: {
      scope: "system",
      key: "check_in_time",
      operator: DEVICE_FILTERING_OPTIONS.$ltne.key,
      value: ({ offlineThreshold }) => offlineThreshold
    },
    title: "Offline devices"
  },
  failedLastUpdate: {
    issueCategory: "issues",
    key: "failedLastUpdate",
    needsFullFiltering: false,
    needsMonitor: false,
    needsReporting: true,
    filterRule: { scope: "monitor", key: "failed_last_update", operator: DEVICE_FILTERING_OPTIONS.$eq.key, value: true },
    title: "Deployment failed"
  },
  monitoring: {
    issueCategory: "issues",
    key: "monitoring",
    needsFullFiltering: false,
    needsMonitor: true,
    needsReporting: false,
    filterRule: { scope: "monitor", key: "alerts", operator: DEVICE_FILTERING_OPTIONS.$eq.key, value: true },
    title: "Monitoring alert"
  },
  authRequests: {
    key: "authRequests",
    needsFullFiltering: false,
    needsMonitor: false,
    needsReporting: true,
    filterRule: { scope: "monitor", key: "auth_requests", operator: DEVICE_FILTERING_OPTIONS.$gt.key, value: 1 },
    title: "Devices with new authentication requests"
  },
  gatewayDevices: {
    key: "gatewayDevices",
    needsFullFiltering: false,
    needsMonitor: false,
    needsReporting: true,
    filterRule: { scope: "inventory", key: "mender_is_gateway", operator: DEVICE_FILTERING_OPTIONS.$eq.key, value: "true" },
    title: "Gateway devices"
  }
};

// src/constants/users.ts
var emptyUiPermissions = Object.freeze({
  auditlog: [],
  deployments: [],
  groups: Object.freeze({}),
  releases: Object.freeze({}),
  tenantManagement: [],
  userManagement: []
});
var emptyRole = Object.freeze({
  name: "",
  description: "",
  permissions: [],
  uiPermissions: Object.freeze({ ...emptyUiPermissions })
});
var staticRolesByName = {
  admin: "RBAC_ROLE_PERMIT_ALL",
  readOnly: "RBAC_ROLE_OBSERVER",
  ci: "RBAC_ROLE_CI",
  deploymentsManager: "RBAC_ROLE_DEPLOYMENTS_MANAGER",
  terminalAccess: "RBAC_ROLE_REMOTE_TERMINAL"
};
var PermissionTypes = {
  Any: "any",
  Get: "GET",
  Post: "POST",
  Put: "PUT",
  Delete: "DELETE",
  Patch: "PATCH",
  DeviceGroup: "DEVICE_GROUP",
  DeviceId: "DEVICE_ID"
};
var permissionSetIds = {
  Basic: "Basic",
  ConfigureDevices: "ConfigureDevices",
  ConnectToDevices: "ConnectToDevices",
  DeployToDevices: "DeployToDevices",
  ManageDevices: "ManageDevices",
  ManageReleases: "ManageReleases",
  ManageTenants: "ManageTenants",
  ManageUsers: "ManageUsers",
  ReadAuditLogs: "ReadAuditLogs",
  ReadDevices: "ReadDevices",
  ReadReleases: "ReadReleases",
  ReadTenants: "ReadTenants",
  ReadUsers: "ReadUsers",
  SuperUser: "SuperUser",
  UploadArtifacts: "UploadArtifacts"
};
var uiPermissionsById = {
  configure: {
    explanations: { groups: `'Configure' allows the user to use mender-configure features and apply configurations.` },
    permissionLevel: 2,
    permissionSets: { groups: permissionSetIds.ConfigureDevices },
    title: "Configure",
    value: "configure",
    verbs: [PermissionTypes.Get, PermissionTypes.Put, PermissionTypes.Post]
  },
  connect: {
    explanations: { groups: `'Connect' allows the user to use mender-connect features and Troubleshoot add-ons.` },
    permissionLevel: 2,
    permissionSets: { groups: permissionSetIds.ConnectToDevices },
    title: "Connect",
    value: "connect",
    verbs: [PermissionTypes.Get, PermissionTypes.Put]
  },
  deploy: {
    explanations: { groups: `'Deploy' allows the user to deploy software or configuration updates to devices.` },
    permissionLevel: 2,
    permissionSets: { deployments: permissionSetIds.DeployToDevices, groups: permissionSetIds.DeployToDevices },
    title: "Deploy",
    value: "deploy",
    verbs: [PermissionTypes.Post]
  },
  manage: {
    explanations: {
      groups: `'Manage' allows the user to edit device name, notes, and manage authentication status. For 'All devices' it also allows the user to edit and create device groups.`,
      releases: `'Manage' allows the user to upload new artifacts, edit release descriptions and remove artifacts.`
    },
    permissionLevel: 2,
    permissionSets: {
      groups: permissionSetIds.ManageDevices,
      releases: permissionSetIds.ManageReleases,
      tenantManagement: permissionSetIds.ManageTenants,
      userManagement: permissionSetIds.ManageUsers
    },
    title: "Manage",
    value: "manage",
    verbs: [PermissionTypes.Post, PermissionTypes.Put, PermissionTypes.Patch]
  },
  read: {
    explanations: { groups: `'Read' allows the user to view devices.` },
    permissionLevel: 1,
    permissionSets: {
      auditlog: permissionSetIds.ReadAuditLogs,
      groups: permissionSetIds.ReadDevices,
      releases: permissionSetIds.ReadReleases,
      tenantManagement: permissionSetIds.ReadTenants,
      userManagement: permissionSetIds.ReadUsers
    },
    title: "Read",
    value: "read",
    verbs: [PermissionTypes.Get, PermissionTypes.Post]
  },
  upload: {
    explanations: { groups: `'Upload' allows the user to upload new Artifacts.` },
    unscopedOnly: { releases: true },
    permissionLevel: 1,
    permissionSets: { releases: permissionSetIds.UploadArtifacts },
    title: "Upload",
    value: "upload",
    verbs: [PermissionTypes.Post, PermissionTypes.Put, PermissionTypes.Patch]
  }
};
var scopedPermissionAreas = {
  groups: { key: "groups", excessiveAccessSelector: ALL_DEVICES, scopeType: "DeviceGroups" },
  releases: { key: "releases", excessiveAccessSelector: ALL_RELEASES, scopeType: "Releases" }
};
var uiPermissionsByArea = {
  auditlog: {
    endpoints: [{ path: /\/(auditlog)/i, types: [PermissionTypes.Get], uiPermissions: [uiPermissionsById.read] }],
    explanation: "Granting access to the audit log will allow tracing changes to devices, releases and user accounts, as well as providing information about deployments.",
    key: "auditlog",
    uiPermissions: [uiPermissionsById.read],
    title: "System Audit Log"
  },
  deployments: {
    endpoints: [
      { path: /\/(deployments\/deployments)/i, types: [PermissionTypes.Post, PermissionTypes.Put], uiPermissions: [uiPermissionsById.deploy] },
      { path: /\/(deployments\/deployments)/i, types: [PermissionTypes.Get], uiPermissions: [uiPermissionsById.read] },
      { path: /\/(deployments\/config)/i, types: [PermissionTypes.Get, PermissionTypes.Put], uiPermissions: [uiPermissionsById.manage] }
    ],
    explanation: "Providing deploy permissions will allow deployments to be created using the releases and devices a user has access to.",
    key: "deployments",
    uiPermissions: [uiPermissionsById.read, uiPermissionsById.deploy],
    title: "Deployments"
  },
  groups: {
    endpoints: [
      {
        path: /\/(devauth|inventory|deviceconfig|devicemonitor|deviceconnect\/devices)/i,
        types: [PermissionTypes.Get],
        uiPermissions: [uiPermissionsById.read]
      },
      { path: /\/(devauth|inventory)/i, types: [PermissionTypes.Put, PermissionTypes.Post], uiPermissions: [uiPermissionsById.manage] },
      { path: /\/(deviceconfig)/i, types: [PermissionTypes.Get, PermissionTypes.Put, PermissionTypes.Post], uiPermissions: [uiPermissionsById.configure] },
      { path: /\/(deviceconnect\/devices)/i, types: [PermissionTypes.Get, PermissionTypes.Post], uiPermissions: [uiPermissionsById.connect] }
    ],
    explanation: "Device group management permissions control the degree to which devices in a group can be accessed and moved to other groups.",
    key: "groups",
    scope: scopedPermissionAreas.groups.scopeType,
    uiPermissions: [uiPermissionsById.read, uiPermissionsById.manage, uiPermissionsById.deploy, uiPermissionsById.configure, uiPermissionsById.connect],
    title: "Group Management"
  },
  releases: {
    endpoints: [
      { path: /\/(deployments\/artifacts|deployments\/deployments\/releases)/i, types: [PermissionTypes.Get], uiPermissions: [uiPermissionsById.read] },
      {
        path: /\/(deployments\/artifacts|deployments\/deployments\/releases)/i,
        types: [PermissionTypes.Post, PermissionTypes.Put],
        uiPermissions: [uiPermissionsById.read, uiPermissionsById.upload]
      },
      {
        path: /\/(deployments\/artifacts|deployments\/deployments\/releases)/i,
        types: [PermissionTypes.Delete],
        uiPermissions: [uiPermissionsById.read, uiPermissionsById.manage]
      }
    ],
    explanation: "Release permissions can be granted to allow artifact & release modifications, as well as the creation of new releases.",
    key: "releases",
    scope: "ReleaseTags",
    uiPermissions: [uiPermissionsById.read, uiPermissionsById.manage, uiPermissionsById.upload],
    title: "Release Management"
  },
  tenantManagement: {
    endpoints: [
      { path: /\/(tenantadm\/tenants)/i, types: [PermissionTypes.Get], uiPermissions: [uiPermissionsById.read] },
      { path: /\/(tenantadm\/tenants)/i, types: [PermissionTypes.Post, PermissionTypes.Put], uiPermissions: [uiPermissionsById.manage] },
      { path: /\/(users\/exists)/i, types: [PermissionTypes.Get], uiPermissions: [uiPermissionsById.manage] }
    ],
    explanation: "Tenant management permissions allow listing, creating and modifying child tenants",
    key: "tenantManagement",
    uiPermissions: [uiPermissionsById.read, uiPermissionsById.manage],
    title: "Tenant Management"
  },
  userManagement: {
    endpoints: [
      { path: /\/(useradm)/i, types: [PermissionTypes.Get], uiPermissions: [uiPermissionsById.read] },
      { path: /\/(useradm)/i, types: [PermissionTypes.Post], uiPermissions: [uiPermissionsById.manage] }
    ],
    explanation: "User management permissions should be granted carefully, as these allow privilege increases for any users managed by a user with user management permissions",
    key: "userManagement",
    uiPermissions: [uiPermissionsById.read, uiPermissionsById.manage],
    title: "User Management"
  }
};
var permissionMapper = (permission) => permission.value;
var rolesById = Object.freeze({
  [staticRolesByName.admin]: {
    name: "Admin",
    value: staticRolesByName.admin,
    description: "Full access",
    permissions: [],
    // permissions refers to the values returned from the backend
    uiPermissions: {
      ...emptyUiPermissions,
      auditlog: uiPermissionsByArea.auditlog.uiPermissions.map(permissionMapper),
      deployments: uiPermissionsByArea.deployments.uiPermissions.map(permissionMapper),
      groups: { [ALL_DEVICES]: uiPermissionsByArea.groups.uiPermissions.map(permissionMapper) },
      releases: { [ALL_RELEASES]: uiPermissionsByArea.releases.uiPermissions.map(permissionMapper) },
      userManagement: uiPermissionsByArea.userManagement.uiPermissions.map(permissionMapper)
    }
  },
  [staticRolesByName.readOnly]: {
    name: "Read Access",
    value: staticRolesByName.readOnly,
    description: "Intended for team leaders or limited tech support accounts, this role can see all Devices, Artifacts and Deployment reports but cannot make any changes.",
    permissions: [],
    uiPermissions: {
      ...emptyUiPermissions,
      deployments: [uiPermissionsById.read.value],
      groups: { [ALL_DEVICES]: [uiPermissionsById.read.value] },
      releases: { [ALL_RELEASES]: [uiPermissionsById.read.value] },
      userManagement: [uiPermissionsById.read.value]
    }
  },
  [staticRolesByName.ci]: {
    name: "Releases Manager",
    value: staticRolesByName.ci,
    description: "Intended for automation accounts building software (e.g. CI/CD systems), this role can only manage Artifacts, including upload new Artifacts and delete Artifacts. It does not have access to Devices or Deployments.",
    permissions: [],
    uiPermissions: {
      ...emptyUiPermissions,
      releases: { [ALL_RELEASES]: uiPermissionsByArea.releases.uiPermissions.map(permissionMapper) }
    }
  },
  [staticRolesByName.deploymentsManager]: {
    name: "Deployments Manager",
    value: staticRolesByName.deploymentsManager,
    description: "Intended for users responsible for managing deployments, this role can create and abort deployments",
    permissions: [],
    uiPermissions: {
      ...emptyUiPermissions,
      deployments: uiPermissionsByArea.deployments.uiPermissions.map(permissionMapper),
      groups: { [ALL_DEVICES]: [uiPermissionsById.deploy.value, uiPermissionsById.read.value] },
      releases: { [ALL_RELEASES]: [uiPermissionsById.read.value] }
    }
  },
  [staticRolesByName.terminalAccess]: {
    name: "Troubleshooting",
    value: staticRolesByName.terminalAccess,
    description: "Access to the troubleshooting features: Remote Terminal, File Transfer, Port Forwarding",
    permissions: [],
    uiPermissions: {
      ...emptyUiPermissions,
      groups: { [ALL_DEVICES]: [uiPermissionsById.connect.value] }
    }
  }
});
var serviceProviderRolesById = {
  admin: {
    name: "Admin",
    value: staticRolesByName.admin,
    description: "Full access",
    permissions: [],
    uiPermissions: {
      ...emptyUiPermissions,
      auditlog: uiPermissionsByArea.auditlog.uiPermissions.map(permissionMapper),
      userManagement: uiPermissionsByArea.userManagement.uiPermissions.map(permissionMapper),
      tenantManagement: uiPermissionsByArea.tenantManagement.uiPermissions.map(permissionMapper)
    }
  },
  readOnly: {
    name: "Read access",
    value: staticRolesByName.readOnly,
    description: "This role can see all linked organizations but cannot make any changes",
    permissions: [],
    uiPermissions: {
      ...emptyUiPermissions,
      auditlog: [uiPermissionsById.read.value],
      userManagement: [uiPermissionsById.read.value],
      tenantManagement: [uiPermissionsById.read.value]
    }
  }
};
var defaultPermissionSets = {
  [permissionSetIds.Basic]: {
    name: permissionSetIds.Basic,
    result: {
      // this is needed to prevent the detailed permissions of the basic permission set from being interpreted as allowing read & management access to user endpoints
      userManagement: [uiPermissionsById.read.value]
    }
  },
  [permissionSetIds.SuperUser]: {
    name: permissionSetIds.SuperUser,
    result: {
      ...rolesById[staticRolesByName.admin].uiPermissions
    }
  },
  [permissionSetIds.ManageUsers]: {
    name: permissionSetIds.ManageUsers,
    result: {
      userManagement: [uiPermissionsById.manage.value]
    }
  },
  [permissionSetIds.ReadAuditLogs]: {
    name: permissionSetIds.ReadAuditLogs,
    result: {
      auditlog: [uiPermissionsById.read.value]
    }
  },
  [permissionSetIds.ReadReleases]: {
    name: permissionSetIds.ReadReleases,
    result: {
      releases: { [ALL_RELEASES]: [uiPermissionsById.read.value] }
    }
  },
  [permissionSetIds.ReadTenants]: {
    name: permissionSetIds.ReadTenants,
    result: {
      tenantManagement: [uiPermissionsById.read.value]
    }
  },
  [permissionSetIds.ManageTenants]: {
    name: permissionSetIds.ManageTenants,
    result: {
      tenantManagement: [uiPermissionsById.manage.value]
    }
  },
  [permissionSetIds.ReadUsers]: {
    name: permissionSetIds.ReadUsers,
    result: {
      userManagement: [uiPermissionsById.read.value]
    }
  },
  [permissionSetIds.UploadArtifacts]: {
    name: permissionSetIds.UploadArtifacts,
    result: {
      releases: { [ALL_RELEASES]: [uiPermissionsById.upload.value] }
    }
  },
  [permissionSetIds.ManageReleases]: {
    name: permissionSetIds.ManageReleases,
    result: {
      releases: { [ALL_RELEASES]: [uiPermissionsById.manage.value] }
    }
  },
  [permissionSetIds.ConfigureDevices]: {
    name: permissionSetIds.ConfigureDevices,
    result: {
      deployments: [uiPermissionsById.read.value, uiPermissionsById.deploy.value],
      groups: { [ALL_DEVICES]: [uiPermissionsById.read.value, uiPermissionsById.configure.value] }
    }
  },
  [permissionSetIds.ConnectToDevices]: {
    name: permissionSetIds.ConnectToDevices,
    result: {
      groups: { [ALL_DEVICES]: [uiPermissionsById.read.value, uiPermissionsById.connect.value] }
    }
  },
  [permissionSetIds.DeployToDevices]: {
    name: permissionSetIds.DeployToDevices,
    result: {
      deployments: [uiPermissionsById.deploy.value, uiPermissionsById.manage.value, uiPermissionsById.read.value],
      groups: { [ALL_DEVICES]: [uiPermissionsById.read.value, uiPermissionsById.deploy.value] }
    }
  },
  [permissionSetIds.ManageDevices]: {
    name: permissionSetIds.ManageDevices,
    result: {
      groups: { [ALL_DEVICES]: [uiPermissionsById.read.value, uiPermissionsById.manage.value] }
    }
  },
  [permissionSetIds.ReadDevices]: {
    name: permissionSetIds.ReadDevices,
    result: {
      groups: { [ALL_DEVICES]: [uiPermissionsById.read.value] }
    }
  }
};
var rolesByName = {
  ...staticRolesByName,
  deploymentCreation: { action: "CREATE_DEPLOYMENT", object: { type: "DEVICE_GROUP", value: void 0 } },
  groupAccess: { action: "VIEW_DEVICE", object: { type: "DEVICE_GROUP", value: void 0 } },
  userManagement: { action: "http", object: { type: "any", value: `${useradmApiUrlv1}/.*` } }
};

// src/constants/index.ts
var alertChannels = { email: "email" };
var limitDefault = { min: 5, max: 100, default: 10 };
var ALL_RELEASES = "All releases";
var SORTING_OPTIONS = {
  asc: "asc",
  desc: "desc"
};
var DEVICE_LIST_DEFAULTS = {
  page: 1,
  perPage: 20
};
var twoFAStates = {
  enabled: "enabled",
  disabled: "disabled",
  unverified: "unverified"
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ALL_DEVICES,
  ALL_DEVICE_STATES,
  ALL_RELEASES,
  APPLICATION_JSON_CONTENT_TYPE,
  APPLICATION_JWT_CONTENT_TYPE,
  ATTRIBUTE_SCOPES,
  DEVICE_FILTERING_OPTIONS,
  DEVICE_ISSUE_OPTIONS,
  DEVICE_LIST_DEFAULTS,
  DEVICE_STATES,
  PermissionTypes,
  SORTING_OPTIONS,
  alertChannels,
  apiRoot,
  apiUrl,
  auditLogsApiUrl,
  defaultPermissionSets,
  deploymentsApiUrl,
  deploymentsApiUrlV1,
  deploymentsApiUrlV2,
  deviceAuthV2,
  deviceConfig,
  deviceConnect,
  emptyRole,
  emptyUiPermissions,
  headerNames,
  inventoryApiUrl,
  inventoryApiUrlV1,
  inventoryApiUrlV2,
  iotManagerBaseURL,
  limitDefault,
  maxSessionAge,
  monitorApiUrlv1,
  reportingApiUrl,
  rolesById,
  rolesByName,
  scopedPermissionAreas,
  serviceProviderRolesById,
  ssoIdpApiUrlv1,
  tenantadmApiUrlv1,
  tenantadmApiUrlv2,
  twoFAStates,
  uiPermissionsByArea,
  uiPermissionsById,
  useradmApiUrl,
  useradmApiUrlv1,
  useradmApiUrlv2
});
//# sourceMappingURL=index.cjs.map