import { RolePermission, Role as Role$1, RoleUseradm, PermissionSet as PermissionSet$1 } from '@northern.tech/types/MenderTypes';

type ReadPermission = 'read';
type ManagePermission = 'manage';
type DeployPermission = 'deploy';
type ConfigurePermission = 'configure';
type ConnectPermission = 'connect';
type UploadPermission = 'upload';
type AuditLogPermission = ReadPermission;
type UserManagementPermission = ReadPermission | ManagePermission;
type DeploymentPermission = ReadPermission | ManagePermission | DeployPermission;
type GroupsPermission = ReadPermission | ManagePermission | DeployPermission | ConfigurePermission | ConnectPermission;
type ReleasesPermission = ReadPermission | ManagePermission | UploadPermission;
type AnyPermission = UiPermissionsByIdKey;
type UiPermissionsDefinition = Readonly<{
    auditlog: string[];
    deployments?: string[];
    groups: Record<string, string[]>;
    releases: Record<string, string[]>;
    tenantManagement: string[];
    userManagement: string[];
}>;
type UiRoleDefinition = {
    description: string;
    editable?: boolean;
    isCustom?: boolean;
    name: string;
    permissions?: RolePermission[];
    uiPermissions: UiPermissionsDefinition;
};
declare const emptyUiPermissions: UiPermissionsDefinition;
declare const emptyRole: UiRoleDefinition;
type Role = Role$1 & Omit<RoleUseradm, 'name' | 'description'> & {
    editable?: boolean;
    isCustom?: boolean;
    uiPermissions: UiPermissionsDefinition;
    value?: string;
};
type PermissionSet = Omit<PermissionSet$1, 'name' | 'permissions'> & {
    isCustom?: boolean;
    name: PermissionSetId;
    permissions?: RolePermission[];
    result: Partial<UiPermissionsDefinition>;
};
declare const PermissionTypes: {
    Any: string;
    Get: string;
    Post: string;
    Put: string;
    Delete: string;
    Patch: string;
    DeviceGroup: string;
    DeviceId: string;
};
declare const permissionSetIds: {
    readonly Basic: "Basic";
    readonly ConfigureDevices: "ConfigureDevices";
    readonly ConnectToDevices: "ConnectToDevices";
    readonly DeployToDevices: "DeployToDevices";
    readonly ManageDevices: "ManageDevices";
    readonly ManageReleases: "ManageReleases";
    readonly ManageTenants: "ManageTenants";
    readonly ManageUsers: "ManageUsers";
    readonly ReadAuditLogs: "ReadAuditLogs";
    readonly ReadDevices: "ReadDevices";
    readonly ReadReleases: "ReadReleases";
    readonly ReadTenants: "ReadTenants";
    readonly ReadUsers: "ReadUsers";
    readonly SuperUser: "SuperUser";
    readonly UploadArtifacts: "UploadArtifacts";
};
type PermissionSetId = keyof typeof permissionSetIds;
declare const uiPermissionsById: {
    readonly configure: {
        readonly explanations: {
            readonly groups: "'Configure' allows the user to use mender-configure features and apply configurations.";
        };
        readonly permissionLevel: 2;
        readonly permissionSets: {
            readonly groups: "ConfigureDevices";
        };
        readonly title: "Configure";
        readonly value: ConfigurePermission;
        readonly verbs: readonly [string, string, string];
    };
    readonly connect: {
        readonly explanations: {
            readonly groups: "'Connect' allows the user to use mender-connect features and Troubleshoot add-ons.";
        };
        readonly permissionLevel: 2;
        readonly permissionSets: {
            readonly groups: "ConnectToDevices";
        };
        readonly title: "Connect";
        readonly value: ConnectPermission;
        readonly verbs: readonly [string, string];
    };
    readonly deploy: {
        readonly explanations: {
            readonly groups: "'Deploy' allows the user to deploy software or configuration updates to devices.";
        };
        readonly permissionLevel: 2;
        readonly permissionSets: {
            readonly deployments: "DeployToDevices";
            readonly groups: "DeployToDevices";
        };
        readonly title: "Deploy";
        readonly value: DeployPermission;
        readonly verbs: readonly [string];
    };
    readonly manage: {
        readonly explanations: {
            readonly groups: "'Manage' allows the user to edit device name, notes, and manage authentication status. For 'All devices' it also allows the user to edit and create device groups.";
            readonly releases: "'Manage' allows the user to upload new artifacts, edit release descriptions and remove artifacts.";
        };
        readonly permissionLevel: 2;
        readonly permissionSets: {
            readonly groups: "ManageDevices";
            readonly releases: "ManageReleases";
            readonly tenantManagement: "ManageTenants";
            readonly userManagement: "ManageUsers";
        };
        readonly title: "Manage";
        readonly value: ManagePermission;
        readonly verbs: readonly [string, string, string];
    };
    readonly read: {
        readonly explanations: {
            readonly groups: "'Read' allows the user to view devices.";
        };
        readonly permissionLevel: 1;
        readonly permissionSets: {
            readonly auditlog: "ReadAuditLogs";
            readonly groups: "ReadDevices";
            readonly releases: "ReadReleases";
            readonly tenantManagement: "ReadTenants";
            readonly userManagement: "ReadUsers";
        };
        readonly title: "Read";
        readonly value: ReadPermission;
        readonly verbs: readonly [string, string];
    };
    readonly upload: {
        readonly explanations: {
            readonly groups: "'Upload' allows the user to upload new Artifacts.";
        };
        readonly unscopedOnly: {
            readonly releases: true;
        };
        readonly permissionLevel: 1;
        readonly permissionSets: {
            readonly releases: "UploadArtifacts";
        };
        readonly title: "Upload";
        readonly value: UploadPermission;
        readonly verbs: readonly [string, string, string];
    };
};
type UiPermissionsByIdKey = keyof typeof uiPermissionsById;
type PermissionObject = (typeof uiPermissionsById)[UiPermissionsByIdKey];
declare const scopedPermissionAreas: {
    readonly groups: {
        readonly key: "groups";
        readonly excessiveAccessSelector: "All devices";
        readonly scopeType: "DeviceGroups";
    };
    readonly releases: {
        readonly key: "releases";
        readonly excessiveAccessSelector: "All releases";
        readonly scopeType: "Releases";
    };
};
type ScopedPermissionsByAreaKey = keyof typeof scopedPermissionAreas;
declare const uiPermissionsByArea: {
    readonly auditlog: {
        readonly endpoints: readonly [{
            readonly path: RegExp;
            readonly types: readonly [string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Read' allows the user to view devices.";
                };
                readonly permissionLevel: 1;
                readonly permissionSets: {
                    readonly auditlog: "ReadAuditLogs";
                    readonly groups: "ReadDevices";
                    readonly releases: "ReadReleases";
                    readonly tenantManagement: "ReadTenants";
                    readonly userManagement: "ReadUsers";
                };
                readonly title: "Read";
                readonly value: ReadPermission;
                readonly verbs: readonly [string, string];
            }];
        }];
        readonly explanation: "Granting access to the audit log will allow tracing changes to devices, releases and user accounts, as well as providing information about deployments.";
        readonly key: "auditlog";
        readonly uiPermissions: readonly [{
            readonly explanations: {
                readonly groups: "'Read' allows the user to view devices.";
            };
            readonly permissionLevel: 1;
            readonly permissionSets: {
                readonly auditlog: "ReadAuditLogs";
                readonly groups: "ReadDevices";
                readonly releases: "ReadReleases";
                readonly tenantManagement: "ReadTenants";
                readonly userManagement: "ReadUsers";
            };
            readonly title: "Read";
            readonly value: ReadPermission;
            readonly verbs: readonly [string, string];
        }];
        readonly title: "System Audit Log";
    };
    readonly deployments: {
        readonly endpoints: readonly [{
            readonly path: RegExp;
            readonly types: readonly [string, string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Deploy' allows the user to deploy software or configuration updates to devices.";
                };
                readonly permissionLevel: 2;
                readonly permissionSets: {
                    readonly deployments: "DeployToDevices";
                    readonly groups: "DeployToDevices";
                };
                readonly title: "Deploy";
                readonly value: DeployPermission;
                readonly verbs: readonly [string];
            }];
        }, {
            readonly path: RegExp;
            readonly types: readonly [string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Read' allows the user to view devices.";
                };
                readonly permissionLevel: 1;
                readonly permissionSets: {
                    readonly auditlog: "ReadAuditLogs";
                    readonly groups: "ReadDevices";
                    readonly releases: "ReadReleases";
                    readonly tenantManagement: "ReadTenants";
                    readonly userManagement: "ReadUsers";
                };
                readonly title: "Read";
                readonly value: ReadPermission;
                readonly verbs: readonly [string, string];
            }];
        }, {
            readonly path: RegExp;
            readonly types: readonly [string, string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Manage' allows the user to edit device name, notes, and manage authentication status. For 'All devices' it also allows the user to edit and create device groups.";
                    readonly releases: "'Manage' allows the user to upload new artifacts, edit release descriptions and remove artifacts.";
                };
                readonly permissionLevel: 2;
                readonly permissionSets: {
                    readonly groups: "ManageDevices";
                    readonly releases: "ManageReleases";
                    readonly tenantManagement: "ManageTenants";
                    readonly userManagement: "ManageUsers";
                };
                readonly title: "Manage";
                readonly value: ManagePermission;
                readonly verbs: readonly [string, string, string];
            }];
        }];
        readonly explanation: "Providing deploy permissions will allow deployments to be created using the releases and devices a user has access to.";
        readonly key: "deployments";
        readonly uiPermissions: readonly [{
            readonly explanations: {
                readonly groups: "'Read' allows the user to view devices.";
            };
            readonly permissionLevel: 1;
            readonly permissionSets: {
                readonly auditlog: "ReadAuditLogs";
                readonly groups: "ReadDevices";
                readonly releases: "ReadReleases";
                readonly tenantManagement: "ReadTenants";
                readonly userManagement: "ReadUsers";
            };
            readonly title: "Read";
            readonly value: ReadPermission;
            readonly verbs: readonly [string, string];
        }, {
            readonly explanations: {
                readonly groups: "'Deploy' allows the user to deploy software or configuration updates to devices.";
            };
            readonly permissionLevel: 2;
            readonly permissionSets: {
                readonly deployments: "DeployToDevices";
                readonly groups: "DeployToDevices";
            };
            readonly title: "Deploy";
            readonly value: DeployPermission;
            readonly verbs: readonly [string];
        }];
        readonly title: "Deployments";
    };
    readonly groups: {
        readonly endpoints: readonly [{
            readonly path: RegExp;
            readonly types: readonly [string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Read' allows the user to view devices.";
                };
                readonly permissionLevel: 1;
                readonly permissionSets: {
                    readonly auditlog: "ReadAuditLogs";
                    readonly groups: "ReadDevices";
                    readonly releases: "ReadReleases";
                    readonly tenantManagement: "ReadTenants";
                    readonly userManagement: "ReadUsers";
                };
                readonly title: "Read";
                readonly value: ReadPermission;
                readonly verbs: readonly [string, string];
            }];
        }, {
            readonly path: RegExp;
            readonly types: readonly [string, string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Manage' allows the user to edit device name, notes, and manage authentication status. For 'All devices' it also allows the user to edit and create device groups.";
                    readonly releases: "'Manage' allows the user to upload new artifacts, edit release descriptions and remove artifacts.";
                };
                readonly permissionLevel: 2;
                readonly permissionSets: {
                    readonly groups: "ManageDevices";
                    readonly releases: "ManageReleases";
                    readonly tenantManagement: "ManageTenants";
                    readonly userManagement: "ManageUsers";
                };
                readonly title: "Manage";
                readonly value: ManagePermission;
                readonly verbs: readonly [string, string, string];
            }];
        }, {
            readonly path: RegExp;
            readonly types: readonly [string, string, string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Configure' allows the user to use mender-configure features and apply configurations.";
                };
                readonly permissionLevel: 2;
                readonly permissionSets: {
                    readonly groups: "ConfigureDevices";
                };
                readonly title: "Configure";
                readonly value: ConfigurePermission;
                readonly verbs: readonly [string, string, string];
            }];
        }, {
            readonly path: RegExp;
            readonly types: readonly [string, string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Connect' allows the user to use mender-connect features and Troubleshoot add-ons.";
                };
                readonly permissionLevel: 2;
                readonly permissionSets: {
                    readonly groups: "ConnectToDevices";
                };
                readonly title: "Connect";
                readonly value: ConnectPermission;
                readonly verbs: readonly [string, string];
            }];
        }];
        readonly explanation: "Device group management permissions control the degree to which devices in a group can be accessed and moved to other groups.";
        readonly key: "groups";
        readonly scope: "DeviceGroups";
        readonly uiPermissions: readonly [{
            readonly explanations: {
                readonly groups: "'Read' allows the user to view devices.";
            };
            readonly permissionLevel: 1;
            readonly permissionSets: {
                readonly auditlog: "ReadAuditLogs";
                readonly groups: "ReadDevices";
                readonly releases: "ReadReleases";
                readonly tenantManagement: "ReadTenants";
                readonly userManagement: "ReadUsers";
            };
            readonly title: "Read";
            readonly value: ReadPermission;
            readonly verbs: readonly [string, string];
        }, {
            readonly explanations: {
                readonly groups: "'Manage' allows the user to edit device name, notes, and manage authentication status. For 'All devices' it also allows the user to edit and create device groups.";
                readonly releases: "'Manage' allows the user to upload new artifacts, edit release descriptions and remove artifacts.";
            };
            readonly permissionLevel: 2;
            readonly permissionSets: {
                readonly groups: "ManageDevices";
                readonly releases: "ManageReleases";
                readonly tenantManagement: "ManageTenants";
                readonly userManagement: "ManageUsers";
            };
            readonly title: "Manage";
            readonly value: ManagePermission;
            readonly verbs: readonly [string, string, string];
        }, {
            readonly explanations: {
                readonly groups: "'Deploy' allows the user to deploy software or configuration updates to devices.";
            };
            readonly permissionLevel: 2;
            readonly permissionSets: {
                readonly deployments: "DeployToDevices";
                readonly groups: "DeployToDevices";
            };
            readonly title: "Deploy";
            readonly value: DeployPermission;
            readonly verbs: readonly [string];
        }, {
            readonly explanations: {
                readonly groups: "'Configure' allows the user to use mender-configure features and apply configurations.";
            };
            readonly permissionLevel: 2;
            readonly permissionSets: {
                readonly groups: "ConfigureDevices";
            };
            readonly title: "Configure";
            readonly value: ConfigurePermission;
            readonly verbs: readonly [string, string, string];
        }, {
            readonly explanations: {
                readonly groups: "'Connect' allows the user to use mender-connect features and Troubleshoot add-ons.";
            };
            readonly permissionLevel: 2;
            readonly permissionSets: {
                readonly groups: "ConnectToDevices";
            };
            readonly title: "Connect";
            readonly value: ConnectPermission;
            readonly verbs: readonly [string, string];
        }];
        readonly title: "Group Management";
    };
    readonly releases: {
        readonly endpoints: readonly [{
            readonly path: RegExp;
            readonly types: readonly [string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Read' allows the user to view devices.";
                };
                readonly permissionLevel: 1;
                readonly permissionSets: {
                    readonly auditlog: "ReadAuditLogs";
                    readonly groups: "ReadDevices";
                    readonly releases: "ReadReleases";
                    readonly tenantManagement: "ReadTenants";
                    readonly userManagement: "ReadUsers";
                };
                readonly title: "Read";
                readonly value: ReadPermission;
                readonly verbs: readonly [string, string];
            }];
        }, {
            readonly path: RegExp;
            readonly types: readonly [string, string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Read' allows the user to view devices.";
                };
                readonly permissionLevel: 1;
                readonly permissionSets: {
                    readonly auditlog: "ReadAuditLogs";
                    readonly groups: "ReadDevices";
                    readonly releases: "ReadReleases";
                    readonly tenantManagement: "ReadTenants";
                    readonly userManagement: "ReadUsers";
                };
                readonly title: "Read";
                readonly value: ReadPermission;
                readonly verbs: readonly [string, string];
            }, {
                readonly explanations: {
                    readonly groups: "'Upload' allows the user to upload new Artifacts.";
                };
                readonly unscopedOnly: {
                    readonly releases: true;
                };
                readonly permissionLevel: 1;
                readonly permissionSets: {
                    readonly releases: "UploadArtifacts";
                };
                readonly title: "Upload";
                readonly value: UploadPermission;
                readonly verbs: readonly [string, string, string];
            }];
        }, {
            readonly path: RegExp;
            readonly types: readonly [string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Read' allows the user to view devices.";
                };
                readonly permissionLevel: 1;
                readonly permissionSets: {
                    readonly auditlog: "ReadAuditLogs";
                    readonly groups: "ReadDevices";
                    readonly releases: "ReadReleases";
                    readonly tenantManagement: "ReadTenants";
                    readonly userManagement: "ReadUsers";
                };
                readonly title: "Read";
                readonly value: ReadPermission;
                readonly verbs: readonly [string, string];
            }, {
                readonly explanations: {
                    readonly groups: "'Manage' allows the user to edit device name, notes, and manage authentication status. For 'All devices' it also allows the user to edit and create device groups.";
                    readonly releases: "'Manage' allows the user to upload new artifacts, edit release descriptions and remove artifacts.";
                };
                readonly permissionLevel: 2;
                readonly permissionSets: {
                    readonly groups: "ManageDevices";
                    readonly releases: "ManageReleases";
                    readonly tenantManagement: "ManageTenants";
                    readonly userManagement: "ManageUsers";
                };
                readonly title: "Manage";
                readonly value: ManagePermission;
                readonly verbs: readonly [string, string, string];
            }];
        }];
        readonly explanation: "Release permissions can be granted to allow artifact & release modifications, as well as the creation of new releases.";
        readonly key: "releases";
        readonly scope: "ReleaseTags";
        readonly uiPermissions: readonly [{
            readonly explanations: {
                readonly groups: "'Read' allows the user to view devices.";
            };
            readonly permissionLevel: 1;
            readonly permissionSets: {
                readonly auditlog: "ReadAuditLogs";
                readonly groups: "ReadDevices";
                readonly releases: "ReadReleases";
                readonly tenantManagement: "ReadTenants";
                readonly userManagement: "ReadUsers";
            };
            readonly title: "Read";
            readonly value: ReadPermission;
            readonly verbs: readonly [string, string];
        }, {
            readonly explanations: {
                readonly groups: "'Manage' allows the user to edit device name, notes, and manage authentication status. For 'All devices' it also allows the user to edit and create device groups.";
                readonly releases: "'Manage' allows the user to upload new artifacts, edit release descriptions and remove artifacts.";
            };
            readonly permissionLevel: 2;
            readonly permissionSets: {
                readonly groups: "ManageDevices";
                readonly releases: "ManageReleases";
                readonly tenantManagement: "ManageTenants";
                readonly userManagement: "ManageUsers";
            };
            readonly title: "Manage";
            readonly value: ManagePermission;
            readonly verbs: readonly [string, string, string];
        }, {
            readonly explanations: {
                readonly groups: "'Upload' allows the user to upload new Artifacts.";
            };
            readonly unscopedOnly: {
                readonly releases: true;
            };
            readonly permissionLevel: 1;
            readonly permissionSets: {
                readonly releases: "UploadArtifacts";
            };
            readonly title: "Upload";
            readonly value: UploadPermission;
            readonly verbs: readonly [string, string, string];
        }];
        readonly title: "Release Management";
    };
    readonly tenantManagement: {
        readonly endpoints: readonly [{
            readonly path: RegExp;
            readonly types: readonly [string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Read' allows the user to view devices.";
                };
                readonly permissionLevel: 1;
                readonly permissionSets: {
                    readonly auditlog: "ReadAuditLogs";
                    readonly groups: "ReadDevices";
                    readonly releases: "ReadReleases";
                    readonly tenantManagement: "ReadTenants";
                    readonly userManagement: "ReadUsers";
                };
                readonly title: "Read";
                readonly value: ReadPermission;
                readonly verbs: readonly [string, string];
            }];
        }, {
            readonly path: RegExp;
            readonly types: readonly [string, string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Manage' allows the user to edit device name, notes, and manage authentication status. For 'All devices' it also allows the user to edit and create device groups.";
                    readonly releases: "'Manage' allows the user to upload new artifacts, edit release descriptions and remove artifacts.";
                };
                readonly permissionLevel: 2;
                readonly permissionSets: {
                    readonly groups: "ManageDevices";
                    readonly releases: "ManageReleases";
                    readonly tenantManagement: "ManageTenants";
                    readonly userManagement: "ManageUsers";
                };
                readonly title: "Manage";
                readonly value: ManagePermission;
                readonly verbs: readonly [string, string, string];
            }];
        }, {
            readonly path: RegExp;
            readonly types: readonly [string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Manage' allows the user to edit device name, notes, and manage authentication status. For 'All devices' it also allows the user to edit and create device groups.";
                    readonly releases: "'Manage' allows the user to upload new artifacts, edit release descriptions and remove artifacts.";
                };
                readonly permissionLevel: 2;
                readonly permissionSets: {
                    readonly groups: "ManageDevices";
                    readonly releases: "ManageReleases";
                    readonly tenantManagement: "ManageTenants";
                    readonly userManagement: "ManageUsers";
                };
                readonly title: "Manage";
                readonly value: ManagePermission;
                readonly verbs: readonly [string, string, string];
            }];
        }];
        readonly explanation: "Tenant management permissions allow listing, creating and modifying child tenants";
        readonly key: "tenantManagement";
        readonly uiPermissions: readonly [{
            readonly explanations: {
                readonly groups: "'Read' allows the user to view devices.";
            };
            readonly permissionLevel: 1;
            readonly permissionSets: {
                readonly auditlog: "ReadAuditLogs";
                readonly groups: "ReadDevices";
                readonly releases: "ReadReleases";
                readonly tenantManagement: "ReadTenants";
                readonly userManagement: "ReadUsers";
            };
            readonly title: "Read";
            readonly value: ReadPermission;
            readonly verbs: readonly [string, string];
        }, {
            readonly explanations: {
                readonly groups: "'Manage' allows the user to edit device name, notes, and manage authentication status. For 'All devices' it also allows the user to edit and create device groups.";
                readonly releases: "'Manage' allows the user to upload new artifacts, edit release descriptions and remove artifacts.";
            };
            readonly permissionLevel: 2;
            readonly permissionSets: {
                readonly groups: "ManageDevices";
                readonly releases: "ManageReleases";
                readonly tenantManagement: "ManageTenants";
                readonly userManagement: "ManageUsers";
            };
            readonly title: "Manage";
            readonly value: ManagePermission;
            readonly verbs: readonly [string, string, string];
        }];
        readonly title: "Tenant Management";
    };
    readonly userManagement: {
        readonly endpoints: readonly [{
            readonly path: RegExp;
            readonly types: readonly [string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Read' allows the user to view devices.";
                };
                readonly permissionLevel: 1;
                readonly permissionSets: {
                    readonly auditlog: "ReadAuditLogs";
                    readonly groups: "ReadDevices";
                    readonly releases: "ReadReleases";
                    readonly tenantManagement: "ReadTenants";
                    readonly userManagement: "ReadUsers";
                };
                readonly title: "Read";
                readonly value: ReadPermission;
                readonly verbs: readonly [string, string];
            }];
        }, {
            readonly path: RegExp;
            readonly types: readonly [string];
            readonly uiPermissions: readonly [{
                readonly explanations: {
                    readonly groups: "'Manage' allows the user to edit device name, notes, and manage authentication status. For 'All devices' it also allows the user to edit and create device groups.";
                    readonly releases: "'Manage' allows the user to upload new artifacts, edit release descriptions and remove artifacts.";
                };
                readonly permissionLevel: 2;
                readonly permissionSets: {
                    readonly groups: "ManageDevices";
                    readonly releases: "ManageReleases";
                    readonly tenantManagement: "ManageTenants";
                    readonly userManagement: "ManageUsers";
                };
                readonly title: "Manage";
                readonly value: ManagePermission;
                readonly verbs: readonly [string, string, string];
            }];
        }];
        readonly explanation: "User management permissions should be granted carefully, as these allow privilege increases for any users managed by a user with user management permissions";
        readonly key: "userManagement";
        readonly uiPermissions: readonly [{
            readonly explanations: {
                readonly groups: "'Read' allows the user to view devices.";
            };
            readonly permissionLevel: 1;
            readonly permissionSets: {
                readonly auditlog: "ReadAuditLogs";
                readonly groups: "ReadDevices";
                readonly releases: "ReadReleases";
                readonly tenantManagement: "ReadTenants";
                readonly userManagement: "ReadUsers";
            };
            readonly title: "Read";
            readonly value: ReadPermission;
            readonly verbs: readonly [string, string];
        }, {
            readonly explanations: {
                readonly groups: "'Manage' allows the user to edit device name, notes, and manage authentication status. For 'All devices' it also allows the user to edit and create device groups.";
                readonly releases: "'Manage' allows the user to upload new artifacts, edit release descriptions and remove artifacts.";
            };
            readonly permissionLevel: 2;
            readonly permissionSets: {
                readonly groups: "ManageDevices";
                readonly releases: "ManageReleases";
                readonly tenantManagement: "ManageTenants";
                readonly userManagement: "ManageUsers";
            };
            readonly title: "Manage";
            readonly value: ManagePermission;
            readonly verbs: readonly [string, string, string];
        }];
        readonly title: "User Management";
    };
};
type UiPermissionsByAreaKey = keyof typeof uiPermissionsByArea;
declare const rolesById: Record<string, Role>;
declare const serviceProviderRolesById: {
    readonly admin: {
        readonly name: "Admin";
        readonly value: "RBAC_ROLE_PERMIT_ALL";
        readonly description: "Full access";
        readonly permissions: readonly [];
        readonly uiPermissions: {
            readonly auditlog: ("read" | "manage" | "deploy" | "configure" | "connect" | "upload")[];
            readonly userManagement: ("read" | "manage" | "deploy" | "configure" | "connect" | "upload")[];
            readonly tenantManagement: ("read" | "manage" | "deploy" | "configure" | "connect" | "upload")[];
            readonly deployments?: string[] | undefined;
            readonly groups: Record<string, string[]>;
            readonly releases: Record<string, string[]>;
        };
    };
    readonly readOnly: {
        readonly name: "Read access";
        readonly value: "RBAC_ROLE_OBSERVER";
        readonly description: "This role can see all linked organizations but cannot make any changes";
        readonly permissions: readonly [];
        readonly uiPermissions: {
            readonly auditlog: readonly ["read"];
            readonly userManagement: readonly ["read"];
            readonly tenantManagement: readonly ["read"];
            readonly deployments?: string[] | undefined;
            readonly groups: Record<string, string[]>;
            readonly releases: Record<string, string[]>;
        };
    };
};
declare const defaultPermissionSets: Record<string, Omit<PermissionSet, 'permissions'>>;
declare const rolesByName: {
    readonly deploymentCreation: {
        readonly action: "CREATE_DEPLOYMENT";
        readonly object: {
            readonly type: "DEVICE_GROUP";
            readonly value: undefined;
        };
    };
    readonly groupAccess: {
        readonly action: "VIEW_DEVICE";
        readonly object: {
            readonly type: "DEVICE_GROUP";
            readonly value: undefined;
        };
    };
    readonly userManagement: {
        readonly action: "http";
        readonly object: {
            readonly type: "any";
            readonly value: `${string}/.*`;
        };
    };
    readonly admin: "RBAC_ROLE_PERMIT_ALL";
    readonly readOnly: "RBAC_ROLE_OBSERVER";
    readonly ci: "RBAC_ROLE_CI";
    readonly deploymentsManager: "RBAC_ROLE_DEPLOYMENTS_MANAGER";
    readonly terminalAccess: "RBAC_ROLE_REMOTE_TERMINAL";
};

export { type AnyPermission, type AuditLogPermission, type ConfigurePermission, type ConnectPermission, type DeployPermission, type DeploymentPermission, type GroupsPermission, type ManagePermission, type PermissionObject, type PermissionSet, type PermissionSetId, PermissionTypes, type ReadPermission, type ReleasesPermission, type Role, type ScopedPermissionsByAreaKey, type UiPermissionsByAreaKey, type UiPermissionsByIdKey, type UiPermissionsDefinition, type UiRoleDefinition, type UploadPermission, type UserManagementPermission, defaultPermissionSets, emptyRole, emptyUiPermissions, rolesById, rolesByName, scopedPermissionAreas, serviceProviderRolesById, uiPermissionsByArea, uiPermissionsById };
