import { NewDeploymentPhase } from '@northern.tech/types/MenderTypes';

declare const fullyDecodeURI: (uri: string) => string;
declare const isEmpty: (obj: any) => boolean;
declare const yes: () => boolean;
declare const canAccess: () => boolean;
declare const versionCompare: (v1: any, v2: any) => 1 | -1 | 0;
declare function deepCompare(...args: any[]): boolean;
declare const stringToBoolean: (content: boolean | number | string) => boolean;
declare const toggle: (current: boolean) => boolean;
declare const formatTime: (date: any) => any;
declare const customSort: (direction: boolean, field: string) => (a: any, b: any) => number;
declare const duplicateFilter: (item: any, index: any, array: any) => boolean;
declare const attributeDuplicateFilter: (filterableArray: any, attributeName?: string) => any;
declare const unionizeStrings: (someStrings: string[], someOtherStrings: string[]) => string[];
declare const getFormattedSize: (bytes: number) => string;
type DeviceAttribute = string | string[];
interface DeviceAttributes {
    identity?: DeviceAttribute;
    inventory?: DeviceAttribute;
    monitor?: DeviceAttribute;
    system?: DeviceAttribute;
    tags?: DeviceAttribute;
}
declare const getDemoDeviceAddress: (devices: any, onboardingApproach: any) => any;
declare const detectOsIdentifier: () => "Windows" | "MacOs" | "Unix" | "Linux";
type TimeUnit = 'days' | 'minutes' | 'hours';
interface StandardizedPhase {
    batch_size: number;
    delay?: number;
    delayUnit?: TimeUnit;
    device_count?: number;
    start_ts?: number;
}
type UiDeploymentPhase = NewDeploymentPhase & StandardizedPhase;
declare const standardizePhases: (phases: NewDeploymentPhase[] | UiDeploymentPhase[]) => StandardizedPhase[];
interface DebConfigurationProps {
    deviceType?: string;
    hasMonitor: boolean;
    ipAddress?: string;
    isDemoMode: boolean;
    isHosted: boolean;
    isOnboarding: boolean;
    isPreRelease: boolean;
    tenantToken?: string;
    token: string;
}
declare const getDebConfigurationCode: (props: DebConfigurationProps) => string;
declare const getSnackbarMessage: (skipped: number, done: number) => string;
type SoftwareInformationEntry = [string, DeviceAttribute];
interface SoftwareInformation {
    nonSoftware: SoftwareInformationEntry[];
    software: SoftwareInformationEntry[];
}
declare const extractSoftware: (attributes?: DeviceAttributes) => SoftwareInformation;
interface SoftwareItem {
    key: string;
    name: string;
    nestingLevel: number;
    version: DeviceAttribute;
}
declare const extractSoftwareItem: (artifactProvides?: DeviceAttributes) => SoftwareItem | undefined;
declare const createDownload: (target: string, filename: string, token: string) => void;
declare const createFileDownload: (content: string, filename: string, token: string) => void;
declare const getISOStringBoundaries: (currentDate: Date) => {
    start: string;
    end: string;
};
declare const extractErrorMessage: (err: any, fallback?: string) => any;
declare const preformatWithRequestID: (res: any, failMsg: string) => string;
interface UnixDateRange {
    end: number | null;
    start: number | null;
}
type UnixDateRangeParam = string | Date | null;
/**
 * Converts dates into Unix timestamps representing the start and end of their respective days.
 * Start timestamp will be set to 00:00:00, end timestamp will be set to 23:59:59.
 * If either date is invalid or null, that value in the returned object will remain null.
 * Handles both date strings correctly, preserving the exact date.
 *
 * @param {string|Date|null} [startDate=null] - The start date of the range.
 * @param {string|Date|null} [endDate=null] - The end date of the range.
 * @returns {{ start: number|null, end: number|null }} An object containing the start and end times as UNIX timestamps, or null if invalid or not set.
 */
declare const dateRangeToUnix: (startDate?: UnixDateRangeParam, endDate?: UnixDateRangeParam) => UnixDateRange;
declare const byteArrayToString: (body: Buffer) => string;
declare const blobToString: (blob: Blob) => Promise<unknown>;

export { attributeDuplicateFilter, blobToString, byteArrayToString, canAccess, createDownload, createFileDownload, customSort, dateRangeToUnix, deepCompare, detectOsIdentifier, duplicateFilter, extractErrorMessage, extractSoftware, extractSoftwareItem, formatTime, fullyDecodeURI, getDebConfigurationCode, getDemoDeviceAddress, getFormattedSize, getISOStringBoundaries, getSnackbarMessage, isEmpty, preformatWithRequestID, standardizePhases, stringToBoolean, toggle, unionizeStrings, versionCompare, yes };
