<div class="settingsPage">

    <div class="left-column">
           <?php $this->load->view('appsetting/settingsSideBar')?>
    </div>

    <div class="right-column">
        <div class="pageTitle">

            <h1 class="display-inline-block"><span>Hub replication Status</span></h1>

        </div>

            <div class="pullTop">

            <?php if (isset($replicationStatusData) && !empty($replicationStatusData)) { ?>
                <p class="title">Replica Name: <b> <?= htmlspecialchars($replicationStatusData['set']) ?></b>

                    <?php if (!$replicationStatusData['status']) { ?>
                <div style="margin:5px;width: 95%">
                        <p class="error">Some members of the replication set are failing. </p>
                    </div>
                <?php } ?>

                <?php foreach ((array) $replicationStatusData['members'] as $host) { ?>
                    <?php $scope = ($host['health']) ? 'green' : 'red'; ?>
                    <table class="bundlelist-table table table-striped table-bordered table-condensed">
                        <thead>
                            <tr><th scope="<?= htmlspecialchars($scope) ?>" colspan="4"><?= htmlspecialchars($host['name']) ?></th></tr>
                            <tr>
                                <th scope="col">Health</th>
                                <th scope="col">Uptime</th>
                                <th scope="col">State</th>
                                <th scope="col">Last heartbeat</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><?php echo $host['health'] ? 'Ok' : 'Failing'; ?></td>
                                <td><?php echo isset($host['uptime']) ? formatSeconds($host['uptime']) : '-'; ?>  </td>
                                <td><?php echo isset($host['stateStr']) ? htmlspecialchars($host['stateStr']) : '-'; ?></td>
                                <td><?php echo isset($host['lastHeartbeat']) ? getDateStatus($host['lastHeartbeat'], true) : '-'; ?></td>
                            </tr>
                        </tbody>
                    </table>


                <?php } ?>

            <?php } else { ?>
                <div class="alert alert-info" style="display:inline"> No replica set configured. </div>
            <?php } ?>
            </div>
    </div>
 </div>

