#!/bin/bash

SCRIPT_PATH=$1
GIT_COMMAND=$3

export PKEY="$2"
export PATH="${PATH}:/var/cfengine/bin"
export GIT_SSH="${SCRIPT_PATH}/ssh-wrapper.sh"

function error_exit {
    # Display error message and exit
    echo "${1}: ${2:-"Unknown Error"}" 1>&2
    exit 1
}

if ! type "git" > /dev/null; then
    error_exit $(basename $0) "git not found on path: $PATH"
fi
echo "Running git wrapper command $GIT_COMMAND with key $PKEY and SSH PATH $GIT_SSH"

git $GIT_COMMAND
