<?php


/**
 * Class CfPdo
 */
class CfPdo implements CfPdoInterface
{
    /**
     * @var null
     */
    private static $instance = null;
    /**
     * @var PDO
     */
    private $conn;

    /**
     * @var string
     */
    private $host = OAUTH_DATABASE_HOST;
    /**
     * @var string
     */
    private $user = OAUTH_DATABASE_USER;
    /**
     * @var string
     */
    private $pass = OAUTH_DATABASE_PASS;
    /**
     * @var string
     */
    private $name = OAUTH_DATABASE_NAME;
    /**
     * @var int
     */
    private $port = OAUTH_DATABASE_PORT;

    /**
     * DbConnection constructor.
     */
    private function __construct()
    {
        $this->conn = new PDO("pgsql:host={$this->host}; dbname={$this->name};port={$this->port}", $this->user, $this->pass);
    }

    /**
     * @return CfPdoInterface
     */
    public static function getInstance(): CfPdoInterface
    {
        if (!self::$instance) {
            self::$instance = new CfPdo();
        }

        return self::$instance;
    }

    /**
     * @return PDO
     */
    public function getConnection(): PDO
    {
        return $this->conn;
    }
}
