<?php

readonly class AuditLogDto
{
    public function __construct(
        public string $actor,
        public string $objectType,
        public ?string $objectName,
        public string $action,
        public ?string $ipAddress,
        public ?string $objectId = null,
        public array $details = [],
    ) {
    }

    public function toArray(): array
    {
        return [
            'actor' => $this->actor,
            'object_type' => $this->objectType,
            'object_id' => $this->objectId,
            'object_name' => $this->objectName,
            'action' => $this->action,
            'ip_address' => $this->ipAddress,
            'details' => json_encode($this->details)
        ];
    }

    public static function fromArray(array $data): self
    {
        return new self(
            actor: $data['actor'] ?? null,
            objectType: $data['objectType'] ?? null,
            objectName: $data['objectName'] ?? null,
            action: $data['action'] ?? null,
            ipAddress: $data['ipAddress'] ?? $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0',
            objectId: $data['objectId'] ?? null,
            details: $data['details'] ?? [],
        );
    }
}
