angular.
    module('inclExclDirectives', []).
    directive('hostsIncludeExclude', ['$filter', '$modal', '$timeout', 'IENaviTreeService', 'includeExcludeService','IEPaginationService', function($filter, $modal, $timeout, IENaviTreeService, includeExcludeService, IEPaginationService) {
        return {
            restrict: 'A',
            link: function ($scope, $elm, $attrs) {
                new includeExcludeSelectionDirective ($scope, $elm, $attrs, $filter, $modal, $timeout, IENaviTreeService, includeExcludeService, IEPaginationService);
            },
            scope: {
                env   : '=',  // name and includes array
                state : '=',   //contain profileid, path names and manual class expression (if exist),
                hideSpecificHostsFilter : '=',
                showenvironmentfilterbuttons : '='
            },
            templateUrl:  MP_SITE_URL + '/directives/partials/directive_hosts_selection.php',
        };
    }])
    .directive('includeExcludeByHostkey', ['$filter', '$modal', '$timeout', 'IENaviTreeService', 'includeExcludeService','IEPaginationService',
        function($filter, $modal, $timeout, IENaviTreeService, includeExcludeService, IEPaginationService) {
        return {
            restrict: 'A',
            link: function ($scope, $elm, $attrs) {
                new includeExcludeByHostkeyDirective($scope, $attrs, $modal, IEPaginationService, IENaviTreeService, $timeout);
            },
            scope: {
                includedHosts: '=',
                excludedHosts: '=',
                otherFiltersApplied: '='
            },
            templateUrl:  MP_SITE_URL + '/directives/partials/directive_hosts_selection_new.php',
        };
    }])
    .directive('chosenAutoComplete', ['autoCompleteService', function (autoCompleteService) {
    var linker = function ($scope, element, attr) {
        if (attr.search === "false") {
            element.chosen({disable_search_threshold: 9999, width: "220px"});
        } else {
            element.chosen({width: "255px"});
        }

        var searchInput = document.querySelector(".hostFilter .chosen-search input");

        $scope.$watchCollection(attr.watch, function () {
            var search_param = searchInput.value.toString();
            element.trigger('chosen:updated');
            searchInput.value = search_param;
        })

        $scope.$watch(attr.ngModel, function () {
            var search_param = searchInput.value.toString();
            element.trigger('chosen:updated')
            searchInput.value = search_param;
        })

        searchInput.onkeyup = function () {
            const search_param = searchInput.value.toString();
            if (search_param.length > 2) {
                autoCompleteService.search(search_param).then(function (result) {
                    if (result.data != undefined) {
                        $scope.clearSearchComplete();

                        if (result.data.hosts != undefined && result.data.hosts.length > 0) {
                            result.data.hosts.forEach(function (item) {
                                $scope.searchComplete.unshift({
                                    name: item.hostname,
                                    type: "Hosts",
                                    id: item.hostkey.replace("SHA=", "")
                                });
                            });
                        }

                        if (result.data.classes != undefined && result.data.classes.length > 0) {
                            result.data.classes.forEach(function (item) {
                                $scope.searchComplete.unshift({
                                    name: item,
                                    type: "Classes",
                                    id: item
                                });
                            });
                        }
                    }
                })
            }
        };

    }
    return {
        restrict: 'A',
        link: linker
    }
}]);