"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/DeviceNameInput.tsx
var DeviceNameInput_exports = {};
__export(DeviceNameInput_exports, {
  DeviceNameInput: () => DeviceNameInput,
  default: () => DeviceNameInput_default
});
module.exports = __toCommonJS(DeviceNameInput_exports);
var import_react2 = require("react");
var import_material2 = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_store = require("@northern.tech/store/store");
var import_thunks = require("@northern.tech/store/thunks");

// src/Confirm.tsx
var import_react = require("react");
var import_icons_material = require("@mui/icons-material");
var import_material = require("@mui/material");
var import_jsx_runtime = require("react/jsx-runtime");
var EditButton = ({ onClick, disabled = false }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Button, { onClick, size: "small", disabled, startIcon: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Edit, {}), style: { padding: 5 }, children: "Edit" });
var ConfirmationButtons = ({ onConfirm, onCancel }) => /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "flexbox", children: [
  /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.IconButton, { onClick: onConfirm, size: "small", "aria-label": "confirm", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Check, { color: "disabled" }) }),
  /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.IconButton, { onClick: onCancel, size: "small", "aria-label": "cancel", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Close, { color: "disabled" }) })
] });

// src/DeviceNameInput.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  icon: {
    fontSize: "1.25rem"
  },
  input: {
    color: theme.palette.text.primary,
    fontSize: "0.8125rem"
  }
}));
var DeviceNameInput = ({ device, isHovered }) => {
  const [isEditing, setIsEditing] = (0, import_react2.useState)(false);
  const [value, setValue] = (0, import_react2.useState)("");
  const { classes } = useStyles();
  const inputRef = (0, import_react2.useRef)(void 0);
  const dispatch = (0, import_store.useAppDispatch)();
  const { id = "", tags = {} } = device;
  const { name = "" } = tags;
  (0, import_react2.useEffect)(() => {
    if (!isEditing && name !== value) {
      setValue(name);
    }
  }, [device, isEditing, name, value]);
  (0, import_react2.useEffect)(() => {
    if (!isEditing || !inputRef.current) {
      return;
    }
    inputRef.current.focus();
  }, [isEditing]);
  const onSubmit = () => dispatch((0, import_thunks.setDeviceTags)({ deviceId: id, tags: { ...tags, name: value } })).then(() => setIsEditing(false));
  const onCancel = () => {
    setValue(name);
    setIsEditing(false);
  };
  const onStartEdit = (e) => {
    e.stopPropagation();
    setIsEditing(true);
  };
  const onInputClick = (e) => e.stopPropagation();
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    import_material2.OutlinedInput,
    {
      id: `${device.id}-id-input`,
      className: classes.input,
      disabled: !isEditing,
      inputRef,
      value,
      placeholder: `${id.substring(0, 6)}...`,
      onClick: onInputClick,
      onChange: ({ target: { value: value2 } }) => setValue(value2),
      type: "text",
      endAdornment: (isHovered || isEditing) && /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.InputAdornment, { position: "end", children: isEditing ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(ConfirmationButtons, { onCancel, onConfirm: onSubmit }) : /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(EditButton, { onClick: onStartEdit }) })
    }
  );
};
var DeviceNameInput_default = DeviceNameInput;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DeviceNameInput
});
//# sourceMappingURL=DeviceNameInput.cjs.map