"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/Search.tsx
var Search_exports = {};
__export(Search_exports, {
  ControlledSearch: () => ControlledSearch,
  default: () => Search_default
});
module.exports = __toCommonJS(Search_exports);
var import_react = require("react");
var import_react_hook_form = require("react-hook-form");
var import_icons_material = require("@mui/icons-material");
var import_material = require("@mui/material");
var import_constants = require("@northern.tech/store/constants");
var import_debouncehook = require("@northern.tech/utils/debouncehook");

// src/Loader.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var Loader = (props) => {
  const { fade, show, small, style, table, waiting } = props;
  const hideClass = fade ? "hidden" : "loaderContainer shrunk";
  const showClass = table ? "miniLoaderContainer" : "loaderContainer";
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { style, className: show ? showClass : hideClass, children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: `${small ? "small" : ""} ${waiting ? "waiting-loader" : ""} loader`, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { className: "dot dot_1" }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { className: "dot dot_2" }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { className: "dot dot_3" }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { className: "dot dot_4" })
  ] }) });
};
var Loader_default = Loader;

// src/Search.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var endAdornment = /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material.InputAdornment, { position: "end", children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(Loader_default, { show: true, small: true, style: { marginTop: -10 } }) });
var startAdornment = /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material.InputAdornment, { position: "start", children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_icons_material.Search, { color: "disabled", fontSize: "small" }) });
var MINIMUM_SEARCH_LENGTH = 2;
var ControlledSearch = ({ className = "", isSearching, name = "search", onSearch, placeholder = "Search devices", style = {} }) => {
  const { control, watch } = (0, import_react_hook_form.useFormContext)();
  const inputRef = (0, import_react.useRef)();
  const focusLockRef = (0, import_react.useRef)(true);
  const timer = (0, import_react.useRef)();
  const triggerDebounceRef = (0, import_react.useRef)(false);
  const searchValue = watch(name, "");
  const debouncedSearchTerm = (0, import_debouncehook.useDebounce)(searchValue, import_constants.TIMEOUTS.debounceDefault);
  const focusAndLock = () => {
    focusLockRef.current = false;
    inputRef.current.focus();
    clearTimeout(timer.current);
    triggerDebounceRef.current = false;
    timer.current = setTimeout(() => focusLockRef.current = true, import_constants.TIMEOUTS.oneSecond);
  };
  (0, import_react.useEffect)(
    () => () => {
      clearTimeout(timer.current);
    },
    []
  );
  (0, import_react.useEffect)(() => {
    if (debouncedSearchTerm.length < MINIMUM_SEARCH_LENGTH || triggerDebounceRef.current) {
      return;
    }
    triggerDebounceRef.current = true;
    onSearch(debouncedSearchTerm).then(focusAndLock);
  }, [debouncedSearchTerm, onSearch]);
  const onTriggerSearch = (0, import_react.useCallback)(
    ({ key }) => {
      if (key === "Enter" && (!debouncedSearchTerm || debouncedSearchTerm.length >= MINIMUM_SEARCH_LENGTH)) {
        onSearch(debouncedSearchTerm).then(focusAndLock);
      }
    },
    [debouncedSearchTerm, onSearch]
  );
  const onFocus = (0, import_react.useCallback)(() => {
    if (focusLockRef.current && debouncedSearchTerm.length >= MINIMUM_SEARCH_LENGTH) {
      onSearch(debouncedSearchTerm).then(focusAndLock);
    }
  }, [debouncedSearchTerm, onSearch]);
  const adornments = isSearching ? { startAdornment, endAdornment } : { startAdornment };
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    import_react_hook_form.Controller,
    {
      name,
      control,
      render: ({ field }) => /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
        import_material.TextField,
        {
          className,
          slotProps: { input: adornments },
          onKeyUp: onTriggerSearch,
          onFocus,
          placeholder,
          inputRef,
          size: "small",
          style,
          ...field
        }
      )
    }
  );
};
ControlledSearch.displayName = "ConnectedSearch";
var Search = (props) => {
  const { className = "", searchTerm, onSearch, trigger } = props;
  const methods = (0, import_react_hook_form.useForm)({ mode: "onChange", defaultValues: { search: searchTerm ?? "" } });
  const { handleSubmit } = methods;
  const onSubmit = (0, import_react.useCallback)((search) => onSearch(search, !trigger), [onSearch, trigger]);
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_react_hook_form.FormProvider, { ...methods, children: /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("form", { className, noValidate: true, onSubmit: handleSubmit(({ search }) => onSearch(search, !trigger)), children: [
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(ControlledSearch, { ...props, onSearch: onSubmit }),
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("input", { className: "hidden", type: "submit" })
  ] }) });
};
var Search_default = Search;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ControlledSearch
});
//# sourceMappingURL=Search.cjs.map