import {
  runValidations
} from "./chunk-4LPSFMP6.js";

// src/forms/PasswordInput.tsx
import React, { useEffect, useRef, useState } from "react";
import { Controller, useFormContext, useWatch } from "react-hook-form";
import { CheckCircle as CheckIcon, Visibility as VisibilityIcon, VisibilityOff as VisibilityOffIcon } from "@mui/icons-material";
import { Button, FormControl, FormHelperText, IconButton, InputAdornment, InputLabel, OutlinedInput } from "@mui/material";
import { TIMEOUTS } from "@northern.tech/store/constants";
import { toggle } from "@northern.tech/utils/helpers";
import copy from "copy-to-clipboard";
import generator from "generate-password-browser";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var PasswordGenerateButtons = ({ clearPass, edit, generatePass, disabled }) => /* @__PURE__ */ jsxs("div", { className: "pass-buttons", children: [
  /* @__PURE__ */ jsx(Button, { color: "primary", onClick: generatePass, disabled, children: "Generate" }),
  edit ? /* @__PURE__ */ jsx(Button, { onClick: clearPass, children: "Cancel" }) : null
] });
var SCORE_THRESHOLD = 3;
var PasswordGenerationControls = ({ score, feedback }) => /* @__PURE__ */ jsxs(Fragment, { children: [
  /* @__PURE__ */ jsxs("div", { className: "help-text", id: "pass-strength", children: [
    "Strength: ",
    /* @__PURE__ */ jsx("meter", { max: 4, min: 0, value: score, high: 3.9, optimum: 4, low: 2.5 }),
    score > SCORE_THRESHOLD ? /* @__PURE__ */ jsx(CheckIcon, { className: "fadeIn green", style: { height: 18, marginTop: -3, marginBottom: -3 } }) : null
  ] }),
  !!feedback.length && /* @__PURE__ */ jsx("p", { className: "help-text", children: feedback.map((message, index) => /* @__PURE__ */ jsxs(React.Fragment, { children: [
    /* @__PURE__ */ jsx("span", { children: message }),
    /* @__PURE__ */ jsx("br", {})
  ] }, `feedback-${index}`)) })
] });
var PasswordInput = ({
  autocomplete,
  className,
  control,
  create,
  defaultValue,
  disabled,
  edit,
  generate,
  id,
  InputLabelProps = {},
  label,
  onClear,
  placeholder,
  required,
  validations = ""
}) => {
  const [score, setScore] = useState(0);
  const [visible, setVisible] = useState(false);
  const [copied, setCopied] = useState(false);
  const [feedback, setFeedback] = useState([]);
  const [confirmationId] = useState(id.includes("current") ? "" : ["password", "password_confirmation"].find((thing) => thing !== id));
  const timer = useRef();
  const {
    clearErrors,
    formState: { errors },
    setError,
    setValue,
    trigger,
    getValues
  } = useFormContext();
  const confirmation = useWatch({ name: confirmationId });
  const errorKey = `${id}`;
  const { message } = errors[errorKey] ?? {};
  useEffect(() => {
    if (confirmationId === "password" && !message) {
      trigger(confirmationId);
    }
  }, [confirmationId, message, trigger]);
  useEffect(() => () => {
    clearTimeout(timer.current);
  });
  const clearPassClick = () => {
    setValue(id, "");
    onClear();
    setCopied(false);
  };
  const generatePassClick = () => {
    const password = generator.generate({ length: 16, numbers: true });
    setValue(id, password);
    const form = getValues();
    if (form.hasOwnProperty(`${id}_confirmation`)) {
      setValue(`${id}_confirmation`, password);
    }
    copy(password);
    setCopied(true);
    setVisible(true);
    timer.current = setTimeout(() => setCopied(false), TIMEOUTS.fiveSeconds);
    trigger();
  };
  const validate = async (value = "") => {
    if (disabled) {
      return true;
    }
    let { isValid, errortext } = runValidations({ id, required, validations, value });
    if (confirmation && value !== confirmation) {
      isValid = false;
      errortext = "The passwords you provided do not match, please check again.";
    }
    if (isValid) {
      clearErrors(errorKey);
    } else {
      setError(errorKey, { type: "validate", message: errortext });
    }
    const { default: zxcvbn } = await import(
      /* webpackChunkName: "zxcvbn" */
      "zxcvbn"
    );
    const strength = zxcvbn(value);
    const score2 = strength.score;
    setScore(score2);
    if (!create || !required && !value) {
      return isValid || errortext;
    }
    setFeedback(strength.feedback.suggestions || []);
    return score2 > SCORE_THRESHOLD && isValid || errortext;
  };
  const showAsNotched = label && typeof label !== "string" ? { notched: true } : {};
  return /* @__PURE__ */ jsxs("div", { className, children: [
    /* @__PURE__ */ jsxs("div", { className: "password-wrapper", children: [
      /* @__PURE__ */ jsx(
        Controller,
        {
          name: id,
          control,
          rules: { required, validate },
          render: ({ field: { value, onChange, onBlur, ref }, fieldState: { error } }) => /* @__PURE__ */ jsxs(FormControl, { className: required ? "required" : "", error: Boolean((error || errors[errorKey])?.message), style: { width: 400 }, children: [
            /* @__PURE__ */ jsx(InputLabel, { htmlFor: id, ...InputLabelProps, children: label }),
            /* @__PURE__ */ jsx(
              OutlinedInput,
              {
                autoComplete: autocomplete,
                id,
                label,
                name: id,
                type: visible ? "text" : "password",
                defaultValue,
                placeholder,
                value: value ?? "",
                disabled,
                inputRef: ref,
                required,
                onChange: ({ target: { value: value2 } }) => {
                  setValue(id, value2);
                  onChange(value2);
                },
                onBlur,
                endAdornment: /* @__PURE__ */ jsx(InputAdornment, { position: "end", children: /* @__PURE__ */ jsx(IconButton, { onClick: () => setVisible(toggle), size: "large", children: visible ? /* @__PURE__ */ jsx(VisibilityIcon, {}) : /* @__PURE__ */ jsx(VisibilityOffIcon, {}) }) }),
                ...showAsNotched
              }
            ),
            /* @__PURE__ */ jsx(FormHelperText, { children: (errors[errorKey] || error)?.message })
          ] })
        }
      ),
      generate && !required && /* @__PURE__ */ jsx(PasswordGenerateButtons, { disabled, clearPass: clearPassClick, edit, generatePass: generatePassClick })
    ] }),
    copied ? /* @__PURE__ */ jsx("div", { className: "green fadeIn margin-bottom-small", children: "Copied to clipboard" }) : null,
    create && /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx(PasswordGenerationControls, { feedback, score }),
      generate && required && /* @__PURE__ */ jsx(PasswordGenerateButtons, { disabled, clearPass: clearPassClick, edit, generatePass: generatePassClick })
    ] })
  ] });
};
var PasswordInput_default = PasswordInput;

export {
  PasswordInput,
  PasswordInput_default
};
//# sourceMappingURL=chunk-AACKQCTN.js.map