// src/xterm.tsx
import { useEffect } from "react";
import { FitAddon } from "@xterm/addon-fit";
import { SearchAddon } from "@xterm/addon-search";
import { Terminal } from "@xterm/xterm";
import "@xterm/xterm/css/xterm.css";
import { jsx } from "react/jsx-runtime";
var searchAddon = new SearchAddon();
var fitAddon = new FitAddon();
var addons = [fitAddon, searchAddon];
var defaultOptions = { allowProposedApi: true, scrollback: 5e3 };
var Xterm = ({ className, customKeyEventHandler, options = {}, onResize, style, triggerResize, xtermRef, ...remainingProps }) => {
  useEffect(() => {
    const { terminal, terminalRef } = xtermRef.current;
    terminal.current = new Terminal({ ...defaultOptions, ...options });
    addons.forEach((addon) => terminal.current.loadAddon(addon));
    Object.entries(remainingProps).forEach(([key, value]) => value ? terminal.current[key](value) : void 0);
    if (customKeyEventHandler) {
      terminal.current.attachCustomKeyEventHandler(customKeyEventHandler);
    }
    if (terminalRef.current) {
      terminal.current.open(terminalRef.current);
    }
    return () => {
      terminal.current.dispose();
    };
  }, [addons, customKeyEventHandler, JSON.stringify(options), Object.keys(remainingProps).join("")]);
  useEffect(() => {
    if (!xtermRef.current.terminalRef.current) {
      return;
    }
    try {
      fitAddon.fit();
      const { rows = 40, cols = 80 } = fitAddon.proposeDimensions() || {};
      if (onResize) {
        onResize({ rows, cols });
      }
    } catch {
    }
  }, [triggerResize]);
  return /* @__PURE__ */ jsx("div", { className, ref: xtermRef.current.terminalRef, style });
};
var xterm_default = Xterm;

export {
  Xterm,
  xterm_default
};
//# sourceMappingURL=chunk-E2JRREHI.js.map