import {
  SupportLink
} from "./chunk-COUEQI3H.js";
import {
  BaseDialog
} from "./chunk-G4SBL2PI.js";

// src/dialogs/StartupNotification.tsx
import { useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { Button, DialogActions, DialogContent, Divider } from "@mui/material";
import storeActions from "@northern.tech/store/actions";
import { DEVICE_ONLINE_CUTOFF, TIMEOUTS } from "@northern.tech/store/constants";
import { getIsDarkMode } from "@northern.tech/store/selectors";
import { saveGlobalSettings } from "@northern.tech/store/thunks";
import { useDebounce } from "@northern.tech/utils/debouncehook";

// ../../assets/img/headerlogo.png
var headerlogo_default = "./headerlogo-QQW3XP5Y.png";

// ../../assets/img/whiteheaderlogo.png
var whiteheaderlogo_default = "./whiteheaderlogo-76DNCTF3.png";

// src/dialogs/StartupNotification.tsx
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var { setShowStartupNotification } = storeActions;
var OfflineThresholdContent = () => /* @__PURE__ */ jsxs(Fragment, { children: [
  "In our continuous efforts to enhance performance and to ensure the stability of our service, we have made adjustments to how granular device connectivity can be checked.",
  /* @__PURE__ */ jsx("h4", { children: "What's changing:" }),
  /* @__PURE__ */ jsx("ul", { children: /* @__PURE__ */ jsxs("li", { children: [
    /* @__PURE__ */ jsx("i", { children: "Offline threshold" }),
    " setting: if a device no longer connects with the server, it may take up to 1 day until it is shown as an offline device in the UI."
  ] }) }),
  "More granular connectivity information will still be reflected in the device details.",
  /* @__PURE__ */ jsx("h4", { children: "Why are we changing this:" }),
  /* @__PURE__ */ jsxs("ul", { children: [
    /* @__PURE__ */ jsx("li", { children: "Performance Improvements: Less frequent updates allow us to better optimize the platform and improve overall performance." }),
    /* @__PURE__ */ jsx("li", { children: "Stability: This change helps ensure that our backend will remain stable while serving an ever growing number of devices and potential disruptions are minimized." })
  ] }),
  "We appreciate your understanding and cooperation as we implement these improvements. Our commitment to providing you with a reliable and high-performing platform remains our top priority.",
  /* @__PURE__ */ jsx(Divider, { className: "margin-top-small margin-bottom-small" }),
  "If you have any questions or concerns regarding this change, please do not hesitate to ",
  /* @__PURE__ */ jsx(SupportLink, { variant: "ourTeam" }),
  "."
] });
var notifications = {
  offlineThreshold: {
    Content: OfflineThresholdContent,
    action: ({ dispatch }) => dispatch(saveGlobalSettings({ offlineThreshold: { interval: 1, intervalUnit: DEVICE_ONLINE_CUTOFF.intervalName } }))
  }
};
var StartupNotificationDialog = () => {
  const [isAllowedToClose] = useState(false);
  const dispatch = useDispatch();
  const isDarkMode = useSelector(getIsDarkMode);
  const { action, Content } = notifications.offlineThreshold;
  const debouncedCloseGuard = useDebounce(isAllowedToClose, TIMEOUTS.fiveSeconds);
  const onClose = () => {
    action({ dispatch });
    dispatch(setShowStartupNotification(false));
  };
  const headerLogo = isDarkMode ? whiteheaderlogo_default : headerlogo_default;
  return /* @__PURE__ */ jsxs(
    BaseDialog,
    {
      open: true,
      slotProps: {
        paper: {
          className: "padding-small",
          sx: { maxWidth: 720 }
        }
      },
      title: /* @__PURE__ */ jsxs("div", { className: "flexbox center-aligned", children: [
        /* @__PURE__ */ jsx("img", { src: headerLogo, style: { maxHeight: 75 } }),
        /* @__PURE__ */ jsx("div", { className: "margin-left-small", children: "Welcome back!" })
      ] }),
      onClose,
      children: [
        /* @__PURE__ */ jsx(DialogContent, { className: "margin-left-small margin-right-small", children: /* @__PURE__ */ jsx(Content, {}) }),
        /* @__PURE__ */ jsx(DialogActions, { children: /* @__PURE__ */ jsx(Button, { variant: "contained", disabled: debouncedCloseGuard, onClick: onClose, children: "Close" }) })
      ]
    }
  );
};
var StartupNotification_default = StartupNotificationDialog;

export {
  StartupNotificationDialog,
  StartupNotification_default
};
//# sourceMappingURL=chunk-IT6FJLPK.js.map