import {
  Form_default
} from "./chunk-4LPSFMP6.js";

// src/forms/KeyValueEditor.tsx
import { useEffect, useState } from "react";
import { useFieldArray, useFormContext } from "react-hook-form";
import { Clear as ClearIcon, Add as ContentAddIcon } from "@mui/icons-material";
import { Fab, FormControl, FormHelperText, IconButton, OutlinedInput } from "@mui/material";
import { makeStyles } from "tss-react/mui";
import { jsx, jsxs } from "react/jsx-runtime";
var emptyInput = { helptip: null, key: "", value: "" };
var reducePairs = (pairs) => (pairs || []).reduce((accu, item) => ({ ...accu, ...item.value ? { [item.key]: item.value } : {} }), {});
var useStyles = makeStyles()((theme) => ({
  spacer: { minWidth: theme.spacing(30) },
  helptip: { left: -35, top: 15, position: "absolute" },
  keyValueContainer: {
    display: "grid",
    gridTemplateColumns: "min-content min-content max-content",
    columnGap: theme.spacing(2),
    alignItems: "baseline",
    justifyItems: "baseline",
    "> div": {
      marginTop: 10
    }
  }
}));
var KeyValueFields = ({ disabled, errortext, inputHelpTipsMap, onInputChange }) => {
  const { classes } = useStyles();
  const {
    control,
    watch,
    setValue,
    formState: { errors },
    trigger
  } = useFormContext();
  const { fields, append, remove, replace } = useFieldArray({
    control,
    name: "inputs",
    rules: {
      validate: {
        noDuplicates: (inputs2) => {
          const keys = (inputs2 || []).map((item) => item.key).filter(Boolean);
          return new Set(keys).size === keys.length || "Duplicate keys exist, only the last set value will be submitted";
        }
      }
    }
  });
  const inputs = watch("inputs");
  useEffect(() => {
    const inputObject = reducePairs(inputs);
    onInputChange(inputObject);
  }, [JSON.stringify(inputs), onInputChange]);
  const onClearClick = () => replace([{ ...emptyInput }]);
  const addKeyValue = () => append({ ...emptyInput });
  const updateField = (index, field, value) => {
    setValue(`inputs.${index}.${field}`, value);
    if (field === "key") {
      const normalizedKey = value.toLowerCase();
      setValue(`inputs.${index}.helptip`, inputHelpTipsMap[normalizedKey]);
    }
    trigger();
  };
  return /* @__PURE__ */ jsxs("div", { children: [
    fields.map((field, index) => {
      const hasError = Boolean(index === fields.length - 1 && (errortext || errors?.inputs?.root?.message));
      const hasRemovalDisabled = !(inputs?.[index]?.key && inputs?.[index]?.value);
      const { component: Helptip = null, props: helptipProps = {} } = inputs[index].helptip ?? {};
      return /* @__PURE__ */ jsxs("div", { className: `${classes.keyValueContainer} relative`, children: [
        /* @__PURE__ */ jsxs(FormControl, { children: [
          /* @__PURE__ */ jsx(
            OutlinedInput,
            {
              disabled,
              value: inputs?.[index]?.key || "",
              placeholder: "Key",
              onChange: (e) => updateField(index, "key", e.target.value),
              type: "text"
            }
          ),
          hasError && /* @__PURE__ */ jsx(FormHelperText, { children: errortext || errors?.inputs?.root?.message })
        ] }),
        /* @__PURE__ */ jsx(FormControl, { children: /* @__PURE__ */ jsx(
          OutlinedInput,
          {
            disabled,
            value: inputs?.[index]?.value || "",
            placeholder: "Value",
            onChange: (e) => updateField(index, "value", e.target.value),
            type: "text"
          }
        ) }),
        fields.length > 1 && !hasRemovalDisabled ? /* @__PURE__ */ jsx(IconButton, { disabled, onClick: () => remove(index), size: "large", children: /* @__PURE__ */ jsx(ClearIcon, { fontSize: "small" }) }) : /* @__PURE__ */ jsx("span", {}),
        Helptip && /* @__PURE__ */ jsx(Helptip, { className: classes.helptip, ...helptipProps })
      ] }, field.id);
    }),
    /* @__PURE__ */ jsxs("div", { className: classes.keyValueContainer, children: [
      /* @__PURE__ */ jsx("div", { className: classes.spacer, children: /* @__PURE__ */ jsx(
        Fab,
        {
          disabled: disabled || !inputs?.[fields.length - 1]?.key || !inputs?.[fields.length - 1]?.value,
          style: { marginBottom: 10 },
          color: "secondary",
          size: "small",
          onClick: addKeyValue,
          children: /* @__PURE__ */ jsx(ContentAddIcon, {})
        }
      ) }),
      /* @__PURE__ */ jsx("div", { className: classes.spacer }),
      inputs.length > 1 ? /* @__PURE__ */ jsx("a", { onClick: onClearClick, children: "clear all" }) : /* @__PURE__ */ jsx("div", {})
    ] })
  ] });
};
var KeyValueEditor = ({ disabled, errortext, initialInput = {}, inputHelpTipsMap = {}, onInputChange }) => {
  const defaultValues = {
    inputs: Object.keys(initialInput).length ? Object.entries(initialInput).map(([key, value]) => ({ helptip: inputHelpTipsMap[key.toLowerCase()], key, value })) : [{ ...emptyInput }]
  };
  const [initialValues] = useState(defaultValues);
  const onFormSubmit = (data) => onInputChange(reducePairs(data.inputs));
  return /* @__PURE__ */ jsx(Form_default, { autocomplete: "off", defaultValues, id: "key-value-editor", initialValues, onSubmit: onFormSubmit, children: /* @__PURE__ */ jsx(KeyValueFields, { disabled, errortext, inputHelpTipsMap, onInputChange }) });
};
var KeyValueEditor_default = KeyValueEditor;

export {
  KeyValueEditor,
  KeyValueEditor_default
};
//# sourceMappingURL=chunk-NTM6ENQ4.js.map