import {
  BaseDialog
} from "../chunk-G4SBL2PI.js";
import "../chunk-424PT5DM.js";

// src/dialogs/ConfirmAddon.tsx
import { Button, DialogActions, DialogContent } from "@mui/material";
import { jsx, jsxs } from "react/jsx-runtime";
var title = {
  remove: "Remove add-on?",
  add: "Add new on?"
};
var ConfirmAddon = (props) => {
  const { variant, name, onConfirm, onClose } = props;
  return /* @__PURE__ */ jsxs(BaseDialog, { open: true, title: title[variant], onClose, children: [
    /* @__PURE__ */ jsxs(DialogContent, { children: [
      "You are requesting to ",
      variant,
      " the Mender ",
      /* @__PURE__ */ jsx("b", { children: name }),
      " add-on from your plan."
    ] }),
    /* @__PURE__ */ jsxs(DialogContent, { children: [
      "Once we receive the request, we will get in touch to confirm the change to your subscription and price, before",
      " ",
      variant === "remove" ? "disabling" : "enabling",
      " the add-on."
    ] }),
    /* @__PURE__ */ jsxs(DialogActions, { children: [
      /* @__PURE__ */ jsx(Button, { onClick: onClose, children: "Cancel" }),
      /* @__PURE__ */ jsx(Button, { color: "secondary", variant: "contained", onClick: onConfirm, children: "Confirm" })
    ] })
  ] });
};
export {
  ConfirmAddon
};
//# sourceMappingURL=ConfirmAddon.js.map