"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/forms/CountrySelect.tsx
var CountrySelect_exports = {};
__export(CountrySelect_exports, {
  ControlledCountrySelect: () => ControlledCountrySelect,
  CountrySelect: () => CountrySelect
});
module.exports = __toCommonJS(CountrySelect_exports);
var import_react = require("react");
var import_react_hook_form = require("react-hook-form");
var import_material = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_constants = require("@northern.tech/store/constants");
var import_jsx_runtime = require("react/jsx-runtime");
var useStyles = (0, import_mui.makeStyles)()(() => ({
  autocomplete: { width: 400 }
}));
var CountrySelect = (props) => {
  const { id, onChange, defaultValue, ...restProps } = props;
  const { classes } = useStyles();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_material.Autocomplete,
    {
      getOptionLabel: (option) => option.label,
      options: import_constants.countries,
      className: classes.autocomplete,
      autoHighlight: true,
      renderInput: (params) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.TextField, { ...params, label: "Country", id: id || "country" }),
      onChange: (e, data) => onChange(data),
      ...restProps,
      defaultValue: import_constants.countries.find((country) => country.code === defaultValue)
    },
    defaultValue
  );
};
var ControlledCountrySelect = ({ control, id, required }) => {
  const [defaultCountry, setDefaultCountry] = (0, import_react.useState)("");
  const { getValues } = (0, import_react_hook_form.useFormContext)();
  const values = getValues();
  (0, import_react.useEffect)(() => {
    setDefaultCountry(values.country);
  }, []);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_react_hook_form.Controller,
    {
      rules: { required },
      render: ({ field: { onChange }, formState, fieldState, ...props }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(CountrySelect, { defaultValue: defaultCountry, onChange, id, ...props }),
      name: "country",
      control
    }
  );
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ControlledCountrySelect,
  CountrySelect
});
//# sourceMappingURL=CountrySelect.cjs.map