"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/forms/KeyValueEditor.tsx
var KeyValueEditor_exports = {};
__export(KeyValueEditor_exports, {
  KeyValueEditor: () => KeyValueEditor,
  default: () => KeyValueEditor_default
});
module.exports = __toCommonJS(KeyValueEditor_exports);
var import_react2 = require("react");
var import_react_hook_form2 = require("react-hook-form");
var import_icons_material = require("@mui/icons-material");
var import_material2 = require("@mui/material");
var import_mui2 = require("tss-react/mui");

// src/forms/Form.tsx
var import_react = require("react");
var import_react_hook_form = require("react-hook-form");
var import_material = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_validator = __toESM(require("validator"), 1);
var import_jsx_runtime = require("react/jsx-runtime");
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  buttonWrapper: { display: "flex", justifyContent: "flex-end", height: "min-content", marginTop: theme.spacing(4) },
  cancelButton: { marginRight: theme.spacing() }
}));
var Form = ({
  autocomplete,
  buttonColor,
  children,
  className = "",
  classes = { buttonWrapper: "", cancelButton: "" },
  defaultValues = {},
  handleCancel,
  id,
  initialValues = {},
  onSubmit,
  showButtons,
  submitLabel,
  submitRef
}) => {
  const { classes: internalClasses } = useStyles();
  const methods = (0, import_react_hook_form.useForm)({ mode: "onChange", defaultValues });
  const {
    handleSubmit,
    formState: { isValid },
    setValue
  } = methods;
  (0, import_react.useEffect)(() => {
    if (submitRef) {
      submitRef.current = handleSubmit(onSubmit);
    }
  }, [handleSubmit, onSubmit, submitRef]);
  (0, import_react.useEffect)(() => {
    Object.entries(initialValues).forEach(([key, value]) => setValue(key, value));
  }, [JSON.stringify(initialValues), setValue]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_react_hook_form.FormProvider, { ...methods, children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("form", { autoComplete: autocomplete, className, id, noValidate: true, onSubmit: handleSubmit(onSubmit), children: [
    children,
    !!showButtons && /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: `button-wrapper ${internalClasses.buttonWrapper} ${classes.buttonWrapper}`, children: [
      !!handleCancel && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Button, { className: `${internalClasses.cancelButton} ${classes.cancelButton}`, onClick: handleCancel, children: "Cancel" }, "cancel"),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Button, { variant: "contained", type: "submit", disabled: !isValid, color: buttonColor, children: submitLabel })
    ] })
  ] }) });
};
var Form_default = Form;

// src/forms/KeyValueEditor.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var emptyInput = { helptip: null, key: "", value: "" };
var reducePairs = (pairs) => (pairs || []).reduce((accu, item) => ({ ...accu, ...item.value ? { [item.key]: item.value } : {} }), {});
var useStyles2 = (0, import_mui2.makeStyles)()((theme) => ({
  spacer: { minWidth: theme.spacing(30) },
  helptip: { left: -35, top: 15, position: "absolute" },
  keyValueContainer: {
    display: "grid",
    gridTemplateColumns: "min-content min-content max-content",
    columnGap: theme.spacing(2),
    alignItems: "baseline",
    justifyItems: "baseline",
    "> div": {
      marginTop: 10
    }
  }
}));
var KeyValueFields = ({ disabled, errortext, inputHelpTipsMap, onInputChange }) => {
  const { classes } = useStyles2();
  const {
    control,
    watch,
    setValue,
    formState: { errors },
    trigger
  } = (0, import_react_hook_form2.useFormContext)();
  const { fields, append, remove, replace } = (0, import_react_hook_form2.useFieldArray)({
    control,
    name: "inputs",
    rules: {
      validate: {
        noDuplicates: (inputs2) => {
          const keys = (inputs2 || []).map((item) => item.key).filter(Boolean);
          return new Set(keys).size === keys.length || "Duplicate keys exist, only the last set value will be submitted";
        }
      }
    }
  });
  const inputs = watch("inputs");
  (0, import_react2.useEffect)(() => {
    const inputObject = reducePairs(inputs);
    onInputChange(inputObject);
  }, [JSON.stringify(inputs), onInputChange]);
  const onClearClick = () => replace([{ ...emptyInput }]);
  const addKeyValue = () => append({ ...emptyInput });
  const updateField = (index, field, value) => {
    setValue(`inputs.${index}.${field}`, value);
    if (field === "key") {
      const normalizedKey = value.toLowerCase();
      setValue(`inputs.${index}.helptip`, inputHelpTipsMap[normalizedKey]);
    }
    trigger();
  };
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { children: [
    fields.map((field, index) => {
      const hasError = Boolean(index === fields.length - 1 && (errortext || errors?.inputs?.root?.message));
      const hasRemovalDisabled = !(inputs?.[index]?.key && inputs?.[index]?.value);
      const { component: Helptip = null, props: helptipProps = {} } = inputs[index].helptip ?? {};
      return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { className: `${classes.keyValueContainer} relative`, children: [
        /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_material2.FormControl, { children: [
          /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
            import_material2.OutlinedInput,
            {
              disabled,
              value: inputs?.[index]?.key || "",
              placeholder: "Key",
              onChange: (e) => updateField(index, "key", e.target.value),
              type: "text"
            }
          ),
          hasError && /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.FormHelperText, { children: errortext || errors?.inputs?.root?.message })
        ] }),
        /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.FormControl, { children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
          import_material2.OutlinedInput,
          {
            disabled,
            value: inputs?.[index]?.value || "",
            placeholder: "Value",
            onChange: (e) => updateField(index, "value", e.target.value),
            type: "text"
          }
        ) }),
        fields.length > 1 && !hasRemovalDisabled ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.IconButton, { disabled, onClick: () => remove(index), size: "large", children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_icons_material.Clear, { fontSize: "small" }) }) : /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("span", {}),
        Helptip && /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(Helptip, { className: classes.helptip, ...helptipProps })
      ] }, field.id);
    }),
    /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { className: classes.keyValueContainer, children: [
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { className: classes.spacer, children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
        import_material2.Fab,
        {
          disabled: disabled || !inputs?.[fields.length - 1]?.key || !inputs?.[fields.length - 1]?.value,
          style: { marginBottom: 10 },
          color: "secondary",
          size: "small",
          onClick: addKeyValue,
          children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_icons_material.Add, {})
        }
      ) }),
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { className: classes.spacer }),
      inputs.length > 1 ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("a", { onClick: onClearClick, children: "clear all" }) : /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", {})
    ] })
  ] });
};
var KeyValueEditor = ({ disabled, errortext, initialInput = {}, inputHelpTipsMap = {}, onInputChange }) => {
  const defaultValues = {
    inputs: Object.keys(initialInput).length ? Object.entries(initialInput).map(([key, value]) => ({ helptip: inputHelpTipsMap[key.toLowerCase()], key, value })) : [{ ...emptyInput }]
  };
  const [initialValues] = (0, import_react2.useState)(defaultValues);
  const onFormSubmit = (data) => onInputChange(reducePairs(data.inputs));
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(Form_default, { autocomplete: "off", defaultValues, id: "key-value-editor", initialValues, onSubmit: onFormSubmit, children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(KeyValueFields, { disabled, errortext, inputHelpTipsMap, onInputChange }) });
};
var KeyValueEditor_default = KeyValueEditor;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  KeyValueEditor
});
//# sourceMappingURL=KeyValueEditor.cjs.map